/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.util.Platform;

public class Help
implements ActionListener,
HyperlinkListener {
    private int m_historyIndex = -1;
    private JButton m_buttonBack;
    private JButton m_buttonForward;
    private final JEditorPane m_editorPane;
    private List<URL> m_history = new ArrayList<URL>();
    private final URL m_contents;
    private final MessageDialogs m_messageDialogs;
    private final Window m_window;

    public Help(URL contents, MessageDialogs messageDialogs, String title) {
        Container contentPane;
        this.m_messageDialogs = messageDialogs;
        this.m_contents = contents;
        if (Platform.isMac()) {
            JDialog dialog = new JDialog((Frame)null, title);
            contentPane = dialog.getContentPane();
            this.m_window = dialog;
        } else {
            JFrame frame = new JFrame(title);
            GuiUtil.setGoIcon(frame);
            contentPane = frame.getContentPane();
            this.m_window = frame;
        }
        JPanel panel = new JPanel(new BorderLayout());
        contentPane.add(panel);
        panel.add((Component)this.createButtons(), "North");
        this.m_editorPane = new JEditorPane();
        this.m_editorPane.setEditable(false);
        this.m_editorPane.addHyperlinkListener(this);
        int width = GuiUtil.getDefaultMonoFontSize() * 50;
        int height = GuiUtil.getDefaultMonoFontSize() * 60;
        JScrollPane scrollPane = new JScrollPane(this.m_editorPane, 22, 31);
        if (Platform.isMac()) {
            scrollPane.setBorder(null);
        }
        scrollPane.setPreferredSize(new Dimension(width, height));
        panel.add((Component)scrollPane, "Center");
        this.m_window.pack();
        this.loadURL(this.m_contents);
        this.appendHistory(this.m_contents);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("back")) {
            this.back();
        } else if (command.equals("close")) {
            this.m_window.setVisible(false);
        } else if (command.equals("contents")) {
            this.loadURL(this.m_contents);
            this.appendHistory(this.m_contents);
        } else if (command.equals("forward")) {
            this.forward();
        }
    }

    public Window getWindow() {
        return this.m_window;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = e.getURL();
            String protocol = url.getProtocol();
            if (protocol.equals("jar") || protocol.equals("file")) {
                this.loadURL(url);
                this.appendHistory(url);
            } else {
                this.openExternal(url);
            }
        }
    }

    private void appendHistory(URL url) {
        if (this.m_historyIndex >= 0 && this.historyEquals(this.m_historyIndex, url)) {
            return;
        }
        if (this.m_historyIndex + 1 < this.m_history.size()) {
            if (!this.historyEquals(this.m_historyIndex + 1, url)) {
                this.m_history = this.m_history.subList(0, this.m_historyIndex + 1);
                this.m_history.add(url);
            }
        } else {
            this.m_history.add(url);
        }
        ++this.m_historyIndex;
        this.historyChanged();
    }

    private void back() {
        assert (this.m_historyIndex > 0);
        assert (this.m_historyIndex < this.m_history.size());
        --this.m_historyIndex;
        this.loadURL(this.getHistory(this.m_historyIndex));
        this.historyChanged();
    }

    private JComponent createButtons() {
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.createToolBarButton("go-home", "contents", "TT_HELP_TOC"));
        this.m_buttonBack = this.createToolBarButton("go-previous", "back", "TT_HELP_BACK");
        toolBar.add(this.m_buttonBack);
        this.m_buttonForward = this.createToolBarButton("go-next", "forward", "TT_HELP_FORWARD");
        toolBar.add(this.m_buttonForward);
        if (!Platform.isMac()) {
            toolBar.setRollover(true);
        }
        toolBar.setFloatable(false);
        return toolBar;
    }

    private JButton createToolBarButton(String icon, String command, String toolTip) {
        JButton button = new JButton();
        button.setActionCommand(command);
        button.setToolTipText(I18n.i18n(toolTip));
        button.addActionListener(this);
        button.setIcon(GuiUtil.getIcon(icon, command));
        button.setFocusable(false);
        return button;
    }

    private void forward() {
        assert (this.m_historyIndex + 1 < this.m_history.size());
        ++this.m_historyIndex;
        this.loadURL(this.getHistory(this.m_historyIndex));
        this.historyChanged();
    }

    private URL getHistory(int index) {
        return this.m_history.get(index);
    }

    private void historyChanged() {
        boolean backPossible = this.m_historyIndex > 0;
        boolean forwardPossible = this.m_historyIndex < this.m_history.size() - 1;
        this.m_buttonBack.setEnabled(backPossible);
        this.m_buttonForward.setEnabled(forwardPossible);
    }

    private boolean historyEquals(int index, URL url) {
        return this.getHistory(index).toString().equals(url.toString());
    }

    private void loadURL(URL url) {
        try {
            this.m_editorPane.setPage(url);
        }
        catch (IOException e) {
            String mainMessage = MessageFormat.format("MSG_HELP_LOAD_FAILURE", url.toString());
            this.m_messageDialogs.showError((Component)this.m_window, mainMessage, e.getMessage(), false);
        }
    }

    private void openExternal(URL url) {
        if (!Platform.openInExternalBrowser(url)) {
            this.loadURL(url);
        }
        this.appendHistory(url);
    }
}

