/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.util.Platform;
import net.sf.gogui.util.PrefUtil;
import net.sf.gogui.util.StringUtil;

public final class MessageDialogs {
    private final Set<String> m_disabled = new TreeSet<String>();

    public void showError(Component frame, String mainMessage, String optionalMessage) {
        this.showError(frame, mainMessage, optionalMessage, true);
    }

    public void showError(Component frame, String mainMessage, String optionalMessage, boolean isCritical) {
        int type = isCritical ? 0 : -1;
        Object[] options = new Object[]{I18n.i18n("LB_CLOSE")};
        Object defaultOption = options[0];
        this.show(null, frame, "", mainMessage, optionalMessage, type, -1, options, defaultOption, -1);
    }

    public void showError(Component frame, String message, Exception e) {
        this.showError(frame, message, e, true);
    }

    public void showError(Component frame, String message, Exception e, boolean isCritical) {
        this.showError(frame, message, StringUtil.getErrorMessage(e), isCritical);
    }

    public void showInfo(Component frame, String mainMessage, String optionalMessage, boolean isCritical) {
        this.showInfo(null, frame, mainMessage, optionalMessage, isCritical);
    }

    public void showInfo(String disableKey, Component frame, String mainMessage, String optionalMessage, boolean isCritical) {
        if (this.checkDisabled(disableKey)) {
            return;
        }
        int type = isCritical ? 1 : -1;
        Object[] options = new Object[]{I18n.i18n("LB_CLOSE")};
        Object defaultOption = options[0];
        this.show(disableKey, frame, "", mainMessage, optionalMessage, type, -1, options, defaultOption, -1);
    }

    public int showYesNoCancelQuestion(Component parent, String mainMessage, String optionalMessage, String destructiveOption, String nonDestructiveOption) {
        return this.showYesNoCancelQuestion(null, parent, mainMessage, optionalMessage, destructiveOption, nonDestructiveOption);
    }

    public int showYesNoCancelQuestion(String disableKey, Component parent, String mainMessage, String optionalMessage, String destructiveOption, String nonDestructiveOption) {
        int destructiveIndex;
        if (this.checkDisabled(disableKey)) {
            return 0;
        }
        Object[] options = new Object[3];
        if (Platform.isMac()) {
            options[0] = nonDestructiveOption;
            options[1] = I18n.i18n("LB_CANCEL");
            options[2] = destructiveOption;
            destructiveIndex = 2;
        } else {
            options[0] = nonDestructiveOption;
            options[1] = destructiveOption;
            options[2] = I18n.i18n("LB_CANCEL");
            destructiveIndex = -1;
        }
        Object defaultOption = options[0];
        int type = 3;
        Object value = this.show(disableKey, parent, "", mainMessage, optionalMessage, type, 1, options, defaultOption, destructiveIndex);
        int result = value == destructiveOption ? 0 : (value == nonDestructiveOption ? 1 : 2);
        return result;
    }

    public void showWarning(Component parent, String mainMessage, String optionalMessage, boolean isCritical) {
        this.showWarning(null, parent, mainMessage, optionalMessage, isCritical);
    }

    public void showWarning(String disableKey, Component parent, String mainMessage, String optionalMessage, boolean isCritical) {
        if (this.checkDisabled(disableKey)) {
            return;
        }
        int type = isCritical ? 2 : -1;
        Object[] options = new Object[]{I18n.i18n("LB_CLOSE")};
        Object defaultOption = options[0];
        this.show(disableKey, parent, "", mainMessage, optionalMessage, type, -1, options, defaultOption, -1);
    }

    public boolean showQuestion(Component parent, String mainMessage, String optionalMessage, String destructiveOption, boolean isCritical) {
        return this.showQuestion(null, parent, mainMessage, optionalMessage, destructiveOption, isCritical);
    }

    public boolean showQuestion(String disableKey, Component parent, String mainMessage, String optionalMessage, String destructiveOption, boolean isCritical) {
        return this.showQuestion(disableKey, parent, mainMessage, optionalMessage, destructiveOption, I18n.i18n("LB_CANCEL"), isCritical);
    }

    public boolean showQuestion(String disableKey, Component parent, String mainMessage, String optionalMessage, String affirmativeOption, String cancelOption, boolean isCritical) {
        if (this.checkDisabled(disableKey)) {
            return true;
        }
        Object[] options = new Object[2];
        if (Platform.isMac()) {
            options[0] = cancelOption;
            options[1] = affirmativeOption;
        } else {
            options[0] = affirmativeOption;
            options[1] = cancelOption;
        }
        String defaultOption = affirmativeOption;
        int type = isCritical ? 3 : -1;
        Object result = this.show(disableKey, parent, "", mainMessage, optionalMessage, type, 0, options, defaultOption, -1);
        return result == affirmativeOption;
    }

    public boolean showWarningQuestion(Component parent, String mainMessage, String optionalMessage, String destructiveOption, boolean isCritical) {
        return this.showWarningQuestion(null, parent, mainMessage, optionalMessage, destructiveOption, isCritical);
    }

    public boolean showWarningQuestion(String disableKey, Component parent, String mainMessage, String optionalMessage, String destructiveOption, boolean isCritical) {
        return this.showWarningQuestion(disableKey, parent, mainMessage, optionalMessage, destructiveOption, I18n.i18n("LB_CANCEL"), isCritical);
    }

    public boolean showWarningQuestion(String disableKey, Component parent, String mainMessage, String optionalMessage, String destructiveOption, String nonDestructiveOption, boolean isCritical) {
        if (this.checkDisabled(disableKey)) {
            return true;
        }
        Object[] options = new Object[2];
        if (Platform.isMac()) {
            options[0] = nonDestructiveOption;
            options[1] = destructiveOption;
        } else {
            options[0] = destructiveOption;
            options[1] = nonDestructiveOption;
        }
        String defaultOption = nonDestructiveOption;
        int type = isCritical ? 2 : -1;
        Object result = this.show(disableKey, parent, "", mainMessage, optionalMessage, type, 0, options, defaultOption, -1);
        return result == destructiveOption;
    }

    private static void addFiller(JComponent component) {
        Box.Filler filler = GuiUtil.createFiller();
        filler.setAlignmentX(0.0f);
        component.add(filler);
    }

    private boolean checkDisabled(String disableKey) {
        if (disableKey == null) {
            return false;
        }
        Preferences prefs = PrefUtil.createNode("net/sf/gogui/gui/messagedialogs/disabled");
        boolean permanentlyDisabled = prefs.getBoolean(disableKey, false);
        if (permanentlyDisabled) {
            return true;
        }
        prefs.putBoolean(disableKey, permanentlyDisabled);
        return this.m_disabled.contains(disableKey);
    }

    private Object show(String disableKey, Component parent, String title, String mainMessage, String optionalMessage, int messageType, int optionType, Object[] options, Object defaultOption, int destructiveIndex) {
        if (optionalMessage == null) {
            optionalMessage = "";
        }
        boolean isMac = Platform.isMac();
        Box box = Box.createVerticalBox();
        String css = GuiUtil.getMessageCss();
        JLabel label = new JLabel("<html>" + css + "<b>" + GuiUtil.insertLineBreaks(mainMessage) + "</b><p>" + GuiUtil.insertLineBreaks(optionalMessage) + "</p>");
        label.setAlignmentX(0.0f);
        box.add(label);
        MessageDialogs.addFiller(box);
        MessageDialogs.addFiller(box);
        JCheckBox disableCheckBox = null;
        if (disableKey != null) {
            disableCheckBox = messageType == 3 ? new JCheckBox(I18n.i18n("LB_DO_NOT_ASK_AGAIN")) : (messageType == 2 ? new JCheckBox(I18n.i18n("LB_DO_NOT_WARN_AGAIN")) : new JCheckBox(I18n.i18n("LB_DO_NOT_SHOW_AGAIN")));
            disableCheckBox.setToolTipText(I18n.i18n("TT_DO_NOT_SHOW_AGAIN"));
            disableCheckBox.setAlignmentX(0.0f);
            box.add(disableCheckBox);
        }
        if (isMac) {
            messageType = -1;
        }
        JOptionPane optionPane = new JOptionPane(box, messageType, optionType, null, options, defaultOption);
        if (destructiveIndex >= 0) {
            String key = "Quaqua.OptionPane.destructiveOption";
            optionPane.putClientProperty(key, destructiveIndex);
        }
        if (isMac && parent.isVisible()) {
            title = null;
        }
        JDialog dialog = optionPane.createDialog(parent, title);
        dialog.setVisible(true);
        dialog.dispose();
        if (disableKey != null && disableCheckBox.isSelected()) {
            this.m_disabled.add(disableKey);
        }
        return optionPane.getValue();
    }
}

