/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectListEditor<OBJECT> {
    private ActionListener m_actionListener;
    private JButton m_edit;
    private JButton m_moveDown;
    private JButton m_moveUp;
    private JButton m_remove;
    private JList m_list;
    private JDialog m_dialog;
    private ArrayList<OBJECT> m_objects;
    private ItemEditor<OBJECT> m_editor;
    private MessageDialogs m_messageDialogs;

    public boolean edit(Component parent, String title, ArrayList<OBJECT> objects, ItemEditor<OBJECT> editor, MessageDialogs messageDialogs) {
        this.m_messageDialogs = messageDialogs;
        this.m_editor = editor;
        this.m_actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String command = event.getActionCommand();
                if (command.equals("edit")) {
                    ObjectListEditor.this.cbEdit();
                } else if (command.equals("move-up")) {
                    ObjectListEditor.this.cbMoveUp();
                } else if (command.equals("move-down")) {
                    ObjectListEditor.this.cbMoveDown();
                } else if (command.equals("remove")) {
                    ObjectListEditor.this.cbRemove();
                } else assert (false);
            }
        };
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        this.m_list = new JList();
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ObjectListEditor.this.selectionChanged();
            }
        });
        this.m_list.setSelectionMode(0);
        int rows = Math.min(Math.max(objects.size(), 8), 15);
        this.m_list.setVisibleRowCount(rows);
        JScrollPane scrollPane = new JScrollPane(this.m_list);
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)this.createButtonPanel(), "East");
        JOptionPane optionPane = new JOptionPane(panel, -1, 2);
        this.m_objects = new ArrayList();
        this.copyObjects(objects, this.m_objects);
        this.updateList(this.m_objects.isEmpty() ? -1 : 0);
        this.m_dialog = optionPane.createDialog(parent, title);
        this.m_dialog.setVisible(true);
        Object value = optionPane.getValue();
        boolean result = true;
        if (!(value instanceof Integer) || (Integer)value != 0) {
            result = false;
        }
        this.m_dialog.dispose();
        if (result) {
            this.copyObjects(this.m_objects, objects);
        }
        return result;
    }

    private void cbMoveDown() {
        int index = this.m_list.getSelectedIndex();
        if (index < 0 || index >= this.m_objects.size() - 1) {
            return;
        }
        OBJECT temp = this.m_objects.get(index);
        this.m_objects.set(index, this.m_objects.get(index + 1));
        this.m_objects.set(index + 1, temp);
        this.updateList(index + 1);
    }

    private void cbEdit() {
        int index = this.m_list.getSelectedIndex();
        if (index == -1) {
            return;
        }
        OBJECT object = this.m_editor.editItem(this.m_dialog, this.getObject(index), this.m_messageDialogs);
        if (object == null) {
            return;
        }
        this.m_objects.set(index, object);
        this.updateList(index);
    }

    private void cbMoveUp() {
        int index = this.m_list.getSelectedIndex();
        if (index < 0 || index == 0) {
            return;
        }
        OBJECT temp = this.m_objects.get(index);
        this.m_objects.set(index, this.m_objects.get(index - 1));
        this.m_objects.set(index - 1, temp);
        this.updateList(index - 1);
    }

    private void cbRemove() {
        String optionalMessage;
        int index = this.m_list.getSelectedIndex();
        if (index == -1) {
            return;
        }
        OBJECT object = this.getObject(index);
        String name = this.m_editor.getItemLabel(object);
        String disableKey = "net.sf.gogui.gui.ObjectListEditor.remove";
        String mainMessage = MessageFormat.format(I18n.i18n("MSG_LISTEDITOR_REALLY_REMOVE"), name);
        if (!this.m_messageDialogs.showQuestion(disableKey, this.m_dialog, mainMessage, optionalMessage = I18n.i18n("MSG_LISTEDITOR_REALLY_REMOVE_2"), I18n.i18n("LB_REMOVE"), false)) {
            return;
        }
        this.m_objects.remove(object);
        if (index >= this.m_objects.size()) {
            index = -1;
        }
        this.updateList(index);
    }

    private void copyObjects(ArrayList<OBJECT> from, ArrayList<OBJECT> to) {
        to.clear();
        for (int i = 0; i < from.size(); ++i) {
            to.add(this.m_editor.cloneItem(from.get(i)));
        }
    }

    private JButton createButton(String label, String command) {
        JButton button = new JButton(I18n.i18n(label));
        button.setEnabled(false);
        button.setActionCommand(command);
        button.addActionListener(this.m_actionListener);
        return button;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        this.m_moveUp = this.createButton("LB_LISTEDITOR_MOVE_UP", "move-up");
        GuiUtil.setMacBevelButton(this.m_moveUp);
        buttonPanel.add(this.m_moveUp);
        this.m_moveDown = this.createButton("LB_LISTEDITOR_MOVE_DOWN", "move-down");
        GuiUtil.setMacBevelButton(this.m_moveDown);
        buttonPanel.add(this.m_moveDown);
        this.m_edit = this.createButton("LB_EDIT", "edit");
        GuiUtil.setMacBevelButton(this.m_edit);
        buttonPanel.add(this.m_edit);
        this.m_remove = this.createButton("LB_REMOVE", "remove");
        GuiUtil.setMacBevelButton(this.m_remove);
        buttonPanel.add(this.m_remove);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)buttonPanel, "North");
        return panel;
    }

    private OBJECT getObject(int i) {
        return this.m_objects.get(i);
    }

    private void selectionChanged() {
        int index = this.m_list.getSelectedIndex();
        this.m_edit.setEnabled(index >= 0);
        this.m_remove.setEnabled(index >= 0);
        this.m_moveUp.setEnabled(index >= 1);
        this.m_moveDown.setEnabled(index < this.m_objects.size() - 1);
    }

    private void updateList(int selectedIndex) {
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < this.m_objects.size(); ++i) {
            String name = this.m_editor.getItemLabel(this.getObject(i));
            data.add(name);
        }
        this.m_list.setListData(data.toArray());
        this.m_list.setSelectedIndex(selectedIndex);
        this.m_list.ensureIndexIsVisible(selectedIndex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ItemEditor<OBJECT> {
        public OBJECT editItem(Component var1, OBJECT var2, MessageDialogs var3);

        public String getItemLabel(OBJECT var1);

        public OBJECT cloneItem(OBJECT var1);
    }
}

