/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.sf.gogui.gui.GuiUtil;

public final class TextViewer
extends JDialog {
    private JTextPane m_textPane;
    private Listener m_listener;

    public TextViewer(Frame owner, String title, String text, boolean highlight, Listener listener) {
        super(owner, title);
        this.initialize(text, highlight, listener);
    }

    public TextViewer(Dialog owner, String title, String text, boolean highlight, Listener listener) {
        super(owner, title);
        this.initialize(text, highlight, listener);
    }

    public void setText(String title, String text, boolean highlight) {
        this.setTitle(title);
        this.insertText(text);
        if (highlight) {
            this.doSyntaxHighlight();
        }
    }

    private void insertText(String text) {
        block3: {
            Document doc = this.m_textPane.getDocument();
            while (text.charAt(text.length() - 1) == '\n') {
                text = text.substring(0, text.length() - 1);
            }
            try {
                doc.remove(0, doc.getLength());
                doc.insertString(0, text, null);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    private void doSyntaxHighlight() {
        GuiUtil.addStyle(this.m_textPane, "title", null, null, true);
        GuiUtil.addStyle(this.m_textPane, "point", new Color(0.25f, 0.5f, 0.7f));
        GuiUtil.addStyle(this.m_textPane, "number", new Color(0.0f, 0.54f, 0.0f));
        GuiUtil.addStyle(this.m_textPane, "const", new Color(0.8f, 0.0f, 0.0f));
        GuiUtil.addStyle(this.m_textPane, "color", new Color(0.54f, 0.0f, 0.54f));
        this.m_textPane.setEditable(true);
        this.highlight("number", "\\b-?\\d+\\.?\\d*([Ee][+-]\\d+)?\\b");
        this.highlight("const", "\\b[A-Z_][A-Z_]+[A-Z]\\b");
        this.highlight("color", "\\b([Bb][Ll][Aa][Cc][Kk]|[Ww][Hh][Ii][Tt][Ee])\\b");
        this.highlight("point", "\\b([Pp][Aa][Ss][Ss]|[A-Ta-t](1\\d|[1-9]))\\b");
        this.highlight("title", "^\\S+:(\\s|$)");
        this.m_textPane.setEditable(false);
    }

    private void highlight(String styleName, String regex) {
        block3: {
            Document doc = this.m_textPane.getDocument();
            Pattern pattern = Pattern.compile(regex, 8);
            try {
                String text = doc.getText(0, doc.getLength());
                Matcher matcher = pattern.matcher(text);
                while (matcher.find()) {
                    int start = matcher.start();
                    int end = matcher.end();
                    GuiUtil.setStyle(this.m_textPane, start, end - start, styleName);
                }
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    private void initialize(String text, boolean highlight, Listener listener) {
        this.m_listener = listener;
        JPanel panel = new JPanel(new BorderLayout());
        Container contentPane = this.getContentPane();
        contentPane.add((Component)panel, "Center");
        this.m_textPane = new JTextPane();
        GuiUtil.setMonospacedFont(this.m_textPane);
        this.insertText(text);
        JScrollPane scrollPane = new JScrollPane(this.m_textPane);
        panel.add((Component)scrollPane, "Center");
        this.setDefaultCloseOperation(2);
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                int c = e.getKeyCode();
                if (c == 27) {
                    TextViewer.this.dispose();
                }
            }
        };
        this.m_textPane.addKeyListener(keyListener);
        CaretListener caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent event) {
                block4: {
                    if (TextViewer.this.m_listener == null) {
                        return;
                    }
                    int start = TextViewer.this.m_textPane.getSelectionStart();
                    int end = TextViewer.this.m_textPane.getSelectionEnd();
                    Document doc = TextViewer.this.m_textPane.getDocument();
                    try {
                        if (start == end) {
                            String text = doc.getText(0, doc.getLength());
                            TextViewer.this.m_listener.textSelected(text);
                            return;
                        }
                        String text = doc.getText(start, end - start);
                        TextViewer.this.m_listener.textSelected(text);
                    }
                    catch (BadLocationException e) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
        };
        this.m_textPane.addCaretListener(caretListener);
        if (highlight) {
            this.doSyntaxHighlight();
        }
        this.m_textPane.setCaretPosition(0);
        this.m_textPane.setEditable(false);
        this.packTextViewer();
    }

    private void packTextViewer() {
        this.pack();
        Dimension size = this.getSize();
        size.width = (int)((double)size.width * 1.1);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int maxHeight = (int)(0.9 * (double)screenSize.height);
        int maxWidth = (int)(0.9 * (double)screenSize.width);
        if (size.height > maxHeight || size.width > maxWidth) {
            size.width = Math.min(size.width, maxWidth);
            size.height = Math.min(size.height, maxHeight);
        }
        this.setMinimumSize(new Dimension(128, 96));
        size.height = Math.max(size.height, 96);
        size.width = Math.max(size.width, 128);
        this.setPreferredSize(size);
        this.setSize(size);
    }

    public static interface Listener {
        public void textSelected(String var1);
    }
}

