/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.thumbnail;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.TreeMap;
import net.sf.gogui.boardpainter.BoardPainter;
import net.sf.gogui.boardpainter.BoardPainterUtil;
import net.sf.gogui.boardpainter.ConstField;
import net.sf.gogui.boardpainter.Field;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.gamefile.GameFile;
import net.sf.gogui.gamefile.GameReader;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.sgf.SgfError;
import net.sf.gogui.thumbnail.ThumbnailPlatform;
import net.sf.gogui.thumbnail.ThumbnailReader;
import net.sf.gogui.thumbnail.ThumbnailUtil;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.FileUtil;
import net.sf.gogui.version.Version;

public final class ThumbnailCreator {
    private final boolean m_verbose;
    private String m_description;
    private File m_lastThumbnail;
    private final BoardPainter m_painter;
    private GameFile m_gameFile;

    public ThumbnailCreator(boolean verbose) {
        this.m_verbose = verbose;
        this.m_painter = new BoardPainter();
    }

    public void create(File input) throws ErrorMessage {
        File file = this.getThumbnailFileNormalSize(input);
        if (file.exists()) {
            URI uri = this.getURI(input);
            long lastModified = this.getLastModified(input);
            try {
                ThumbnailReader.MetaData data = ThumbnailReader.read(file);
                if (uri.equals(data.m_uri) && data.m_lastModified == lastModified) {
                    this.m_lastThumbnail = file;
                    this.m_description = data.m_description;
                    return;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.create(input, null, 128, false);
    }

    public void create(File input, File output, int thumbnailSize, boolean scale) throws ErrorMessage {
        assert (thumbnailSize > 0);
        this.m_lastThumbnail = null;
        try {
            BufferedImage image;
            this.log("File: " + input);
            URI uri = this.getURI(input);
            this.log("URI: " + uri);
            this.m_description = "";
            ConstBoard board = this.readFile(input);
            int size = board.getSize();
            ConstField[][] fields = new Field[size][size];
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < size; ++y) {
                    fields[x][y] = new Field();
                    GoColor color = board.getColor(GoPoint.get(x, y));
                    ((Field)fields[x][y]).setColor(color);
                }
            }
            int imageSize = thumbnailSize;
            if (scale) {
                imageSize = Math.min(thumbnailSize * size / 19, thumbnailSize);
            }
            if (imageSize < 256) {
                image = BoardPainterUtil.getImage(this.m_painter, fields, 2 * imageSize, 2 * imageSize);
                BufferedImage newImage = BoardPainterUtil.createImage(imageSize, imageSize);
                Graphics2D graphics = newImage.createGraphics();
                Image scaledInstance = image.getScaledInstance(imageSize, imageSize, 4);
                graphics.drawImage(scaledInstance, 0, 0, null);
                image = newImage;
            } else {
                image = BoardPainterUtil.getImage(this.m_painter, fields, imageSize, imageSize);
            }
            if (output == null) {
                output = this.getThumbnailFileNormalSize(input);
            }
            long lastModified = this.getLastModified(input);
            TreeMap<String, String> metaData = new TreeMap<String, String>();
            metaData.put("Thumb::URI", uri.toASCIIString());
            metaData.put("Thumb::MTime", Long.toString(lastModified));
            switch (this.m_gameFile.m_format) {
                case XML: {
                    metaData.put("Thumb::Mimetype", "application/x-go-sgf");
                    break;
                }
                case SGF: {
                    metaData.put("Thumb::Mimetype", "application/x-go+xml");
                }
            }
            if (!this.m_description.equals("")) {
                metaData.put("Description", this.m_description);
            }
            metaData.put("Software", "GoGui " + Version.get());
            BoardPainterUtil.writeImage(image, output, metaData);
            this.m_lastThumbnail = output;
        }
        catch (FileNotFoundException e) {
            throw new Error("File not found: " + input);
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
        catch (SgfError e) {
            throw new Error(e.getMessage());
        }
    }

    public String getLastDescription() {
        return this.m_description;
    }

    public File getLastThumbnail() {
        return this.m_lastThumbnail;
    }

    private ConstBoard readFile(File file) throws ErrorMessage {
        GameReader reader = new GameReader(file);
        this.m_gameFile = reader.getFile();
        GameTree tree = reader.getTree();
        ConstGameInfo info = tree.getGameInfoConst(tree.getRootConst());
        this.m_description = info.suggestGameName();
        if (this.m_description == null) {
            this.m_description = "";
        }
        return ThumbnailUtil.getPosition(tree);
    }

    private long getLastModified(File file) throws Error {
        long lastModified = file.lastModified() / 1000L;
        if (lastModified == 0L) {
            throw new Error("Could not get last modification time: " + file);
        }
        return lastModified;
    }

    private String getMD5(String string) throws Error {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] md5 = digest.digest(string.getBytes());
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < md5.length; ++i) {
                buffer.append(Integer.toHexString(md5[i] >> 4 & 0xF));
                buffer.append(Integer.toHexString(md5[i] & 0xF));
            }
            return buffer.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("No MD5 message digest found");
        }
    }

    private File getThumbnailFileNormalSize(File file) throws Error {
        URI uri = this.getURI(file);
        String md5 = this.getMD5(uri.toASCIIString());
        return new File(ThumbnailPlatform.getNormalDir(), md5 + ".png");
    }

    private URI getURI(File file) throws Error {
        URI uri = FileUtil.getURI(file);
        if (uri == null) {
            throw new Error("Invalid file name");
        }
        return uri;
    }

    private void log(String line) {
        if (!this.m_verbose) {
            return;
        }
        System.err.println(line);
    }

    public static class Error
    extends ErrorMessage {
        public Error(String message) {
            super(message);
        }
    }
}

