/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.thumbnail;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import net.sf.gogui.util.StringUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ThumbnailReader {
    public static void main(String[] argv) throws IOException {
        for (String arg : argv) {
            System.out.println(arg);
            MetaData metaData = ThumbnailReader.read(new File(arg));
            System.out.println("URI: " + metaData.m_uri);
            System.out.println("MTime: " + metaData.m_lastModified);
            System.out.println("MimeType: " + metaData.m_mimeType);
            System.out.println("Description: " + metaData.m_description);
            System.out.println("Software: " + metaData.m_software);
            System.out.println();
        }
    }

    public static MetaData read(File file) throws IOException {
        IIOMetadata metadata;
        MetaData metaData = new MetaData();
        ImageInputStream stream = ImageIO.createImageInputStream(file);
        if (stream == null) {
            return metaData;
        }
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        ImageReader reader = iter.next();
        reader.setInput(stream, true);
        try {
            metadata = reader.getImageMetadata(0);
        }
        catch (Throwable t) {
            StringUtil.printException(t);
            throw new IOException("Internal error reading PNG meta data");
        }
        String formatName = "javax_imageio_1.0";
        Node root = metadata.getAsTree(formatName);
        String uri = ThumbnailReader.getMeta(root, "Thumb::URI");
        try {
            if (uri == null) {
                ThumbnailReader.warning(file, "no Thumb::URI");
            } else {
                metaData.m_uri = new URI(uri);
            }
        }
        catch (URISyntaxException e) {
            ThumbnailReader.warning(file, "invalid Thumb::URI " + uri);
        }
        String lastModified = ThumbnailReader.getMeta(root, "Thumb::MTime");
        try {
            if (lastModified == null) {
                ThumbnailReader.warning(file, "no Thumb::MTime");
            } else {
                metaData.m_lastModified = Long.parseLong(ThumbnailReader.getMeta(root, "Thumb::MTime"));
            }
        }
        catch (NumberFormatException e) {
            ThumbnailReader.warning(file, "invalid Thumb::MTime " + lastModified);
        }
        metaData.m_mimeType = ThumbnailReader.getMeta(root, "Thumb::Mimetype");
        metaData.m_description = ThumbnailReader.getMeta(root, "Description");
        metaData.m_software = ThumbnailReader.getMeta(root, "Software");
        return metaData;
    }

    private static String getMeta(Node node, String key) {
        String value;
        if ("TextEntry".equalsIgnoreCase(node.getNodeName())) {
            String keyword = null;
            value = null;
            NamedNodeMap attributes = node.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (attribute.getNodeName().equals("keyword")) {
                    keyword = attribute.getNodeValue();
                    continue;
                }
                if (!attribute.getNodeName().equals("value")) continue;
                value = attribute.getNodeValue();
            }
            if (key.equals(keyword)) {
                return value;
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            value = ThumbnailReader.getMeta(child, key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static void warning(File file, String message) {
        System.err.println(file + ": " + message);
    }

    public static class MetaData {
        public URI m_uri;
        public long m_lastModified;
        public String m_mimeType;
        public String m_description;
        public String m_software;
    }
}

