/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Komi;
import net.sf.gogui.go.Marker;
import net.sf.gogui.go.PointList;
import net.sf.gogui.go.Score;

public class CountScore {
    private Marker m_dead;
    private GoColor[][] m_score;
    private ConstBoard m_board;

    public void begin(ConstBoard board, ConstPointList deadStones) {
        this.m_board = board;
        int size = board.getSize();
        this.m_dead = new Marker(size);
        this.m_score = new GoColor[size][size];
        for (GoPoint p : this.m_board) {
            this.m_dead.clear(p);
        }
        if (deadStones != null) {
            for (GoPoint p : deadStones) {
                this.m_dead.set(p);
            }
        }
        this.compute();
    }

    public PointList changeStatus(GoPoint p) {
        GoColor c = this.m_board.getColor(p);
        assert (c.isBlackWhite());
        PointList stones = new PointList();
        Marker marker = new Marker(this.m_board.getSize());
        boolean allSurroundingAlive = this.findRegion(p, c, marker, stones);
        if (!allSurroundingAlive) {
            stones.clear();
            this.m_board.getStones(p, c, stones);
        }
        boolean isDead = !this.isDead(p);
        for (GoPoint stone : stones) {
            this.setDead(stone, isDead);
        }
        return stones;
    }

    public void compute() {
        Marker mark = new Marker(this.m_board.getSize());
        boolean allEmpty = true;
        for (GoPoint p : this.m_board) {
            GoColor c = this.m_board.getColor(p);
            this.setScore(p, GoColor.EMPTY);
            if (c == GoColor.EMPTY) continue;
            allEmpty = false;
            if (this.m_dead.get(p)) continue;
            this.setScore(p, c);
        }
        if (allEmpty) {
            return;
        }
        PointList territory = new PointList();
        for (GoPoint p : this.m_board) {
            if (mark.get(p)) continue;
            territory.clear();
            if (this.isTerritory(mark, p, territory, GoColor.BLACK)) {
                this.setScore(territory, GoColor.BLACK);
                continue;
            }
            mark.clear(territory);
            if (this.isTerritory(mark, p, territory, GoColor.WHITE)) {
                this.setScore(territory, GoColor.WHITE);
                continue;
            }
            mark.clear(territory);
        }
    }

    public GoColor getColor(GoPoint p) {
        return this.m_score[p.getX()][p.getY()];
    }

    public boolean isDead(GoPoint p) {
        return this.m_dead.get(p);
    }

    public Score getScore(Komi komi, Score.ScoringMethod rules) {
        Score s = new Score();
        s.m_rules = rules;
        s.m_komi = komi;
        s.m_capturedBlack = this.m_board.getCaptured(GoColor.BLACK);
        s.m_capturedWhite = this.m_board.getCaptured(GoColor.WHITE);
        int areaDiff = 0;
        int territoryDiff = 0;
        for (GoPoint p : this.m_board) {
            GoColor c = this.m_board.getColor(p);
            GoColor sc = this.getColor(p);
            if (sc == GoColor.BLACK) {
                ++s.m_areaBlack;
                ++areaDiff;
            } else if (sc == GoColor.WHITE) {
                ++s.m_areaWhite;
                --areaDiff;
            }
            if (c == GoColor.EMPTY) {
                if (sc == GoColor.BLACK) {
                    ++s.m_territoryBlack;
                    ++territoryDiff;
                } else if (sc == GoColor.WHITE) {
                    ++s.m_territoryWhite;
                    --territoryDiff;
                }
            }
            if (c == GoColor.BLACK && sc == GoColor.WHITE) {
                ++s.m_capturedBlack;
                ++s.m_territoryWhite;
                --territoryDiff;
            }
            if (c != GoColor.WHITE || sc != GoColor.BLACK) continue;
            ++s.m_capturedWhite;
            ++s.m_territoryBlack;
            ++territoryDiff;
        }
        s.m_resultArea = areaDiff;
        s.m_resultTerritory = s.m_capturedWhite - s.m_capturedBlack + territoryDiff;
        if (komi != null) {
            s.m_resultArea -= komi.toDouble();
            s.m_resultTerritory -= komi.toDouble();
        }
        if (rules == Score.ScoringMethod.TERRITORY) {
            s.m_result = s.m_resultTerritory;
        } else {
            assert (rules == Score.ScoringMethod.AREA);
            s.m_result = s.m_resultArea;
        }
        return s;
    }

    public void setDead(GoPoint p, boolean value) {
        this.m_dead.set(p, value);
    }

    private boolean findRegion(GoPoint p, GoColor color, Marker marker, PointList stones) {
        if (marker.get(p)) {
            return true;
        }
        GoColor c = this.m_board.getColor(p);
        if (c == color.otherColor()) {
            return !this.isDead(p);
        }
        marker.set(p);
        if (c == color) {
            stones.add(p);
        }
        for (GoPoint adj : this.m_board.getAdjacent(p)) {
            if (this.findRegion(adj, color, marker, stones)) continue;
            return false;
        }
        return true;
    }

    private boolean isTerritory(Marker mark, GoPoint p, PointList territory, GoColor color) {
        GoColor c = this.getColor(p);
        if (c == color.otherColor() && !this.m_dead.get(p)) {
            return false;
        }
        if (c.equals((Object)color)) {
            return !this.m_dead.get(p);
        }
        if (mark.get(p)) {
            return true;
        }
        mark.set(p);
        territory.add(p);
        for (GoPoint adj : this.m_board.getAdjacent(p)) {
            if (this.isTerritory(mark, adj, territory, color)) continue;
            return false;
        }
        return true;
    }

    private void setScore(GoPoint p, GoColor c) {
        assert (c != null);
        this.m_score[p.getX()][p.getY()] = c;
    }

    private void setScore(ConstPointList points, GoColor c) {
        for (GoPoint p : points) {
            this.setScore(p, c);
        }
    }
}

