/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.regress;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressUtil {
    public static void checkFiles(ArrayList<String> list) throws ErrorMessage {
        for (int i = 0; i < list.size(); ++i) {
            File file = new File(list.get(i));
            if (!file.exists()) {
                throw new ErrorMessage("File not found: " + file);
            }
            if (!file.isFile()) {
                throw new ErrorMessage("Not a normal file: " + file);
            }
            if (file.canRead()) continue;
            throw new ErrorMessage("No read permissions: " + file);
        }
    }

    public static ArrayList<String> expandTestSuites(ArrayList<String> list) throws IOException {
        while (RegressUtil.containsTestSuite(list)) {
            ArrayList<String> newList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String name = list.get(i);
                if (name.startsWith("@")) {
                    File file = new File(name.substring(1));
                    newList.addAll(FileUtil.readStringListFromFile(file));
                    continue;
                }
                newList.add(name);
            }
            list = newList;
        }
        return list;
    }

    private RegressUtil() {
    }

    private static boolean containsTestSuite(ArrayList<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String name = list.get(i);
            if (!name.startsWith("@")) continue;
            return true;
        }
        return false;
    }
}

