/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.util;

import java.io.IOException;
import java.io.InputStream;

public class ByteCountInputStream
extends InputStream {
    private long m_byteCount;
    private final InputStream m_in;

    public ByteCountInputStream(InputStream in) {
        this.m_in = in;
    }

    public long getCount() {
        return this.m_byteCount;
    }

    public int read() throws IOException {
        int result = this.m_in.read();
        if (result > 0) {
            ++this.m_byteCount;
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        int result = this.m_in.read(b);
        if (result > 0) {
            this.m_byteCount += (long)result;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.m_in.read(b, off, len);
        if (result > 0) {
            this.m_byteCount += (long)result;
        }
        return result;
    }
}

