/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.game;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.ConstSgfProperties;
import net.sf.gogui.game.ExtraInfo;
import net.sf.gogui.game.GameInfo;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.MoreExtraInfo;
import net.sf.gogui.game.SetupInfo;
import net.sf.gogui.game.SgfProperties;
import net.sf.gogui.game.TimeInfo;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.go.PointList;
import net.sf.gogui.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Node
implements ConstNode {
    private byte[] m_comment;
    private ExtraInfo m_extraInfo;
    private Move m_move;
    private Node m_father;
    private Object m_children;

    public Node() {
    }

    public Node(Move move) {
        this.m_move = move;
    }

    public void append(Node node) {
        assert (node.m_father == null);
        if (this.m_children == null) {
            this.m_children = node;
        } else if (this.m_children instanceof Node) {
            ArrayList<Node> list = new ArrayList<Node>(2);
            list.add((Node)this.m_children);
            list.add(node);
            this.m_children = list;
        } else {
            ((ArrayList)this.m_children).add(node);
        }
        node.m_father = this;
    }

    public void addMarked(GoPoint point, MarkType type) {
        assert (point != null);
        Map<MarkType, PointList> marked = this.createMarked();
        PointList pointList = marked.get((Object)type);
        if (pointList == null) {
            pointList = new PointList(1);
            pointList.add(point);
            marked.put(type, pointList);
        } else if (!pointList.contains(point)) {
            pointList.add(point);
        }
    }

    public void addSgfProperty(String label, ArrayList<String> values) {
        this.createSgfProperties().add(label, values);
    }

    public void addSgfProperty(String label, String value) {
        this.createSgfProperties().add(label, value);
    }

    public void addStone(GoColor c, GoPoint p) {
        assert (p != null);
        this.createSetupInfo().m_stones.get(c).add(p);
    }

    public void addStones(GoColor c, ConstPointList list) {
        assert (list != null);
        this.createSetupInfo().m_stones.get(c).addAllFromConst(list);
    }

    public GameInfo createGameInfo() {
        MoreExtraInfo moreExtraInfo = this.createMoreExtraInfo();
        if (moreExtraInfo.m_info == null) {
            moreExtraInfo.m_info = new GameInfo();
        }
        return moreExtraInfo.m_info;
    }

    public Node getChild() {
        if (!this.hasChildren()) {
            return null;
        }
        return this.getChild(0);
    }

    @Override
    public ConstNode getChildConst() {
        return this.getChild();
    }

    public Node getChild(int i) {
        if (this.getNumberChildren() == 1) {
            return (Node)this.m_children;
        }
        return (Node)((ArrayList)this.m_children).get(i);
    }

    @Override
    public ConstNode getChildConst(int i) {
        return this.getChild(i);
    }

    @Override
    public int getChildIndex(ConstNode child) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            if (this.getChildConst(i) != child) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getComment() {
        if (this.m_comment == null) {
            return null;
        }
        try {
            return new String(this.m_comment, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.m_comment);
        }
    }

    public Node getFather() {
        return this.m_father;
    }

    @Override
    public ConstNode getFatherConst() {
        return this.m_father;
    }

    public GameInfo getGameInfo() {
        if (this.m_extraInfo == null || this.m_extraInfo.m_moreExtraInfo == null) {
            return null;
        }
        return this.m_extraInfo.m_moreExtraInfo.m_info;
    }

    @Override
    public ConstGameInfo getGameInfoConst() {
        return this.getGameInfo();
    }

    @Override
    public String getLabel(GoPoint point) {
        Map<GoPoint, String> map = this.getLabels();
        if (map == null || !map.containsKey(point)) {
            return null;
        }
        return map.get(point);
    }

    public Map<GoPoint, String> getLabels() {
        if (this.m_extraInfo == null || this.m_extraInfo.m_moreExtraInfo == null) {
            return null;
        }
        return this.m_extraInfo.m_moreExtraInfo.m_label;
    }

    @Override
    public Map<GoPoint, String> getLabelsUnmodifiable() {
        Map<GoPoint, String> labels = this.getLabels();
        if (labels == null) {
            return null;
        }
        return Collections.unmodifiableMap(labels);
    }

    public PointList getMarked(MarkType type) {
        if (this.m_extraInfo == null || this.m_extraInfo.m_marked == null) {
            return null;
        }
        return this.m_extraInfo.m_marked.get((Object)type);
    }

    @Override
    public ConstPointList getMarkedConst(MarkType type) {
        return this.getMarked(type);
    }

    @Override
    public Move getMove() {
        return this.m_move;
    }

    @Override
    public int getMovesLeft(GoColor c) {
        assert (c.isBlackWhite());
        TimeInfo timeInfo = this.getTimeInfo();
        if (timeInfo == null) {
            return -1;
        }
        return timeInfo.m_movesLeft.get(c);
    }

    @Override
    public int getNumberChildren() {
        if (this.m_children == null) {
            return 0;
        }
        if (this.m_children instanceof Node) {
            return 1;
        }
        return ((ArrayList)this.m_children).size();
    }

    @Override
    public GoColor getPlayer() {
        SetupInfo setupInfo = this.getSetupInfo();
        if (setupInfo == null) {
            return null;
        }
        return setupInfo.m_player;
    }

    @Override
    public ConstPointList getSetup(GoColor c) {
        SetupInfo setupInfo = this.getSetupInfo();
        if (setupInfo == null) {
            return PointList.getEmptyList();
        }
        return setupInfo.m_stones.get(c);
    }

    public SgfProperties getSgfProperties() {
        if (this.m_extraInfo == null || this.m_extraInfo.m_moreExtraInfo == null) {
            return null;
        }
        return this.m_extraInfo.m_moreExtraInfo.m_sgfProperties;
    }

    @Override
    public ConstSgfProperties getSgfPropertiesConst() {
        return this.getSgfProperties();
    }

    @Override
    public double getTimeLeft(GoColor c) {
        assert (c.isBlackWhite());
        TimeInfo timeInfo = this.getTimeInfo();
        if (timeInfo == null) {
            return Double.NaN;
        }
        return timeInfo.m_timeLeft.get(c);
    }

    @Override
    public GoColor getToMove() {
        GoColor player = this.getPlayer();
        if (player != null) {
            return player;
        }
        if (this.m_move != null) {
            return this.m_move.getColor().otherColor();
        }
        return null;
    }

    @Override
    public float getValue() {
        if (this.m_extraInfo == null) {
            return Float.NaN;
        }
        return this.m_extraInfo.m_value;
    }

    @Override
    public boolean hasChildren() {
        return this.getNumberChildren() > 0;
    }

    @Override
    public boolean hasComment() {
        return this.m_comment != null;
    }

    @Override
    public boolean hasFather() {
        return this.getFatherConst() != null;
    }

    @Override
    public boolean hasSetup() {
        for (GoColor c : GoColor.BLACK_WHITE_EMPTY) {
            if (this.getSetup(c).size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOf(Node node) {
        return node.getChildIndex(this) != -1;
    }

    @Override
    public boolean isEmpty() {
        return this.m_comment == null && this.m_move == null && (this.m_extraInfo == null || this.m_extraInfo.isEmpty());
    }

    public void makeFirstChild(Node child) {
        assert (child.isChildOf(this));
        if (this.getNumberChildren() <= 1) {
            return;
        }
        ArrayList list = (ArrayList)this.m_children;
        list.remove(child);
        list.add(0, child);
    }

    public void removeChild(Node child) {
        assert (child.isChildOf(this));
        int numberChildren = this.getNumberChildren();
        if (numberChildren == 1) {
            this.m_children = null;
        } else if (numberChildren >= 2) {
            ArrayList list = (ArrayList)this.m_children;
            list.remove(child);
            if (numberChildren == 2) {
                this.m_children = list.get(0);
            }
        } else assert (false);
        child.m_father = null;
    }

    public void removeMarked(GoPoint point, MarkType type) {
        assert (point != null);
        Map<MarkType, PointList> marked = this.createMarked();
        PointList pointList = marked.get((Object)type);
        if (pointList != null) {
            pointList.remove(point);
        }
    }

    public void removeSetup(GoPoint p) {
        assert (p != null);
        SetupInfo setupInfo = this.getSetupInfo();
        if (setupInfo == null) {
            return;
        }
        for (GoColor c : GoColor.BLACK_WHITE_EMPTY) {
            while (setupInfo.m_stones.get(c).remove(p)) {
            }
        }
    }

    public void removeVariations() {
        if (this.getNumberChildren() <= 1) {
            return;
        }
        Node child = this.getChild(0);
        this.m_children = child;
    }

    public void setComment(String comment) {
        if (StringUtil.isEmpty(comment)) {
            this.m_comment = null;
            return;
        }
        try {
            this.m_comment = comment.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.m_comment = comment.getBytes();
        }
    }

    public void setFather(Node father) {
        this.m_father = father;
    }

    public void setLabel(GoPoint point, String label) {
        assert (point != null);
        Map<GoPoint, String> map = this.createLabel();
        map.remove(point);
        if (label == null) {
            return;
        }
        if ((label = label.trim()).equals("")) {
            return;
        }
        map.put(point, label);
    }

    public void setMove(Move move) {
        this.m_move = move;
    }

    public void setMovesLeft(GoColor c, int n) {
        assert (c.isBlackWhite());
        this.createTimeInfo().m_movesLeft.set(c, n);
    }

    public void setTimeLeft(GoColor c, double seconds) {
        assert (c.isBlackWhite());
        this.createTimeInfo().m_timeLeft.set(c, seconds);
    }

    public void setPlayer(GoColor color) {
        assert (color.isBlackWhite());
        this.createSetupInfo().m_player = color;
    }

    public void setValue(float value) {
        this.createExtraInfo();
        this.m_extraInfo.m_value = value;
    }

    public void sortSetup() {
        for (GoColor c : GoColor.BLACK_WHITE_EMPTY) {
            if (this.getSetup(c).size() <= 0) continue;
            Collections.sort(this.getSetupInfo().m_stones.get(c));
        }
    }

    @Override
    public ConstNode variationAfter(ConstNode child) {
        int i;
        int numberChildren = this.getNumberChildren();
        if (numberChildren == 1) {
            return null;
        }
        for (i = 0; i < numberChildren && this.getChildConst(i) != child; ++i) {
        }
        if (i == numberChildren - 1) {
            return null;
        }
        return this.getChildConst(i + 1);
    }

    @Override
    public ConstNode variationBefore(ConstNode child) {
        int i;
        int numberChildren = this.getNumberChildren();
        if (numberChildren == 1) {
            return null;
        }
        for (i = 0; i < numberChildren && this.getChildConst(i) != child; ++i) {
        }
        if (i == 0) {
            return null;
        }
        return this.getChildConst(i - 1);
    }

    private void createExtraInfo() {
        if (this.m_extraInfo == null) {
            this.m_extraInfo = new ExtraInfo();
        }
    }

    private MoreExtraInfo createMoreExtraInfo() {
        this.createExtraInfo();
        if (this.m_extraInfo.m_moreExtraInfo == null) {
            this.m_extraInfo.m_moreExtraInfo = new MoreExtraInfo();
        }
        return this.m_extraInfo.m_moreExtraInfo;
    }

    private Map<GoPoint, String> createLabel() {
        MoreExtraInfo moreExtraInfo = this.createMoreExtraInfo();
        if (moreExtraInfo.m_label == null) {
            moreExtraInfo.m_label = new TreeMap<GoPoint, String>();
        }
        return moreExtraInfo.m_label;
    }

    private Map<MarkType, PointList> createMarked() {
        this.createExtraInfo();
        if (this.m_extraInfo.m_marked == null) {
            this.m_extraInfo.m_marked = new TreeMap<MarkType, PointList>();
        }
        return this.m_extraInfo.m_marked;
    }

    private SetupInfo createSetupInfo() {
        MoreExtraInfo moreExtraInfo = this.createMoreExtraInfo();
        if (moreExtraInfo.m_setupInfo == null) {
            moreExtraInfo.m_setupInfo = new SetupInfo();
        }
        return moreExtraInfo.m_setupInfo;
    }

    private SgfProperties createSgfProperties() {
        MoreExtraInfo moreExtraInfo = this.createMoreExtraInfo();
        if (moreExtraInfo.m_sgfProperties == null) {
            moreExtraInfo.m_sgfProperties = new SgfProperties();
        }
        return moreExtraInfo.m_sgfProperties;
    }

    private TimeInfo createTimeInfo() {
        MoreExtraInfo moreExtraInfo = this.createMoreExtraInfo();
        if (moreExtraInfo.m_timeInfo == null) {
            moreExtraInfo.m_timeInfo = new TimeInfo();
        }
        return moreExtraInfo.m_timeInfo;
    }

    private SetupInfo getSetupInfo() {
        if (this.m_extraInfo == null || this.m_extraInfo.m_moreExtraInfo == null) {
            return null;
        }
        return this.m_extraInfo.m_moreExtraInfo.m_setupInfo;
    }

    private TimeInfo getTimeInfo() {
        if (this.m_extraInfo == null || this.m_extraInfo.m_moreExtraInfo == null) {
            return null;
        }
        return this.m_extraInfo.m_moreExtraInfo.m_timeInfo;
    }
}

