/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.PointList;
import net.sf.gogui.gtp.AnalyzeCommand;
import net.sf.gogui.gtp.AnalyzeDefinition;
import net.sf.gogui.gtp.AnalyzeType;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpResponseFormatError;
import net.sf.gogui.gtp.GtpUtil;
import net.sf.gogui.gui.FileDialogs;
import net.sf.gogui.gui.GuiGtpClient;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.util.Platform;
import net.sf.gogui.util.PrefUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnalyzeDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final int MAX_SAVE_RECENT = 100;
    private boolean m_firstIsTemp;
    private int m_boardSize = 19;
    private ArrayList<String> m_fullRecentList;
    private GoColor m_selectedColor = GoColor.EMPTY;
    private final MessageDialogs m_messageDialogs;
    private final GuiGtpClient m_gtp;
    private JButton m_clearButton;
    private JButton m_runButton;
    private JCheckBox m_autoRun;
    private JCheckBox m_clearBoard;
    private JCheckBox m_reuseWindow;
    private JComboBox m_comboBoxHistory;
    private JList m_list;
    private Box m_colorBox;
    private JRadioButton m_black;
    private JRadioButton m_white;
    private final ArrayList<AnalyzeDefinition> m_commands;
    private final Listener m_listener;
    private String m_lastUpdateOptionsCommand;

    public AnalyzeDialog(Frame owner, Listener listener, ArrayList<AnalyzeDefinition> commands, GuiGtpClient gtp, MessageDialogs messageDialogs) {
        super(owner, I18n.i18n("TIT_ANALYZE"));
        this.m_messageDialogs = messageDialogs;
        this.m_gtp = gtp;
        this.m_commands = commands;
        this.m_listener = listener;
        Container contentPane = this.getContentPane();
        JPanel commandPanel = this.createCommandPanel();
        contentPane.add((Component)commandPanel, "Center");
        this.comboBoxChanged();
        this.setSelectedColor(GoColor.BLACK);
        int minWidth = commandPanel.getPreferredSize().width;
        this.setMinimumSize(new Dimension(minWidth, 192));
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                AnalyzeDialog.this.m_comboBoxHistory.requestFocusInWindow();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("clear")) {
            this.clearCommand();
        } else if (command.equals("comboBoxChanged")) {
            this.comboBoxChanged();
        } else if (command.equals("run")) {
            this.runCommand();
        } else assert (false);
    }

    @Override
    public void dispose() {
        if (!this.m_autoRun.isSelected()) {
            this.clearCommand();
        }
        this.saveRecent();
        super.dispose();
    }

    public boolean getReuseTextWindow() {
        return this.m_reuseWindow.isSelected();
    }

    public GoColor getSelectedColor() {
        if (this.m_black.isSelected()) {
            return GoColor.BLACK;
        }
        return GoColor.WHITE;
    }

    public void saveRecent() {
        String name;
        int start;
        int i;
        ArrayList<String> recent = new ArrayList<String>(100);
        for (i = start = this.m_firstIsTemp ? 1 : 0; i < this.getComboBoxItemCount(); ++i) {
            name = this.getComboBoxItem(i);
            if (recent.indexOf(name) >= 0) continue;
            recent.add(name);
        }
        for (i = 0; i < this.m_fullRecentList.size() && recent.size() != 100; ++i) {
            name = this.m_fullRecentList.get(i);
            if (recent.indexOf(name) >= 0) continue;
            recent.add(name);
        }
        PrefUtil.putList("net/sf/gogui/gui/analyzedialog/recentcommands", recent);
    }

    public void setBoardSize(int boardSize) {
        this.m_boardSize = boardSize;
    }

    public void setReuseTextWindow(boolean enable) {
        this.m_reuseWindow.setSelected(enable);
    }

    public void setSelectedColor(GoColor color) {
        this.m_selectedColor = color;
        this.selectColor();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this.m_list.getSelectedIndex();
        if (index >= 0) {
            this.selectCommand(index);
        }
    }

    private void clearCommand() {
        this.m_listener.actionClearAnalyzeCommand();
        this.m_autoRun.setSelected(false);
    }

    private void comboBoxChanged() {
        Object item = this.m_comboBoxHistory.getSelectedItem();
        if (item == null) {
            this.m_list.clearSelection();
            return;
        }
        String label = item.toString();
        this.updateOptions(label);
        String selectedValue = (String)this.m_list.getSelectedValue();
        if (selectedValue != null && !selectedValue.equals(label)) {
            this.m_list.clearSelection();
        }
    }

    private JPanel createButtons() {
        JPanel innerPanel = new JPanel(new GridLayout(1, 0, 5, 0));
        this.m_runButton = new JButton(I18n.i18n("LB_RUN"));
        this.m_runButton.setToolTipText(I18n.i18n("TT_ANALYZE_RUN"));
        this.m_runButton.setActionCommand("run");
        this.m_runButton.addActionListener(this);
        this.m_runButton.setMnemonic(82);
        this.m_runButton.setEnabled(false);
        GuiUtil.setMacBevelButton(this.m_runButton);
        innerPanel.add(this.m_runButton);
        this.m_clearButton = new JButton(I18n.i18n("LB_ANALYZE_CLEAR"));
        this.m_clearButton.setToolTipText(I18n.i18n("TT_ANALYZE_CLEAR"));
        this.m_clearButton.setActionCommand("clear");
        this.m_clearButton.addActionListener(this);
        this.m_clearButton.setMnemonic(67);
        GuiUtil.setMacBevelButton(this.m_clearButton);
        innerPanel.add(this.m_clearButton);
        JPanel outerPanel = new JPanel(new FlowLayout(1));
        outerPanel.add(innerPanel);
        return outerPanel;
    }

    private JComponent createColorPanel() {
        this.m_colorBox = Box.createVerticalBox();
        ButtonGroup group = new ButtonGroup();
        this.m_black = new JRadioButton(I18n.i18n("LB_BLACK"));
        this.m_black.setToolTipText(I18n.i18n("TT_ANALYZE_BLACK"));
        this.m_black.setEnabled(false);
        group.add(this.m_black);
        this.m_colorBox.add(this.m_black);
        this.m_white = new JRadioButton(I18n.i18n("LB_WHITE"));
        this.m_white.setToolTipText(I18n.i18n("TT_ANALYZE_WHITE"));
        this.m_white.setEnabled(false);
        group.add(this.m_white);
        this.m_colorBox.add(this.m_white);
        return this.m_colorBox;
    }

    private JPanel createCommandPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.m_list = new JList();
        this.m_list.setSelectionMode(0);
        this.m_list.setVisibleRowCount(25);
        this.m_list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int modifiers = e.getModifiers();
                int mask = 8;
                if (e.getClickCount() == 2 || (modifiers & mask) != 0) {
                    AnalyzeDialog.this.runCommand();
                }
            }
        });
        this.m_list.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                int index = AnalyzeDialog.this.getSelectedCommand();
                if (index >= 0) {
                    AnalyzeDialog.this.m_list.setSelectedIndex(index);
                }
            }
        });
        this.m_list.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.m_list);
        if (Platform.isMac()) {
            scrollPane.setBorder(null);
        }
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)this.createLowerPanel(), "South");
        String[] labels = new String[this.m_commands.size()];
        for (int i = 0; i < this.m_commands.size(); ++i) {
            labels[i] = this.m_commands.get(i).getLabel();
        }
        this.m_list.setListData(labels);
        this.comboBoxChanged();
        this.loadRecent();
        return panel;
    }

    private JComponent createLowerPanel() {
        Box panel = Box.createVerticalBox();
        panel.add(GuiUtil.createFiller());
        this.m_comboBoxHistory = new JComboBox();
        panel.add(this.m_comboBoxHistory);
        Box lowerPanel = Box.createVerticalBox();
        lowerPanel.setBorder(GuiUtil.createEmptyBorder());
        panel.add(lowerPanel);
        Box optionsPanel = Box.createHorizontalBox();
        lowerPanel.add(optionsPanel);
        JPanel leftPanel = new JPanel();
        optionsPanel.add(leftPanel);
        Box leftBox = Box.createVerticalBox();
        leftPanel.add(leftBox);
        this.m_autoRun = new JCheckBox(I18n.i18n("LB_ANALYZE_AUTORUN"));
        this.m_autoRun.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (!AnalyzeDialog.this.m_autoRun.isSelected()) {
                    AnalyzeDialog.this.m_listener.actionClearAnalyzeCommand();
                }
            }
        });
        this.m_autoRun.setToolTipText(I18n.i18n("TT_ANALYZE_AUTORUN"));
        this.m_autoRun.setEnabled(false);
        leftBox.add(this.m_autoRun);
        this.m_clearBoard = new JCheckBox(I18n.i18n("LB_ANALYZE_CLEARBOARD"));
        this.m_clearBoard.setToolTipText(I18n.i18n("TT_ANALYZE_CLEARBOARD"));
        this.m_clearBoard.setEnabled(false);
        leftBox.add(this.m_clearBoard);
        this.m_clearBoard.setSelected(true);
        this.m_reuseWindow = new JCheckBox(I18n.i18n("LB_ANALYZE_REUSE_TEXT_WINDOW"));
        this.m_reuseWindow.setToolTipText(I18n.i18n("TT_ANALYZE_REUSE_TEXT_WINDOW"));
        leftBox.add(this.m_reuseWindow);
        JPanel rightPanel = new JPanel();
        rightPanel.add(this.createColorPanel());
        optionsPanel.add(rightPanel);
        optionsPanel.add(Box.createHorizontalGlue());
        optionsPanel.add(GuiUtil.createFiller());
        optionsPanel.add(GuiUtil.createFiller());
        lowerPanel.add(this.createButtons());
        this.m_comboBoxHistory.addActionListener(this);
        return panel;
    }

    private String getComboBoxItem(int i) {
        return this.m_comboBoxHistory.getItemAt(i).toString();
    }

    private int getComboBoxItemCount() {
        return this.m_comboBoxHistory.getItemCount();
    }

    private int getCommandIndex(String label) {
        for (int i = 0; i < this.m_commands.size(); ++i) {
            if (!this.m_commands.get(i).getLabel().equals(label)) continue;
            return i;
        }
        return -1;
    }

    private int getSelectedCommand() {
        Object item = this.m_comboBoxHistory.getSelectedItem();
        if (item == null) {
            return -1;
        }
        return this.getCommandIndex(item.toString());
    }

    private void insertComboBoxItem(String label, int index) {
        this.m_comboBoxHistory.insertItemAt(GuiUtil.createComboBoxItem(label), index);
    }

    private void loadRecent() {
        int index;
        this.m_comboBoxHistory.removeAllItems();
        this.m_fullRecentList = PrefUtil.getList("net/sf/gogui/gui/analyzedialog/recentcommands");
        for (int i = 0; i < this.m_fullRecentList.size(); ++i) {
            String name = this.m_fullRecentList.get(i);
            if (this.getCommandIndex(name) >= 0) {
                this.m_comboBoxHistory.addItem(GuiUtil.createComboBoxItem(name));
            }
            if (this.m_comboBoxHistory.getItemCount() > 20) break;
        }
        if ((index = this.getSelectedCommand()) >= 0) {
            this.selectCommand(index);
        }
        this.m_firstIsTemp = false;
    }

    private void runCommand() {
        File fileArg;
        String commandWithoutArg;
        if (this.m_gtp.isCommandInProgress()) {
            this.showError("MSG_ANALYZE_CANNOT_EXECUTE", "MSG_ANALYZE_CANNOT_EXECUTE_2", false);
            return;
        }
        int index = this.getSelectedCommand();
        if (index < 0) {
            String name = this.m_gtp.getName();
            if (name == null) {
                this.showError("MSG_ANALYZE_NOT_SUPPORTED", "MSG_ANALYZE_NOT_SUPPORTED_2", false);
            } else {
                this.showError("MSG_ANALYZE_NOT_SUPPORTED", "MSG_ANALYZE_NOT_SUPPORTED_3", false, name);
            }
            return;
        }
        this.updateRecent(index);
        AnalyzeCommand command = new AnalyzeCommand(this.m_commands.get(index));
        if (command.needsColorArg()) {
            command.setColorArg(this.getSelectedColor());
        }
        String label = command.getResultTitle();
        if (command.needsStringArg()) {
            String stringArg = JOptionPane.showInputDialog(this, label, I18n.i18n("TIT_INPUT"), -1);
            if (stringArg == null) {
                return;
            }
            command.setStringArg(stringArg);
        }
        if (command.needsOptStringArg()) {
            command.setOptStringArg("");
            commandWithoutArg = command.replaceWildCards(this.m_selectedColor);
            try {
                String value = this.m_gtp.send(commandWithoutArg);
                Object optStringArg = JOptionPane.showInputDialog(this, label, I18n.i18n("TIT_INPUT"), -1, null, null, value);
                if (optStringArg == null || optStringArg.equals(value)) {
                    return;
                }
                command.setOptStringArg((String)optStringArg);
            }
            catch (GtpError e) {
                this.showError("MSG_ANALYZE_COMMAND_FAILED", e.getMessage(), false, commandWithoutArg);
                return;
            }
        }
        if (command.getType() == AnalyzeType.EPLIST) {
            command.setPointListArg(new PointList());
            commandWithoutArg = command.replaceWildCards(this.m_selectedColor) + " show";
            try {
                String response = this.m_gtp.send(commandWithoutArg);
                PointList pointList = GtpUtil.parsePointList(response, this.m_boardSize);
                command.setPointListArg(pointList);
            }
            catch (GtpError e) {
                this.showError("MSG_ANALYZE_COMMAND_FAILED", e.getMessage(), false, commandWithoutArg);
                return;
            }
            catch (GtpResponseFormatError e) {
                this.showError("MSG_ANALYZE_INVALID_RESPONSE", "MSG_ANALYZE_INVALID_RESPONSE_2", true, commandWithoutArg, e.getMessage());
                return;
            }
        }
        if (command.needsFileArg()) {
            fileArg = FileDialogs.showSelectFile(this, label);
            if (fileArg == null) {
                return;
            }
            command.setFileArg(fileArg);
        }
        if (command.needsFileOpenArg()) {
            fileArg = FileDialogs.showOpen(this, label);
            if (fileArg == null) {
                return;
            }
            command.setFileOpenArg(fileArg);
        }
        if (command.needsFileSaveArg()) {
            fileArg = FileDialogs.showSave(this, label, this.m_messageDialogs);
            if (fileArg == null) {
                return;
            }
            command.setFileSaveArg(fileArg);
        }
        if (command.needsColorArg()) {
            command.setColorArg(this.getSelectedColor());
        }
        boolean autoRun = this.m_autoRun.isEnabled() && this.m_autoRun.isSelected();
        boolean clearBoard = !this.m_clearBoard.isEnabled() || this.m_clearBoard.isSelected();
        boolean reuseWindow = this.m_reuseWindow.isEnabled() && this.m_reuseWindow.isSelected();
        this.m_listener.actionSetAnalyzeCommand(command, autoRun, clearBoard, false, reuseWindow);
    }

    private void selectCommand(int index) {
        String label = this.m_commands.get(index).getLabel();
        this.updateOptions(label);
        this.m_comboBoxHistory.removeActionListener(this);
        if (this.m_firstIsTemp && this.getComboBoxItemCount() > 0) {
            this.m_comboBoxHistory.removeItemAt(0);
        }
        if (this.getComboBoxItemCount() == 0 || !this.getComboBoxItem(0).equals(label)) {
            this.insertComboBoxItem(label, 0);
            this.m_firstIsTemp = true;
            this.m_comboBoxHistory.setSelectedIndex(0);
        }
        this.m_comboBoxHistory.addActionListener(this);
    }

    private void selectColor() {
        if (this.m_selectedColor == GoColor.BLACK) {
            this.m_black.setSelected(true);
        } else if (this.m_selectedColor == GoColor.WHITE) {
            this.m_white.setSelected(true);
        }
    }

    private void showError(String mainMessage, String optionalMessage, boolean isCritical) {
        this.m_messageDialogs.showError((Component)this, I18n.i18n(mainMessage), I18n.i18n(optionalMessage), isCritical);
    }

    private void showError(String mainMessage, String optionalMessage, boolean isCritical, Object ... args) {
        optionalMessage = MessageFormat.format(I18n.i18n(optionalMessage), args);
        this.m_messageDialogs.showError((Component)this, I18n.i18n(mainMessage), optionalMessage, isCritical);
    }

    private void updateOptions(String label) {
        if (label.equals(this.m_lastUpdateOptionsCommand)) {
            return;
        }
        this.m_lastUpdateOptionsCommand = label;
        int index = this.getCommandIndex(label);
        if (index < 0) {
            return;
        }
        AnalyzeCommand command = new AnalyzeCommand(this.m_commands.get(index));
        boolean needsColorArg = command.needsColorArg();
        this.m_black.setEnabled(needsColorArg);
        this.m_white.setEnabled(needsColorArg);
        this.m_autoRun.setEnabled(command.getType() != AnalyzeType.PARAM);
        this.m_autoRun.setSelected(false);
        this.m_clearBoard.setEnabled(command.getType() != AnalyzeType.PARAM);
        this.m_runButton.setEnabled(true);
    }

    private void updateRecent(int index) {
        String label = this.m_commands.get(index).getLabel();
        this.insertComboBoxItem(label, 0);
        this.m_comboBoxHistory.setSelectedIndex(0);
        for (int i = 1; i < this.getComboBoxItemCount(); ++i) {
            if (!this.getComboBoxItem(i).equals(label)) continue;
            this.m_comboBoxHistory.removeItemAt(i);
        }
        this.m_firstIsTemp = false;
    }

    public static interface Listener {
        public void actionClearAnalyzeCommand();

        public void actionSetAnalyzeCommand(AnalyzeCommand var1, boolean var2, boolean var3, boolean var4, boolean var5);
    }
}

