/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseListener;
import java.awt.font.LineMetrics;
import javax.swing.JComponent;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.Move;
import net.sf.gogui.gui.GameTreePanel;
import net.sf.gogui.gui.I18n;

class GameTreeNode
extends JComponent {
    private final int m_moveNumber;
    private static final Color COLOR_LIGHT_BLUE = new Color(103, 122, 164);
    private static final Color COLOR_CURSOR = new Color(142, 168, 226);
    private static final Color COLOR_GRID = new Color(148, 148, 148);
    private final GameTreePanel m_gameTreePanel;
    private final ConstNode m_node;
    private final Image m_imageBlack;
    private final Image m_imageWhite;
    private final Image m_imageSetup;

    public GameTreeNode(ConstNode node, int moveNumber, GameTreePanel gameTreePanel, MouseListener mouseListener, Font font, Image imageBlack, Image imageWhite, Image imageSetup, Dimension size) {
        this.m_gameTreePanel = gameTreePanel;
        this.m_node = node;
        this.m_moveNumber = moveNumber;
        this.addMouseListener(mouseListener);
        this.setOpaque(false);
        this.setFocusable(false);
        this.setFocusTraversalKeysEnabled(false);
        if (font != null) {
            this.setFont(font);
        }
        this.m_imageBlack = imageBlack;
        this.m_imageWhite = imageWhite;
        this.m_imageSetup = imageSetup;
        this.updateToolTip();
        this.setPreferredSize(size);
    }

    public ConstNode getNode() {
        return this.m_node;
    }

    public void paintComponent(Graphics graphics) {
        int size = this.m_gameTreePanel.getNodeSize();
        int fullSize = this.m_gameTreePanel.getNodeFullSize();
        int halfSize = size / 2;
        int numberChildren = this.m_node.getNumberChildren();
        boolean isExpanded = this.m_gameTreePanel.isExpanded(this.m_node);
        if (this.m_gameTreePanel.isCurrent(this.m_node)) {
            graphics.setColor(COLOR_CURSOR);
            graphics.fillRect(0, 0, size, size > 10 ? size : fullSize - 1);
        }
        graphics.setColor(COLOR_GRID);
        if (numberChildren > 0) {
            graphics.drawLine(size, halfSize, fullSize, halfSize);
        }
        if (numberChildren > 1 && isExpanded) {
            graphics.drawLine(halfSize, size, halfSize, fullSize);
        }
        Move move = this.m_node.getMove();
        if (this.m_node.hasSetup()) {
            graphics.drawImage(this.m_imageSetup, 0, 0, null);
        } else if (move == null) {
            graphics.setColor(COLOR_GRID);
            int[] xPoints = new int[]{halfSize, size, halfSize, 0};
            int[] yPoints = new int[]{0, halfSize, size, halfSize};
            graphics.fillPolygon(xPoints, yPoints, 4);
        } else {
            if (move.getColor() == GoColor.BLACK) {
                graphics.drawImage(this.m_imageBlack, 0, 0, null);
            } else {
                graphics.drawImage(this.m_imageWhite, 0, 0, null);
            }
            this.drawText(graphics);
        }
        if (this.m_node.hasComment()) {
            graphics.setColor(COLOR_LIGHT_BLUE);
            int y = size + (fullSize - size) / 4;
            int d = size / 5;
            graphics.drawLine(d, y, size - d, y);
        }
    }

    public final void updateToolTip() {
        StringBuilder toolTip = new StringBuilder(128);
        Move move = this.m_node.getMove();
        GoColor player = this.m_node.getPlayer();
        if (move != null) {
            toolTip.append(this.m_moveNumber);
            toolTip.append(' ');
            toolTip.append(move);
        } else if (this.m_node.hasSetup() || player != null) {
            toolTip.append(I18n.i18n("TT_NODE_SETUP"));
            toolTip.append(" (");
            boolean anyStones = false;
            for (GoColor c : GoColor.BLACK_WHITE_EMPTY) {
                int n = this.m_node.getSetup(c).size();
                if (n == 0) continue;
                if (anyStones) {
                    toolTip.append(", ");
                }
                anyStones = true;
                toolTip.append(c.getUppercaseLetter());
                toolTip.append(' ');
                toolTip.append(n);
            }
            if (player != null) {
                if (anyStones) {
                    toolTip.append(", ");
                }
                toolTip.append(I18n.i18n("TT_NODE_PLAYER"));
                toolTip.append(' ');
                toolTip.append(player.getUppercaseLetter());
            }
            toolTip.append(')');
        }
        String comment = NodeUtil.getCommentStart(this.m_node, false, 80);
        if (comment != null) {
            comment = comment.replaceAll("\n *\n", "\n");
            if ((comment = comment.replaceAll("\n", "<br>")).length() > 50) {
                toolTip.append("<p width=\"250\">");
                toolTip.append(comment);
                toolTip.append("</p>");
            } else {
                toolTip.append("<p>");
                toolTip.append(comment);
                toolTip.append("</p>");
            }
        }
        if (toolTip.length() > 0) {
            this.setToolTipText("<html>" + toolTip.toString() + "</html>");
        }
    }

    private void drawText(Graphics graphics) {
        String text;
        GameTreePanel.Label labelMode = this.m_gameTreePanel.getLabelMode();
        if (labelMode == GameTreePanel.Label.NONE) {
            return;
        }
        Move move = this.m_node.getMove();
        int size = this.m_gameTreePanel.getNodeSize();
        if (labelMode == GameTreePanel.Label.MOVE) {
            if (move.getPoint() == null) {
                return;
            }
            text = move.getPoint().toString();
        } else {
            text = Integer.toString(this.m_moveNumber);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(text, graphics);
        int textWidth = fontMetrics.stringWidth(text);
        int ascent = (int)lineMetrics.getAscent();
        int xText = (size - textWidth) / 2;
        int yText = (ascent + size) / 2;
        if (move.getColor() == GoColor.BLACK) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.drawString(text, xText, yText);
    }
}

