/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.gui.GameTreePanel;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.util.Platform;

public class GameTreeViewer
extends JDialog {
    private final GameTreePanel m_panel;
    private final JScrollPane m_scrollPane;

    public GameTreeViewer(Frame owner, Listener listener, MessageDialogs messageDialogs) {
        super(owner, I18n.i18n("TIT_TREE"));
        Container contentPane = this.getContentPane();
        this.m_panel = new GameTreePanel(this, listener, GameTreePanel.Label.NUMBER, GameTreePanel.Size.NORMAL, messageDialogs);
        this.m_scrollPane = new JScrollPane(this.m_panel, 22, 32);
        if (Platform.isMac()) {
            this.m_scrollPane.setBorder(null);
        }
        GuiUtil.removeKeyBinding(this.m_scrollPane, "control END");
        KeyAdapter keyAdapter = new KeyAdapter(){
            private final int m_shortcut = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

            public void keyReleased(KeyEvent e) {
                boolean shift;
                int c = e.getKeyCode();
                int mod = e.getModifiers();
                if ((mod & this.m_shortcut) == 0) {
                    if (c == 36) {
                        GameTreeViewer.this.scrollToCurrent();
                    }
                    return;
                }
                boolean bl = shift = (mod & 1) != 0;
                if (c == 10 && !shift) {
                    GameTreeViewer.this.m_panel.showPopup();
                }
            }
        };
        this.m_scrollPane.addKeyListener(keyAdapter);
        this.m_panel.setScrollPane(this.m_scrollPane);
        this.m_scrollPane.setFocusable(true);
        this.m_scrollPane.setFocusTraversalKeysEnabled(false);
        JViewport viewport = this.m_scrollPane.getViewport();
        viewport.setBackground(GameTreePanel.BACKGROUND);
        contentPane.add((Component)this.m_scrollPane, "Center");
        viewport.setFocusTraversalKeysEnabled(false);
        this.setFocusTraversalKeysEnabled(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                GameTreeViewer.this.m_scrollPane.requestFocusInWindow();
            }
        });
        this.setMinimumSize(new Dimension(128, 96));
        this.pack();
    }

    public void addNewSingleChild(ConstNode node) {
        this.m_panel.addNewSingleChild(node);
    }

    public void redrawCurrentNode() {
        this.m_panel.redrawCurrentNode();
    }

    public void scrollToCurrent() {
        this.m_panel.scrollToCurrent();
    }

    public void setLabelMode(GameTreePanel.Label mode) {
        this.m_panel.setLabelMode(mode);
    }

    public void setSizeMode(GameTreePanel.Size mode) {
        this.m_panel.setSizeMode(mode);
    }

    public void setShowSubtreeSizes(boolean enable) {
        this.m_panel.setShowSubtreeSizes(enable);
    }

    public void update(ConstGameTree gameTree, ConstNode currentNode) {
        Dimension size = this.m_scrollPane.getViewport().getSize();
        this.m_panel.update(gameTree, currentNode, size.width, size.height);
        this.repaint();
    }

    public void update(ConstNode currentNode) {
        Dimension size = this.m_scrollPane.getViewport().getSize();
        this.m_panel.update(currentNode, size.width, size.height);
    }

    public static interface Listener {
        public void actionGotoNode(ConstNode var1);
    }
}

