/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.sf.gogui.gtp.GtpUtil;
import net.sf.gogui.gui.FileDialogs;
import net.sf.gogui.gui.GtpShellText;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.util.ObjectUtil;
import net.sf.gogui.util.Platform;
import net.sf.gogui.util.PrefUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtpShell
extends JDialog
implements ActionListener {
    private boolean m_disableCompletions;
    private boolean m_commandInProgress;
    private final int m_historyMax;
    private final int m_historyMin;
    private int m_linesTruncated;
    private int m_numberCommands;
    private final Listener m_listener;
    private ComboBoxEditor m_editor;
    private JButton m_runButton;
    private JTextField m_textField;
    private JComboBox m_comboBox;
    private final JScrollPane m_scrollPane;
    private final GtpShellText m_gtpShellText;
    private final StringBuilder m_commands = new StringBuilder(4096);
    private final ArrayList<String> m_history = new ArrayList(128);
    private String m_selectedText;
    private String m_programCommand = "unknown";
    private String m_programName = "unknown";
    private String m_programVersion = "unknown";
    private final MessageDialogs m_messageDialogs;

    public GtpShell(Frame owner, Listener listener, MessageDialogs messageDialogs) {
        super(owner, I18n.i18n("TIT_SHELL"));
        this.m_messageDialogs = messageDialogs;
        this.m_listener = listener;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        this.m_historyMin = prefs.getInt("history-min", 2000);
        this.m_historyMax = prefs.getInt("history-max", 3000);
        JPanel panel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.m_gtpShellText = new GtpShellText(this.m_historyMin, this.m_historyMax, false);
        CaretListener caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent event) {
                if (GtpShell.this.m_listener == null) {
                    return;
                }
                String selectedText = GtpShell.this.m_gtpShellText.getSelectedText();
                if (!ObjectUtil.equals(selectedText, GtpShell.this.m_selectedText)) {
                    GtpShell.this.m_listener.textSelected(selectedText);
                    GtpShell.this.m_selectedText = selectedText;
                }
            }
        };
        this.m_gtpShellText.addCaretListener(caretListener);
        this.m_scrollPane = new JScrollPane(this.m_gtpShellText, 22, 31);
        if (Platform.isMac()) {
            this.m_scrollPane.setBorder(null);
        }
        panel.add((Component)this.m_scrollPane, "Center");
        panel.add((Component)this.createCommandInput(), "South");
        this.setMinimumSize(new Dimension(160, 112));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("run")) {
            this.commandEntered();
        } else if (command.equals("close")) {
            this.setVisible(false);
        }
    }

    public boolean isLastTextNonGTP() {
        return this.m_gtpShellText.isLastTextNonGTP();
    }

    public void receivedInvalidResponse(final String response, boolean invokeLater) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.appendInvalidResponse(response);
        } else {
            Runnable r = new Runnable(){

                public void run() {
                    GtpShell.this.appendInvalidResponse(response);
                }
            };
            if (invokeLater) {
                SwingUtilities.invokeLater(r);
            } else {
                GuiUtil.invokeAndWait(r);
            }
        }
    }

    public void receivedResponse(final boolean error, final String response, boolean invokeLater) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.appendResponse(error, response);
        } else {
            Runnable r = new Runnable(){

                public void run() {
                    GtpShell.this.appendResponse(error, response);
                }
            };
            if (invokeLater) {
                SwingUtilities.invokeLater(r);
            } else {
                GuiUtil.invokeAndWait(r);
            }
        }
    }

    public void receivedStdErr(final String s, boolean invokeLater, final boolean isLiveGfx, final boolean isWarning) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.appendLog(s, isLiveGfx, isWarning);
        } else {
            Runnable r = new Runnable(){

                public void run() {
                    GtpShell.this.appendLog(s, isLiveGfx, isWarning);
                }
            };
            if (invokeLater) {
                SwingUtilities.invokeLater(r);
            } else {
                GuiUtil.invokeAndWait(r);
            }
        }
    }

    public void saveLog(JFrame parent) {
        this.save(parent, this.m_gtpShellText.getLog(), this.m_gtpShellText.getLinesTruncated());
    }

    public void saveCommands(JFrame parent) {
        this.save(parent, this.m_commands.toString(), this.m_linesTruncated);
    }

    public void saveHistory() {
        int maxHistory = 100;
        int max = this.m_history.size();
        if (max > maxHistory) {
            max = maxHistory;
        }
        ArrayList<String> list = new ArrayList<String>(max);
        for (int i = this.m_history.size() - max; i < this.m_history.size(); ++i) {
            list.add(this.m_history.get(i));
        }
        PrefUtil.putList("net/sf/gogui/gui/gtpshell/recentcommands", list);
    }

    public void setCommandInProgess(boolean commandInProgess) {
        this.m_commandInProgress = commandInProgess;
    }

    public void setCommandCompletion(boolean commandCompletion) {
        this.m_disableCompletions = !commandCompletion;
    }

    public void setTimeStamp(boolean enable) {
        this.m_gtpShellText.setTimeStamp(enable);
    }

    public void sentCommand(final String command) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.appendSentCommand(command);
        } else {
            GuiUtil.invokeAndWait(new Runnable(){

                public void run() {
                    GtpShell.this.appendSentCommand(command);
                }
            });
        }
    }

    public void setInitialCompletions(ArrayList<String> completions) {
        for (int i = completions.size() - 1; i >= 0; --i) {
            String command = completions.get(i);
            if (GtpUtil.isStateChangingCommand(command)) continue;
            this.appendToHistory(command);
        }
        ArrayList<String> list = PrefUtil.getList("net/sf/gogui/gui/gtpshell/recentcommands");
        for (int i = 0; i < list.size(); ++i) {
            this.appendToHistory(list.get(i));
        }
        this.addAllCompletions(this.m_history);
    }

    public void setProgramCommand(String command) {
        this.m_programCommand = command;
    }

    public void setProgramName(String name) {
        this.m_programName = name;
    }

    public void setProgramVersion(String version) {
        this.m_programVersion = version;
    }

    private void addAllCompletions(ArrayList<String> completions) {
        String oldText = this.m_textField.getText();
        int oldCaretPosition = this.m_textField.getCaretPosition();
        if (completions.size() > this.m_comboBox.getItemCount()) {
            this.m_comboBox.hidePopup();
        }
        this.m_comboBox.removeAllItems();
        for (int i = completions.size() - 1; i >= 0; --i) {
            this.m_comboBox.addItem(GuiUtil.createComboBoxItem(completions.get(i)));
        }
        this.m_comboBox.setSelectedIndex(-1);
        this.m_textField.setText(oldText);
        this.m_textField.setCaretPosition(oldCaretPosition);
    }

    private void appendInvalidResponse(String response) {
        assert (SwingUtilities.isEventDispatchThread());
        this.m_gtpShellText.appendInvalidResponse(response);
    }

    private void appendLog(String line, boolean isLiveGfx, boolean isWarning) {
        assert (SwingUtilities.isEventDispatchThread());
        this.m_gtpShellText.appendLog(line, isLiveGfx, isWarning);
    }

    private void appendResponse(boolean error, String response) {
        assert (SwingUtilities.isEventDispatchThread());
        if (error) {
            this.m_gtpShellText.appendError(response);
        } else {
            this.m_gtpShellText.appendInput(response);
        }
    }

    private void appendSentCommand(String command) {
        assert (SwingUtilities.isEventDispatchThread());
        this.m_commands.append(command);
        this.m_commands.append('\n');
        ++this.m_numberCommands;
        if (this.m_numberCommands > this.m_historyMax) {
            int truncateLines = this.m_numberCommands - this.m_historyMin;
            String s = this.m_commands.toString();
            int index = GtpShellText.findTruncateIndex(s, truncateLines);
            assert (index != -1);
            this.m_commands.delete(0, index);
            this.m_linesTruncated += truncateLines;
            this.m_numberCommands = 0;
        }
        this.m_gtpShellText.appendOutput(command + "\n");
    }

    private void appendToHistory(String command) {
        int i = this.m_history.indexOf(command = command.trim());
        if (i >= 0) {
            this.m_history.remove(i);
        }
        this.m_history.add(command);
    }

    private void commandEntered() {
        assert (SwingUtilities.isEventDispatchThread());
        String command = this.m_textField.getText().trim();
        if (command.trim().equals("")) {
            return;
        }
        if (command.startsWith("#")) {
            this.m_gtpShellText.appendComment(command + "\n");
        } else {
            if (GtpUtil.isStateChangingCommand(command)) {
                this.showError(I18n.i18n("MSG_SHELL_BOARDCHANGING"), I18n.i18n("MSG_SHELL_BOARDCHANGING_2"), false);
                return;
            }
            if (this.m_commandInProgress) {
                this.showError(I18n.i18n("MSG_SHELL_CMD_IN_PROGRESS"), I18n.i18n("MSG_SHELL_CMD_IN_PROGRESS_2"), false);
                return;
            }
            this.m_listener.actionSendCommand(command, false, false);
        }
        this.appendToHistory(command);
        this.m_gtpShellText.setPositionToEnd();
        this.m_comboBox.hidePopup();
        this.addAllCompletions(this.m_history);
        this.m_editor.setItem(null);
    }

    private JComponent createCommandInput() {
        Box box = Box.createVerticalBox();
        JPanel panel = new JPanel(new BorderLayout());
        box.add(GuiUtil.createSmallFiller());
        box.add(Box.createVerticalGlue());
        box.add(panel);
        box.add(Box.createVerticalGlue());
        this.m_comboBox = new JComboBox();
        if (Platform.isMac()) {
            this.m_comboBox.setMaximumRowCount(7);
        }
        this.m_editor = this.m_comboBox.getEditor();
        this.m_textField = (JTextField)this.m_editor.getEditorComponent();
        this.m_textField.setFocusTraversalKeysEnabled(false);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                int c = e.getKeyCode();
                int mod = e.getModifiers();
                if (c == 27) {
                    return;
                }
                if (c == 9) {
                    GtpShell.this.findBestCompletion();
                    GtpShell.this.popupCompletions();
                } else if (c == 33 && mod == 1) {
                    GtpShell.this.scrollPage(true);
                } else if (c == 34 && mod == 1) {
                    GtpShell.this.scrollPage(false);
                } else if (c == 10 && !GtpShell.this.m_comboBox.isPopupVisible()) {
                    GtpShell.this.commandEntered();
                } else if (e.getKeyChar() != '\uffff') {
                    GtpShell.this.popupCompletions();
                }
            }
        };
        this.m_textField.addKeyListener(keyAdapter);
        this.m_comboBox.setEditable(true);
        this.m_comboBox.setFont(this.m_gtpShellText.getFont());
        this.m_comboBox.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                GtpShell.this.m_comboBox.requestFocusInWindow();
                GtpShell.this.m_textField.requestFocusInWindow();
            }
        });
        panel.add((Component)this.m_comboBox, "Center");
        this.m_runButton = new JButton();
        this.m_runButton.setIcon(GuiUtil.getIcon("gogui-key_enter", I18n.i18n("LB_RUN")));
        this.m_runButton.setActionCommand("run");
        this.m_runButton.setFocusable(false);
        this.m_runButton.setToolTipText(I18n.i18n("TT_SHELL_RUN"));
        this.m_runButton.addActionListener(this);
        GuiUtil.setMacBevelButton(this.m_runButton);
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add((Component)buttonPanel, "East");
        buttonPanel.add(GuiUtil.createSmallFiller());
        buttonPanel.add(this.m_runButton);
        if (Platform.isMac()) {
            Dimension dimension = new Dimension(20, 1);
            Box.Filler filler = new Box.Filler(dimension, dimension, dimension);
            buttonPanel.add(filler);
        }
        return box;
    }

    private void findBestCompletion() {
        String text = this.m_textField.getText().trim();
        if (text.equals("")) {
            return;
        }
        String bestCompletion = null;
        for (int i = 0; i < this.m_history.size(); ++i) {
            int j;
            String completion = this.m_history.get(i);
            if (!completion.startsWith(text)) continue;
            if (bestCompletion == null) {
                bestCompletion = completion;
                continue;
            }
            for (j = text.length(); j < bestCompletion.length() && j < completion.length() && bestCompletion.charAt(j) == completion.charAt(j); ++j) {
            }
            bestCompletion = completion.substring(0, j);
        }
        if (bestCompletion != null) {
            this.m_textField.setText(bestCompletion);
        }
    }

    private void popupCompletions() {
        String text = this.m_textField.getText();
        text = text.replaceAll("^ *", "");
        ArrayList<String> completions = new ArrayList<String>(128);
        for (int i = 0; i < this.m_history.size(); ++i) {
            String c = this.m_history.get(i);
            if (!c.startsWith(text)) continue;
            completions.add(c);
        }
        this.addAllCompletions(completions);
        if (this.m_disableCompletions) {
            return;
        }
        int size = completions.size();
        if (text.length() > 0 && (size > 1 || size == 1 && !text.equals(completions.get(0)))) {
            this.m_comboBox.showPopup();
        } else {
            this.m_comboBox.hidePopup();
        }
    }

    private void save(JFrame parent, String s, int linesTruncated) {
        File file = FileDialogs.showSave(parent, null, this.m_messageDialogs);
        if (file == null) {
            return;
        }
        try {
            PrintStream out = new PrintStream(file);
            out.println("# Name: " + this.m_programName);
            out.println("# Version: " + this.m_programVersion);
            out.println("# Command: " + this.m_programCommand);
            out.println("# Lines truncated: " + linesTruncated);
            out.print(s);
            out.close();
        }
        catch (FileNotFoundException e) {
            this.m_messageDialogs.showError((Component)parent, I18n.i18n("MSG_SHELL_SAVE_FAILURE"), "");
        }
    }

    private void showError(String mainMessage, String optionalMessage, boolean isCritical) {
        this.m_messageDialogs.showError((Component)this, mainMessage, optionalMessage, isCritical);
    }

    private void scrollPage(boolean up) {
        JViewport viewport = this.m_scrollPane.getViewport();
        Point position = viewport.getViewPosition();
        int delta = this.m_scrollPane.getSize().height - this.m_gtpShellText.getFont().getSize();
        if (up) {
            position.y -= delta;
            if (position.y < 0) {
                position.y = 0;
            }
        } else {
            position.y += delta;
            int max = viewport.getViewSize().height - this.m_scrollPane.getSize().height;
            if (position.y > max) {
                position.y = max;
            }
        }
        viewport.setViewPosition(position);
    }

    public static interface Listener {
        public void actionSendCommand(String var1, boolean var2, boolean var3);

        public void textSelected(String var1);
    }
}

