/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.Komi;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpClientBase;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpSynchronizer;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;

public class GuiGtpClient
extends GtpClientBase {
    private static final int TIMEOUT = 15000;
    private boolean m_commandInProgress;
    private final GtpClient m_gtp;
    private GtpError m_exception;
    private final GtpSynchronizer m_gtpSynchronizer;
    private final Component m_owner;
    private final MessageDialogs m_messageDialogs;
    private final Object m_mutex = new Object();
    private Runnable m_callback;
    private String m_command;
    private String m_response;

    public GuiGtpClient(GtpClient gtp, Component owner, GtpSynchronizer.Listener listener, MessageDialogs messageDialogs) {
        this.m_gtp = gtp;
        this.m_owner = owner;
        this.m_messageDialogs = messageDialogs;
        this.m_gtpSynchronizer = new GtpSynchronizer(this, listener, false);
        Thread thread = new Thread(){

            public void run() {
                Object object = GuiGtpClient.this.m_mutex;
                synchronized (object) {
                    boolean firstWait = true;
                    while (true) {
                        try {
                            if (GuiGtpClient.this.m_command == null || !firstWait) {
                                GuiGtpClient.this.m_mutex.wait();
                            }
                        }
                        catch (InterruptedException e) {
                            System.err.println("Interrupted");
                        }
                        firstWait = false;
                        GuiGtpClient.this.m_response = null;
                        GuiGtpClient.this.m_exception = null;
                        try {
                            GuiGtpClient.this.m_response = GuiGtpClient.this.m_gtp.send(GuiGtpClient.this.m_command);
                        }
                        catch (GtpError e) {
                            GuiGtpClient.this.m_exception = e;
                        }
                        SwingUtilities.invokeLater(GuiGtpClient.this.m_callback);
                    }
                }
            }
        };
        thread.start();
    }

    public void close() {
        if (!this.isProgramDead()) {
            this.m_gtp.close();
            TimeoutCallback timeoutCallback = new TimeoutCallback(null);
            this.m_gtp.waitForExit(15000, timeoutCallback);
        }
    }

    public void destroyGtp() {
        this.m_gtp.destroyProcess();
    }

    public boolean getAnyCommandsResponded() {
        return this.m_gtp.getAnyCommandsResponded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GtpError getException() {
        Object object = this.m_mutex;
        synchronized (object) {
            assert (SwingUtilities.isEventDispatchThread());
            assert (this.m_commandInProgress);
            this.m_commandInProgress = false;
            return this.m_exception;
        }
    }

    public String getProgramCommand() {
        return this.m_gtp.getProgramCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponse() {
        Object object = this.m_mutex;
        synchronized (object) {
            assert (SwingUtilities.isEventDispatchThread());
            assert (!this.m_commandInProgress);
            return this.m_response;
        }
    }

    public void initSynchronize(ConstBoard board, Komi komi, TimeSettings timeSettings) throws GtpError {
        assert (SwingUtilities.isEventDispatchThread());
        assert (!this.m_commandInProgress);
        this.m_gtpSynchronizer.init(board, komi, timeSettings);
    }

    public boolean isCommandInProgress() {
        return this.m_commandInProgress;
    }

    public boolean isOutOfSync() {
        return this.m_gtpSynchronizer.isOutOfSync();
    }

    public boolean isProgramDead() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.m_gtp.isProgramDead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String command, Runnable callback) {
        assert (SwingUtilities.isEventDispatchThread());
        assert (!this.m_commandInProgress);
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_command = command;
            this.m_callback = callback;
            this.m_commandInProgress = true;
            this.m_mutex.notifyAll();
        }
    }

    public void sendComment(String comment) {
        this.m_gtp.sendComment(comment);
    }

    public String send(String command) throws GtpError {
        assert (SwingUtilities.isEventDispatchThread());
        assert (!this.m_commandInProgress);
        TimeoutCallback timeoutCallback = new TimeoutCallback(command);
        return this.m_gtp.send(command, 15000L, timeoutCallback);
    }

    public void setAutoNumber(boolean enable) {
        this.m_gtp.setAutoNumber(enable);
    }

    public void synchronize(ConstBoard board, Komi komi, TimeSettings timeSettings) throws GtpError {
        assert (SwingUtilities.isEventDispatchThread());
        assert (!this.m_commandInProgress);
        this.m_gtpSynchronizer.synchronize(board, komi, timeSettings);
    }

    public void updateAfterGenmove(ConstBoard board) {
        assert (SwingUtilities.isEventDispatchThread());
        assert (!this.m_commandInProgress);
        this.m_gtpSynchronizer.updateAfterGenmove(board);
    }

    public void updateHumanMove(ConstBoard board, Move move) throws GtpError {
        assert (SwingUtilities.isEventDispatchThread());
        assert (!this.m_commandInProgress);
        this.m_gtpSynchronizer.updateHumanMove(board, move);
    }

    public void waitForExit() {
        this.m_gtp.waitForExit();
    }

    public boolean wasKilled() {
        return this.m_gtp.wasKilled();
    }

    private class TimeoutCallback
    implements GtpClient.TimeoutCallback {
        private final String m_command;

        TimeoutCallback(String command) {
            this.m_command = command;
        }

        public boolean askContinue() {
            String destructiveOption;
            String optionalMessage;
            String mainMessage = I18n.i18n("MSG_PROGRAM_NOT_RESPONDING");
            if (this.m_command == null) {
                optionalMessage = I18n.i18n("MSG_PROGRAM_NOT_RESPONDING_2");
                destructiveOption = I18n.i18n("LB_FORCE_QUIT_PROGRAM");
            } else {
                optionalMessage = MessageFormat.format(I18n.i18n("MSG_PROGRAM_NOT_RESPONDING_3"), this.m_command);
                destructiveOption = I18n.i18n("LB_TERMINATE_PROGRAM");
            }
            return !GuiGtpClient.this.m_messageDialogs.showWarningQuestion(null, GuiGtpClient.this.m_owner, mainMessage, optionalMessage, destructiveOption, I18n.i18n("LB_WAIT"), true);
        }
    }
}

