/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.statistics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.util.Table;
import net.sf.gogui.util.TableUtil;

public class Plot {
    private boolean m_autoXMax = true;
    private boolean m_autoXMin = true;
    private boolean m_autoXTics = true;
    private boolean m_autoYMin = true;
    private boolean m_autoYMax = true;
    private boolean m_autoYTics = true;
    private boolean m_noLines = false;
    private boolean m_onlyBoolValues;
    private boolean m_onlyIntValuesX;
    private boolean m_onlyIntValuesY;
    private boolean m_plotYZero = true;
    private boolean m_useSolidLineInterval = false;
    private boolean m_withBars;
    private boolean m_xLabelsBool;
    private int m_fontHeight;
    private int m_bottom;
    private int m_height;
    private final int m_imgHeight;
    private final int m_imgWidth;
    private int m_left;
    private final int m_precision;
    private int m_right;
    private int m_top;
    private int m_width;
    private int m_xLabelPerTic = 1;
    private double m_barWidth;
    private double m_minX;
    private double m_maxX;
    private double m_minY;
    private double m_maxY;
    private double m_solidLineInterval;
    private double m_xRange;
    private double m_xTics;
    private double m_xTicsMin;
    private double m_yRange;
    private double m_yTics;
    private double m_yTicsMin;
    private final Color m_color;
    private DecimalFormat m_formatX;
    private DecimalFormat m_formatY;
    private FontMetrics m_metrics;
    private Graphics2D m_graphics2D;
    private String m_title;

    public Plot(int imgWidth, int imgHeight, Color color, int precision) {
        this.m_precision = precision;
        this.m_color = color;
        this.m_imgWidth = imgWidth;
        this.m_imgHeight = imgHeight;
    }

    public void plot(File file, Table table, String columnX, String columnY, String errorColumn) throws IOException {
        int type = 1;
        BufferedImage image = new BufferedImage(this.m_imgWidth, this.m_imgHeight, type);
        this.m_graphics2D = image.createGraphics();
        GuiUtil.setAntiAlias(this.m_graphics2D);
        Font font = this.m_graphics2D.getFont();
        if (font != null) {
            font = font.deriveFont((float)((double)font.getSize() * 0.8));
            this.m_graphics2D.setFont(font);
        }
        this.m_metrics = this.m_graphics2D.getFontMetrics();
        this.m_fontHeight = this.m_metrics.getHeight();
        this.m_left = 4 * this.m_fontHeight;
        this.m_top = this.m_title == null ? (int)((double)this.m_fontHeight * 0.5) : (int)((double)this.m_fontHeight * 1.7);
        this.m_right = this.m_imgWidth - (int)((double)this.m_fontHeight * 0.5);
        this.m_bottom = this.m_imgHeight - (int)((double)this.m_fontHeight * 1.5);
        this.m_width = this.m_right - this.m_left;
        this.m_height = this.m_bottom - this.m_top;
        this.initScale(table, columnX, columnY);
        this.drawBackground();
        this.drawGrid();
        this.drawData(table, columnX, columnY, errorColumn, this.m_withBars);
        this.m_graphics2D.dispose();
        ImageIO.write((RenderedImage)image, "png", file);
    }

    public void setFormatX(DecimalFormat format) {
        this.m_formatX = format;
    }

    public void setFormatY(DecimalFormat format) {
        this.m_formatY = format;
    }

    public void setPlotStyleBars(double barWidth) {
        this.m_withBars = true;
        this.m_barWidth = barWidth;
    }

    public void setPlotStyleNoLines() {
        this.m_noLines = true;
    }

    public void setNoPlotYZero() {
        this.m_plotYZero = false;
    }

    public void setSolidLineInterval(double solidLineInterval) {
        this.m_solidLineInterval = solidLineInterval;
        this.m_useSolidLineInterval = true;
    }

    public void setXLabelPerTic(int xLabelPerTic) {
        this.m_xLabelPerTic = xLabelPerTic;
    }

    public void setXLabelsBool() {
        this.m_xLabelsBool = true;
        this.setXMin(-5.0);
        this.setXMax(5.0);
        this.setXTics(1.0);
    }

    public void setXMax(double max) {
        this.m_maxX = max;
        this.m_autoXMax = false;
    }

    public void setXMin(double min) {
        this.m_minX = min;
        this.m_autoXMin = false;
    }

    public void setXTics(double tics) {
        this.m_xTics = tics;
        this.m_autoXTics = false;
    }

    public void setYMax(double max) {
        this.m_maxY = max;
        this.m_autoYMax = false;
    }

    public void setYMin(double min) {
        this.m_minY = min;
        this.m_autoYMin = false;
    }

    public void setYTics(double tics) {
        this.m_yTics = tics;
        this.m_autoYTics = false;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    private void drawBackground() {
        this.m_graphics2D.setColor(Color.decode("#e0e0e0"));
        this.m_graphics2D.fillRect(0, 0, this.m_imgWidth, this.m_imgHeight);
        this.m_graphics2D.setColor(Color.WHITE);
        this.m_graphics2D.fillRect(this.m_left, this.m_top, this.m_width, this.m_height);
        this.m_graphics2D.setColor(Color.BLACK);
        if (this.m_title != null) {
            int width = this.m_metrics.stringWidth(this.m_title) + 10;
            int height = (int)((double)this.m_fontHeight * 1.4);
            int x = this.m_left + (this.m_width - width) / 2;
            int y = (this.m_top - height) / 2;
            this.m_graphics2D.setColor(Color.decode("#ffffe1"));
            this.m_graphics2D.fillRect(x, y, width, height);
            this.m_graphics2D.setColor(Color.DARK_GRAY);
            this.m_graphics2D.drawRect(x, y, width, height);
            this.drawString(this.m_title, this.m_left + this.m_width / 2, this.m_top / 2);
        }
    }

    private void drawData(Table table, String columnX, String columnY, String errorColumn, boolean withBars) {
        this.m_graphics2D.setColor(this.m_color);
        Point last = null;
        int barWidthPixels = this.getPoint((double)this.m_barWidth, (double)0.0).x - this.getPoint((double)0.0, (double)0.0).x - 2;
        for (int row = 0; row < table.getNumberRows(); ++row) {
            try {
                double x = table.getDouble(columnX, row);
                double y = table.getDouble(columnY, row);
                Point point = this.getPoint(x, y);
                if (withBars) {
                    Point bottom = this.getPoint(x, 0.0);
                    this.m_graphics2D.fillRect(point.x - barWidthPixels / 2 + 1, point.y, barWidthPixels, bottom.y - point.y);
                } else if (last != null && !this.m_noLines) {
                    this.m_graphics2D.drawLine(last.x, last.y, point.x, point.y);
                }
                if (errorColumn != null) {
                    double err = table.getDouble(errorColumn, row);
                    Point top = this.getPoint(x, y + err);
                    Point bottom = this.getPoint(x, y - err);
                    this.m_graphics2D.drawLine(top.x, top.y, bottom.x, bottom.y);
                }
                if (!withBars) {
                    this.m_graphics2D.fillRect(point.x - 1, point.y - 1, 3, 3);
                }
                last = point;
                continue;
            }
            catch (Table.InvalidElement e) {
                last = null;
                continue;
            }
            catch (Table.InvalidLocation e) {
                last = null;
            }
        }
    }

    private void drawGrid() {
        Stroke oldStroke = this.m_graphics2D.getStroke();
        BasicStroke dottedStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
        if (this.m_useSolidLineInterval) {
            double min = (double)((int)(this.m_xTicsMin / this.m_solidLineInterval)) * this.m_solidLineInterval;
            int n = 0;
            double x = min;
            while (x < this.m_maxX) {
                Point bottom = this.getPoint(x, this.m_minY);
                Point top = this.getPoint(x, this.m_maxY);
                if (n % 2 == 0) {
                    this.m_graphics2D.setColor(Color.decode("#f0f0f0"));
                    Point right = this.getPoint(x + this.m_solidLineInterval, this.m_maxY);
                    this.m_graphics2D.fillRect(top.x, top.y, Math.min(right.x - top.x, this.m_right - top.x), bottom.y - top.y);
                }
                x += this.m_solidLineInterval;
                ++n;
            }
        }
        this.m_graphics2D.setStroke(dottedStroke);
        for (double x = this.m_xTicsMin; x < this.m_maxX; x += this.m_xTics) {
            Point bottom = this.getPoint(x, this.m_minY);
            Point top = this.getPoint(x, this.m_maxY);
            this.m_graphics2D.setColor(Color.LIGHT_GRAY);
            this.m_graphics2D.drawLine(top.x, top.y, bottom.x, bottom.y);
        }
        this.m_graphics2D.setStroke(oldStroke);
        this.m_graphics2D.setStroke(dottedStroke);
        for (double y = this.m_yTicsMin; y < this.m_maxY; y += this.m_yTics) {
            Point left = this.getPoint(this.m_minX, y);
            Point right = this.getPoint(this.m_maxX, y);
            this.m_graphics2D.setColor(Color.LIGHT_GRAY);
            this.m_graphics2D.drawLine(left.x, left.y, right.x, right.y);
        }
        this.m_graphics2D.setStroke(oldStroke);
        this.m_graphics2D.setColor(Color.GRAY);
        if (this.m_minX <= 0.0 && this.m_maxX >= 0.0) {
            Point top = this.getPoint(0.0, this.m_minY);
            Point bottom = this.getPoint(0.0, this.m_maxY);
            this.m_graphics2D.drawLine(top.x, top.y, bottom.x, bottom.y);
        }
        if (this.m_minY <= 0.0 && this.m_maxY >= 0.0) {
            Point left = this.getPoint(this.m_minX, 0.0);
            Point right = this.getPoint(this.m_maxX, 0.0);
            this.m_graphics2D.drawLine(left.x, left.y, right.x, right.y);
        }
        if (this.m_formatX == null) {
            this.m_formatX = this.getFormat(this.m_onlyIntValuesX);
        }
        if (this.m_formatY == null) {
            this.m_formatY = this.getFormat(this.m_onlyIntValuesY);
        }
        for (double x = this.m_xTicsMin; x < this.m_maxX; x += (double)this.m_xLabelPerTic * this.m_xTics) {
            if (this.m_xLabelsBool && Math.round(x) != 0L && Math.round(x) != 1L) continue;
            Point bottom = this.getPoint(x, this.m_minY);
            String label = this.m_formatX.format(x);
            this.m_graphics2D.setColor(Color.GRAY);
            this.m_graphics2D.drawLine(bottom.x, bottom.y, bottom.x, bottom.y + 3);
            this.m_graphics2D.setColor(Color.BLACK);
            this.drawString(label, bottom.x, this.m_bottom + (this.m_imgHeight - this.m_bottom) / 2);
        }
        for (double y = this.m_yTicsMin; y < this.m_maxY; y += this.m_yTics) {
            if (!this.m_plotYZero && Math.round(y) == 0L) continue;
            Point point = this.getPoint(this.m_minX, y);
            String label = this.m_formatY.format(y);
            this.m_graphics2D.setColor(Color.GRAY);
            this.m_graphics2D.drawLine(point.x, point.y, point.x - 3, point.y);
            this.m_graphics2D.setColor(Color.BLACK);
            this.drawStringRightAlign(label, this.m_left - 5, point.y);
        }
        this.m_graphics2D.setColor(Color.LIGHT_GRAY);
        this.m_graphics2D.drawRect(this.m_left, this.m_top, this.m_width, this.m_height);
        this.m_graphics2D.setColor(Color.GRAY);
        this.m_graphics2D.drawLine(this.m_left, this.m_top, this.m_left, this.m_bottom);
        this.m_graphics2D.drawLine(this.m_left, this.m_bottom, this.m_right, this.m_bottom);
        this.m_graphics2D.setStroke(oldStroke);
    }

    private void drawString(String string, int x, int y) {
        FontMetrics metrics = this.m_graphics2D.getFontMetrics();
        int width = metrics.stringWidth(string);
        int height = this.m_fontHeight;
        this.m_graphics2D.drawString(string, x - width / 2, y + height / 2);
    }

    private void drawStringRightAlign(String string, int x, int y) {
        FontMetrics metrics = this.m_graphics2D.getFontMetrics();
        int width = metrics.stringWidth(string);
        int height = this.m_fontHeight;
        this.m_graphics2D.drawString(string, x - width, y + height / 2);
    }

    private DecimalFormat getFormat(boolean onlyIntValues) {
        DecimalFormat format = new DecimalFormat();
        format.setGroupingUsed(false);
        if (onlyIntValues) {
            format.setMaximumFractionDigits(0);
        } else {
            format.setMaximumFractionDigits(this.m_precision);
        }
        return format;
    }

    private Point getPoint(double x, double y) {
        int intX = (int)((double)this.m_left + (x - this.m_minX) / this.m_xRange * (double)this.m_width);
        int intY = (int)((double)this.m_bottom - (y - this.m_minY) / this.m_yRange * (double)this.m_height);
        return new Point(intX, intY);
    }

    private double getTics(double range, int maxNumberTics) {
        maxNumberTics = Math.max(maxNumberTics, 2);
        double maxTics = range / 2.1;
        double tics = 1.0;
        if (range / (double)maxNumberTics < 1.0) {
            while (!(!(range / (tics / 2.0) < (double)maxNumberTics) && !(tics > maxTics) || range / ((tics /= 2.0) / 2.0) > (double)maxNumberTics && tics < maxTics || range / ((tics /= 2.0) / 2.5) > (double)maxNumberTics && tics < maxTics)) {
                tics /= 2.5;
            }
        } else {
            while (range / tics > (double)maxNumberTics && tics * 2.0 < maxTics && !(range / (tics *= 2.0) <= (double)maxNumberTics) && !(tics * 2.5 > maxTics) && !(range / (tics *= 2.5) <= (double)maxNumberTics) && !(tics * 2.0 > maxTics)) {
                tics *= 2.0;
            }
        }
        return tics;
    }

    private double getTicsMin(double tics, double min) {
        double result = (double)((int)(min / tics)) * tics;
        if (result < min) {
            result += tics;
        }
        return result;
    }

    private void initScale(Table table, String columnX, String columnY) {
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        this.m_onlyBoolValues = true;
        this.m_onlyIntValuesX = true;
        this.m_onlyIntValuesY = true;
        for (int row = 0; row < table.getNumberRows(); ++row) {
            try {
                String xValue = table.get(columnX, row);
                String yValue = table.get(columnY, row);
                if (xValue == null || yValue == null || !TableUtil.isNumberValue(yValue)) continue;
                if (!TableUtil.isBoolValue(yValue)) {
                    this.m_onlyBoolValues = false;
                }
                if (!TableUtil.isIntValue(xValue)) {
                    this.m_onlyIntValuesX = false;
                }
                if (!TableUtil.isIntValue(yValue)) {
                    this.m_onlyIntValuesY = false;
                }
                double x = Double.parseDouble(xValue);
                double y = Double.parseDouble(yValue);
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
                continue;
            }
            catch (Table.InvalidLocation e) {
                // empty catch block
            }
        }
        this.initScaleX(minX, maxX);
        this.initScaleY(minY, maxY);
    }

    private void initScaleX(double min, double max) {
        if (this.m_autoXMin) {
            this.m_minX = min - 0.05 * (max - min);
        }
        if (this.m_autoXMax) {
            this.m_maxX = max + 0.05 * (max - this.m_minX);
        }
        if (this.m_minX > 0.0 && this.m_minX < 0.3 * this.m_maxX) {
            this.m_minX = 0.0;
        }
        if (this.m_maxX - this.m_minX < Double.MIN_VALUE) {
            this.m_minX -= 1.1;
            this.m_maxX += 1.1;
        }
        this.m_xRange = this.m_maxX - this.m_minX;
        if (this.m_autoXTics) {
            double absMax = Math.max(Math.abs(this.m_minX), Math.abs(this.m_maxX));
            double log10 = Math.log(10.0);
            int maxLength = (int)(Math.log(absMax) / log10) + this.m_precision + 3;
            int maxPixels = (int)((double)maxLength * (0.7 * (double)this.m_fontHeight));
            int numberTics = this.m_width / maxPixels;
            this.m_xTics = this.getTics(this.m_xRange, numberTics);
        }
        if (this.m_onlyIntValuesX) {
            this.m_xTics = Math.max(1.0, this.m_xTics);
        }
        this.m_xTicsMin = this.getTicsMin(this.m_xTics, this.m_minX);
    }

    private void initScaleY(double min, double max) {
        if (this.m_autoYMin) {
            this.m_minY = this.m_onlyBoolValues ? 0.0 : min;
        }
        if (this.m_autoYMax) {
            this.m_maxY = this.m_onlyBoolValues ? 1.1 : max + 0.05 * (max - this.m_minY);
        }
        if (this.m_autoYMin && this.m_minY > 0.0 && this.m_minY < 0.3 * this.m_maxY) {
            this.m_minY = 0.0;
        }
        if (this.m_maxY - this.m_minY < Double.MIN_VALUE) {
            this.m_minY -= 1.1;
            this.m_maxY += 1.1;
        }
        this.m_yRange = this.m_maxY - this.m_minY;
        if (this.m_autoYTics) {
            if (this.m_onlyBoolValues) {
                this.m_yTics = 1.0;
                this.m_yTicsMin = 0.0;
            } else {
                int maxNumberTics = (int)((double)this.m_height / (1.5 * (double)this.m_fontHeight));
                this.m_yTics = this.getTics(this.m_yRange, maxNumberTics);
                if (this.m_onlyIntValuesY) {
                    this.m_yTics = Math.max(1.0, this.m_yTics);
                }
            }
        }
        if (!this.m_onlyBoolValues) {
            this.m_yTicsMin = this.getTicsMin(this.m_yTics, this.m_minY);
        }
    }
}

