/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.dummy;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Random;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.PointList;
import net.sf.gogui.gtp.GtpCallback;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpEngine;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.version.Version;

public class Dummy
extends GtpEngine {
    private boolean m_nextResponseFixed;
    private boolean m_nextStatus;
    private int m_delay;
    private int m_numberGenmove;
    private final int m_resign;
    private int m_size;
    private boolean[][] m_alreadyPlayed;
    private final Random m_random;
    private String m_nextResponse;
    private PointList m_ePList = new PointList();

    public Dummy(PrintStream log, boolean useRandomSeed, long randomSeed, int resign) throws Exception {
        super(log);
        this.registerCommands();
        this.setName("gogui-dummy");
        this.setVersion(Version.get());
        this.m_random = new Random();
        this.m_resign = resign;
        if (useRandomSeed) {
            this.m_random.setSeed(randomSeed);
        }
        this.initSize(19);
    }

    public void cmdBWBoard(GtpCommand cmd) {
        cmd.getResponse().append('\n');
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                cmd.getResponse().append(this.m_random.nextBoolean() ? (char)'B' : 'W');
                if (y >= this.m_size - 1) continue;
                cmd.getResponse().append(' ');
            }
            cmd.getResponse().append('\n');
        }
    }

    public void cmdBoardsize(GtpCommand cmd) throws GtpError {
        cmd.checkNuArg(1);
        int size = cmd.getIntArg(0, 1, 25);
        this.initSize(size);
    }

    public void cmdCrash(GtpCommand cmd) {
        System.err.println("Aborting gogui-dummy");
        System.exit(1);
    }

    public void cmdClearBoard(GtpCommand cmd) throws GtpError {
        this.initSize(this.m_size);
    }

    public void cmdEcho(GtpCommand cmd) {
        cmd.setResponse(cmd.getArgLine());
    }

    public void cmdEchoErr(GtpCommand cmd) {
        System.err.println(cmd.getArgLine());
    }

    public void cmdDelay(GtpCommand cmd) throws GtpError {
        cmd.checkNuArgLessEqual(1);
        if (cmd.getNuArg() == 1) {
            this.m_delay = cmd.getIntArg(0, 0, Integer.MAX_VALUE);
        } else {
            cmd.getResponse().append(this.m_delay);
        }
    }

    public void cmdFileOpen(GtpCommand cmd) throws GtpError {
        try {
            File f = new File(cmd.getArg());
            cmd.setResponse("CanonicalPath: " + f.getCanonicalPath() + "\n" + "Exists:        " + f.exists() + "\n" + "CanRead:       " + f.canRead() + "\n" + "CanWrite:      " + f.canWrite() + "\n");
        }
        catch (IOException e) {
            throw new GtpError(e.getMessage());
        }
    }

    public void cmdFileSave(GtpCommand cmd) throws GtpError {
        File file = new File(cmd.getArg());
        try {
            PrintStream out = new PrintStream(file);
            out.println("Hello world!");
            out.close();
        }
        catch (IOException e) {
            throw new GtpError(e.getMessage());
        }
    }

    public void cmdEPList(GtpCommand cmd) throws GtpError {
        if (cmd.getNuArg() == 1 && cmd.getArg(0).equals("show")) {
            cmd.setResponse(GoPoint.toString(this.m_ePList));
        } else {
            this.m_ePList = cmd.getPointListArg(this.m_size);
        }
    }

    public void cmdGfx(GtpCommand cmd) {
        cmd.setResponse("LABEL A4 test\nCOLOR green A5 A7 B9\nCOLOR #980098 B7 B8\nSQUARE B5 C9\nMARK A6 B6\nTRIANGLE A9\nWHITE A1\nBLACK B1\nCIRCLE c8\nINFLUENCE a7 -1 b7 -0.75 c7 -0.5 d7 -0.25 e7 0 f7 0.25 g7 0.5 h7 0.75 j7 1\nVAR b c1 w c2 b c3 b c4 w pass b c5\nTEXT Graphics Demo\n");
    }

    public void cmdGoGuiAnalyzeCommands(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        String response = "bwboard/BWBoard/gogui-dummy-bwboard\nnone/Crash/gogui-dummy-crash\nnone/Delay/gogui-dummy-delay %o\neplist/EPList/gogui-dummy-eplist\nstring/File Open/gogui-dummy-file_open %r\nnone/File Save/gogui-dummy-file_save %w\ngfx/Gfx/gogui-dummy-gfx\nnone/Invalid/gogui-dummy-invalid\nnone/Live Gfx/gogui-dummy-live_gfx\nstring/Long Response/gogui-dummy-long_response %s\nnone/Next Failure/gogui-dummy-next_failure %s\nnone/Next Success/gogui-dummy-next_success %s\nsboard/SBoard/gogui-dummy-sboard\nnone/Sleep/gogui-dummy-sleep %s\nnone/Sleep 20s/gogui-dummy-sleep\n";
        cmd.setResponse(response);
    }

    public void cmdGenmove(GtpCommand cmd) {
        ++this.m_numberGenmove;
        if (this.m_numberGenmove == this.m_resign) {
            cmd.setResponse("resign");
            return;
        }
        int numberPossibleMoves = 0;
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                if (this.m_alreadyPlayed[x][y]) continue;
                ++numberPossibleMoves;
            }
        }
        GoPoint point = null;
        if (numberPossibleMoves > 0) {
            int rand = this.m_random.nextInt(numberPossibleMoves);
            int index = 0;
            for (int x = 0; x < this.m_size && point == null; ++x) {
                for (int y = 0; y < this.m_size && point == null; ++y) {
                    if (this.m_alreadyPlayed[x][y]) continue;
                    if (index == rand) {
                        point = GoPoint.get(x, y);
                    }
                    ++index;
                }
            }
        }
        cmd.setResponse(GoPoint.toString(point));
        if (point != null) {
            this.m_alreadyPlayed[point.getX()][point.getY()] = true;
        }
    }

    public void cmdInterrupt(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
    }

    public void cmdInvalid(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        this.printInvalidResponse("This is an invalid GTP response.\nIt does not start with a status character.\n");
    }

    public void cmdLiveGfx(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        System.err.println("gogui-gfx: TEXT Live Graphics Demo");
        System.err.println("gogui-gfx: LABEL A4 test");
        this.sleep(1000L);
        System.err.println("gogui-gfx: COLOR green A5 A7 B9");
        this.sleep(1000L);
        System.err.println("gogui-gfx: COLOR #980098 B7 B8");
        this.sleep(1000L);
        System.err.println("gogui-gfx:\nSQUARE B5 C9\nMARK A6 B6\nTRIANGLE A9\n");
        this.sleep(1000L);
        System.err.println("gogui-gfx: WHITE A1");
        this.sleep(1000L);
        System.err.println("gogui-gfx: BLACK B1");
        this.sleep(1000L);
        System.err.println("gogui-gfx: CIRCLE c8");
        this.sleep(1000L);
        System.err.println("gogui-gfx: INFLUENCE a7 -1 b7 -0.75 c7 -0.5 d7 -0.25 e7 0 f7 0.25 g7 0.5 h7 0.75 j7 1");
        this.sleep(1000L);
        System.err.println("gogui-gfx: VAR b c1 w c2 b c3 b c4 w pass b c5");
        this.sleep(1000L);
        System.err.println("gogui-gfx: CLEAR");
    }

    public void cmdLongResponse(GtpCommand cmd) throws GtpError {
        cmd.checkNuArg(1);
        int n = cmd.getIntArg(0, 1, Integer.MAX_VALUE);
        for (int i = 1; i <= n; ++i) {
            cmd.getResponse().append(i);
            cmd.getResponse().append("\n");
        }
    }

    public void cmdNextFailure(GtpCommand cmd) throws GtpError {
        this.nextResponseFixed(cmd, false);
    }

    public void cmdNextSuccess(GtpCommand cmd) throws GtpError {
        this.nextResponseFixed(cmd, true);
    }

    public void cmdPlay(GtpCommand cmd) throws GtpError {
        cmd.checkNuArg(2);
        cmd.getColorArg(0);
        GoPoint point = cmd.getPointArg(1, this.m_size);
        if (point != null) {
            this.m_alreadyPlayed[point.getX()][point.getY()] = true;
        }
    }

    public void cmdSBoard(GtpCommand cmd) {
        cmd.getResponse().append('\n');
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                if (x == 1 && y == 1) {
                    cmd.getResponse().append("\"a b\"");
                } else if (x == 1 && y == 2) {
                    cmd.getResponse().append("ab   ");
                } else if (x == 1 && y == 3) {
                    cmd.getResponse().append("abc  ");
                } else if (x == 2 && y == 1) {
                    cmd.getResponse().append("abcde");
                } else {
                    cmd.getResponse().append("\"\"   ");
                }
                if (y >= this.m_size - 1) continue;
                cmd.getResponse().append(' ');
            }
            cmd.getResponse().append('\n');
        }
    }

    public void cmdSleep(GtpCommand cmd) throws GtpError {
        cmd.checkNuArgLessEqual(1);
        long millis = 20000L;
        if (cmd.getNuArg() == 1) {
            millis = (long)(cmd.getDoubleArg(0) * 1000.0);
        }
        long showProgressInterval = Math.max(millis / 100L, 1000L);
        long steps = millis / showProgressInterval;
        long remaining = millis - steps * showProgressInterval;
        for (long i = 0L; i < steps && !this.isInterrupted(); ++i) {
            System.err.println("gogui-gfx: TEXT " + 100L * i / steps + " %");
            this.sleep(showProgressInterval);
        }
        this.sleep(remaining);
    }

    public void handleCommand(GtpCommand cmd) throws GtpError {
        if (this.m_nextResponseFixed) {
            this.m_nextResponseFixed = false;
            if (!this.m_nextStatus) {
                throw new GtpError(this.m_nextResponse);
            }
            cmd.setResponse(this.m_nextResponse);
        } else {
            super.handleCommand(cmd);
        }
        if (this.m_delay > 0) {
            try {
                Thread.sleep(1000L * (long)this.m_delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void initSize(int size) {
        this.m_alreadyPlayed = new boolean[size][size];
        this.m_size = size;
        this.m_numberGenmove = 0;
    }

    private void nextResponseFixed(GtpCommand cmd, boolean nextStatus) {
        this.m_nextResponseFixed = true;
        this.m_nextStatus = nextStatus;
        this.m_nextResponse = cmd.getArgLine();
    }

    private void registerCommands() {
        this.register("boardsize", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdBoardsize(cmd);
            }
        });
        this.register("clear_board", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdClearBoard(cmd);
            }
        });
        this.register("gogui-dummy-bwboard", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdBWBoard(cmd);
            }
        });
        this.register("gogui-dummy-crash", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdCrash(cmd);
            }
        });
        this.register("gogui-dummy-delay", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdDelay(cmd);
            }
        });
        this.register("gogui-dummy-eplist", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdEPList(cmd);
            }
        });
        this.register("gogui-dummy-file_open", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdFileOpen(cmd);
            }
        });
        this.register("gogui-dummy-file_save", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdFileSave(cmd);
            }
        });
        this.register("gogui-dummy-gfx", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdGfx(cmd);
            }
        });
        this.register("gogui-dummy-invalid", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdInvalid(cmd);
            }
        });
        this.register("gogui-dummy-live_gfx", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdLiveGfx(cmd);
            }
        });
        this.register("gogui-dummy-long_response", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdLongResponse(cmd);
            }
        });
        this.register("gogui-dummy-next_failure", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdNextFailure(cmd);
            }
        });
        this.register("gogui-dummy-next_success", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdNextSuccess(cmd);
            }
        });
        this.register("gogui-dummy-sboard", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdSBoard(cmd);
            }
        });
        this.register("gogui-dummy-sleep", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdSleep(cmd);
            }
        });
        this.register("echo", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdEcho(cmd);
            }
        });
        this.register("echo_err", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdEchoErr(cmd);
            }
        });
        this.register("genmove", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdGenmove(cmd);
            }
        });
        this.register("gogui-analyze_commands", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdGoGuiAnalyzeCommands(cmd);
            }
        });
        this.register("gogui-interrupt", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdInterrupt(cmd);
            }
        });
        this.register("play", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Dummy.this.cmdPlay(cmd);
            }
        });
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

