/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.util;

import java.io.PrintStream;
import net.sf.gogui.util.Statistics;

public class Histogram
extends Statistics {
    private final int m_size;
    private final double m_max;
    private final double m_min;
    private final double m_step;
    private int[] m_array;

    public Histogram(double min, double max, double step) {
        this.m_min = min;
        this.m_max = max;
        this.m_step = step;
        this.m_size = Math.max(1, (int)Math.ceil((max - min) / step));
        this.m_array = new int[this.m_size];
    }

    public void add(double value) {
        super.add(value);
        int i = value == this.m_max ? this.m_size - 1 : (int)((value - this.m_min) / this.m_step);
        int n = i;
        this.m_array[n] = this.m_array[n] + 1;
    }

    public int getCount(int i) {
        return this.m_array[i];
    }

    public double getHistoMin() {
        return this.m_min;
    }

    public double getHistoMax() {
        return this.m_max;
    }

    public int getSize() {
        return this.m_size;
    }

    public double getStep() {
        return this.m_step;
    }

    public double getValue(int i) {
        return this.m_min + (double)i * this.m_step;
    }

    public void printHtml(PrintStream out) {
        int max;
        out.print("<p>\n<table border=\"0\" cellspacing=\"1\" cellpadding=\"0\" rules=\"groups\">\n");
        for (int min = 0; min < this.m_size - 1 && this.m_array[min] == 0; ++min) {
        }
        for (max = this.m_size - 1; max > 0 && this.m_array[max] == 0; --max) {
        }
        for (int i = min; i <= max; ++i) {
            int scale = 630;
            int width = this.m_array[i] * scale / this.getCount();
            if (this.getValue(i) >= 0.0 && this.getValue(i - 1) < 0.0) {
                out.print("<tbody>\n");
            }
            out.print("<tr><td align=\"right\"><small>" + this.getValue(i) + "</small></td><td><table cellspacing=\"0\"" + " cellpadding=\"0\" border=\"0\" width=\"" + scale + "\"><tr>" + "<td bgcolor=\"#666666\" width=\"" + width + "\"></td>" + "<td bgcolor=\"#cccccc\" width=\"" + (scale - width) + "\"><small>" + this.m_array[i] + "</small></td></tr></table></td></tr>\n");
        }
        out.print("</table>\n</p>\n");
    }
}

