/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.game;

import net.sf.gogui.util.ErrorMessage;

public final class TimeSettings {
    private static final long MSEC_PER_MIN = 60000L;
    private static final long MSEC_PER_SEC = 1000L;
    private final long m_preByoyomi;
    private final long m_byoyomi;
    private final int m_byoyomiMoves;

    public TimeSettings(long totalTime) {
        assert (totalTime > 0L);
        this.m_preByoyomi = totalTime;
        this.m_byoyomi = 0L;
        this.m_byoyomiMoves = -1;
    }

    public TimeSettings(long preByoyomi, long byoyomi, int byoyomiMoves) {
        assert (preByoyomi >= 0L);
        assert (byoyomi > 0L);
        assert (byoyomiMoves > 0);
        this.m_preByoyomi = preByoyomi;
        this.m_byoyomi = byoyomi;
        this.m_byoyomiMoves = byoyomiMoves;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        TimeSettings settings = (TimeSettings)object;
        return settings.m_preByoyomi == this.m_preByoyomi && settings.m_byoyomi == this.m_byoyomi && settings.m_byoyomiMoves == this.m_byoyomiMoves;
    }

    public long getByoyomi() {
        assert (this.getUseByoyomi());
        return this.m_byoyomi;
    }

    public int getByoyomiMoves() {
        assert (this.getUseByoyomi());
        return this.m_byoyomiMoves;
    }

    public long getPreByoyomi() {
        return this.m_preByoyomi;
    }

    public boolean getUseByoyomi() {
        return this.m_byoyomiMoves > 0;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public static TimeSettings parse(String s) throws ErrorMessage {
        boolean useByoyomi = false;
        long preByoyomi = 0L;
        long byoyomi = 0L;
        int byoyomiMoves = 0;
        int idx = s.indexOf(43);
        if (idx < 0) {
            preByoyomi = TimeSettings.parseTime(s);
        } else {
            useByoyomi = true;
            preByoyomi = TimeSettings.parseTime(s.substring(0, idx));
            int idx2 = s.indexOf(47);
            if (idx2 <= idx) {
                throw new ErrorMessage("Invalid time specification");
            }
            byoyomi = TimeSettings.parseTime(s.substring(idx + 1, idx2));
            try {
                byoyomiMoves = Integer.parseInt(s.substring(idx2 + 1));
            }
            catch (NumberFormatException e) {
                throw new ErrorMessage("Invalid specification for byoyomi moves");
            }
        }
        if (preByoyomi <= 0L) {
            throw new ErrorMessage("Pre-byoyomi time must be positive");
        }
        if (useByoyomi) {
            if (byoyomi <= 0L) {
                throw new ErrorMessage("Byoyomi time must be positive");
            }
            if (byoyomiMoves <= 0) {
                throw new ErrorMessage("Byoyomi moves must be positive");
            }
            return new TimeSettings(preByoyomi, byoyomi, byoyomiMoves);
        }
        return new TimeSettings(preByoyomi);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(TimeSettings.toString(this.m_preByoyomi));
        if (this.getUseByoyomi()) {
            buffer.append(" + ");
            buffer.append(TimeSettings.toString(this.m_byoyomi));
            buffer.append(" / ");
            buffer.append(this.m_byoyomiMoves);
            buffer.append(" moves");
        }
        return buffer.toString();
    }

    private static long parseTime(String s) throws ErrorMessage {
        long factor = 60000L;
        if ((s = s.trim()).endsWith("m")) {
            s = s.substring(0, s.length() - "m".length());
        } else if (s.endsWith("min")) {
            s = s.substring(0, s.length() - "min".length());
        } else if (s.endsWith("s")) {
            s = s.substring(0, s.length() - "s".length());
            factor = 1000L;
        } else if (s.endsWith("sec")) {
            s = s.substring(0, s.length() - "sec".length());
            factor = 1000L;
        }
        try {
            return Long.parseLong(s.trim()) * factor;
        }
        catch (NumberFormatException e) {
            throw new ErrorMessage("Invalid time specification: '" + s + "'");
        }
    }

    private static String toString(long millisec) {
        StringBuilder buffer = new StringBuilder(64);
        if (millisec % 60000L == 0L) {
            buffer.append(millisec / 60000L);
            buffer.append(" min");
        } else {
            buffer.append(millisec / 1000L);
            buffer.append(" sec");
        }
        return buffer.toString();
    }
}

