/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import net.sf.gogui.util.ErrorMessage;

public final class StringUtil {
    public static String capitalize(String message) {
        if ((message = message.trim()).equals("")) {
            return message;
        }
        StringBuilder buffer = new StringBuilder(message);
        char first = buffer.charAt(0);
        if (!Character.isUpperCase(first)) {
            buffer.setCharAt(0, Character.toUpperCase(first));
        }
        return buffer.toString();
    }

    public static String formatTime(long seconds) {
        long hours;
        StringBuilder buffer = new StringBuilder(8);
        if (seconds < 0L) {
            buffer.append('-');
            seconds *= -1L;
        }
        if ((hours = seconds / 3600L) > 0L) {
            if (hours > 9999L) {
                return "--:--";
            }
            buffer.append(hours);
            buffer.append(':');
        }
        long minutes = (seconds %= 3600L) / 60L;
        seconds %= 60L;
        if (minutes >= 10L) {
            buffer.append(minutes);
        } else {
            buffer.append('0');
            buffer.append(minutes);
        }
        buffer.append(':');
        if (seconds >= 10L) {
            buffer.append(seconds);
        } else {
            buffer.append('0');
            buffer.append(seconds);
        }
        return buffer.toString();
    }

    public static String getDate() {
        DateFormat format = DateFormat.getDateTimeInstance(1, 1, Locale.ENGLISH);
        Date date = Calendar.getInstance().getTime();
        return format.format(date);
    }

    public static String getDateShort() {
        DateFormat format = DateFormat.getDateTimeInstance(3, 3, Locale.ENGLISH);
        Date date = Calendar.getInstance().getTime();
        return format.format(date);
    }

    public static String getDefaultEncoding() {
        String encoding = System.getProperty("file.encoding");
        if (encoding != null) {
            return encoding;
        }
        OutputStreamWriter out = new OutputStreamWriter(new ByteArrayOutputStream());
        return out.getEncoding();
    }

    public static String getErrorMessage(Throwable e) {
        String message = e.getMessage();
        boolean hasMessage = !StringUtil.isEmpty(message);
        String className = e.getClass().getName();
        String result = e instanceof ErrorMessage ? message : (hasMessage ? className + ":\n" + message : className);
        return result;
    }

    public static NumberFormat getNumberFormat(int maximumFractionDigits) {
        NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
        format.setMaximumFractionDigits(maximumFractionDigits);
        format.setGroupingUsed(false);
        return format;
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String printException(Throwable exception) {
        boolean isSevere;
        String result = StringUtil.getErrorMessage(exception);
        System.err.println(result);
        boolean bl = isSevere = exception instanceof RuntimeException || exception instanceof Error;
        if (isSevere) {
            exception.printStackTrace();
        }
        return result;
    }

    public static String[] split(String s, char separator) {
        int newPos;
        int count = 1;
        int pos = -1;
        while ((pos = s.indexOf(separator, pos + 1)) >= 0) {
            ++count;
        }
        String[] result = new String[count];
        pos = 0;
        int i = 0;
        while ((newPos = s.indexOf(separator, pos)) >= 0) {
            result[i] = s.substring(pos, newPos);
            ++i;
            pos = newPos + 1;
        }
        result[i] = s.substring(pos);
        return result;
    }

    public static String[] splitArguments(String string) {
        assert (string != null);
        ArrayList<String> result = new ArrayList<String>();
        boolean escape = false;
        boolean inString = false;
        StringBuilder token = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"' && !escape) {
                if (inString) {
                    result.add(token.toString());
                    token.setLength(0);
                }
                inString = !inString;
            } else if (Character.isWhitespace(c) && !inString) {
                if (token.length() > 0) {
                    result.add(token.toString());
                    token.setLength(0);
                }
            } else {
                token.append(c);
            }
            escape = c == '\\' && !escape;
        }
        if (token.length() > 0) {
            result.add(token.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public static String trimTrailing(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        if (i <= 0 || i == s.length() - 1) {
            return s;
        }
        return s.substring(0, i + 1);
    }

    private StringUtil() {
    }
}

