/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoPoint;

public class Marker {
    private final int m_size;
    private boolean[] m_mark;

    public Marker(int size) {
        this.m_size = size;
        this.m_mark = new boolean[625];
    }

    public void clear() {
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                this.m_mark[GoPoint.getIndex((int)x, (int)y)] = false;
            }
        }
    }

    public void clear(GoPoint p) {
        this.m_mark[p.getIndex()] = false;
    }

    public void clear(ConstPointList points) {
        int nuPoints = points.size();
        for (int i = 0; i < nuPoints; ++i) {
            this.m_mark[points.get((int)i).getIndex()] = false;
        }
    }

    public boolean get(GoPoint p) {
        return this.m_mark[p.getIndex()];
    }

    public boolean isCleared() {
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                if (!this.m_mark[GoPoint.getIndex(x, y)]) continue;
                return false;
            }
        }
        return true;
    }

    public void set(GoPoint p) {
        this.m_mark[p.getIndex()] = true;
    }

    public void set(GoPoint p, boolean value) {
        this.m_mark[p.getIndex()] = value;
    }

    public void set(ConstPointList points) {
        int nuPoints = points.size();
        for (int i = 0; i < nuPoints; ++i) {
            this.m_mark[points.get((int)i).getIndex()] = true;
        }
    }
}

