/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.util;

import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrefUtil {
    public static Preferences createNode(String path) {
        assert (!path.startsWith("/"));
        return Preferences.userRoot().node(path);
    }

    public static ArrayList<String> getList(String path) {
        String element;
        Preferences prefs = PrefUtil.getNode(path);
        if (prefs == null) {
            return new ArrayList<String>();
        }
        int size = prefs.getInt("size", 0);
        if (size <= 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>(size);
        for (int i = 0; i < size && (element = prefs.get("element_" + i, null)) != null; ++i) {
            result.add(element);
        }
        return result;
    }

    public static Preferences getNode(String path) {
        assert (!path.startsWith("/"));
        Preferences prefs = Preferences.userRoot();
        try {
            if (!prefs.nodeExists(path)) {
                return null;
            }
        }
        catch (BackingStoreException e) {
            return null;
        }
        return prefs.node(path);
    }

    public static void putList(String path, ArrayList<String> list) {
        Preferences prefs = PrefUtil.createNode(path);
        if (prefs == null) {
            return;
        }
        prefs.putInt("size", list.size());
        for (int i = 0; i < list.size(); ++i) {
            prefs.put("element_" + i, list.get(i));
        }
    }

    private PrefUtil() {
    }
}

