/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.xml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import net.sf.gogui.game.GameInfo;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.StringInfo;
import net.sf.gogui.game.StringInfoColor;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.InvalidKomiException;
import net.sf.gogui.go.InvalidPointException;
import net.sf.gogui.go.Komi;
import net.sf.gogui.go.Move;
import net.sf.gogui.sgf.SgfUtil;
import net.sf.gogui.util.ByteCountInputStream;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.ProgressShow;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XmlReader {
    private static final int DEFAULT_BOARDSIZE = 19;
    private boolean m_isFirstElement;
    private boolean m_isFirstNode;
    private boolean m_isBoardSizeKnown;
    private int m_numberGames;
    private int m_numberTrees;
    private int m_boardSize;
    private int m_lastPercent;
    private final long m_streamSize;
    private Stack<String> m_elementStack = new Stack();
    private Node m_node;
    private Stack<Node> m_variation = new Stack();
    private GameInfo m_info = new GameInfo();
    private Node m_root;
    private GameTree m_tree;
    private String m_element;
    private Attributes m_atts;
    private String m_sgfType;
    private ArrayList<String> m_sgfArgs = new ArrayList();
    private StringBuilder m_characters = new StringBuilder();
    private final Set<String> m_warnings = new TreeSet<String>();
    private Locator m_locator;
    private MarkType m_markType;
    private String m_label;
    private String m_gameName;
    private ByteCountInputStream m_byteCountInputStream;
    private final ProgressShow m_progressShow;
    private int m_byoyomiMoves;
    private long m_byoyomi;
    private long m_preByoyomi;
    private long m_gameInfoPreByoyomi;
    private boolean m_ignoreOvertime;
    private String m_paragraphElementText;

    public XmlReader(InputStream in, ProgressShow progressShow, long streamSize) throws ErrorMessage {
        this.m_progressShow = progressShow;
        this.m_streamSize = streamSize;
        if (progressShow != null) {
            progressShow.showProgress(0);
            this.m_byteCountInputStream = new ByteCountInputStream(in);
            in = this.m_byteCountInputStream;
        }
        try {
            this.m_isFirstElement = true;
            this.m_isFirstNode = true;
            this.m_gameInfoPreByoyomi = -1L;
            this.m_root = new Node();
            this.m_info = new GameInfo();
            this.m_node = this.m_root;
            XMLReader reader = XMLReaderFactory.createXMLReader();
            try {
                reader.setFeature("http://xml.org/sax/features/validation", false);
            }
            catch (SAXException e) {
                // empty catch block
            }
            Handler handler = new Handler();
            reader.setContentHandler(handler);
            reader.setEntityResolver(handler);
            reader.setErrorHandler(handler);
            reader.parse(new InputSource(in));
            int size = this.m_isBoardSizeKnown ? this.m_boardSize : Math.max(19, this.m_boardSize);
            this.m_tree = new GameTree(size, this.m_root);
            this.m_tree.getGameInfo(this.m_root).copyFrom(this.m_info);
            if (this.m_gameName != null) {
                this.m_root.addSgfProperty("GN", this.m_gameName);
            }
        }
        catch (SAXException e) {
            throw new ErrorMessage(e.getMessage());
        }
        catch (IOException e) {
            throw new ErrorMessage(e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    public GameTree getTree() {
        return this.m_tree;
    }

    public String getWarnings() {
        if (this.m_warnings.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder(this.m_warnings.size() * 80);
        for (String s : this.m_warnings) {
            result.append(s);
            result.append('\n');
        }
        return result.toString();
    }

    private void checkAttributes(String ... atts) throws SAXException {
        List<String> list = Arrays.asList(atts);
        for (int i = 0; i < this.m_atts.getLength(); ++i) {
            String name = this.m_atts.getLocalName(i);
            if (list.contains(name)) continue;
            this.setWarning("Unknown attribute \"" + name + "\" for element \"" + this.m_element + "\"");
        }
    }

    private void checkNoCharacters() throws SAXException {
        if (!this.getCharacters().trim().equals("")) {
            this.setWarning("Cannot handle text content in element \"" + this.m_element + "\"");
        }
    }

    private void checkRoot() throws SAXException {
        String parent = this.parentElement();
        if (parent != null) {
            this.throwError("Element \"" + this.m_element + "\" cannot be child of \"" + parent + "\"");
        }
    }

    private void checkParent(String ... parents) throws SAXException {
        String parent = this.parentElement();
        if (!Arrays.asList(parents).contains(parent)) {
            this.throwError("Element \"" + this.m_element + "\" cannot be child of \"" + parent + "\"");
        }
    }

    private void createNode() {
        Node node = new Node();
        if (this.m_node != null) {
            this.m_node.append(node);
        } else if (!this.m_variation.isEmpty()) {
            this.m_variation.peek().getFather().append(node);
        }
        this.m_node = node;
    }

    private void endAt() throws SAXException {
        GoPoint p = this.getPoint(this.getCharacters());
        String parent = this.parentElement();
        if (parent.equals("Black")) {
            this.m_node.setMove(Move.get(GoColor.BLACK, p));
        } else if (parent.equals("White")) {
            this.m_node.setMove(Move.get(GoColor.WHITE, p));
        } else if (parent.equals("AddBlack")) {
            this.m_node.addStone(GoColor.BLACK, p);
        } else if (parent.equals("AddWhite")) {
            this.m_node.addStone(GoColor.WHITE, p);
        } else if (parent.equals("Delete")) {
            this.m_node.addStone(GoColor.EMPTY, p);
        } else if (parent.equals("Mark")) {
            if (this.m_markType != null) {
                this.m_node.addMarked(p, this.m_markType);
            }
            if (this.m_label != null) {
                this.m_node.setLabel(p, this.m_label);
            }
        }
    }

    private void endBoardSize() throws SAXException {
        int boardSize = this.parseInt();
        if (boardSize < 1 || boardSize > 25) {
            throw new SAXException("Unsupported board size");
        }
        this.m_isBoardSizeKnown = true;
        this.m_boardSize = boardSize;
    }

    private void endComment() {
        this.m_node.setComment(this.getParagraphElementText());
    }

    private void endCopyright() {
        this.m_info.set(StringInfo.COPYRIGHT, this.getParagraphElementText());
    }

    private void endHandicap() throws SAXException {
        int handicap = this.parseInt();
        if (handicap == 1 || handicap < 0) {
            this.setWarning("Ignoring invalid handicap: " + handicap);
        } else {
            this.m_info.setHandicap(handicap);
        }
    }

    private void endKomi() throws SAXException {
        String komi = this.getCharacters();
        try {
            this.m_info.setKomi(Komi.parseKomi(komi));
        }
        catch (InvalidKomiException e) {
            this.setWarning("Invalid komi: " + komi);
        }
    }

    private void endMark() throws SAXException {
        String value = this.getCharacters();
        if (!value.trim().equals("")) {
            GoPoint p = this.getPoint(value);
            if (this.m_markType != null) {
                this.m_node.addMarked(p, this.m_markType);
            }
            if (this.m_label != null) {
                this.m_node.setLabel(p, this.m_label);
            }
        }
    }

    private void endMove(GoColor c) throws SAXException {
        String value = this.getCharacters();
        if (!value.trim().equals("")) {
            this.m_node.setMove(Move.get(c, this.getPoint(value)));
        }
    }

    private void endNode() throws SAXException {
        this.checkNoCharacters();
        this.setSgfTimeSettings();
    }

    private void endP() throws SAXException {
        this.m_paragraphElementText = this.m_paragraphElementText + this.getMergedLines() + "\n";
    }

    private void endSetup(GoColor c) throws SAXException {
        String value = this.getCharacters();
        if (!value.trim().equals("")) {
            this.m_node.addStone(c, this.getPoint(value));
        }
    }

    private void endSgf() throws SAXException {
        this.checkNoCharacters();
        if (this.m_sgfType == null) {
            return;
        }
        if (this.m_sgfType.equals("AN")) {
            this.endSgfInfo(StringInfo.ANNOTATION);
        } else if (this.m_sgfType.equals("BL")) {
            this.endSgfTimeLeft(GoColor.BLACK);
        } else if (this.m_sgfType.equals("BR")) {
            this.endSgfInfo(StringInfoColor.RANK, GoColor.BLACK);
        } else if (this.m_sgfType.equals("BT")) {
            this.endSgfInfo(StringInfoColor.TEAM, GoColor.BLACK);
        } else if (this.m_sgfType.equals("CP")) {
            this.endSgfInfo(StringInfo.COPYRIGHT);
        } else if (this.m_sgfType.equals("DT")) {
            this.endSgfInfo(StringInfo.DATE);
        } else if (this.m_sgfType.equals("HA")) {
            this.endSgfHandicap();
        } else if (this.m_sgfType.equals("OB")) {
            this.endSgfMovesLeft(GoColor.BLACK);
        } else if (this.m_sgfType.equals("OM")) {
            this.endSgfOvertimeMoves();
        } else if (this.m_sgfType.equals("OP")) {
            this.endSgfOvertimePeriod();
        } else if (this.m_sgfType.equals("OT")) {
            this.endSgfOvertime();
        } else if (this.m_sgfType.equals("OW")) {
            this.endSgfMovesLeft(GoColor.WHITE);
        } else if (this.m_sgfType.equals("KM")) {
            this.endSgfKomi();
        } else if (this.m_sgfType.equals("PB")) {
            this.endSgfInfo(StringInfoColor.NAME, GoColor.BLACK);
        } else if (this.m_sgfType.equals("PW")) {
            this.endSgfInfo(StringInfoColor.NAME, GoColor.WHITE);
        } else if (this.m_sgfType.equals("PL")) {
            this.endSgfPlayer();
        } else if (this.m_sgfType.equals("RE")) {
            this.endSgfInfo(StringInfo.RESULT);
        } else if (this.m_sgfType.equals("RO")) {
            this.endSgfInfo(StringInfo.ROUND);
        } else if (this.m_sgfType.equals("RU")) {
            this.endSgfInfo(StringInfo.RULES);
        } else if (this.m_sgfType.equals("SL")) {
            this.endSgfSelect();
        } else if (this.m_sgfType.equals("WL")) {
            this.endSgfTimeLeft(GoColor.WHITE);
        } else if (this.m_sgfType.equals("TM")) {
            this.endSgfTime();
        } else if (this.m_sgfType.equals("WR")) {
            this.endSgfInfo(StringInfoColor.RANK, GoColor.WHITE);
        } else if (this.m_sgfType.equals("WT")) {
            this.endSgfInfo(StringInfoColor.TEAM, GoColor.WHITE);
        } else if (this.m_sgfType.equals("US")) {
            this.endSgfInfo(StringInfo.USER);
        } else {
            this.m_node.addSgfProperty(this.m_sgfType, this.m_sgfArgs);
        }
    }

    private void endSgfHandicap() {
        if (this.m_sgfArgs.size() == 0) {
            return;
        }
        try {
            int handicap = Integer.parseInt(this.m_sgfArgs.get(0));
            GameInfo info = this.m_node.createGameInfo();
            info.setHandicap(handicap);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void endSgfInfo(StringInfo type) {
        if (this.m_sgfArgs.size() == 0) {
            return;
        }
        GameInfo info = this.m_node.createGameInfo();
        info.set(type, this.m_sgfArgs.get(0));
    }

    private void endSgfInfo(StringInfoColor type, GoColor c) {
        if (this.m_sgfArgs.size() == 0) {
            return;
        }
        GameInfo info = this.m_node.createGameInfo();
        info.set(type, c, this.m_sgfArgs.get(0));
    }

    private void endSgfKomi() {
        if (this.m_sgfArgs.size() == 0) {
            return;
        }
        try {
            Komi komi = Komi.parseKomi(this.m_sgfArgs.get(0));
            GameInfo info = this.m_node.createGameInfo();
            info.setKomi(komi);
        }
        catch (InvalidKomiException invalidKomiException) {
            // empty catch block
        }
    }

    private void endSgfMovesLeft(GoColor c) {
        if (this.m_sgfArgs.size() == 0) {
            return;
        }
        try {
            int movesLeft = Integer.parseInt(this.m_sgfArgs.get(0));
            if (movesLeft >= 0) {
                this.m_node.setMovesLeft(c, movesLeft);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void endSgfOvertime() {
        if (this.m_sgfArgs.size() == 0) {
            return;
        }
        String value = this.m_sgfArgs.get(0).trim();
        if (value.equals("") || value.equals("-")) {
            return;
        }
        SgfUtil.Overtime overtime = SgfUtil.parseOvertime(value);
        if (overtime == null) {
            this.setWarning("Overtime settings in unknown format");
            this.m_node.addSgfProperty("OT", value);
        } else {
            this.m_byoyomi = overtime.m_byoyomi;
            this.m_byoyomiMoves = overtime.m_byoyomiMoves;
        }
    }

    private void endSgfOvertimeMoves() {
        if (this.m_sgfArgs.size() == 0) {
            return;
        }
        try {
            this.m_byoyomiMoves = Integer.parseInt(this.m_sgfArgs.get(0));
        }
        catch (NumberFormatException e) {
            this.setWarning("Invalid value for byoyomi moves");
            this.m_ignoreOvertime = true;
        }
    }

    private void endSgfOvertimePeriod() {
        if (this.m_sgfArgs.size() == 0) {
            return;
        }
        try {
            this.m_byoyomi = (long)(Double.parseDouble(this.m_sgfArgs.get(0)) * 1000.0);
        }
        catch (NumberFormatException e) {
            this.setWarning("Invalid value for byoyomi time");
            this.m_ignoreOvertime = true;
        }
    }

    private void endSgfPlayer() {
        GoColor c;
        if (this.m_sgfArgs.size() == 0) {
            return;
        }
        String value = this.m_sgfArgs.get(0).trim().toLowerCase(Locale.ENGLISH);
        if (value.equals("b") || value.equals("black")) {
            c = GoColor.BLACK;
        } else if (value.equals("w") || value.equals("white")) {
            c = GoColor.WHITE;
        } else {
            return;
        }
        this.m_node.setPlayer(c);
    }

    private void endSgfSelect() throws SAXException {
        for (int i = 0; i < this.m_sgfArgs.size(); ++i) {
            this.m_node.addMarked(this.getSgfPoint(this.m_sgfArgs.get(i)), MarkType.SELECT);
        }
    }

    private void endSgfTimeLeft(GoColor c) {
        if (this.m_sgfArgs.size() == 0) {
            return;
        }
        try {
            double timeLeft = Double.parseDouble(this.m_sgfArgs.get(0));
            this.m_node.setTimeLeft(c, timeLeft);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void endSgfTime() {
        if (this.m_sgfArgs.size() == 0) {
            return;
        }
        String value = this.m_sgfArgs.get(0).trim();
        if (value.equals("") || value.equals("-")) {
            return;
        }
        long preByoyomi = SgfUtil.parseTime(value);
        if (preByoyomi < 0L) {
            this.setWarning("Unknown format in time property");
            this.m_node.addSgfProperty("TM", value);
        } else {
            this.m_preByoyomi = preByoyomi;
        }
    }

    private void endTime() throws SAXException {
        String value = this.getCharacters().trim();
        if (value.equals("") || value.equals("-")) {
            return;
        }
        long preByoyomi = SgfUtil.parseTime(value);
        if (preByoyomi < 0L) {
            this.setWarning("Unknown format in Time element");
            this.m_node.addSgfProperty("TM", value);
        } else {
            this.m_gameInfoPreByoyomi = preByoyomi;
            TimeSettings timeSettings = new TimeSettings(preByoyomi);
            this.m_info.setTimeSettings(timeSettings);
        }
    }

    private void endToPlay() throws SAXException {
        if (!this.getCharacters().trim().equals("")) {
            this.setWarning("Ignoring text content in element \"" + this.m_element + "\"");
        }
    }

    private void endVariation() throws SAXException {
        this.checkNoCharacters();
        this.m_node = this.m_variation.pop();
    }

    private String getCharacters() {
        return this.m_characters.toString();
    }

    private String getMergedLines() {
        StringBuilder result;
        block4: {
            String chars = this.getCharacters();
            result = new StringBuilder(chars.length());
            BufferedReader reader = new BufferedReader(new StringReader(chars));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (result.length() > 0) {
                        result.append(' ');
                    }
                    result.append(line);
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        return result.toString();
    }

    private String getParagraphElementText() {
        String text = this.m_paragraphElementText;
        String mergedLines = this.getMergedLines();
        if (!mergedLines.equals("")) {
            text = text + mergedLines + "\n";
        }
        if (text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    private GoPoint getPoint(String value) throws SAXException {
        if ((value = value.trim()).equals("")) {
            return null;
        }
        try {
            GoPoint p;
            if (this.m_isBoardSizeKnown) {
                p = GoPoint.parsePoint(value, this.m_boardSize);
            } else {
                p = GoPoint.parsePoint(value, 25);
                if (p != null) {
                    this.m_boardSize = Math.max(this.m_boardSize, p.getX());
                    this.m_boardSize = Math.max(this.m_boardSize, p.getY());
                }
            }
            return p;
        }
        catch (InvalidPointException e) {
            this.throwError(e.getMessage());
            return null;
        }
    }

    private GoPoint getSgfPoint(String s) throws SAXException {
        if ((s = s.trim().toLowerCase(Locale.ENGLISH)).equals("")) {
            return null;
        }
        if (s.length() > 2 || s.length() == 2 && s.charAt(1) < 'a' || s.charAt(1) > 'z') {
            return this.getPoint(s);
        }
        if (s.length() != 2) {
            this.throwError("Invalid SGF coordinates: " + s);
        }
        if (!this.m_isBoardSizeKnown) {
            this.m_boardSize = 19;
            this.m_isBoardSizeKnown = true;
        }
        if (s.equals("tt") && this.m_boardSize <= 19) {
            return null;
        }
        int x = s.charAt(0) - 97;
        int y = this.m_boardSize - (s.charAt(1) - 97) - 1;
        if (x < 0 || x >= this.m_boardSize || y < 0 || y >= this.m_boardSize) {
            if (x == this.m_boardSize && y == -1) {
                return null;
            }
            this.throwError("Coordinates \"" + s + "\" outside board size " + this.m_boardSize);
        }
        return GoPoint.get(x, y);
    }

    private void setSgfTimeSettings() {
        long preByoyomi = this.m_preByoyomi;
        if (this.m_node == this.m_root && preByoyomi < 0L) {
            preByoyomi = this.m_gameInfoPreByoyomi;
        }
        TimeSettings s = null;
        if (preByoyomi > 0L && (this.m_ignoreOvertime || this.m_byoyomi <= 0L || this.m_byoyomiMoves <= 0)) {
            s = new TimeSettings(preByoyomi);
        } else if (preByoyomi <= 0L && !this.m_ignoreOvertime && this.m_byoyomi > 0L && this.m_byoyomiMoves > 0) {
            s = new TimeSettings(0L, this.m_byoyomi, this.m_byoyomiMoves);
        } else if (preByoyomi > 0L && !this.m_ignoreOvertime && this.m_byoyomi > 0L && this.m_byoyomiMoves > 0) {
            s = new TimeSettings(preByoyomi, this.m_byoyomi, this.m_byoyomiMoves);
        }
        if (s != null) {
            if (this.m_node == this.m_root) {
                this.m_info.setTimeSettings(s);
            } else {
                this.m_node.createGameInfo().setTimeSettings(s);
            }
        }
    }

    private void showProgress() {
        int percent;
        if (this.m_streamSize > 0L) {
            long count = this.m_byteCountInputStream.getCount();
            percent = (int)(count * 100L / this.m_streamSize);
        } else {
            percent = 100;
        }
        if (percent != this.m_lastPercent) {
            this.m_progressShow.showProgress(percent);
        }
        this.m_lastPercent = percent;
    }

    private void startComment() throws SAXException {
        this.checkParent("Nodes", "Node", "Variation");
        this.checkAttributes(new String[0]);
        this.m_paragraphElementText = "";
    }

    private void startCopyright() throws SAXException {
        this.checkParent("Information");
        this.checkAttributes(new String[0]);
        this.m_paragraphElementText = "";
    }

    private void startGo() throws SAXException {
        this.checkRoot();
        this.checkAttributes(new String[0]);
    }

    private void startGoGame() throws SAXException {
        this.checkParent("Go");
        this.checkAttributes("name");
        String name = this.m_atts.getValue("name");
        if (name != null) {
            this.m_gameName = name;
        }
        if (++this.m_numberGames > 1) {
            this.throwError("Multiple games per file not supported");
        }
    }

    private void startInfoElemWithFormat() throws SAXException {
        this.checkParent("Information");
        this.checkAttributes("format");
        String format = this.m_atts.getValue("format");
        if (format == null) {
            return;
        }
        if (!(format = format.trim().toLowerCase(Locale.ENGLISH)).equals("sgf")) {
            this.setWarning("Unknown format attribute \"" + format + "\" for element \"" + this.m_element + "\"");
        }
    }

    private void startInfoElemWithoutFormat() throws SAXException {
        this.checkParent("Information");
        this.checkAttributes(new String[0]);
    }

    private void startInformation() throws SAXException {
        this.checkParent("GoGame");
        this.checkAttributes(new String[0]);
    }

    private void startLine() throws SAXException {
        this.setWarning("Element \"Line\" cannot be child of element \"" + this.parentElement() + "\"");
    }

    private void startMark() throws SAXException {
        String value;
        this.checkParent("Node");
        this.checkAttributes("at", "label", "territory", "type");
        this.m_markType = null;
        this.m_label = this.m_atts.getValue("label");
        String type = this.m_atts.getValue("type");
        String territory = this.m_atts.getValue("territory");
        if (type != null) {
            if (type.equals("triangle")) {
                this.m_markType = MarkType.TRIANGLE;
            } else if (type.equals("circle")) {
                this.m_markType = MarkType.CIRCLE;
            } else if (type.equals("square")) {
                this.m_markType = MarkType.SQUARE;
            } else {
                this.setWarning("Unknown mark type " + type);
            }
        }
        if (territory != null) {
            if (territory.equals("black")) {
                this.m_markType = MarkType.TERRITORY_BLACK;
            } else if (territory.equals("white")) {
                this.m_markType = MarkType.TERRITORY_WHITE;
            } else {
                this.setWarning("Unknown territory type " + territory);
            }
        }
        if (type == null && territory == null && this.m_label == null) {
            this.m_markType = MarkType.MARK;
        }
        if ((value = this.m_atts.getValue("at")) != null) {
            GoPoint p = this.getPoint(value);
            if (this.m_markType != null) {
                this.m_node.addMarked(p, this.m_markType);
            }
            if (this.m_label != null) {
                this.m_node.setLabel(p, this.m_label);
            }
        }
    }

    private void startMove(GoColor c) throws SAXException {
        String value;
        this.checkParent("Node", "Nodes", "Variation");
        if (!this.parentElement().equals("Node")) {
            this.createNode();
        }
        this.checkAttributes("annotate", "at", "timeleft", "name", "number");
        String name = this.m_atts.getValue("name");
        if (name != null) {
            this.m_node.addSgfProperty("N", name);
        }
        if (this.m_atts.getValue("annotate") != null) {
            this.setWarning("Attribute \"annotate\" in element \"" + this.m_element + "\" not supported");
        }
        if ((value = this.m_atts.getValue("at")) != null) {
            this.m_node.setMove(Move.get(c, this.getPoint(value)));
        }
        if ((value = this.m_atts.getValue("timeleft")) != null) {
            try {
                this.m_node.setTimeLeft(c, Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private void startNode() throws SAXException {
        String value;
        this.checkParent("Nodes", "Variation");
        this.checkAttributes("blacktime", "name", "whitetime");
        if (!this.m_isFirstNode || !this.m_node.isEmpty()) {
            this.createNode();
        }
        this.m_isFirstNode = false;
        String name = this.m_atts.getValue("name");
        if (name != null) {
            this.m_node.addSgfProperty("N", name);
        }
        if ((value = this.m_atts.getValue("blacktime")) != null) {
            try {
                this.m_node.setTimeLeft(GoColor.BLACK, Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((value = this.m_atts.getValue("whitetime")) != null) {
            try {
                this.m_node.setTimeLeft(GoColor.WHITE, Double.parseDouble(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_ignoreOvertime = false;
        this.m_byoyomiMoves = -1;
        this.m_byoyomi = -1L;
        this.m_preByoyomi = -1L;
    }

    private void startNodes() throws SAXException {
        this.checkParent("GoGame");
        this.checkAttributes(new String[0]);
        if (++this.m_numberTrees > 1) {
            this.throwError("More than one Nodes element in element GoGame");
        }
    }

    private void startP() throws SAXException {
        this.checkParent("Comment", "Copyright");
        this.checkAttributes(new String[0]);
    }

    private void startSetup(GoColor c) throws SAXException {
        this.checkParent("Node");
        this.checkAttributes("at");
        String value = this.m_atts.getValue("at");
        if (value != null) {
            this.m_node.addStone(c, this.getPoint(value));
        }
    }

    private void startSGF() throws SAXException {
        this.checkParent("Node");
        this.checkAttributes("type");
        this.m_sgfType = this.m_atts.getValue("type");
        this.m_sgfArgs.clear();
    }

    private void startToPlay(GoColor c) throws SAXException {
        this.checkParent("Node");
        this.checkAttributes(new String[0]);
        this.m_node.setPlayer(c);
    }

    private void startVariation() throws SAXException {
        this.checkParent("Nodes", "Variation");
        this.checkAttributes(new String[0]);
        if (this.m_node == null) {
            this.throwError("Variation without main node");
        }
        assert (this.m_node.hasFather());
        this.m_variation.push(this.m_node);
        this.m_node = null;
    }

    private String parentElement() {
        if (this.m_elementStack.isEmpty()) {
            return null;
        }
        return this.m_elementStack.peek();
    }

    private int parseInt() throws SAXException {
        try {
            return Integer.parseInt(this.getCharacters());
        }
        catch (NumberFormatException e) {
            throw new SAXException("Expected integer in element " + this.m_element);
        }
    }

    private void setWarning(String message) {
        this.m_warnings.add(message);
    }

    private void throwError(String message) throws SAXException {
        if (this.m_locator != null) {
            message = "Line " + this.m_locator.getLineNumber() + ":" + this.m_locator.getColumnNumber() + ": " + message;
        }
        throw new SAXException(message);
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        public void startElement(String namespaceURI, String name, String qualifiedName, Attributes atts) throws SAXException {
            if (XmlReader.this.m_progressShow != null) {
                XmlReader.this.showProgress();
            }
            XmlReader.this.checkNoCharacters();
            XmlReader.this.m_element = name;
            XmlReader.this.m_atts = atts;
            if (XmlReader.this.m_isFirstElement) {
                if (!XmlReader.this.m_element.equals("Go")) {
                    throw new SAXException("Not a Go game");
                }
                XmlReader.this.m_isFirstElement = false;
            }
            if (name.equals("Annotation")) {
                XmlReader.this.startInfoElemWithoutFormat();
            } else if (name.equals("Application")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("AddBlack")) {
                XmlReader.this.startSetup(GoColor.BLACK);
            } else if (name.equals("AddWhite")) {
                XmlReader.this.startSetup(GoColor.WHITE);
            } else if (name.equals("Arg")) {
                XmlReader.this.checkParent(new String[]{"SGF"});
            } else if (name.equals("at")) {
                XmlReader.this.checkParent(new String[]{"Black", "White", "AddBlack", "AddWhite", "Delete", "Mark"});
            } else if (name.equals("Black")) {
                XmlReader.this.startMove(GoColor.BLACK);
            } else if (name.equals("BlackPlayer")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("BlackRank")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("BlackTeam")) {
                XmlReader.this.startInfoElemWithoutFormat();
            } else if (name.equals("BlackToPlay")) {
                XmlReader.this.startToPlay(GoColor.BLACK);
            } else if (name.equals("BoardSize")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("Comment")) {
                XmlReader.this.startComment();
            } else if (name.equals("Copyright")) {
                XmlReader.this.startCopyright();
            } else if (name.equals("Date")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("Delete")) {
                XmlReader.this.startSetup(GoColor.EMPTY);
            } else if (name.equals("Go")) {
                XmlReader.this.startGo();
            } else if (name.equals("GoGame")) {
                XmlReader.this.startGoGame();
            } else if (name.equals("Handicap")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("Information")) {
                XmlReader.this.startInformation();
            } else if (name.equals("Line")) {
                XmlReader.this.startLine();
            } else if (name.equals("Komi")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("Mark")) {
                XmlReader.this.startMark();
            } else if (name.equals("Node")) {
                XmlReader.this.startNode();
            } else if (name.equals("Nodes")) {
                XmlReader.this.startNodes();
            } else if (name.equals("P")) {
                XmlReader.this.startP();
            } else if (name.equals("Result")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("Round")) {
                XmlReader.this.startInfoElemWithoutFormat();
            } else if (name.equals("Rules")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("Source")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("SGF")) {
                XmlReader.this.startSGF();
            } else if (name.equals("Time")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("User")) {
                XmlReader.this.startInfoElemWithoutFormat();
            } else if (name.equals("Variation")) {
                XmlReader.this.startVariation();
            } else if (name.equals("White")) {
                XmlReader.this.startMove(GoColor.WHITE);
            } else if (name.equals("WhitePlayer")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("WhiteRank")) {
                XmlReader.this.startInfoElemWithFormat();
            } else if (name.equals("WhiteTeam")) {
                XmlReader.this.startInfoElemWithoutFormat();
            } else if (name.equals("WhiteToPlay")) {
                XmlReader.this.startToPlay(GoColor.WHITE);
            } else {
                XmlReader.this.setWarning("Ignoring unknown element: " + name);
            }
            XmlReader.this.m_elementStack.push(name);
            XmlReader.this.m_characters.setLength(0);
        }

        public void endElement(String namespaceURI, String name, String qualifiedName) throws SAXException {
            XmlReader.this.m_element = (String)XmlReader.this.m_elementStack.pop();
            if (name.equals("AddBlack")) {
                XmlReader.this.endSetup(GoColor.BLACK);
            } else if (name.equals("AddWhite")) {
                XmlReader.this.endSetup(GoColor.WHITE);
            } else if (name.equals("Annotation")) {
                XmlReader.this.m_info.set(StringInfo.ANNOTATION, XmlReader.this.getCharacters());
            } else if (name.equals("Arg")) {
                XmlReader.this.m_sgfArgs.add(XmlReader.this.getCharacters());
            } else if (name.equals("at")) {
                XmlReader.this.endAt();
            } else if (name.equals("Black")) {
                XmlReader.this.endMove(GoColor.BLACK);
            } else if (name.equals("BlackPlayer")) {
                XmlReader.this.m_info.set(StringInfoColor.NAME, GoColor.BLACK, XmlReader.this.getCharacters());
            } else if (name.equals("BlackRank")) {
                XmlReader.this.m_info.set(StringInfoColor.RANK, GoColor.BLACK, XmlReader.this.getCharacters());
            } else if (name.equals("BlackTeam")) {
                XmlReader.this.m_info.set(StringInfoColor.TEAM, GoColor.BLACK, XmlReader.this.getCharacters());
            } else if (name.equals("BlackToPlay")) {
                XmlReader.this.endToPlay();
            } else if (name.equals("BoardSize")) {
                XmlReader.this.endBoardSize();
            } else if (name.equals("Comment")) {
                XmlReader.this.endComment();
            } else if (name.equals("Copyright")) {
                XmlReader.this.endCopyright();
            } else if (name.equals("Date")) {
                XmlReader.this.m_info.set(StringInfo.DATE, XmlReader.this.getCharacters());
            } else if (name.equals("Delete")) {
                XmlReader.this.endSetup(GoColor.EMPTY);
            } else if (name.equals("Go")) {
                XmlReader.this.checkNoCharacters();
            } else if (name.equals("GoGame")) {
                XmlReader.this.checkNoCharacters();
            } else if (name.equals("Handicap")) {
                XmlReader.this.endHandicap();
            } else if (name.equals("Information")) {
                XmlReader.this.checkNoCharacters();
            } else if (name.equals("Komi")) {
                XmlReader.this.endKomi();
            } else if (name.equals("Mark")) {
                XmlReader.this.endMark();
            } else if (name.equals("Node")) {
                XmlReader.this.endNode();
            } else if (name.equals("Nodes")) {
                XmlReader.this.checkNoCharacters();
            } else if (name.equals("P")) {
                XmlReader.this.endP();
            } else if (name.equals("Result")) {
                XmlReader.this.m_info.set(StringInfo.RESULT, XmlReader.this.getCharacters());
            } else if (name.equals("Round")) {
                XmlReader.this.m_info.set(StringInfo.ROUND, XmlReader.this.getCharacters());
            } else if (name.equals("Rules")) {
                XmlReader.this.m_info.set(StringInfo.RULES, XmlReader.this.getCharacters());
            } else if (name.equals("SGF")) {
                XmlReader.this.endSgf();
            } else if (name.equals("Source")) {
                XmlReader.this.m_info.set(StringInfo.SOURCE, XmlReader.this.getCharacters());
            } else if (name.equals("Time")) {
                XmlReader.this.endTime();
            } else if (name.equals("User")) {
                XmlReader.this.m_info.set(StringInfo.USER, XmlReader.this.getCharacters());
            } else if (name.equals("White")) {
                XmlReader.this.endMove(GoColor.WHITE);
            } else if (name.equals("WhitePlayer")) {
                XmlReader.this.m_info.set(StringInfoColor.NAME, GoColor.WHITE, XmlReader.this.getCharacters());
            } else if (name.equals("WhiteRank")) {
                XmlReader.this.m_info.set(StringInfoColor.RANK, GoColor.WHITE, XmlReader.this.getCharacters());
            } else if (name.equals("WhiteTeam")) {
                XmlReader.this.m_info.set(StringInfoColor.TEAM, GoColor.WHITE, XmlReader.this.getCharacters());
            } else if (name.equals("WhiteToPlay")) {
                XmlReader.this.endToPlay();
            } else if (name.equals("Variation")) {
                XmlReader.this.endVariation();
            }
            XmlReader.this.m_characters.setLength(0);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            XmlReader.this.m_characters.append(ch, start, length);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            XmlReader.this.throwError(e.getMessage());
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            URI uri;
            if (systemId == null) {
                return null;
            }
            try {
                uri = new URI(systemId);
            }
            catch (URISyntaxException e) {
                return null;
            }
            if (!"file".equals(uri.getScheme())) {
                return null;
            }
            File file = new File(uri.getPath());
            if (file.exists() || !"go.dtd".equals(file.getName())) {
                return null;
            }
            String text = "<?xml version='1.0' encoding='UTF-8'?>";
            return new InputSource(new ByteArrayInputStream(text.getBytes()));
        }

        public void setDocumentLocator(Locator locator) {
            XmlReader.this.m_locator = locator;
        }

        public void error(SAXParseException e) {
            XmlReader.this.setWarning(e.getMessage());
        }

        public void warning(SAXParseException e) {
            XmlReader.this.setWarning(e.getMessage());
        }
    }
}

