/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GtpClientBase {
    private boolean m_isInterruptCommentSupported;
    protected String m_name;
    private String m_pid;
    private final StringBuilder m_buffer = new StringBuilder(128);
    private boolean m_lowerCase;
    private int m_protocolVersion = 2;
    private String[] m_supportedCommands;

    public abstract void close();

    public String getCommandBoardsize(int size) {
        if (this.m_protocolVersion == 2) {
            this.m_buffer.setLength(0);
            this.m_buffer.append("boardsize ");
            this.m_buffer.append(size);
            return this.m_buffer.toString();
        }
        return null;
    }

    public String getCommandClearBoard(int size) {
        if (this.m_protocolVersion == 1) {
            this.m_buffer.setLength(0);
            this.m_buffer.append("boardsize ");
            this.m_buffer.append(size);
            return this.m_buffer.toString();
        }
        return "clear_board";
    }

    public String getCommandGenmove(GoColor color) {
        assert (color.isBlackWhite());
        if (this.m_protocolVersion == 1) {
            if (color == GoColor.BLACK) {
                return "genmove_black";
            }
            return "genmove_white";
        }
        if (color == GoColor.BLACK) {
            return "genmove b";
        }
        return "genmove w";
    }

    public String getCommandPlay(Move move) {
        this.m_buffer.setLength(0);
        if (this.m_protocolVersion == 1) {
            GoColor color = move.getColor();
            String point = GoPoint.toString(move.getPoint());
            if (color == GoColor.BLACK) {
                this.m_buffer.append("black ");
            } else if (color == GoColor.WHITE) {
                this.m_buffer.append("white ");
            }
            this.m_buffer.append(point);
        } else {
            this.m_buffer.append("play ");
            this.m_buffer.append(move);
        }
        if (this.m_lowerCase) {
            return this.m_buffer.toString().toLowerCase(Locale.ENGLISH);
        }
        return this.m_buffer.toString();
    }

    public double getCpuTime() throws GtpError {
        try {
            return Double.parseDouble(this.send("cputime"));
        }
        catch (NumberFormatException e) {
            throw new GtpError("Invalid response to cputime command");
        }
    }

    public String getLabel() {
        return this.m_name == null ? "Unknown Program" : this.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    public int getProtocolVersion() {
        return this.m_protocolVersion;
    }

    public ArrayList<String> getSupportedCommands() {
        ArrayList<String> result = new ArrayList<String>(128);
        if (this.m_supportedCommands != null) {
            for (int i = 0; i < this.m_supportedCommands.length; ++i) {
                result.add(this.m_supportedCommands[i]);
            }
        }
        return result;
    }

    public boolean isProgramDead() {
        return false;
    }

    public boolean isSupported(String command) {
        if (this.m_supportedCommands == null) {
            return false;
        }
        for (int i = 0; i < this.m_supportedCommands.length; ++i) {
            if (!this.m_supportedCommands[i].equals(command)) continue;
            return true;
        }
        return false;
    }

    public boolean isCpuTimeSupported() {
        return this.isSupported("cputime");
    }

    public boolean isGenmoveSupported() {
        if (this.m_protocolVersion == 1) {
            return !this.isSupported("help") || this.isSupported("genmove_black") && this.isSupported("genmove_white");
        }
        return !this.isSupported("list_commands") || this.isSupported("genmove");
    }

    public boolean isInterruptSupported() {
        return this.m_isInterruptCommentSupported || this.m_pid != null;
    }

    public void queryInterruptSupport() {
        try {
            if (this.isSupported("gogui-interrupt")) {
                this.send("gogui-interrupt");
                this.m_isInterruptCommentSupported = true;
            } else if (this.isSupported("gogui_interrupt")) {
                this.send("gogui_interrupt");
                this.m_isInterruptCommentSupported = true;
            } else if (this.isSupported("gogui-sigint")) {
                this.m_pid = this.send("gogui-sigint").trim();
            } else if (this.isSupported("gogui_sigint")) {
                this.m_pid = this.send("gogui_sigint").trim();
            }
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
    }

    public void queryName() {
        try {
            this.m_name = this.send("name");
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
    }

    public void queryProtocolVersion() {
        this.m_protocolVersion = 2;
        try {
            String response = this.send("protocol_version");
            int v = Integer.parseInt(response);
            if (v == 1 || v == 2) {
                this.m_protocolVersion = v;
            }
        }
        catch (NumberFormatException e) {
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
    }

    public void querySupportedCommands() throws GtpError {
        String command = this.m_protocolVersion == 1 ? "help" : "list_commands";
        String response = this.send(command);
        this.m_supportedCommands = StringUtil.splitArguments(response);
        for (int i = 0; i < this.m_supportedCommands.length; ++i) {
            this.m_supportedCommands[i] = this.m_supportedCommands[i].trim();
        }
    }

    public String queryVersion() {
        try {
            return this.send("version");
        }
        catch (GtpError e) {
            return "";
        }
    }

    public abstract String send(String var1) throws GtpError;

    public abstract void sendComment(String var1);

    public void sendBoardsize(int size) throws GtpError {
        String command = this.getCommandBoardsize(size);
        if (command != null) {
            this.send(command);
        }
    }

    public void sendClearBoard(int size) throws GtpError {
        this.send(this.getCommandClearBoard(size));
    }

    public void sendPlay(Move move) throws GtpError {
        this.send(this.getCommandPlay(move));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendInterrupt() throws GtpError {
        if (this.m_isInterruptCommentSupported) {
            this.sendComment("# interrupt");
            return;
        }
        if (this.m_pid == null) throw new GtpError("Interrupt not supported");
        String command = "kill -INT " + this.m_pid;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(command);
            int result = process.waitFor();
            if (result == 0) return;
            throw new GtpError("Command \"" + command + "\" returned " + result);
        }
        catch (IOException e) {
            throw new GtpError("Could not run command " + command + ":\n" + e);
        }
        catch (InterruptedException e) {
            this.printInterrupted();
            return;
        }
    }

    public void setLowerCase() {
        this.m_lowerCase = true;
    }

    public abstract void waitForExit();

    private void printInterrupted() {
        System.err.println("GtpClient: InterruptedException");
        Thread.dumpStack();
    }
}

