/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.thumbnail.ThumbnailCreator;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.StringUtil;

class SgfPreview
extends JPanel
implements PropertyChangeListener {
    private File m_file;
    private File m_lastFailure;
    private String m_lastError;
    private final JButton m_preview;
    private final JCheckBox m_auto;
    private Image m_image;
    private final ImagePanel m_imagePanel;
    private final ThumbnailCreator m_thumbnailCreator = new ThumbnailCreator(false);
    private final Preferences m_prefs = Preferences.userNodeForPackage(this.getClass());
    private static final Image MISSING_IMAGE = GuiUtil.getIcon("image-missing", I18n.i18n("LB_NO_PREVIEW")).getImage();

    public SgfPreview() {
        this.setLayout(new BorderLayout());
        JPanel previewPanel = new JPanel();
        previewPanel.setBorder(GuiUtil.createEmptyBorder());
        previewPanel.setLayout(new BoxLayout(previewPanel, 1));
        previewPanel.add(Box.createVerticalGlue());
        Dimension dimension = new Dimension(140, 140);
        previewPanel.setPreferredSize(dimension);
        this.add(previewPanel);
        this.m_imagePanel = new ImagePanel();
        previewPanel.add(this.m_imagePanel);
        previewPanel.add(Box.createVerticalGlue());
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        this.m_auto = new JCheckBox(I18n.i18n("LB_AUTOMATIC_PREVIEW"));
        this.m_auto.setSelected(this.m_prefs.getBoolean("auto-preview", false));
        this.m_auto.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                boolean isSelected = SgfPreview.this.m_auto.isSelected();
                SgfPreview.this.m_prefs.putBoolean("auto-preview", isSelected);
                if (isSelected) {
                    SgfPreview.this.preview();
                }
            }
        });
        buttonPanel.add(this.m_auto);
        this.m_preview = new JButton(I18n.i18n("LB_PREVIEW"));
        this.m_preview.setActionCommand("preview");
        this.m_preview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("preview")) {
                    SgfPreview.this.preview();
                }
            }
        });
        this.m_preview.setEnabled(false);
        buttonPanel.add(this.m_preview);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("SelectedFileChangedProperty")) {
            String name;
            this.m_file = null;
            this.m_preview.setEnabled(false);
            File file = (File)event.getNewValue();
            if (file != null && !file.exists()) {
                file = null;
            }
            if (file != null && ((name = file.getAbsolutePath()) == null || !name.toLowerCase(Locale.ENGLISH).endsWith(".sgf") && !name.toLowerCase(Locale.ENGLISH).endsWith(".xml"))) {
                file = null;
            }
            this.m_file = file;
            if (file != null) {
                this.m_preview.setEnabled(true);
            }
            if (this.m_auto.isSelected()) {
                this.preview();
            }
        }
    }

    public void preview() {
        if (this.m_file == null) {
            this.m_image = null;
            this.m_imagePanel.setToolTipText(null);
        } else if (this.m_file.equals(this.m_lastFailure)) {
            this.m_image = MISSING_IMAGE;
            this.m_imagePanel.setToolTipText(this.m_lastError);
        } else {
            try {
                if (this.m_file.length() > 500000L) {
                    throw new ThumbnailCreator.Error(I18n.i18n("MSG_TOO_LARGE_FOR_PREVIEW"));
                }
                this.m_thumbnailCreator.create(this.m_file);
                File thumbnail = this.m_thumbnailCreator.getLastThumbnail();
                this.m_image = SgfPreview.loadImage(thumbnail);
                String description = this.m_thumbnailCreator.getLastDescription();
                if (!StringUtil.isEmpty(description)) {
                    this.m_imagePanel.setToolTipText(description);
                } else {
                    this.m_imagePanel.setToolTipText(null);
                }
            }
            catch (ErrorMessage e) {
                this.m_image = MISSING_IMAGE;
                this.m_lastError = e.getMessage();
                if (this.m_lastError != null && this.m_lastError.trim().equals("")) {
                    this.m_lastError = null;
                }
                this.m_imagePanel.setToolTipText(this.m_lastError);
                this.m_lastFailure = this.m_file;
            }
        }
        this.m_imagePanel.repaint();
        this.m_preview.setEnabled(false);
    }

    private static Image loadImage(File file) {
        URL url;
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(url);
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException e) {
            return null;
        }
        return image;
    }

    private class ImagePanel
    extends JPanel {
        public ImagePanel() {
            Dimension dimension = new Dimension(140, 140);
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (SgfPreview.this.m_image != null) {
                int imageWidth = SgfPreview.this.m_image.getWidth(null);
                int imageHeight = SgfPreview.this.m_image.getHeight(null);
                int x = (this.getWidth() - imageWidth) / 2;
                int y = (this.getHeight() - imageHeight) / 2;
                graphics.drawImage(SgfPreview.this.m_image, x, y, imageWidth, imageHeight, null);
            }
        }
    }
}

