/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import net.sf.gogui.gtp.AnalyzeType;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzeDefinition {
    private final AnalyzeType m_type;
    private final String m_label;
    private final String m_command;

    public AnalyzeDefinition(String line) {
        String[] array = line.split("/");
        String typeStr = array[0];
        this.m_type = typeStr.equals("bwboard") ? AnalyzeType.BWBOARD : (typeStr.equals("cboard") ? AnalyzeType.CBOARD : (typeStr.equals("dboard") ? AnalyzeType.DBOARD : (typeStr.equals("eplist") ? AnalyzeType.EPLIST : (typeStr.equals("gfx") ? AnalyzeType.GFX : (typeStr.equals("hstring") ? AnalyzeType.HSTRING : (typeStr.equals("hpstring") ? AnalyzeType.HPSTRING : (typeStr.equals("param") ? AnalyzeType.PARAM : (typeStr.equals("plist") ? AnalyzeType.PLIST : (typeStr.equals("pspairs") ? AnalyzeType.PSPAIRS : (typeStr.equals("pstring") ? AnalyzeType.PSTRING : (typeStr.equals("string") ? AnalyzeType.STRING : (typeStr.equals("sboard") ? AnalyzeType.SBOARD : (typeStr.equals("var") ? AnalyzeType.VAR : (typeStr.equals("varb") ? AnalyzeType.VARB : (typeStr.equals("varc") ? AnalyzeType.VARC : (typeStr.equals("varp") ? AnalyzeType.VARP : (typeStr.equals("varpo") ? AnalyzeType.VARPO : (typeStr.equals("varw") ? AnalyzeType.VARW : AnalyzeType.NONE))))))))))))))))));
        this.m_label = array[1];
        this.m_command = array[2];
    }

    public AnalyzeDefinition(AnalyzeType type, String label, String command) {
        this.m_type = type;
        this.m_label = label;
        this.m_command = command;
    }

    public String getCommand() {
        return this.m_command;
    }

    public String getLabel() {
        return this.m_label;
    }

    public AnalyzeType getType() {
        return this.m_type;
    }

    public boolean isTextType() {
        return this.m_type == AnalyzeType.STRING || this.m_type == AnalyzeType.HSTRING || this.m_type == AnalyzeType.HPSTRING || this.m_type == AnalyzeType.PSTRING || this.m_type == AnalyzeType.VAR || this.m_type == AnalyzeType.VARC || this.m_type == AnalyzeType.VARW || this.m_type == AnalyzeType.VARB || this.m_type == AnalyzeType.VARP || this.m_type == AnalyzeType.VARPO;
    }

    public boolean needsColorArg() {
        return this.m_command.indexOf("%c") >= 0;
    }

    public boolean needsFileArg() {
        return this.m_command.indexOf("%f") >= 0;
    }

    public boolean needsFileOpenArg() {
        return this.m_command.indexOf("%r") >= 0;
    }

    public boolean needsFileSaveArg() {
        return this.m_command.indexOf("%w") >= 0;
    }

    public boolean needsOnlyPointArg() {
        return this.needsPointArg() && !this.needsColorArg() && !this.needsFileArg() && !this.needsFileOpenArg() && !this.needsFileSaveArg() && !this.needsPointListArg() && !this.needsStringArg() && !this.needsOptStringArg();
    }

    public boolean needsOnlyPointAndColorArg() {
        return this.needsPointArg() && this.needsColorArg() && !this.needsFileArg() && !this.needsFileOpenArg() && !this.needsFileSaveArg() && !this.needsPointListArg() && !this.needsStringArg() && !this.needsOptStringArg();
    }

    public boolean needsPointArg() {
        return this.m_command.indexOf("%p") >= 0;
    }

    public boolean needsPointListArg() {
        return this.m_command.indexOf("%P") >= 0 || this.m_type == AnalyzeType.EPLIST;
    }

    public boolean needsStringArg() {
        return this.m_command.indexOf("%s") >= 0;
    }

    public boolean needsOptStringArg() {
        return this.m_command.indexOf("%o") >= 0;
    }

    public static ArrayList<AnalyzeDefinition> read(ArrayList<String> supportedCommands, File analyzeCommands, String programAnalyzeCommands) throws ErrorMessage {
        if (analyzeCommands != null) {
            try {
                FileReader fileReader = new FileReader(analyzeCommands);
                BufferedReader reader = new BufferedReader(fileReader);
                return AnalyzeDefinition.readConfig(reader, analyzeCommands.getName(), null);
            }
            catch (FileNotFoundException e) {
                throw new ErrorMessage("File \"" + analyzeCommands + "\" not found");
            }
        }
        if (programAnalyzeCommands != null) {
            StringReader stringReader = new StringReader(programAnalyzeCommands);
            BufferedReader reader = new BufferedReader(stringReader);
            return AnalyzeDefinition.readConfig(reader, "program response to gogui-analyze_commands", null);
        }
        String resource = "net/sf/gogui/gui/analyze-commands";
        URL url = ClassLoader.getSystemClassLoader().getResource(resource);
        if (url == null) {
            return new ArrayList<AnalyzeDefinition>();
        }
        try {
            InputStream inputStream = url.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(inputStreamReader);
            return AnalyzeDefinition.readConfig(reader, "builtin default commands", supportedCommands);
        }
        catch (IOException e) {
            throw new ErrorMessage(e.getMessage());
        }
    }

    private static ArrayList<AnalyzeDefinition> readConfig(BufferedReader reader, String name, ArrayList<String> supportedCommands) throws ErrorMessage {
        ArrayList<AnalyzeDefinition> result = new ArrayList<AnalyzeDefinition>();
        ArrayList<String> labels = new ArrayList<String>();
        try {
            String line;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                String label;
                String[] cmdArray;
                ++lineNumber;
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                String[] array = line.split("/");
                if (array.length < 3 || array.length > 5) {
                    throw new ErrorMessage("Error in " + name + " line " + lineNumber);
                }
                if (supportedCommands != null && ((cmdArray = StringUtil.splitArguments(array[2].trim())).length == 0 || !supportedCommands.contains(cmdArray[0])) || labels.contains(label = array[1])) continue;
                labels.add(label);
                result.add(new AnalyzeDefinition(line));
            }
            ArrayList<AnalyzeDefinition> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            throw new ErrorMessage("Error reading " + name);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new ErrorMessage("Error reading " + name);
            }
        }
    }
}

