/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.game;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.sf.gogui.game.Clock;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.ConstSgfProperties;
import net.sf.gogui.game.GameInfo;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.SgfProperties;
import net.sf.gogui.game.StringInfo;
import net.sf.gogui.game.StringInfoColor;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.go.PointList;
import net.sf.gogui.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeUtil {
    private static Random s_random = new Random();

    public static ConstNode backward(ConstNode node, int n) {
        assert (n >= 0);
        for (int i = 0; i < n && node.getFatherConst() != null; ++i) {
            node = node.getFatherConst();
        }
        return node;
    }

    public static SgfProperties cleanSgfProps(ConstNode node) {
        SgfProperties props = new SgfProperties(node.getSgfPropertiesConst());
        ConstGameInfo info = node.getGameInfoConst();
        if (info != null && info.getTimeSettings() != null) {
            props.remove("OT");
            props.remove("TM");
            props.remove("OM");
            props.remove("OP");
        }
        return props;
    }

    public static boolean commentContains(ConstNode node, Pattern pattern) {
        String comment = node.getComment();
        return comment != null && pattern.matcher(comment).find();
    }

    public static ConstNode findByMoveNumber(ConstNode node, int moveNumber) {
        int maxMoveNumber = NodeUtil.getMoveNumber(node) + NodeUtil.getMovesLeft(node);
        if (moveNumber < 0 || moveNumber > maxMoveNumber) {
            return null;
        }
        if (moveNumber <= NodeUtil.getMoveNumber(node)) {
            while (node.getFatherConst() != null && (NodeUtil.getMoveNumber(node) > moveNumber || node.getMove() == null)) {
                node = node.getFatherConst();
            }
        } else {
            while (node.getChildConst() != null && NodeUtil.getMoveNumber(node) < moveNumber) {
                node = node.getChildConst();
            }
        }
        return node;
    }

    public static ConstNode findByVariation(ConstNode root, String variation) {
        if (variation.trim().equals("")) {
            return root;
        }
        String[] tokens = StringUtil.split(variation, '.');
        int[] n = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            try {
                n[i] = Integer.parseInt(tokens[i]) - 1;
                if (n[i] >= 0) continue;
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        ConstNode node = root;
        for (int i = 0; i < n.length; ++i) {
            while (node.getNumberChildren() <= 1) {
                if ((node = node.getChildConst()) != null) continue;
                return null;
            }
            if (n[i] >= node.getNumberChildren()) {
                return null;
            }
            node = node.getChildConst(n[i]);
        }
        return node;
    }

    public static ConstNode findInComments(ConstNode node, Pattern pattern) {
        node = NodeUtil.nextNode(node);
        while (node != null) {
            if (NodeUtil.commentContains(node, pattern)) {
                return node;
            }
            node = NodeUtil.nextNode(node);
        }
        return null;
    }

    public static ConstNode findNextComment(ConstNode node) {
        node = NodeUtil.nextNode(node);
        while (node != null) {
            if (node.hasComment()) {
                return node;
            }
            node = NodeUtil.nextNode(node);
        }
        return null;
    }

    public static ConstNode forward(ConstNode node, int n) {
        ConstNode child;
        assert (n >= 0);
        for (int i = 0; i < n && (child = node.getChildConst()) != null; ++i) {
            node = child;
        }
        return node;
    }

    public static ConstNode getBackToMainVariation(ConstNode node) {
        if (NodeUtil.isInMainVariation(node)) {
            return node;
        }
        while (!NodeUtil.isInMainVariation(node)) {
            node = node.getFatherConst();
        }
        return node.getChildConst(0);
    }

    public static PointList getChildrenMoves(ConstNode node) {
        PointList moves = new PointList();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            Move childMove = node.getChildConst(i).getMove();
            if (childMove == null || childMove.getPoint() == null) continue;
            moves.add(childMove.getPoint());
        }
        return moves;
    }

    public static ConstNode getChildWithMove(ConstNode node, Move move) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            ConstNode child = node.getChildConst(i);
            Move childMove = child.getMove();
            if (childMove == null || !childMove.equals(move)) continue;
            return child;
        }
        return null;
    }

    public static String getCommentStart(ConstNode node, boolean firstLineOnly, int maxChar) {
        int pos;
        String comment = node.getComment();
        if (comment == null) {
            return null;
        }
        boolean trimmed = false;
        if (firstLineOnly && (pos = comment.indexOf("\n")) >= 0) {
            comment = comment.substring(0, pos);
            trimmed = true;
        }
        if (comment.length() > maxChar) {
            comment = comment.substring(0, maxChar);
            trimmed = true;
        }
        if (trimmed) {
            if (maxChar > 30 && (pos = comment.lastIndexOf(32)) > 20) {
                if (comment.charAt(pos) == '.') {
                    --pos;
                }
                comment = comment.substring(0, pos);
            }
            comment = comment + "...";
        }
        return comment;
    }

    public static int getDepth(ConstNode node) {
        int depth = 0;
        while (node.getFatherConst() != null) {
            node = node.getFatherConst();
            ++depth;
        }
        return depth;
    }

    public static ConstNode getLast(ConstNode node) {
        while (node.hasChildren()) {
            node = node.getChildConst();
        }
        return node;
    }

    public static int getMoveNumber(ConstNode node) {
        int moveNumber = 0;
        while (node != null) {
            if (node.getMove() != null) {
                ++moveNumber;
            }
            node = node.getFatherConst();
        }
        return moveNumber;
    }

    public static int getMovesLeft(ConstNode node) {
        int movesLeft = 0;
        for (node = node.getChildConst(); node != null; node = node.getChildConst()) {
            if (node.getMove() == null) continue;
            ++movesLeft;
        }
        return movesLeft;
    }

    public static ConstNode getNextVariation(ConstNode node) {
        ConstNode father = node.getFatherConst();
        if (father == null) {
            return null;
        }
        return father.variationAfter(node);
    }

    public static ConstNode getNextEarlierVariation(ConstNode node) {
        ConstNode child = node;
        for (node = node.getFatherConst(); node != null && node.variationAfter(child) == null; node = node.getFatherConst()) {
            child = node;
        }
        if (node == null) {
            return null;
        }
        return node.variationAfter(child);
    }

    public static int getNodesLeft(ConstNode node) {
        int nodesLeft = 0;
        while (node != null) {
            ++nodesLeft;
            node = node.getChildConst();
        }
        return nodesLeft;
    }

    public static void getPathToRoot(ConstNode node, ArrayList<ConstNode> result) {
        result.clear();
        while (node != null) {
            result.add(node);
            node = node.getFatherConst();
        }
    }

    public static ConstNode getPreviousVariation(ConstNode node) {
        ConstNode father = node.getFatherConst();
        if (father == null) {
            return null;
        }
        return father.variationBefore(node);
    }

    public static ConstNode getPreviousEarlierVariation(ConstNode node) {
        ConstNode child = node;
        for (node = node.getFatherConst(); node != null && node.variationBefore(child) == null; node = node.getFatherConst()) {
            child = node;
        }
        if (node == null) {
            return null;
        }
        if ((node = node.variationBefore(child)) == null) {
            return null;
        }
        while (NodeUtil.hasSubtree(node)) {
            node = node.getChildConst(node.getNumberChildren() - 1);
        }
        return node;
    }

    public static ConstNode getRoot(ConstNode node) {
        while (node.getFatherConst() != null) {
            node = node.getFatherConst();
        }
        return node;
    }

    public static String getVariationString(ConstNode node) {
        ArrayList<String> list = new ArrayList<String>();
        while (node != null) {
            ConstNode father = node.getFatherConst();
            if (father != null && father.getNumberChildren() > 1) {
                int index = father.getChildIndex(node) + 1;
                list.add(0, Integer.toString(index));
            }
            node = father;
        }
        StringBuilder result = new StringBuilder(list.size() * 3);
        for (int i = 0; i < list.size(); ++i) {
            result.append((String)list.get(i));
            if (i >= list.size() - 1) continue;
            result.append('.');
        }
        return result.toString();
    }

    public static boolean hasSiblingMoves(ConstNode node) {
        ConstNode father = node.getFatherConst();
        if (father == null) {
            return false;
        }
        Move move = node.getMove();
        if (move == null) {
            return false;
        }
        for (int i = 0; i < father.getNumberChildren(); ++i) {
            Move childMove = father.getChildConst(i).getMove();
            if (childMove == null || childMove == move) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSubtree(ConstNode node) {
        while (node != null && node.getNumberChildren() < 2) {
            node = node.getChildConst();
        }
        return node != null;
    }

    public static boolean isInCleanup(ConstNode node) {
        boolean lastPass = false;
        while (node != null) {
            Move move = node.getMove();
            if (move != null) {
                if (move.getPoint() == null) {
                    if (lastPass) {
                        return true;
                    }
                    lastPass = true;
                } else {
                    lastPass = false;
                }
            }
            node = node.getFatherConst();
        }
        return false;
    }

    public static boolean isInMainVariation(ConstNode node) {
        while (node.getFatherConst() != null) {
            if (node.getFatherConst().getChildConst(0) != node) {
                return false;
            }
            node = node.getFatherConst();
        }
        return true;
    }

    public static boolean isRootWithoutChildren(ConstNode node) {
        return !node.hasFather() && !node.hasChildren();
    }

    public static boolean isTimeLeftKnown(ConstNode node, GoColor color) {
        while (node != null) {
            Move move = node.getMove();
            if (move != null && move.getColor() == color) {
                return !Double.isNaN(node.getTimeLeft(color));
            }
            ConstGameInfo info = node.getGameInfoConst();
            if (info != null && info.getTimeSettings() != null) {
                return true;
            }
            node = node.getFatherConst();
        }
        return false;
    }

    public static void makeMainVariation(Node node) {
        while (node.getFatherConst() != null) {
            node.getFather().makeFirstChild(node);
            node = node.getFather();
        }
    }

    public static GameTree makeTreeFromPosition(ConstGameInfo info, ConstBoard board) {
        if (info == null) {
            info = new GameInfo();
        }
        GameTree tree = new GameTree(board.getSize(), info.getKomi(), null, info.get(StringInfo.RULES), info.getTimeSettings());
        Node root = tree.getRoot();
        for (GoPoint p : board) {
            GoColor c = board.getColor(p);
            if (!c.isBlackWhite()) continue;
            root.addStone(c, p);
        }
        root.setPlayer(board.getToMove());
        return tree;
    }

    public static ConstNode nextNode(ConstNode node) {
        ConstNode child = node.getChildConst();
        if (child != null) {
            return child;
        }
        return NodeUtil.getNextEarlierVariation(node);
    }

    public static ConstNode nextNode(ConstNode node, int depth) {
        if ((node = NodeUtil.nextNode(node)) == null || NodeUtil.getDepth(node) <= depth) {
            return null;
        }
        return node;
    }

    public static String nodeInfo(ConstNode node) {
        ConstSgfProperties sgfProperties;
        ConstGameInfo info;
        ConstPointList empty;
        ConstPointList white;
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("NodeProperties:\n");
        NodeUtil.appendInfo(buffer, "Depth", NodeUtil.getDepth(node));
        NodeUtil.appendInfo(buffer, "Children", node.getNumberChildren());
        if (node.getMove() != null) {
            NodeUtil.appendInfo(buffer, "Move", node.getMove().toString());
            NodeUtil.appendInfo(buffer, "MoveNumber", NodeUtil.getMoveNumber(node));
        }
        NodeUtil.appendInfo(buffer, "Variation", NodeUtil.getVariationString(node));
        ConstPointList black = node.getSetup(GoColor.BLACK);
        if (black.size() > 0) {
            NodeUtil.appendInfo(buffer, "AddBlack", black);
        }
        if ((white = node.getSetup(GoColor.WHITE)).size() > 0) {
            NodeUtil.appendInfo(buffer, "AddWhite", white);
        }
        if ((empty = node.getSetup(GoColor.EMPTY)).size() > 0) {
            NodeUtil.appendInfo(buffer, "AddEmpty", empty);
        }
        if (node.getPlayer() != null) {
            NodeUtil.appendInfo(buffer, "Player", node.getPlayer().toString());
        }
        if (!Double.isNaN(node.getTimeLeft(GoColor.BLACK))) {
            NodeUtil.appendInfo(buffer, "TimeLeftBlack", node.getTimeLeft(GoColor.BLACK));
        }
        if (node.getMovesLeft(GoColor.BLACK) >= 0) {
            NodeUtil.appendInfo(buffer, "MovesLeftBlack", node.getMovesLeft(GoColor.BLACK));
        }
        if (!Double.isNaN(node.getTimeLeft(GoColor.WHITE))) {
            NodeUtil.appendInfo(buffer, "TimeLeftWhite", node.getTimeLeft(GoColor.WHITE));
        }
        if (node.getMovesLeft(GoColor.WHITE) >= 0) {
            NodeUtil.appendInfo(buffer, "MovesLeftWhite", node.getMovesLeft(GoColor.WHITE));
        }
        NodeUtil.appendInfoComment(buffer, node);
        for (MarkType type : EnumSet.allOf(MarkType.class)) {
            ConstPointList marked = node.getMarkedConst(type);
            if (marked == null || marked.size() <= 0) continue;
            NodeUtil.appendInfo(buffer, "Marked " + (Object)((Object)type), marked);
        }
        Map<GoPoint, String> labels = node.getLabelsUnmodifiable();
        if (labels != null && !labels.isEmpty()) {
            StringBuilder labelsBuffer = new StringBuilder();
            boolean isFirst = true;
            for (Map.Entry<GoPoint, String> entry : labels.entrySet()) {
                if (!isFirst) {
                    labelsBuffer.append(' ');
                }
                isFirst = false;
                GoPoint point = entry.getKey();
                String value = entry.getValue();
                labelsBuffer.append(point);
                labelsBuffer.append(':');
                labelsBuffer.append(value);
            }
            NodeUtil.appendInfo(buffer, "Labels", labelsBuffer.toString());
        }
        if (!Float.isNaN(node.getValue())) {
            NodeUtil.appendInfo(buffer, "Value", Float.toString(node.getValue()));
        }
        if ((info = node.getGameInfoConst()) != null) {
            String s;
            buffer.append("GameInfo:\n");
            for (StringInfo stringInfo : EnumSet.allOf(StringInfo.class)) {
                s = info.get(stringInfo);
                if (s == null) continue;
                NodeUtil.appendInfo(buffer, stringInfo.toString(), s);
            }
            for (StringInfoColor stringInfoColor : EnumSet.allOf(StringInfoColor.class)) {
                s = info.get(stringInfoColor, GoColor.BLACK);
                if (s != null) {
                    NodeUtil.appendInfo(buffer, stringInfoColor.toString() + "[B]", s);
                }
                if ((s = info.get(stringInfoColor, GoColor.WHITE)) == null) continue;
                NodeUtil.appendInfo(buffer, stringInfoColor.toString() + "[W]", s);
            }
            if (info.getHandicap() != 0) {
                NodeUtil.appendInfo(buffer, "HANDICAP", info.getHandicap());
            }
            if (info.getKomi() != null) {
                NodeUtil.appendInfo(buffer, "KOMI", info.getKomi().toString());
            }
            if (info.getTimeSettings() != null) {
                NodeUtil.appendInfo(buffer, "TIMESETTINGS", info.getTimeSettings().toString());
            }
        }
        if ((sgfProperties = node.getSgfPropertiesConst()) != null) {
            buffer.append("SgfProperties:\n");
            for (String key : sgfProperties.getKeys()) {
                StringBuilder values = new StringBuilder();
                for (int i = 0; i < sgfProperties.getNumberValues(key); ++i) {
                    values.append('[');
                    values.append(sgfProperties.getValue(key, i));
                    values.append(']');
                }
                NodeUtil.appendInfo(buffer, key, values.toString());
            }
        }
        return buffer.toString();
    }

    public static void restoreClock(ConstNode node, Clock clock) {
        clock.reset();
        ArrayList<ConstNode> path = new ArrayList<ConstNode>();
        NodeUtil.getPathToRoot(node, path);
        for (int i = path.size() - 1; i >= 0; --i) {
            ConstNode pathNode = path.get(i);
            NodeUtil.restoreTimeLeft(pathNode, clock, GoColor.BLACK);
            NodeUtil.restoreTimeLeft(pathNode, clock, GoColor.WHITE);
        }
    }

    public static ConstNode selectRandom(ConstNode root, int minDepth, int maxDepth) {
        ConstNode last = NodeUtil.getLast(root);
        int depth = NodeUtil.getDepth(last);
        if (depth < minDepth) {
            return null;
        }
        if (depth < maxDepth) {
            maxDepth = depth;
        }
        int idx = minDepth + s_random.nextInt(maxDepth - minDepth + 1);
        ConstNode node = last;
        for (int i = depth; i != idx; --i) {
            node = node.getFatherConst();
        }
        return node;
    }

    public static boolean subtreeGreaterThan(ConstNode node, int size) {
        int n = 0;
        int depth = NodeUtil.getDepth(node);
        while (node != null) {
            if (++n > size) {
                return true;
            }
            node = NodeUtil.nextNode(node, depth);
        }
        return false;
    }

    public static int subtreeSize(ConstNode node) {
        int n = 0;
        int depth = NodeUtil.getDepth(node);
        while (node != null) {
            ++n;
            node = NodeUtil.nextNode(node, depth);
        }
        return n;
    }

    public static String treeInfo(ConstNode node) {
        int numberNodes = 0;
        int numberTerminal = 0;
        int moreThanOneChild = 0;
        int maxDepth = 0;
        int maxChildren = 0;
        double averageDepth = 0.0;
        double averageChildren = 0.0;
        double averageChildrenInner = 0.0;
        int rootDepth = NodeUtil.getDepth(node);
        while (node != null) {
            ++numberNodes;
            int numberChildren = node.getNumberChildren();
            int depth = NodeUtil.getDepth(node) - rootDepth;
            assert (depth >= 0);
            if (depth > maxDepth) {
                maxDepth = depth;
            }
            if (numberChildren > maxChildren) {
                maxChildren = numberChildren;
            }
            if (numberChildren == 0) {
                ++numberTerminal;
            } else {
                averageChildrenInner += (double)numberChildren;
            }
            if (numberChildren > 1) {
                ++moreThanOneChild;
            }
            averageDepth += (double)depth;
            averageChildren += (double)numberChildren;
            node = NodeUtil.nextNode(node, rootDepth);
        }
        int numberInner = numberNodes - numberTerminal;
        averageDepth /= (double)numberNodes;
        averageChildren /= (double)numberNodes;
        averageChildrenInner /= (double)Math.max(numberInner, 1);
        NumberFormat format = StringUtil.getNumberFormat(3);
        format.setMinimumFractionDigits(3);
        StringBuilder buffer = new StringBuilder();
        NodeUtil.appendInfo(buffer, "Nodes", numberNodes);
        NodeUtil.appendInfo(buffer, "Terminal", numberTerminal);
        NodeUtil.appendInfo(buffer, "Inner", numberInner);
        NodeUtil.appendInfo(buffer, "AvgDepth", format.format(averageDepth));
        NodeUtil.appendInfo(buffer, "MaxDepth", maxDepth);
        NodeUtil.appendInfo(buffer, "AvgChildren", format.format(averageChildren));
        NodeUtil.appendInfo(buffer, "AvgChildrenInner", format.format(averageChildrenInner));
        NodeUtil.appendInfo(buffer, "MaxChildren", maxChildren);
        NodeUtil.appendInfo(buffer, "MoreThanOneChild", moreThanOneChild);
        return buffer.toString();
    }

    public static void truncateChildren(Node node) {
        Node child;
        while ((child = node.getChild()) != null) {
            node.removeChild(child);
        }
    }

    private NodeUtil() {
    }

    private static void appendInfo(StringBuilder buffer, String label, int value) {
        NodeUtil.appendInfo(buffer, label, Integer.toString(value));
    }

    private static void appendInfo(StringBuilder buffer, String label, double value) {
        NodeUtil.appendInfo(buffer, label, Double.toString(value));
    }

    private static void appendInfo(StringBuilder buffer, String label, ConstPointList points) {
        NodeUtil.appendInfoLabel(buffer, label);
        for (int i = 0; i < points.size(); ++i) {
            if (i % 10 == 9 && i < points.size() - 1) {
                buffer.append('\n');
                NodeUtil.appendInfoLabel(buffer, "");
            }
            buffer.append(points.get(i));
            buffer.append(' ');
        }
        buffer.append('\n');
    }

    private static void appendInfo(StringBuilder buffer, String label, String value) {
        NodeUtil.appendInfoLabel(buffer, label);
        buffer.append(value);
        buffer.append('\n');
    }

    private static void appendInfoComment(StringBuilder buffer, ConstNode node) {
        String comment = NodeUtil.getCommentStart(node, true, 30);
        if (comment != null) {
            NodeUtil.appendInfo(buffer, "Comment", comment);
        }
    }

    private static void appendInfoLabel(StringBuilder buffer, String label) {
        buffer.append(label);
        int numberEmpty = Math.max(0, 20 - label.length());
        for (int i = 0; i < numberEmpty; ++i) {
            buffer.append(' ');
        }
        buffer.append(' ');
    }

    private static void restoreTimeLeft(ConstNode node, Clock clock, GoColor color) {
        double timeLeft = node.getTimeLeft(color);
        int movesLeft = node.getMovesLeft(color);
        if (!Double.isNaN(timeLeft)) {
            clock.setTimeLeft(color, (long)(timeLeft * 1000.0), movesLeft);
        }
    }
}

