/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.twogtp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.gogui.game.GameInfo;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.sgf.SgfError;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.tools.twogtp.Filter;
import net.sf.gogui.util.ErrorMessage;

public class Openings {
    private int m_currentFile;
    private final File m_directory;
    private File[] m_files;
    private GameTree m_tree;

    public Openings(File directory) throws ErrorMessage {
        if (!directory.isDirectory()) {
            throw new ErrorMessage(directory + " is not a directory");
        }
        this.m_directory = directory;
        this.m_files = directory.listFiles(new Filter());
        if (this.m_files.length == 0) {
            throw new ErrorMessage("No SGF files found in " + directory);
        }
        this.sortFiles();
        this.m_currentFile = -1;
    }

    public int getBoardSize() {
        return this.getTree().getBoardSize();
    }

    public String getDirectory() {
        return this.m_directory.toString();
    }

    public String getFilename() {
        return this.m_files[this.m_currentFile].toString();
    }

    public GameInfo getGameInfo() {
        return this.m_tree.getGameInfo(this.m_tree.getRoot());
    }

    public GameTree getTree() {
        return this.m_tree;
    }

    public int getNumber() {
        return this.m_files.length;
    }

    public void loadFile(int i) throws IOException, SgfError {
        File file = this.m_files[i];
        FileInputStream fileStream = new FileInputStream(file);
        SgfReader reader = new SgfReader(fileStream, file, null, 0L);
        this.m_tree = reader.getTree();
        this.m_currentFile = i;
    }

    private void sortFiles() {
        for (int i = 0; i < this.m_files.length - 1; ++i) {
            for (int j = i + 1; j < this.m_files.length; ++j) {
                if (this.m_files[i].compareTo(this.m_files[j]) <= 0) continue;
                File tmp = this.m_files[i];
                this.m_files[i] = this.m_files[j];
                this.m_files[j] = tmp;
            }
        }
    }
}

