/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.twogtp;

import java.util.ArrayList;
import net.sf.gogui.game.ConstGame;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpSynchronizer;
import net.sf.gogui.util.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Program {
    private double m_cpuTime;
    private final String m_defaultName;
    private String m_label;
    private final GtpClient m_gtp;
    private final GtpSynchronizer m_synchronizer;
    private String m_name;
    private String m_version;

    public Program(String command, String defaultName, String logPrefix, boolean verbose) throws GtpError {
        this.m_defaultName = defaultName;
        this.m_gtp = new GtpClient(command, null, verbose, null);
        this.m_gtp.setLogPrefix(logPrefix);
        this.m_synchronizer = new GtpSynchronizer(this.m_gtp);
        this.m_gtp.queryProtocolVersion();
        try {
            this.m_name = this.m_gtp.send("name");
            if (this.m_name.trim().equals("")) {
                this.m_name = defaultName;
            }
        }
        catch (GtpError e) {
            this.m_name = defaultName;
        }
        try {
            this.m_version = this.m_gtp.send("version");
        }
        catch (GtpError e) {
            this.m_version = "";
        }
        this.m_gtp.querySupportedCommands();
        this.m_gtp.queryInterruptSupport();
    }

    public void close() {
        try {
            this.m_gtp.send("quit");
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
        this.m_gtp.close();
        this.m_gtp.waitForExit();
    }

    public double getAndClearCpuTime() {
        double cpuTime;
        try {
            cpuTime = this.m_gtp.isCpuTimeSupported() ? this.m_gtp.getCpuTime() : 0.0;
        }
        catch (GtpError e) {
            cpuTime = 0.0;
        }
        double result = Math.max(0.0, cpuTime - this.m_cpuTime);
        this.m_cpuTime = cpuTime;
        return result;
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getProgramCommand() {
        return this.m_gtp.getProgramCommand();
    }

    public String getResult() {
        try {
            return this.m_gtp.send("final_score");
        }
        catch (GtpError e) {
            return "?";
        }
    }

    public String getVersion() {
        return this.m_version;
    }

    public void interruptProgram() {
        try {
            if (this.m_gtp.isInterruptSupported()) {
                this.m_gtp.sendInterrupt();
            }
        }
        catch (GtpError e) {
            System.err.println(e);
        }
    }

    public boolean isOutOfSync() {
        return this.m_synchronizer.isOutOfSync();
    }

    public boolean isProgramDead() {
        return this.m_gtp.isProgramDead();
    }

    public boolean isSupported(String command) {
        return this.m_gtp.isSupported(command);
    }

    public String send(String command) throws GtpError {
        return this.m_gtp.send(command);
    }

    public String sendCommandGenmove(GoColor color) throws GtpError {
        return this.send(this.m_gtp.getCommandGenmove(color));
    }

    public void sendIfSupported(String cmd, String cmdLine) {
        if (!this.m_gtp.isSupported(cmd)) {
            return;
        }
        try {
            this.m_gtp.send(cmdLine);
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
    }

    public void setIOCallback(GtpClient.IOCallback callback) {
        this.m_gtp.setIOCallback(callback);
    }

    public void setLabel(ArrayList<Program> programs) {
        boolean isUnique = true;
        for (Program program : programs) {
            if (program == this || !program.m_name.equals(this.m_name)) continue;
            isUnique = false;
            break;
        }
        this.m_label = isUnique ? this.m_name : (!this.m_version.trim().equals("") && this.m_version.length() <= 40 ? this.m_name + ":" + this.m_version : this.m_name + "[" + (programs.indexOf(this) + 1) + "]");
    }

    public void setTableProperties(Table table) {
        table.setProperty(this.m_defaultName, this.m_name);
        table.setProperty(this.m_defaultName + "Version", this.m_version);
        table.setProperty(this.m_defaultName + "Label", this.m_label);
        table.setProperty(this.m_defaultName + "Command", this.getProgramCommand());
    }

    public void synchronize(ConstGame game) throws GtpError {
        try {
            ConstNode node = game.getGameInfoNode();
            ConstGameInfo info = game.getGameInfo(node);
            this.m_synchronizer.synchronize(game.getBoard(), info.getKomi(), info.getTimeSettings());
        }
        catch (GtpError e) {
            throw new GtpError(this.m_label + ": " + e.getMessage());
        }
    }

    public void synchronizeInit(ConstGame game) throws GtpError {
        try {
            ConstNode node = game.getGameInfoNode();
            ConstGameInfo info = game.getGameInfo(node);
            this.m_synchronizer.init(game.getBoard(), info.getKomi(), info.getTimeSettings());
        }
        catch (GtpError e) {
            throw new GtpError(this.m_label + ": " + e.getMessage());
        }
    }

    public void updateAfterGenmove(ConstBoard board) {
        this.m_synchronizer.updateAfterGenmove(board);
    }
}

