/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.twogtp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.gogui.game.ConstGame;
import net.sf.gogui.game.Node;
import net.sf.gogui.go.Komi;
import net.sf.gogui.sgf.SgfError;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.sgf.SgfWriter;
import net.sf.gogui.tools.twogtp.Compare;
import net.sf.gogui.tools.twogtp.Openings;
import net.sf.gogui.tools.twogtp.Program;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.Platform;
import net.sf.gogui.util.StringUtil;
import net.sf.gogui.util.Table;
import net.sf.gogui.version.Version;
import net.sf.gogui.xml.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultFile {
    private final boolean m_alternate;
    private final boolean m_useXml;
    private final TreeSet<Integer> m_gameExists = new TreeSet();
    private int m_nextGameIndex;
    private final int m_numberGames;
    private final int m_numberThreads;
    private final String m_filePrefix;
    private final File m_tableFile;
    private final File m_lockFile;
    private FileChannel m_lockFileChannel;
    private final Table m_table;
    private final TreeMap<Integer, ArrayList<Compare.Placement>> m_games = new TreeMap();

    public ResultFile(boolean force, Program black, Program white, Program referee, int numberGames, int size, Komi komi, String filePrefix, Openings openings, boolean alternate, boolean useXml, int numberThreads) throws ErrorMessage {
        this.m_filePrefix = filePrefix;
        this.m_alternate = alternate;
        this.m_numberGames = numberGames;
        this.m_useXml = useXml;
        this.m_numberThreads = numberThreads;
        this.m_lockFile = new File(filePrefix + ".lock");
        this.acquireLock();
        this.m_tableFile = new File(filePrefix + ".dat");
        if (force && this.m_tableFile.exists() && !this.m_tableFile.delete()) {
            throw new ErrorMessage("Could not delete file '" + this.m_tableFile + "'");
        }
        if (this.m_tableFile.exists()) {
            this.m_table = ResultFile.readTable(this.m_tableFile, numberGames, this.m_gameExists);
            this.m_nextGameIndex = 0;
            while (this.m_gameExists.contains(this.m_nextGameIndex)) {
                ++this.m_nextGameIndex;
                if (numberGames <= 0 || this.m_nextGameIndex <= numberGames) continue;
                this.m_nextGameIndex = -1;
                break;
            }
            this.readGames();
        } else {
            this.m_table = this.createTable(black, white, referee, size, komi, openings);
            this.m_nextGameIndex = 0;
        }
    }

    public synchronized void addResult(int gameIndex, ConstGame game, String resultBlack, String resultWhite, String resultReferee, boolean alternated, int numberMoves, boolean error, String errorMessage, double timeBlack, double timeWhite, double cpuTimeBlack, double cpuTimeWhite) throws ErrorMessage {
        ArrayList<Compare.Placement> moves = Compare.getPlacements(game.getTree().getRootConst());
        String duplicate = Compare.checkDuplicate(game.getBoard(), moves, this.m_games, this.m_alternate, alternated);
        NumberFormat format = StringUtil.getNumberFormat(1);
        this.m_table.startRow();
        this.m_table.set("GAME", Integer.toString(gameIndex));
        this.m_table.set("RES_B", resultBlack);
        this.m_table.set("RES_W", resultWhite);
        this.m_table.set("RES_R", resultReferee);
        this.m_table.set("ALT", alternated ? "1" : "0");
        this.m_table.set("DUP", duplicate);
        this.m_table.set("LEN", numberMoves);
        this.m_table.set("TIME_B", format.format(timeBlack));
        this.m_table.set("TIME_W", format.format(timeWhite));
        this.m_table.set("CPU_B", format.format(cpuTimeBlack));
        this.m_table.set("CPU_W", format.format(cpuTimeWhite));
        this.m_table.set("ERR", error ? "1" : "0");
        this.m_table.set("ERR_MSG", errorMessage);
        int rowEnd = this.m_table.getNumberRows();
        int rowBegin = rowEnd - this.m_numberThreads;
        if (rowBegin < 0) {
            rowBegin = 0;
        }
        if (gameIndex < rowBegin) {
            rowBegin = gameIndex;
        }
        this.m_table.sortByIntColumn("GAME", rowBegin, rowEnd);
        File tmpFile = new File(this.m_tableFile.getAbsolutePath() + ".new");
        try {
            this.m_table.save(tmpFile);
            if (Platform.isWindows()) {
                this.m_tableFile.delete();
            }
            tmpFile.renameTo(this.m_tableFile);
        }
        catch (IOException e) {
            throw new ErrorMessage("Could not write to: " + this.m_tableFile);
        }
        File file = this.getFile(gameIndex);
        try {
            FileOutputStream out = new FileOutputStream(file);
            if (this.m_useXml) {
                new XmlWriter(out, game.getTree(), "gogui-twogtp:" + Version.get());
            } else {
                new SgfWriter((OutputStream)out, game.getTree(), "gogui-twogtp", Version.get());
            }
            this.m_games.put(gameIndex, moves);
        }
        catch (FileNotFoundException e) {
            throw new ErrorMessage("Could not save " + file + ": " + e.getMessage());
        }
    }

    public void close() {
        try {
            this.m_lockFileChannel.close();
        }
        catch (IOException e) {
            System.err.println("Could not close '" + this.m_lockFile + "'");
        }
        if (!this.m_lockFile.delete()) {
            System.err.println("Could not delete '" + this.m_lockFile + "'");
        }
    }

    public synchronized int getNextGameIndex() {
        if (this.m_nextGameIndex != -1) {
            while (this.m_gameExists.contains(this.m_nextGameIndex)) {
                ++this.m_nextGameIndex;
                if (this.m_numberGames <= 0 || this.m_nextGameIndex < this.m_numberGames) continue;
                this.m_nextGameIndex = -1;
                break;
            }
        }
        if (this.m_nextGameIndex != -1) {
            this.m_gameExists.add(this.m_nextGameIndex);
        }
        return this.m_nextGameIndex;
    }

    private void acquireLock() throws ErrorMessage {
        try {
            this.m_lockFile.createNewFile();
            this.m_lockFileChannel = new RandomAccessFile(this.m_lockFile, "rw").getChannel();
            FileLock lock = this.m_lockFileChannel.tryLock();
            if (lock == null) {
                throw new ErrorMessage("Could not get lock on file '" + this.m_lockFile + "': already used by another instance of TwoGtp");
            }
        }
        catch (IOException e) {
            throw new ErrorMessage("Could not lock file '" + this.m_lockFile + "': " + e.getMessage());
        }
    }

    private Table createTable(Program black, Program white, Program referee, int size, Komi komi, Openings openings) {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("GAME");
        columns.add("RES_B");
        columns.add("RES_W");
        columns.add("RES_R");
        columns.add("ALT");
        columns.add("DUP");
        columns.add("LEN");
        columns.add("TIME_B");
        columns.add("TIME_W");
        columns.add("CPU_B");
        columns.add("CPU_W");
        columns.add("ERR");
        columns.add("ERR_MSG");
        Table table = new Table(columns);
        black.setTableProperties(table);
        white.setTableProperties(table);
        if (referee == null) {
            table.setProperty("Referee", "-");
        } else {
            referee.setTableProperties(table);
        }
        table.setProperty("Size", Integer.toString(size));
        table.setProperty("Komi", komi.toString());
        if (openings != null) {
            table.setProperty("Openings", openings.getDirectory() + " (" + openings.getNumber() + " files)");
        }
        table.setProperty("Date", StringUtil.getDate());
        table.setProperty("Host", Platform.getHostInfo());
        table.setProperty("Xml", this.m_useXml ? "1" : "0");
        return table;
    }

    private File getFile(int gameIndex) {
        if (this.m_useXml) {
            return new File(this.m_filePrefix + "-" + gameIndex + ".xml");
        }
        return new File(this.m_filePrefix + "-" + gameIndex + ".sgf");
    }

    private void readGames() {
        for (int n = 0; n < this.m_numberGames; ++n) {
            if (!this.m_gameExists.contains(n)) continue;
            File file = this.getFile(n);
            if (!file.exists()) {
                System.err.println("Game " + file + " not found");
                continue;
            }
            if (!file.exists()) {
                return;
            }
            try {
                FileInputStream fileStream = new FileInputStream(file);
                SgfReader reader = new SgfReader(fileStream, file, null, 0L);
                Node root = reader.getTree().getRoot();
                this.m_games.put(n, Compare.getPlacements(root));
                continue;
            }
            catch (SgfError e) {
                System.err.println("Error reading " + file + ": " + e.getMessage());
                continue;
            }
            catch (Exception e) {
                System.err.println("Error reading " + file + ": " + e.getMessage());
            }
        }
    }

    private static Table readTable(File file, int numberGames, TreeSet<Integer> gameExists) throws ErrorMessage {
        Table table = new Table();
        try {
            table.read(file);
            int numberRows = table.getNumberRows();
            if (numberGames > 0 && numberRows >= numberGames) {
                throw new ErrorMessage("File " + file + " already contains " + numberRows + " games");
            }
            for (int i = 0; i < numberRows; ++i) {
                int gameIndex = Integer.parseInt(table.get("GAME", i));
                if (gameIndex < 0) {
                    throw new ErrorMessage("Invalid file format: " + file);
                }
                gameExists.add(gameIndex);
            }
        }
        catch (NumberFormatException e) {
            throw new ErrorMessage("Invalid file format: " + file);
        }
        catch (FileNotFoundException e) {
            throw new ErrorMessage(e.getMessage());
        }
        catch (IOException e) {
            throw new ErrorMessage("Read error: " + file);
        }
        return table;
    }
}

