/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Locale;
import net.sf.gogui.util.ProcessUtil;

public class Platform {
    private static boolean s_isMac;
    private static boolean s_isUnix;
    private static boolean s_isWindows;

    public static String getJavaRuntimeName() {
        String name = System.getProperty("java.runtime.name");
        if (name == null) {
            name = System.getProperty("java.vm.name");
        }
        return name;
    }

    public static String getHostInfo() {
        String info;
        try {
            info = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            info = "?";
        }
        try {
            String[] cmdArray;
            String result;
            int start;
            if (Platform.existsProcCpuinfo() && (start = (result = ProcessUtil.runCommand(cmdArray = new String[]{"/bin/sh", "-c", "grep '^model name' /proc/cpuinfo"})).indexOf(58)) >= 0) {
                info = info + " (";
                int end = result.indexOf("\n");
                info = end >= 0 ? info + result.substring(start + 1, end).trim() : info + result.substring(start + 1).trim();
                info = info + ")";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return info;
    }

    public static boolean isMac() {
        return s_isMac;
    }

    public static boolean isUnix() {
        return s_isUnix;
    }

    public static boolean isWindows() {
        return s_isWindows;
    }

    public static boolean openInExternalBrowser(URL url) {
        if (Platform.isMac()) {
            String[] cmd = new String[]{"/usr/bin/open", url.toString()};
            if (Platform.runProcess(cmd)) {
                return true;
            }
        } else if (Platform.isWindows()) {
            String[] cmd = new String[]{"rundll32", "url.dll,FileProtocolHandler", url.toString()};
            if (Platform.runProcess(cmd)) {
                return true;
            }
        } else if (Platform.isUnix()) {
            String[] cmd = new String[]{"xdg-open", url.toString()};
            if (Platform.runProcess(cmd)) {
                return true;
            }
            if (Platform.checkKDERunning() && Platform.runProcess(cmd = new String[]{"kfmclient", "openURL", url.toString()})) {
                return true;
            }
            cmd = new String[]{"firefox", url.toString()};
            if (Platform.runProcess(cmd)) {
                return true;
            }
            cmd = new String[]{"mozilla", url.toString()};
            if (Platform.runProcess(cmd)) {
                return true;
            }
            cmd = new String[]{"opera", url.toString()};
            if (Platform.runProcess(cmd)) {
                return true;
            }
        }
        return false;
    }

    public static void registerSpecialMacHandler(SpecialMacHandler handler) {
        try {
            Object[] args = new Object[]{handler};
            Class[] arglist = new Class[]{SpecialMacHandler.class};
            String name = "net.sf.gogui.specialmac.RegisterSpecialMacHandler";
            Class<?> registerClass = Class.forName(name);
            Constructor<?> constructor = registerClass.getConstructor(arglist);
            constructor.newInstance(args);
        }
        catch (Throwable e) {
            System.err.println("Could not register handler for Mac events. (com.apple.eawt classes not found)");
        }
    }

    private static boolean checkKDERunning() {
        try {
            String[] cmdArray = new String[]{"dcop"};
            String result = ProcessUtil.runCommand(cmdArray);
            return result.indexOf("kicker") >= 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean existsProcCpuinfo() {
        return new File("/proc/cpuinfo").exists();
    }

    private static boolean runProcess(String[] cmd) {
        try {
            ProcessUtil.runProcess(cmd);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    static {
        String name = System.getProperty("os.name");
        s_isMac = name.toLowerCase(Locale.getDefault()).startsWith("mac os x");
        s_isUnix = name.indexOf("nix") >= 0 || name.indexOf("nux") >= 0;
        s_isWindows = name.startsWith("Windows");
    }

    public static interface SpecialMacHandler {
        public boolean handleAbout();

        public boolean handleOpenFile(String var1);

        public boolean handleQuit();
    }
}

