/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import jchessboard.Move;

class VirtualBoard {
    static final int EMPTY_FIELD = 0;
    static final int EM = 0;
    static final int WHITE_KING = 1;
    static final int WK = 1;
    static final int WHITE_QUEEN = 2;
    static final int WQ = 2;
    static final int WHITE_ROOK = 3;
    static final int WR = 3;
    static final int WHITE_BISHOP = 4;
    static final int WB = 4;
    static final int WHITE_KNIGHT = 5;
    static final int WN = 5;
    static final int WHITE_PAWN = 6;
    static final int WP = 6;
    static final int BLACK_KING = 7;
    static final int BK = 7;
    static final int BLACK_QUEEN = 8;
    static final int BQ = 8;
    static final int BLACK_ROOK = 9;
    static final int BR = 9;
    static final int BLACK_BISHOP = 10;
    static final int BB = 10;
    static final int BLACK_KNIGHT = 11;
    static final int BN = 11;
    static final int BLACK_PAWN = 12;
    static final int BP = 12;
    static final int MAX_FIGURE_VALUE = 12;
    static final int NONE = 0;
    static final int KING = 1;
    static final int QUEEN = 2;
    static final int ROOK = 3;
    static final int BISHOP = 4;
    static final int KNIGHT = 5;
    static final int PAWN = 6;
    private static final int[] startPosition = new int[]{3, 5, 4, 2, 1, 4, 5, 3, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 12, 12, 12, 12, 12, 12, 12, 9, 11, 10, 8, 7, 10, 11, 9};
    String[] name = new String[]{"-", "K", "Q", "R", "B", "N", "P", "k", "q", "r", "b", "n", "p"};
    protected int[] field = new int[64];
    protected boolean whiteKingHasMoved;
    protected boolean blackKingHasMoved;
    protected boolean leftBlackRookHasMoved;
    protected boolean rightBlackRookHasMoved;
    protected boolean leftWhiteRookHasMoved;
    protected boolean rightWhiteRookHasMoved;
    protected boolean isWhiteTurn;
    protected int blackKingPos;
    protected int whiteKingPos;
    protected int lastFrom = 64;
    protected int lastTo = 64;
    protected int pawnPromotion = 0;
    protected boolean pawnHasPromoted = false;
    protected int enPassantTarget = 64;
    protected int halfmoveClock = 0;
    protected int fullmoveNumber = 0;
    private boolean doNotConsiderCheckInTryMove = false;
    private static long[] knightMovesBitboards;
    private static long[] kingMovesBitboards;
    private static long[] rookMovesBitboards;
    private static long[] queenMovesBitboards;
    private static long[] bishopMovesBitboards;
    private static int[][] knightMoves;
    private static int[][] rookMoves;
    private static int[][] queenMoves;
    private static List[] kingMoves;
    private static List[] bishopMoves;
    private static long[][] horMoves;
    private static long[][] vertMoves;
    private static long[][] diag1Moves;
    private static long[][] diag2Moves;
    private long whitePieces;
    private long blackPieces;
    private long whitePiecesRot;
    private long blackPiecesRot;
    private long whitePiecesDiag1;
    private long blackPiecesDiag1;
    private long whitePiecesDiag2;
    private long blackPiecesDiag2;
    private long whiteAttackBoard = 0L;
    private long blackAttackBoard = 0L;
    private static int[] diag1length;
    private static int[] shift;
    private static int[] diag2length;
    private static int[] diag2pos;
    private static int[] diag1Mapping;
    private static int[] diag1ReverseMapping;
    private static int[] diag2Mapping;
    private static int[] diag2ReverseMapping;
    private static int[] diag2shift;
    public int score;

    public static String getVersion() {
        return "$Id: VirtualBoard.java,v 1.34 2004/12/26 23:12:13 cdivossen Exp $";
    }

    public Move getLastMove() {
        if (this.lastFrom == 64 || this.lastTo == 64) {
            return null;
        }
        Move move = new Move(this.lastFrom, this.lastTo);
        if (this.pawnHasPromoted) {
            move.setPawnPromotion(this.pawnPromotion);
        }
        return move;
    }

    public boolean isWhiteTurn() {
        return this.isWhiteTurn;
    }

    public int getWhiteKingPos() {
        return this.whiteKingPos;
    }

    public int getBlackKingPos() {
        return this.blackKingPos;
    }

    public int getFullMoveNumber() {
        return this.fullmoveNumber;
    }

    public int getField(int n, int n2) {
        return this.field[(n << 3) + (n2 & 7)];
    }

    public String toString() {
        String string = "\n";
        for (int i = 7; i >= 0; --i) {
            for (int j = 0; j < 8; ++j) {
                string = string + " " + this.name[this.field[(i << 3) + j]];
            }
            string = string + "\n";
        }
        string = string + "Last move: " + this.getLastMove() + "\n";
        return string;
    }

    public static boolean isWhiteFigure(int n) {
        return n > 0 && n < 7;
    }

    public static boolean isBlackFigure(int n) {
        return n > 6 && n < 13;
    }

    public String getFEN() {
        int n;
        String string = "";
        int n2 = 0;
        for (n = 7; n >= 0; --n) {
            block16: for (int i = 0; i < 8; ++i) {
                if (this.field[(n << 3) + i] != 0 && n2 > 0) {
                    string = string + n2;
                    n2 = 0;
                }
                switch (this.field[(n << 3) + i]) {
                    case 6: {
                        string = string + "P";
                        continue block16;
                    }
                    case 4: {
                        string = string + "B";
                        continue block16;
                    }
                    case 5: {
                        string = string + "N";
                        continue block16;
                    }
                    case 3: {
                        string = string + "R";
                        continue block16;
                    }
                    case 2: {
                        string = string + "Q";
                        continue block16;
                    }
                    case 1: {
                        string = string + "K";
                        continue block16;
                    }
                    case 12: {
                        string = string + "p";
                        continue block16;
                    }
                    case 10: {
                        string = string + "b";
                        continue block16;
                    }
                    case 11: {
                        string = string + "n";
                        continue block16;
                    }
                    case 9: {
                        string = string + "r";
                        continue block16;
                    }
                    case 8: {
                        string = string + "q";
                        continue block16;
                    }
                    case 7: {
                        string = string + "k";
                        continue block16;
                    }
                    case 0: {
                        ++n2;
                    }
                }
            }
            if (n2 > 0) {
                string = string + n2;
            }
            if (n != 0) {
                string = string + "/";
            }
            n2 = 0;
        }
        string = string + " ";
        string = string + (this.isWhiteTurn ? "w" : "b");
        string = string + " ";
        n = 0;
        if (!this.whiteKingHasMoved && !this.rightWhiteRookHasMoved) {
            string = string + "K";
            n = 1;
        }
        if (!this.whiteKingHasMoved && !this.leftWhiteRookHasMoved) {
            string = string + "Q";
            n = 1;
        }
        if (!this.blackKingHasMoved && !this.rightBlackRookHasMoved) {
            string = string + "k";
            n = 1;
        }
        if (!this.blackKingHasMoved && !this.leftBlackRookHasMoved) {
            string = string + "q";
            n = 1;
        }
        if (n == 0) {
            string = string + "-";
        }
        string = string + " ";
        string = this.enPassantTarget < 64 ? string + (char)(97 + (this.enPassantTarget & 7)) + "" + ((this.enPassantTarget >> 3) + 1) : string + "-";
        string = string + " ";
        string = string + this.halfmoveClock;
        string = string + " ";
        string = string + (this.isWhiteTurn ? this.fullmoveNumber + 1 : this.fullmoveNumber);
        return string;
    }

    public boolean initFromFEN(String string) {
        int n;
        int n2;
        int n3 = 7;
        int n4 = 0;
        this.init();
        for (int i = 0; i < 64; ++i) {
            this.field[i] = 0;
        }
        this.whiteKingPos = 64;
        this.blackKingPos = 64;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        block17: for (n2 = 0; n2 < string2.length() && string2.charAt(n2) != ' '; ++n2) {
            n = string2.charAt(n2);
            switch (n) {
                case 80: {
                    this.field[(n3 << 3) + n4] = 6;
                    ++n4;
                    continue block17;
                }
                case 66: {
                    this.field[(n3 << 3) + n4] = 4;
                    ++n4;
                    continue block17;
                }
                case 78: {
                    this.field[(n3 << 3) + n4] = 5;
                    ++n4;
                    continue block17;
                }
                case 82: {
                    this.field[(n3 << 3) + n4] = 3;
                    ++n4;
                    continue block17;
                }
                case 81: {
                    this.field[(n3 << 3) + n4] = 2;
                    ++n4;
                    continue block17;
                }
                case 75: {
                    this.field[(n3 << 3) + n4] = 1;
                    this.whiteKingPos = (n3 << 3) + n4;
                    ++n4;
                    continue block17;
                }
                case 112: {
                    this.field[(n3 << 3) + n4] = 12;
                    ++n4;
                    continue block17;
                }
                case 98: {
                    this.field[(n3 << 3) + n4] = 10;
                    ++n4;
                    continue block17;
                }
                case 110: {
                    this.field[(n3 << 3) + n4] = 11;
                    ++n4;
                    continue block17;
                }
                case 114: {
                    this.field[(n3 << 3) + n4] = 9;
                    ++n4;
                    continue block17;
                }
                case 113: {
                    this.field[(n3 << 3) + n4] = 8;
                    ++n4;
                    continue block17;
                }
                case 107: {
                    this.field[(n3 << 3) + n4] = 7;
                    this.blackKingPos = (n3 << 3) + n4;
                    ++n4;
                    continue block17;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: {
                    n4 += n - 48;
                    continue block17;
                }
                case 47: {
                    --n3;
                    n4 = 0;
                    continue block17;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.whiteKingPos == 64 || this.blackKingPos == 64) {
            return false;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        if (string2.equals("w")) {
            this.isWhiteTurn = true;
        } else if (string2.equals("b")) {
            this.isWhiteTurn = false;
        } else {
            return false;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        this.whiteKingHasMoved = true;
        this.rightWhiteRookHasMoved = true;
        this.leftWhiteRookHasMoved = true;
        this.blackKingHasMoved = true;
        this.rightBlackRookHasMoved = true;
        this.leftBlackRookHasMoved = true;
        n2 = 0;
        if (n2 < string2.length() && string2.charAt(n2) == 'K') {
            this.whiteKingHasMoved = false;
            this.rightWhiteRookHasMoved = false;
            ++n2;
        }
        if (n2 < string2.length() && string2.charAt(n2) == 'Q') {
            this.whiteKingHasMoved = false;
            this.leftWhiteRookHasMoved = false;
            ++n2;
        }
        if (n2 < string2.length() && string2.charAt(n2) == 'k') {
            this.blackKingHasMoved = false;
            this.rightBlackRookHasMoved = false;
            ++n2;
        }
        if (n2 < string2.length() && string2.charAt(n2) == 'q') {
            this.blackKingHasMoved = false;
            this.leftBlackRookHasMoved = false;
            ++n2;
        }
        if (n2 == 0 && !string2.equals("-")) {
            return false;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        if (string2.equals("-")) {
            this.enPassantTarget = 64;
        } else if (string2.length() == 2) {
            this.enPassantTarget = string2.charAt(0) - 97 + (string2.charAt(1) - 49 << 3);
        } else {
            return false;
        }
        if (this.enPassantTarget > 64 || this.enPassantTarget < 0) {
            return false;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        this.halfmoveClock = Integer.parseInt(string2);
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        this.fullmoveNumber = Integer.parseInt(string2);
        if (this.isWhiteTurn) {
            --this.fullmoveNumber;
        }
        if (stringTokenizer.hasMoreTokens()) {
            return false;
        }
        this.whitePieces = 0L;
        this.blackPieces = 0L;
        this.whitePiecesRot = 0L;
        this.blackPiecesRot = 0L;
        this.whitePiecesDiag1 = 0L;
        this.blackPiecesDiag1 = 0L;
        this.whitePiecesDiag2 = 0L;
        this.blackPiecesDiag2 = 0L;
        for (n = 0; n < 64; ++n) {
            if (VirtualBoard.isWhiteFigure(this.field[n])) {
                this.whitePieces |= 1L << n;
                this.whitePiecesRot |= 1L << ((n & 7) << 3) + (n >> 3);
                this.whitePiecesDiag1 |= 1L << diag1ReverseMapping[n];
                this.whitePiecesDiag2 |= 1L << diag2ReverseMapping[n];
            }
            if (!VirtualBoard.isBlackFigure(this.field[n])) continue;
            this.blackPieces |= 1L << n;
            this.blackPiecesRot |= 1L << ((n & 7) << 3) + (n >> 3);
            this.blackPiecesDiag1 |= 1L << diag1ReverseMapping[n];
            this.blackPiecesDiag2 |= 1L << diag2ReverseMapping[n];
        }
        return true;
    }

    private String algebraicDraft(Move move) {
        boolean bl = false;
        String string = (char)(97 + move.toFile()) + "" + (move.toRank() + 1);
        String string2 = "";
        String string3 = "";
        if (this.field[move.fromField()] == 1 || this.field[move.fromField()] == 7) {
            if (move.fromFile() == 4 && move.toFile() == 2) {
                return "O-O-O";
            }
            if (move.fromFile() == 4 && move.toFile() == 6) {
                return "O-O";
            }
        }
        if (this.field[move.fromField()] == 6 && move.toRank() == 7 || this.field[move.fromField()] == 12 && move.toRank() == 0) {
            string3 = "=Q";
            if (move.pawnPromotion() == 3) {
                string3 = "=R";
            } else if (move.pawnPromotion() == 4) {
                string3 = "=B";
            } else if (move.pawnPromotion() == 5) {
                string3 = "=N";
            }
        }
        if (this.field[move.toField()] != 0 || (this.field[move.fromField()] == 6 || this.field[move.fromField()] == 12) && move.toField() == this.enPassantTarget) {
            bl = true;
        }
        if (this.field[move.fromField()] == 3 || this.field[move.fromField()] == 9) {
            string2 = "R";
        } else if (this.field[move.fromField()] == 4 || this.field[move.fromField()] == 10) {
            string2 = "B";
        } else if (this.field[move.fromField()] == 5 || this.field[move.fromField()] == 11) {
            string2 = "N";
        } else if (this.field[move.fromField()] == 2 || this.field[move.fromField()] == 8) {
            string2 = "Q";
        } else if (this.field[move.fromField()] == 1 || this.field[move.fromField()] == 7) {
            string2 = "K";
        }
        if (bl && (this.field[move.fromField()] == 6 || this.field[move.fromField()] == 12)) {
            string2 = (char)(97 + (move.fromField() & 7)) + "";
        }
        return string2 + (bl ? "x" : "") + string + string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getAllAlgebraicDrafts() {
        Iterator iterator;
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Object object = this;
        synchronized (object) {
            iterator = this.getAllMoves().iterator();
        }
        while (iterator.hasNext()) {
            object = (Move)iterator.next();
            hashtable.put(object, this.algebraicDraft((Move)object));
        }
        return hashtable;
    }

    public String algebraic(Move move) {
        return this.algebraic(move, true);
    }

    public String algebraic(Move move, boolean bl) {
        if (!this.isPossibleMove(move)) {
            return null;
        }
        Hashtable hashtable = this.getAllAlgebraicDrafts();
        Move move2 = null;
        String string = this.algebraicDraft(move);
        Enumeration enumeration = hashtable.keys();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        while (enumeration.hasMoreElements()) {
            move2 = (Move)enumeration.nextElement();
            if (!string.equals((String)hashtable.get(move2)) || move.equals(move2)) continue;
            bl4 = true;
            if (move.fromFile() == move2.fromFile()) {
                bl3 = true;
            }
            if (move.fromRank() != move2.fromRank()) continue;
            bl2 = true;
        }
        if (bl4) {
            String string2;
            boolean bl5 = false;
            boolean bl6 = false;
            if (bl2 && bl3) {
                bl5 = true;
                bl6 = true;
            } else if (bl3) {
                bl5 = true;
            } else {
                bl6 = true;
            }
            if (bl5) {
                string = string2 = string.charAt(0) + "" + (move.fromRank() + 1) + string.substring(1, string.length());
            }
            if (bl6) {
                string = string2 = string.charAt(0) + "" + (char)(97 + move.fromFile()) + "" + string.substring(1, string.length());
            }
        }
        if (bl) {
            VirtualBoard virtualBoard = this.clonedBoard();
            try {
                virtualBoard.makeMove(move);
            }
            catch (ImpossibleMoveException impossibleMoveException) {
                // empty catch block
            }
            if (virtualBoard.isWhiteTurn && virtualBoard.isAttackedByBlack(virtualBoard.whiteKingPos) || !virtualBoard.isWhiteTurn && virtualBoard.isAttackedByWhite(virtualBoard.blackKingPos)) {
                string = virtualBoard.gameIsFinished() ? string + "#" : string + "+";
            }
        }
        return string;
    }

    public void makeMove(String string) throws ImpossibleMoveException {
        String string2;
        String string3 = string.endsWith("+") || string.endsWith("#") ? string.substring(0, string.length() - 1) : string;
        if (this.isWhiteTurn) {
            if (string3.equals("O-O")) {
                this.makeMove(new Move(4, 6));
                return;
            }
            if (string3.equals("O-O-O")) {
                this.makeMove(new Move(4, 2));
                return;
            }
        } else {
            if (string3.equals("O-O")) {
                this.makeMove(new Move(60, 62));
                return;
            }
            if (string3.equals("O-O-O")) {
                this.makeMove(new Move(60, 58));
                return;
            }
        }
        this.pawnPromotion = 0;
        if (string3.length() < 2) {
            throw new ImpossibleMoveException(string);
        }
        char c = string3.charAt(string3.length() - 1);
        if (c == 'Q' || c == 'R' || c == 'B' || c == 'N') {
            if (c == 'Q') {
                this.pawnPromotion = 2;
            } else if (c == 'R') {
                this.pawnPromotion = 3;
            } else if (c == 'B') {
                this.pawnPromotion = 4;
            } else if (c == 'N') {
                this.pawnPromotion = 5;
            }
            string2 = string3.charAt(string3.length() - 2) == '=' ? string3.substring(0, string3.length() - 2) : string3.substring(0, string3.length() - 1);
        } else {
            string2 = string3;
        }
        int n = string2.charAt(string2.length() - 2) - 97 + (Character.getNumericValue(string2.charAt(string2.length() - 1)) - 1 << 3);
        char c2 = string2.charAt(0);
        int n2 = c2 == 'N' ? 5 : (c2 == 'B' ? 4 : (c2 == 'R' ? 3 : (c2 == 'Q' ? 2 : (c2 == 'K' ? 1 : 6))));
        if (!this.isWhiteTurn) {
            n2 += 6;
        }
        boolean bl = string2.indexOf(120) != -1;
        int n3 = -1;
        int n4 = -1;
        if (n2 == 6 || n2 == 12) {
            if (string2.length() > 2) {
                n3 = string2.charAt(0) - 97;
            }
        } else {
            if (string2.length() > 3 + (bl ? 1 : 0) && ((n3 = string2.charAt(1) - 97) < 0 || n3 > 7)) {
                n3 = -1;
                n4 = Character.getNumericValue(string2.charAt(1)) - 1;
            }
            if (string2.length() > 4 + (bl ? 1 : 0)) {
                n4 = Character.getNumericValue(string2.charAt(2)) - 1;
            }
        }
        if (n4 == -1 && n3 == -1) {
            for (int i = 0; i < 64; ++i) {
                if (this.field[i] != n2 || !this.isPossibleMove(i, n)) continue;
                this.move(i, n);
                return;
            }
        } else if (n4 == -1) {
            if (n3 < 0 || n3 > 7) {
                throw new ImpossibleMoveException(string);
            }
            for (int i = n3; i < 64; i += 8) {
                if (this.field[i] != n2 || !this.isPossibleMove(i, n)) continue;
                this.move(i, n);
                return;
            }
        } else if (n3 == -1) {
            for (int i = n4 * 8; i < n4 * 8 + 8; ++i) {
                if (this.field[i] != n2 || !this.isPossibleMove(i, n)) continue;
                this.move(i, n);
                return;
            }
        } else {
            int n5 = (n4 << 3) + n3;
            if (this.field[n5] == n2 && this.isPossibleMove(n5, n)) {
                this.move(n5, n);
                return;
            }
        }
        throw new ImpossibleMoveException(string);
    }

    public void inithorMoves() {
        int n;
        int n2;
        int n3;
        horMoves = new long[64][256];
        int[][] nArray = new int[8][256];
        for (n3 = 0; n3 < 8; ++n3) {
            block1: for (n2 = 0; n2 < 256; ++n2) {
                for (n = n3 + 1; n < 8; ++n) {
                    int[] nArray2 = nArray[n3];
                    int n4 = n2;
                    nArray2[n4] = nArray2[n4] | 1 << n;
                    if ((n2 & 1 << n) != 0) break;
                }
                for (n = n3 - 1; n >= 0; --n) {
                    int[] nArray3 = nArray[n3];
                    int n5 = n2;
                    nArray3[n5] = nArray3[n5] | 1 << n;
                    if ((n2 & 1 << n) != 0) continue block1;
                }
            }
        }
        for (n3 = 0; n3 < 8; ++n3) {
            for (n2 = 0; n2 < 8; ++n2) {
                for (n = 0; n < 256; ++n) {
                    VirtualBoard.horMoves[(n3 << 3) + n2][n] = (long)nArray[n2][n] << n3 * 8;
                }
            }
        }
    }

    public void initVertMoves() {
        int n;
        int n2;
        int n3;
        vertMoves = new long[64][256];
        long[][] lArray = new long[8][256];
        for (n3 = 0; n3 < 8; ++n3) {
            block1: for (n2 = 0; n2 < 256; ++n2) {
                for (n = n3 + 1; n < 8; ++n) {
                    long[] lArray2 = lArray[n3];
                    int n4 = n2;
                    lArray2[n4] = lArray2[n4] | 1L << n * 8;
                    if ((n2 & 1 << n) != 0) break;
                }
                for (n = n3 - 1; n >= 0; --n) {
                    long[] lArray3 = lArray[n3];
                    int n5 = n2;
                    lArray3[n5] = lArray3[n5] | 1L << n * 8;
                    if ((n2 & 1 << n) != 0) continue block1;
                }
            }
        }
        for (n3 = 0; n3 < 8; ++n3) {
            for (n2 = 0; n2 < 8; ++n2) {
                for (n = 0; n < 256; ++n) {
                    VirtualBoard.vertMoves[(n3 << 3) + n2][n] = lArray[n3][n] << n2;
                }
            }
        }
    }

    public void initDiag1Moves() {
        diag1Moves = new long[64][256];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = i + j <= 7 ? i + j + 1 : 7 - i + (7 - j) + 1;
                int n2 = shift[(i << 3) + j];
                block2: for (int k = 0; k < 1 << n; ++k) {
                    int n3;
                    for (n3 = (i + j <= 7 ? i : 7 - j) + 1; n3 < n; ++n3) {
                        long[] lArray = diag1Moves[(i << 3) + j];
                        int n4 = k;
                        lArray[n4] = lArray[n4] | 1L << diag1Mapping[n2 + n3];
                        if ((k & 1 << n3) != 0) break;
                    }
                    for (n3 = (i + j <= 7 ? i : 7 - j) - 1; n3 >= 0; --n3) {
                        long[] lArray = diag1Moves[(i << 3) + j];
                        int n5 = k;
                        lArray[n5] = lArray[n5] | 1L << diag1Mapping[n2 + n3];
                        if ((k & 1 << n3) != 0) continue block2;
                    }
                }
            }
        }
    }

    public void initDiag2Moves() {
        diag2Moves = new long[64][256];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = diag2length[(i << 3) + j];
                int n2 = diag2shift[(i << 3) + j];
                block2: for (int k = 0; k < 1 << n; ++k) {
                    int n3;
                    for (n3 = diag2pos[(i << 3) + j] + 1; n3 < n; ++n3) {
                        long[] lArray = diag2Moves[(i << 3) + j];
                        int n4 = k;
                        lArray[n4] = lArray[n4] | 1L << diag2Mapping[n2 + n3];
                        if ((k & 1 << n3) != 0) break;
                    }
                    for (n3 = diag2pos[(i << 3) + j] - 1; n3 >= 0; --n3) {
                        long[] lArray = diag2Moves[(i << 3) + j];
                        int n5 = k;
                        lArray[n5] = lArray[n5] | 1L << diag2Mapping[n2 + n3];
                        if ((k & 1 << n3) != 0) continue block2;
                    }
                }
            }
        }
    }

    public VirtualBoard() {
        if (knightMoves == null) {
            int n;
            this.initKnightMoves();
            this.initKingMoves();
            this.initRookMoves();
            this.initBishopMoves();
            this.initQueenMoves();
            this.inithorMoves();
            this.initVertMoves();
            this.initDiag1Moves();
            diag1ReverseMapping = new int[64];
            for (n = 0; n < 64; ++n) {
                VirtualBoard.diag1ReverseMapping[VirtualBoard.diag1Mapping[n]] = n;
            }
            this.initDiag2Moves();
            diag2ReverseMapping = new int[64];
            for (n = 0; n < 64; ++n) {
                VirtualBoard.diag2ReverseMapping[VirtualBoard.diag2Mapping[n]] = n;
            }
        }
    }

    public List getAllMoves() {
        Vector<Move> vector = new Vector<Move>();
        for (int i = 0; i < 64; ++i) {
            if ((!this.isWhiteTurn || !VirtualBoard.isWhiteFigure(this.field[i])) && (this.isWhiteTurn || !VirtualBoard.isBlackFigure(this.field[i]))) continue;
            long l = 0L;
            if (this.field[i] == 6) {
                if (i >> 3 == 6) {
                    if (this.isPossibleMove(i, i + 8)) {
                        vector.add(new Move(i, i + 8, 2));
                        vector.add(new Move(i, i + 8, 3));
                        vector.add(new Move(i, i + 8, 4));
                        vector.add(new Move(i, i + 8, 5));
                    }
                    if (this.isPossibleMove(i, i + 7)) {
                        vector.add(new Move(i, i + 7, 2));
                        vector.add(new Move(i, i + 7, 3));
                        vector.add(new Move(i, i + 7, 4));
                        vector.add(new Move(i, i + 7, 5));
                    }
                    if (!this.isPossibleMove(i, i + 9)) continue;
                    vector.add(new Move(i, i + 9, 2));
                    vector.add(new Move(i, i + 9, 3));
                    vector.add(new Move(i, i + 9, 4));
                    vector.add(new Move(i, i + 9, 5));
                    continue;
                }
                if (i >> 3 == 1 && this.isPossibleMove(i, i + 16)) {
                    vector.add(new Move(i, i + 16));
                }
                if (this.isPossibleMove(i, i + 8)) {
                    vector.add(new Move(i, i + 8));
                }
                if (this.isPossibleMove(i, i + 7)) {
                    vector.add(new Move(i, i + 7));
                }
                if (!this.isPossibleMove(i, i + 9)) continue;
                vector.add(new Move(i, i + 9));
                continue;
            }
            if (this.field[i] == 12) {
                if (i >> 3 == 1) {
                    if (this.isPossibleMove(i, i - 8)) {
                        vector.add(new Move(i, i - 8, 2));
                        vector.add(new Move(i, i - 8, 3));
                        vector.add(new Move(i, i - 8, 4));
                        vector.add(new Move(i, i - 8, 5));
                    }
                    if (this.isPossibleMove(i, i - 7)) {
                        vector.add(new Move(i, i - 7, 2));
                        vector.add(new Move(i, i - 7, 3));
                        vector.add(new Move(i, i - 7, 4));
                        vector.add(new Move(i, i - 7, 5));
                    }
                    if (!this.isPossibleMove(i, i - 9)) continue;
                    vector.add(new Move(i, i - 9, 2));
                    vector.add(new Move(i, i - 9, 3));
                    vector.add(new Move(i, i - 9, 4));
                    vector.add(new Move(i, i - 9, 5));
                    continue;
                }
                if (i >> 3 == 6 && this.isPossibleMove(i, i - 16)) {
                    vector.add(new Move(i, i - 16));
                }
                if (this.isPossibleMove(i, i - 8)) {
                    vector.add(new Move(i, i - 8));
                }
                if (this.isPossibleMove(i, i - 7)) {
                    vector.add(new Move(i, i - 7));
                }
                if (!this.isPossibleMove(i, i - 9)) continue;
                vector.add(new Move(i, i - 9));
                continue;
            }
            if (this.field[i] == 5 || this.field[i] == 11) {
                vector.addAll(this.getPossibleKnightMoves(i));
                continue;
            }
            if (this.field[i] == 1 || this.field[i] == 7) {
                vector.addAll(this.getPossibleKingMoves(i));
                continue;
            }
            if (this.field[i] == 4 || this.field[i] == 10) {
                vector.addAll(this.getPossibleBishopMoves(i));
                continue;
            }
            if (this.field[i] == 3 || this.field[i] == 9) {
                List list = this.getPossibleRookMoves(i);
                if (list == null) continue;
                vector.addAll(list);
                continue;
            }
            if (this.field[i] != 2 && this.field[i] != 8) continue;
            vector.addAll(this.getPossibleQueenMoves(i));
        }
        return vector;
    }

    public List simpleGetAllMoves() {
        Vector<Move> vector = new Vector<Move>();
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                if (!this.isPossibleMove(i, j)) continue;
                vector.add(new Move(i, j));
            }
        }
        return vector;
    }

    public List getPossibleKnightMoves(int n) {
        Vector<Move> vector = new Vector<Move>();
        for (int i = 0; i < knightMoves[n].length; ++i) {
            Move move = new Move(n, knightMoves[n][i]);
            if (!this.isPossibleMove(move)) continue;
            vector.add(move);
        }
        return vector;
    }

    public List getPossibleKingMoves(int n) {
        Vector<Move> vector = new Vector<Move>();
        for (int i = 0; i < kingMoves[n].size(); ++i) {
            Move move = (Move)kingMoves[n].get(i);
            if (!this.isPossibleMove(move)) continue;
            vector.add(move);
        }
        return vector;
    }

    public List getPossibleRookMoves(int n) {
        Vector<Move> vector = null;
        for (int i = 0; i < rookMoves[n].length; ++i) {
            int n2 = rookMoves[n][i];
            if (!this.isPossibleMove(n, n2)) continue;
            if (vector == null) {
                vector = new Vector<Move>();
            }
            vector.add(new Move(n, n2));
        }
        return vector;
    }

    public List getPossibleQueenMoves(int n) {
        Vector<Move> vector = new Vector<Move>();
        for (int i = 0; i < queenMoves[n].length; ++i) {
            Move move = new Move(n, queenMoves[n][i]);
            if (!this.isPossibleMove(move)) continue;
            vector.add(move);
        }
        return vector;
    }

    public List getPossibleBishopMoves(int n) {
        Vector<Move> vector = new Vector<Move>();
        for (int i = 0; i < bishopMoves[n].size(); ++i) {
            Move move = (Move)bishopMoves[n].get(i);
            if (!this.isPossibleMove(move)) continue;
            vector.add(move);
        }
        return vector;
    }

    public int abs(int n) {
        return n < 0 ? -n : n;
    }

    public void clear() {
        for (int i = 0; i < 64; ++i) {
            this.field[i] = 0;
        }
        this.isWhiteTurn = true;
        this.whiteKingHasMoved = false;
        this.blackKingHasMoved = false;
        this.leftBlackRookHasMoved = false;
        this.rightBlackRookHasMoved = false;
        this.leftWhiteRookHasMoved = false;
        this.rightWhiteRookHasMoved = false;
        this.lastFrom = 64;
        this.lastTo = 64;
        this.enPassantTarget = 64;
        this.halfmoveClock = 0;
        this.fullmoveNumber = 0;
        this.whitePieces = 0L;
        this.whitePiecesRot = 0L;
        this.whitePiecesDiag1 = 0L;
        this.whitePiecesDiag2 = 0L;
        this.blackPieces = 0L;
        this.blackPiecesRot = 0L;
        this.blackPiecesDiag1 = 0L;
        this.blackPiecesDiag2 = 0L;
    }

    public void init() {
        int n;
        this.clear();
        for (n = 0; n < 64; ++n) {
            this.field[n] = startPosition[n];
        }
        this.blackKingPos = 60;
        this.whiteKingPos = 4;
        for (n = 0; n < 64; ++n) {
            if (VirtualBoard.isWhiteFigure(this.field[n])) {
                this.whitePieces |= 1L << n;
                this.whitePiecesRot |= 1L << ((n & 7) << 3) + (n >> 3);
                this.whitePiecesDiag1 |= 1L << diag1ReverseMapping[n];
                this.whitePiecesDiag2 |= 1L << diag2ReverseMapping[n];
            }
            if (!VirtualBoard.isBlackFigure(this.field[n])) continue;
            this.blackPieces |= 1L << n;
            this.blackPiecesRot |= 1L << ((n & 7) << 3) + (n >> 3);
            this.blackPiecesDiag1 |= 1L << diag1ReverseMapping[n];
            this.blackPiecesDiag2 |= 1L << diag2ReverseMapping[n];
        }
    }

    public VirtualBoard clonedBoard() {
        VirtualBoard virtualBoard = new VirtualBoard();
        System.arraycopy(this.field, 0, virtualBoard.field, 0, 64);
        virtualBoard.isWhiteTurn = this.isWhiteTurn;
        virtualBoard.whiteKingHasMoved = this.whiteKingHasMoved;
        virtualBoard.blackKingHasMoved = this.blackKingHasMoved;
        virtualBoard.leftBlackRookHasMoved = this.leftBlackRookHasMoved;
        virtualBoard.rightBlackRookHasMoved = this.rightBlackRookHasMoved;
        virtualBoard.leftWhiteRookHasMoved = this.leftWhiteRookHasMoved;
        virtualBoard.rightWhiteRookHasMoved = this.rightWhiteRookHasMoved;
        virtualBoard.lastFrom = this.lastFrom;
        virtualBoard.lastTo = this.lastTo;
        virtualBoard.enPassantTarget = this.enPassantTarget;
        virtualBoard.blackKingPos = this.blackKingPos;
        virtualBoard.whiteKingPos = this.whiteKingPos;
        virtualBoard.pawnPromotion = this.pawnPromotion;
        virtualBoard.pawnHasPromoted = this.pawnHasPromoted;
        virtualBoard.fullmoveNumber = this.fullmoveNumber;
        virtualBoard.halfmoveClock = this.halfmoveClock;
        virtualBoard.whitePieces = this.whitePieces;
        virtualBoard.blackPieces = this.blackPieces;
        virtualBoard.whitePiecesRot = this.whitePiecesRot;
        virtualBoard.blackPiecesRot = this.blackPiecesRot;
        virtualBoard.whitePiecesDiag1 = this.whitePiecesDiag1;
        virtualBoard.blackPiecesDiag1 = this.blackPiecesDiag1;
        virtualBoard.whitePiecesDiag2 = this.whitePiecesDiag2;
        virtualBoard.blackPiecesDiag2 = this.blackPiecesDiag2;
        virtualBoard.whiteAttackBoard = this.whiteAttackBoard;
        virtualBoard.blackAttackBoard = this.blackAttackBoard;
        return virtualBoard;
    }

    public boolean equals(VirtualBoard virtualBoard) {
        for (int i = 0; i < 64; ++i) {
            if (this.field[i] == virtualBoard.field[i]) continue;
            return false;
        }
        return this.isWhiteTurn == virtualBoard.isWhiteTurn && this.whiteKingHasMoved == virtualBoard.whiteKingHasMoved && this.blackKingHasMoved == virtualBoard.blackKingHasMoved && this.leftBlackRookHasMoved == virtualBoard.leftBlackRookHasMoved && this.rightBlackRookHasMoved == virtualBoard.rightBlackRookHasMoved && this.leftWhiteRookHasMoved == virtualBoard.leftWhiteRookHasMoved && this.rightWhiteRookHasMoved == virtualBoard.rightWhiteRookHasMoved && this.lastFrom == virtualBoard.lastFrom && this.lastTo == virtualBoard.lastTo && this.enPassantTarget == virtualBoard.enPassantTarget && this.blackKingPos == virtualBoard.blackKingPos && this.whiteKingPos == virtualBoard.whiteKingPos && this.pawnPromotion == virtualBoard.pawnPromotion && this.pawnHasPromoted == virtualBoard.pawnHasPromoted && this.fullmoveNumber == virtualBoard.fullmoveNumber && this.halfmoveClock == virtualBoard.halfmoveClock;
    }

    public boolean isEqualPosition(VirtualBoard virtualBoard) {
        if (this.whitePieces != virtualBoard.whitePieces || this.blackPieces != virtualBoard.blackPieces) {
            return false;
        }
        for (int i = 0; i < 64; ++i) {
            if (this.field[i] == virtualBoard.field[i]) continue;
            return false;
        }
        return true;
    }

    public void makeMove(Move move) throws ImpossibleMoveException {
        this.pawnPromotion = move.pawnPromotion();
        if (!this.isPossibleMove(move)) {
            throw new ImpossibleMoveException(move + "");
        }
        this.move(move.fromField(), move.toField());
    }

    public void makeAnyMove(Move move) {
        this.pawnPromotion = move.pawnPromotion();
        this.move(move.fromField(), move.toField());
    }

    public boolean isAttackedByWhite(int n) {
        if (this.whiteAttackBoard != 0L) {
            return (this.whiteAttackBoard & 1L << n) != 0L;
        }
        long l = 1L << n;
        block8: for (int i = 0; i < 64; ++i) {
            if (this.field[i] == 0) continue;
            switch (this.field[i]) {
                case 6: {
                    if (!this.WPmightAttack(i >> 3, i & 7, n >> 3, n & 7)) continue block8;
                    return true;
                }
                case 1: {
                    if ((kingMovesBitboards[i] & l) == 0L) continue block8;
                    return true;
                }
                case 5: {
                    if ((knightMovesBitboards[i] & l) == 0L) continue block8;
                    return true;
                }
                case 2: {
                    if (!this.WQmightMove(i >> 3, i & 7, n >> 3, n & 7)) continue block8;
                    return true;
                }
                case 3: {
                    if (!this.WRmightMove(i >> 3, i & 7, n >> 3, n & 7)) continue block8;
                    return true;
                }
                case 4: {
                    if (!this.WBmightMove(i >> 3, i & 7, n >> 3, n & 7)) continue block8;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAttackedByBlack(int n) {
        if (this.whiteAttackBoard != 0L) {
            return (this.whiteAttackBoard & 1L << n) != 0L;
        }
        long l = 1L << n;
        block8: for (int i = 0; i < 64; ++i) {
            if (i == n || this.field[i] == 0) continue;
            switch (this.field[i]) {
                case 12: {
                    if (!this.BPmightAttack(i >> 3, i & 7, n >> 3, n & 7)) continue block8;
                    return true;
                }
                case 7: {
                    if ((kingMovesBitboards[i] & l) == 0L) continue block8;
                    return true;
                }
                case 11: {
                    if ((knightMovesBitboards[i] & l) == 0L) continue block8;
                    return true;
                }
                case 8: {
                    if (!this.BQmightMove(i >> 3, i & 7, n >> 3, n & 7)) continue block8;
                    return true;
                }
                case 9: {
                    if (!this.BRmightMove(i >> 3, i & 7, n >> 3, n & 7)) continue block8;
                    return true;
                }
                case 10: {
                    if (!this.BBmightMove(i >> 3, i & 7, n >> 3, n & 7)) continue block8;
                    return true;
                }
            }
        }
        return false;
    }

    public long getWhiteAttackBoard() {
        if (this.whiteAttackBoard != 0L) {
            return this.whiteAttackBoard;
        }
        long l = 0L;
        block8: for (int i = 0; i < 64; ++i) {
            if (this.field[i] == 0) continue;
            switch (this.field[i]) {
                case 6: {
                    int n = i >> 3;
                    int n2 = i & 7;
                    if (n2 < 7 && n < 7) {
                        l |= 1L << (n + 1) * 8 + n2 + 1;
                    }
                    if (n2 <= 0 || n >= 7) continue block8;
                    l |= 1L << (n + 1) * 8 + n2 - 1;
                    continue block8;
                }
                case 1: {
                    l |= kingMovesBitboards[i];
                    continue block8;
                }
                case 5: {
                    l |= knightMovesBitboards[i];
                    continue block8;
                }
                case 2: {
                    int n = (int)((this.whitePieces | this.blackPieces) >> (i & 0x38)) & 0xFF;
                    l |= horMoves[i][n];
                    int n3 = (int)((this.whitePiecesRot | this.blackPiecesRot) >> (i & 7) * 8) & 0xFF;
                    l |= vertMoves[i][n3];
                    int n4 = (int)((this.whitePiecesDiag1 | this.blackPiecesDiag1) >> shift[i]) & (1 << diag1length[i]) - 1;
                    l |= diag1Moves[i][n4];
                    int n5 = (int)((this.whitePiecesDiag2 | this.blackPiecesDiag2) >> diag2shift[i]) & (1 << diag2length[i]) - 1;
                    l |= diag2Moves[i][n5];
                    continue block8;
                }
                case 3: {
                    int n = (int)((this.whitePieces | this.blackPieces) >> (i & 0x38)) & 0xFF;
                    l |= horMoves[i][n];
                    int n3 = (int)((this.whitePiecesRot | this.blackPiecesRot) >> (i & 7) * 8) & 0xFF;
                    l |= vertMoves[i][n3];
                    continue block8;
                }
                case 4: {
                    int n4 = (int)((this.whitePiecesDiag1 | this.blackPiecesDiag1) >> shift[i]) & (1 << diag1length[i]) - 1;
                    l |= diag1Moves[i][n4];
                    int n5 = (int)((this.whitePiecesDiag2 | this.blackPiecesDiag2) >> diag2shift[i]) & (1 << diag2length[i]) - 1;
                    l |= diag2Moves[i][n5];
                }
            }
        }
        this.whiteAttackBoard = l & (this.whitePieces ^ 0xFFFFFFFFFFFFFFFFL);
        return this.whiteAttackBoard;
    }

    public long getBlackAttackBoard() {
        if (this.blackAttackBoard != 0L) {
            return this.blackAttackBoard;
        }
        long l = 0L;
        block8: for (int i = 0; i < 64; ++i) {
            if (this.field[i] == 0) continue;
            switch (this.field[i]) {
                case 12: {
                    int n = i >> 3;
                    int n2 = i & 7;
                    if (n2 < 7 && n > 0) {
                        l |= 1L << (n - 1) * 8 + n2 + 1;
                    }
                    if (n2 <= 0 || n <= 0) continue block8;
                    l |= 1L << (n - 1) * 8 + n2 - 1;
                    continue block8;
                }
                case 7: {
                    l |= kingMovesBitboards[i];
                    continue block8;
                }
                case 11: {
                    l |= knightMovesBitboards[i];
                    continue block8;
                }
                case 8: {
                    int n = (int)((this.whitePieces | this.blackPieces) >> (i & 0x38)) & 0xFF;
                    l |= horMoves[i][n];
                    int n3 = (int)((this.whitePiecesRot | this.blackPiecesRot) >> (i & 7) * 8) & 0xFF;
                    l |= vertMoves[i][n3];
                    int n4 = (int)((this.whitePiecesDiag1 | this.blackPiecesDiag1) >> shift[i]) & (1 << diag1length[i]) - 1;
                    l |= diag1Moves[i][n4];
                    int n5 = (int)((this.whitePiecesDiag2 | this.blackPiecesDiag2) >> diag2shift[i]) & (1 << diag2length[i]) - 1;
                    l |= diag2Moves[i][n5];
                    continue block8;
                }
                case 9: {
                    int n = (int)((this.whitePieces | this.blackPieces) >> (i & 0x38)) & 0xFF;
                    l |= horMoves[i][n];
                    int n3 = (int)((this.whitePiecesRot | this.blackPiecesRot) >> (i & 7) * 8) & 0xFF;
                    l |= vertMoves[i][n3];
                    continue block8;
                }
                case 10: {
                    int n4 = (int)((this.whitePiecesDiag1 | this.blackPiecesDiag1) >> shift[i]) & (1 << diag1length[i]) - 1;
                    l |= diag1Moves[i][n4];
                    int n5 = (int)((this.whitePiecesDiag2 | this.blackPiecesDiag2) >> diag2shift[i]) & (1 << diag2length[i]) - 1;
                    l |= diag2Moves[i][n5];
                }
            }
        }
        this.blackAttackBoard = l & (this.blackPieces ^ 0xFFFFFFFFFFFFFFFFL);
        return this.blackAttackBoard;
    }

    public boolean isPossibleMove(Move move) {
        return this.isPossibleMove(move.fromField(), move.toField());
    }

    public boolean isPossibleMove(int n, int n2) {
        if (this.field[n] != 0 && this.isWhiteTurn == VirtualBoard.isWhiteFigure(this.field[n]) && this.mightBePossibleMove(n, n2)) {
            if (this.doNotConsiderCheckInTryMove) {
                return true;
            }
            VirtualBoard virtualBoard = this.clonedBoard();
            virtualBoard.move(n, n2);
            if (this.isWhiteTurn ? virtualBoard.whiteKingPos < 64 && virtualBoard.whiteKingPos >= 0 && !virtualBoard.isAttackedByBlack(virtualBoard.whiteKingPos) : virtualBoard.blackKingPos < 64 && virtualBoard.blackKingPos >= 0 && !virtualBoard.isAttackedByWhite(virtualBoard.blackKingPos)) {
                return true;
            }
        }
        return false;
    }

    public VirtualBoard tryMove(int n, int n2) {
        if (this.field[n] != 0 && this.isWhiteTurn == VirtualBoard.isWhiteFigure(this.field[n]) && this.mightBePossibleMove(n, n2)) {
            VirtualBoard virtualBoard = this.clonedBoard();
            virtualBoard.move(n, n2);
            if (this.doNotConsiderCheckInTryMove) {
                return virtualBoard;
            }
            if (this.isWhiteTurn ? virtualBoard.whiteKingPos < 64 && virtualBoard.whiteKingPos >= 0 && !virtualBoard.isAttackedByBlack(virtualBoard.whiteKingPos) : virtualBoard.blackKingPos < 64 && virtualBoard.blackKingPos >= 0 && !virtualBoard.isAttackedByWhite(virtualBoard.blackKingPos)) {
                return virtualBoard;
            }
        }
        return null;
    }

    public boolean onlyKingsLeft() {
        for (int i = 0; i < 64; ++i) {
            if (this.field[i] == 0 || this.field[i] == 1 || this.field[i] == 7) continue;
            return false;
        }
        return true;
    }

    public boolean gameIsFinished() {
        if (this.onlyKingsLeft()) {
            return true;
        }
        for (int i = 0; i < 64; ++i) {
            if (this.field[i] <= 0 || this.isWhiteTurn != this.field[i] < 7) continue;
            for (int j = 0; j < 64; ++j) {
                if (!this.isPossibleMove(new Move(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    private void move(int n, int n2) {
        int n3 = n & 7;
        int n4 = n >> 3;
        int n5 = n2 & 7;
        int n6 = n2 >> 3;
        this.pawnHasPromoted = false;
        boolean bl = false;
        if (this.isWhiteTurn) {
            ++this.fullmoveNumber;
        }
        if (n3 == 4) {
            if (this.field[n] == 1 && n3 == 4 && n5 == 2) {
                this.move(0, 3);
                boolean bl2 = this.isWhiteTurn = !this.isWhiteTurn;
                if (this.isWhiteTurn) {
                    --this.fullmoveNumber;
                }
            } else if (this.field[n] == 1 && n3 == 4 && n5 == 6) {
                this.move(7, 5);
                boolean bl3 = this.isWhiteTurn = !this.isWhiteTurn;
                if (this.isWhiteTurn) {
                    --this.fullmoveNumber;
                }
            } else if (this.field[n] == 7 && n3 == 4 && n5 == 2) {
                this.move(56, 59);
                boolean bl4 = this.isWhiteTurn = !this.isWhiteTurn;
                if (this.isWhiteTurn) {
                    --this.fullmoveNumber;
                }
            } else if (this.field[n] == 7 && n3 == 4 && n5 == 6) {
                this.move(63, 61);
                boolean bl5 = this.isWhiteTurn = !this.isWhiteTurn;
                if (this.isWhiteTurn) {
                    --this.fullmoveNumber;
                }
            }
        }
        if (this.field[n2] == 0 && this.field[n] == 6 && n3 != n5) {
            this.field[32 + n5] = 0;
            bl = true;
        } else if (this.field[n2] == 0 && this.field[n] == 12 && n3 != n5) {
            this.field[24 + n5] = 0;
            bl = true;
        }
        if (this.field[n2] == 1) {
            this.whiteKingPos = 64;
        } else if (this.field[n2] == 7) {
            this.blackKingPos = 64;
        }
        if (this.field[n] == 3 && n == 0) {
            this.leftWhiteRookHasMoved = true;
        } else if (this.field[n] == 3 && n == 7) {
            this.rightWhiteRookHasMoved = true;
        } else if (this.field[n] == 9 && n == 56) {
            this.leftBlackRookHasMoved = true;
        } else if (this.field[n] == 9 && n == 63) {
            this.rightBlackRookHasMoved = true;
        } else if (this.field[n] == 1) {
            this.whiteKingHasMoved = true;
            this.whiteKingPos = n2;
        } else if (this.field[n] == 7) {
            this.blackKingHasMoved = true;
            this.blackKingPos = n2;
        }
        if (n2 == 0) {
            this.leftWhiteRookHasMoved = true;
        } else if (n2 == 7) {
            this.rightWhiteRookHasMoved = true;
        } else if (n2 == 56) {
            this.leftBlackRookHasMoved = true;
        } else if (n2 == 63) {
            this.rightBlackRookHasMoved = true;
        }
        if (this.field[n2] != 0) {
            bl = true;
        }
        this.halfmoveClock = this.field[n] == 6 || this.field[n] == 12 || bl ? 0 : ++this.halfmoveClock;
        this.enPassantTarget = this.field[n] == 6 && n4 == 1 && n6 == 3 ? 16 + n3 : (this.field[n] == 12 && n4 == 6 && n6 == 4 ? 40 + n3 : 64);
        this.whitePieces &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
        this.blackPieces &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
        this.blackPiecesRot &= 1L << (n3 << 3) + n4 ^ 0xFFFFFFFFFFFFFFFFL;
        this.whitePiecesRot &= 1L << (n3 << 3) + n4 ^ 0xFFFFFFFFFFFFFFFFL;
        this.whitePiecesDiag1 &= 1L << diag1ReverseMapping[n] ^ 0xFFFFFFFFFFFFFFFFL;
        this.blackPiecesDiag1 &= 1L << diag1ReverseMapping[n] ^ 0xFFFFFFFFFFFFFFFFL;
        this.whitePiecesDiag2 &= 1L << diag2ReverseMapping[n] ^ 0xFFFFFFFFFFFFFFFFL;
        this.blackPiecesDiag2 &= 1L << diag2ReverseMapping[n] ^ 0xFFFFFFFFFFFFFFFFL;
        if (VirtualBoard.isWhiteFigure(this.field[n])) {
            this.whitePieces |= 1L << n2;
            this.whitePiecesRot |= 1L << (n5 << 3) + n6;
            this.whitePiecesDiag1 |= 1L << diag1ReverseMapping[n2];
            this.whitePiecesDiag2 |= 1L << diag2ReverseMapping[n2];
        }
        if (VirtualBoard.isBlackFigure(this.field[n])) {
            this.blackPieces |= 1L << n2;
            this.blackPiecesRot |= 1L << (n5 << 3) + n6;
            this.blackPiecesDiag1 |= 1L << diag1ReverseMapping[n2];
            this.blackPiecesDiag2 |= 1L << diag2ReverseMapping[n2];
        }
        this.whiteAttackBoard = 0L;
        this.blackAttackBoard = 0L;
        this.field[n2] = this.field[n];
        this.field[n] = 0;
        this.lastFrom = n;
        this.lastTo = n2;
        boolean bl6 = this.isWhiteTurn = !this.isWhiteTurn;
        if (this.field[n2] == 6 && n6 == 7) {
            if (this.pawnPromotion == 0) {
                this.pawnPromotion = 2;
                this.field[n2] = 2;
            } else if (this.pawnPromotion == 2) {
                this.field[n2] = 2;
            } else if (this.pawnPromotion == 3) {
                this.field[n2] = 3;
            } else if (this.pawnPromotion == 4) {
                this.field[n2] = 4;
            } else if (this.pawnPromotion == 5) {
                this.field[n2] = 5;
            }
            this.pawnHasPromoted = true;
        } else if (this.field[n2] == 12 && n6 == 0) {
            if (this.pawnPromotion == 0) {
                this.pawnPromotion = 2;
                this.field[n2] = 8;
            } else if (this.pawnPromotion == 2) {
                this.field[n2] = 8;
            } else if (this.pawnPromotion == 3) {
                this.field[n2] = 9;
            } else if (this.pawnPromotion == 4) {
                this.field[n2] = 10;
            } else if (this.pawnPromotion == 5) {
                this.field[n2] = 11;
            }
            this.pawnHasPromoted = true;
        }
    }

    public boolean mightBePossibleMove(int n, int n2) {
        return this.mightBePossibleMove(n >> 3, n & 7, n2 >> 3, n2 & 7);
    }

    private void initKnightMoves() {
        knightMoves = new int[64][];
        knightMovesBitboards = new long[64];
        for (int i = 0; i < 64; ++i) {
            int n;
            int n2 = 0;
            int[] nArray = new int[64];
            for (n = 0; n < 64; ++n) {
                if (i == n || !this.WNmightMove(i >> 3, i & 7, n >> 3, n & 7)) continue;
                nArray[n2++] = n;
                int n3 = i;
                knightMovesBitboards[n3] = knightMovesBitboards[n3] | 1L << n;
            }
            VirtualBoard.knightMoves[i] = new int[n2];
            for (n = 0; n < n2; ++n) {
                VirtualBoard.knightMoves[i][n] = nArray[n];
            }
        }
    }

    private void initKingMoves() {
        kingMoves = new List[64];
        kingMovesBitboards = new long[64];
        for (int i = 0; i < 64; ++i) {
            VirtualBoard.kingMoves[i] = new Vector();
            for (int j = 0; j < 64; ++j) {
                if (i == j || !this.WKmightMove(i >> 3, i & 7, j >> 3, j & 7)) continue;
                kingMoves[i].add(new Move(i, j));
                int n = i;
                kingMovesBitboards[n] = kingMovesBitboards[n] | 1L << j;
            }
        }
    }

    private void initRookMoves() {
        rookMoves = new int[64][];
        rookMovesBitboards = new long[64];
        for (int i = 0; i < 64; ++i) {
            int n;
            int n2 = 0;
            int[] nArray = new int[64];
            for (n = 0; n < 64; ++n) {
                if (i == n || !this.WRmightMove(i >> 3, i & 7, n >> 3, n & 7)) continue;
                nArray[n2++] = n;
                int n3 = i;
                rookMovesBitboards[n3] = rookMovesBitboards[n3] | 1L << n;
            }
            VirtualBoard.rookMoves[i] = new int[n2];
            for (n = 0; n < n2; ++n) {
                VirtualBoard.rookMoves[i][n] = nArray[n];
            }
        }
    }

    private void initQueenMoves() {
        queenMoves = new int[64][];
        queenMovesBitboards = new long[64];
        for (int i = 0; i < 64; ++i) {
            int n;
            int n2 = 0;
            int[] nArray = new int[64];
            for (n = 0; n < 64; ++n) {
                if (i == n || !this.WQmightMove(i >> 3, i & 7, n >> 3, n & 7)) continue;
                nArray[n2++] = n;
                int n3 = i;
                queenMovesBitboards[n3] = queenMovesBitboards[n3] | 1L << n;
            }
            VirtualBoard.queenMoves[i] = new int[n2 - 1];
            for (n = 0; n < n2 - 1; ++n) {
                VirtualBoard.queenMoves[i][n] = nArray[n];
            }
        }
    }

    private void initBishopMoves() {
        bishopMoves = new List[64];
        bishopMovesBitboards = new long[64];
        for (int i = 0; i < 64; ++i) {
            VirtualBoard.bishopMoves[i] = new Vector();
            for (int j = 0; j < 64; ++j) {
                if (i != j && this.WBmightMove(i >> 3, i & 7, j >> 3, j & 7)) {
                    bishopMoves[i].add(new Move(i, j));
                }
                int n = i;
                bishopMovesBitboards[n] = bishopMovesBitboards[n] | 1L << j;
            }
        }
    }

    public boolean mightBePossibleMove(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n > 7 || n2 > 7 || n3 < 0 || n4 < 0 || n3 > 7 || n4 > 7) {
            return false;
        }
        int n5 = this.getField(n, n2);
        if (n5 == 0 || n == n3 && n2 == n4) {
            return false;
        }
        int n6 = this.getField(n3, n4);
        if (VirtualBoard.isWhiteFigure(n5) && VirtualBoard.isWhiteFigure(n6)) {
            return false;
        }
        if (VirtualBoard.isBlackFigure(n5) && VirtualBoard.isBlackFigure(n6)) {
            return false;
        }
        switch (n5) {
            case 1: {
                return this.WKmightMove(n, n2, n3, n4);
            }
            case 2: {
                return this.WQmightMove(n, n2, n3, n4);
            }
            case 3: {
                return this.WRmightMove(n, n2, n3, n4);
            }
            case 4: {
                return this.WBmightMove(n, n2, n3, n4);
            }
            case 5: {
                return this.WNmightMove(n, n2, n3, n4);
            }
            case 6: {
                return this.WPmightMove(n, n2, n3, n4);
            }
            case 7: {
                return this.BKmightMove(n, n2, n3, n4);
            }
            case 8: {
                return this.BQmightMove(n, n2, n3, n4);
            }
            case 9: {
                return this.BRmightMove(n, n2, n3, n4);
            }
            case 10: {
                return this.BBmightMove(n, n2, n3, n4);
            }
            case 11: {
                return this.BNmightMove(n, n2, n3, n4);
            }
            case 12: {
                return this.BPmightMove(n, n2, n3, n4);
            }
        }
        return false;
    }

    private boolean BNmightMove(int n, int n2, int n3, int n4) {
        return n2 != n4 && n != n3 && this.abs(n2 - n4) + this.abs(n - n3) == 3;
    }

    public boolean BQmightMove(int n, int n2, int n3, int n4) {
        return this.checkLineOfSight(n, n2, n3, n4);
    }

    private boolean BBmightMove(int n, int n2, int n3, int n4) {
        return this.abs(n3 - n) == this.abs(n4 - n2) && this.checkLineOfSight(n, n2, n3, n4);
    }

    private boolean BRmightMove(int n, int n2, int n3, int n4) {
        return (n3 == n || n4 == n2) && this.checkLineOfSight(n, n2, n3, n4);
    }

    private boolean BPmightMove(int n, int n2, int n3, int n4) {
        return n3 == n - 1 && n4 == n2 && this.getField(n3, n4) == 0 || n3 == n - 1 && this.abs(n4 - n2) == 1 && (VirtualBoard.isWhiteFigure(this.getField(n3, n4)) || (n3 << 3) + n4 == this.enPassantTarget) || n == 6 && n3 == 4 && n4 == n2 && this.getField(4, n4) == 0 && this.getField(5, n4) == 0;
    }

    public boolean BPmightAttack(int n, int n2, int n3, int n4) {
        return n3 == n - 1 && this.abs(n4 - n2) == 1;
    }

    public boolean BKmightAttack(int n, int n2, int n3, int n4) {
        return this.abs(n3 - n) <= 1 && this.abs(n4 - n2) <= 1;
    }

    private boolean BKmightMove(int n, int n2, int n3, int n4) {
        return this.abs(n3 - n) <= 1 && this.abs(n4 - n2) <= 1 || n == 7 && n2 == 4 && n3 == 7 && n4 == 2 && this.BKcouldCastleQueenSide() || n == 7 && n2 == 4 && n3 == 7 && n4 == 6 && this.BKcouldCastleKingSide();
    }

    private boolean BKcouldCastleQueenSide() {
        return !this.blackKingHasMoved && !this.leftBlackRookHasMoved && this.checkLineOfSight(7, 0, 7, 4) && !this.isAttackedByWhite(60) && !this.isAttackedByWhite(59);
    }

    private boolean BKcouldCastleKingSide() {
        return !this.blackKingHasMoved && !this.rightBlackRookHasMoved && this.checkLineOfSight(7, 7, 7, 4) && !this.isAttackedByWhite(60) && !this.isAttackedByWhite(61);
    }

    private boolean WNmightMove(int n, int n2, int n3, int n4) {
        return n2 != n4 && n != n3 && this.abs(n2 - n4) + this.abs(n - n3) == 3;
    }

    public boolean WQmightMove(int n, int n2, int n3, int n4) {
        return this.checkLineOfSight(n, n2, n3, n4);
    }

    private boolean WBmightMove(int n, int n2, int n3, int n4) {
        return this.abs(n3 - n) == this.abs(n4 - n2) && this.checkLineOfSight(n, n2, n3, n4);
    }

    private boolean WRmightMove(int n, int n2, int n3, int n4) {
        return (n3 == n || n4 == n2) && this.checkLineOfSight(n, n2, n3, n4);
    }

    public boolean WKmightAttack(int n, int n2, int n3, int n4) {
        return this.abs(n3 - n) <= 1 && this.abs(n4 - n2) <= 1;
    }

    private boolean WKmightMove(int n, int n2, int n3, int n4) {
        return this.abs(n3 - n) <= 1 && this.abs(n4 - n2) <= 1 || n == 0 && n2 == 4 && n3 == 0 && n4 == 2 && this.WKcouldCastleQueenSide() || n == 0 && n2 == 4 && n3 == 0 && n4 == 6 && this.WKcouldCastleKingSide();
    }

    public boolean WKcouldCastleQueenSide() {
        return !this.whiteKingHasMoved && !this.leftWhiteRookHasMoved && this.checkLineOfSight(0, 0, 0, 4);
    }

    public boolean WKcouldCastleKingSide() {
        return !this.whiteKingHasMoved && !this.rightWhiteRookHasMoved && this.checkLineOfSight(0, 7, 0, 4);
    }

    public boolean WPmightMove(int n, int n2, int n3, int n4) {
        return n3 == n + 1 && n4 == n2 && this.getField(n3, n4) == 0 || n3 == n + 1 && this.abs(n4 - n2) == 1 && (VirtualBoard.isBlackFigure(this.getField(n3, n4)) || (n3 << 3) + n4 == this.enPassantTarget) || n == 1 && n3 == 3 && n4 == n2 && this.getField(3, n4) == 0 && this.getField(2, n4) == 0;
    }

    public boolean WPmightAttack(int n, int n2, int n3, int n4) {
        return n3 == n + 1 && this.abs(n4 - n2) == 1;
    }

    public String getResult() {
        if (this.gameIsFinished()) {
            if (this.onlyKingsLeft()) {
                return "1/2-1/2";
            }
            if (this.isWhiteTurn()) {
                if (this.isAttackedByBlack(this.getWhiteKingPos())) {
                    return "0-1";
                }
                return "1/2-1/2";
            }
            if (this.isAttackedByWhite(this.getBlackKingPos())) {
                return "1-0";
            }
            return "1/2-1/2";
        }
        return "*";
    }

    private boolean checkLineOfSight(int n, int n2, int n3, int n4) {
        int n5;
        if (n != n3 && n2 != n4 && this.abs(n3 - n) != this.abs(n4 - n2)) {
            return false;
        }
        int n6 = n3 >= n ? (n3 > n ? 1 : 0) : (n5 = -1);
        int n7 = n4 >= n2 ? (n4 > n2 ? 1 : 0) : -1;
        int n8 = n + n5;
        for (int i = n2 + n7; n8 != n3 || i != n4; n8 += n5, i += n7) {
            if (this.field[(n8 << 3) + i] == 0) continue;
            return false;
        }
        return true;
    }

    private static String binaryPresentation(long l) {
        String string = "";
        for (int i = 7; i >= 0; --i) {
            for (int j = 0; j < 8; ++j) {
                string = (l & 1L << (i << 3) + j) != 0L ? string + "1 " : string + "0 ";
            }
            string = string + "\n";
        }
        return string;
    }

    private static String binaryPresentation(byte by) {
        String string = "";
        for (int i = 7; i >= 0; --i) {
            string = ((long)by & 1L << i) != 0L ? string + "1" : string + "0";
        }
        return string;
    }

    static {
        diag1length = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 2, 3, 4, 5, 6, 7, 8, 7, 3, 4, 5, 6, 7, 8, 7, 6, 4, 5, 6, 7, 8, 7, 6, 5, 5, 6, 7, 8, 7, 6, 5, 4, 6, 7, 8, 7, 6, 5, 4, 3, 7, 8, 7, 6, 5, 4, 3, 2, 8, 7, 6, 5, 4, 3, 2, 1};
        shift = new int[]{0, 1, 3, 6, 10, 15, 21, 28, 1, 3, 6, 10, 15, 21, 28, 36, 3, 6, 10, 15, 21, 28, 36, 43, 6, 10, 15, 21, 28, 36, 43, 49, 10, 15, 21, 28, 36, 43, 49, 54, 15, 21, 28, 36, 43, 49, 54, 58, 21, 28, 36, 43, 49, 54, 58, 61, 28, 36, 43, 49, 54, 58, 61, 63};
        diag2length = new int[]{8, 7, 6, 5, 4, 3, 2, 1, 7, 8, 7, 6, 5, 4, 3, 2, 6, 7, 8, 7, 6, 5, 4, 3, 5, 6, 7, 8, 7, 6, 5, 4, 4, 5, 6, 7, 8, 7, 6, 5, 3, 4, 5, 6, 7, 8, 7, 6, 2, 3, 4, 5, 6, 7, 8, 7, 1, 2, 3, 4, 5, 6, 7, 8};
        diag2pos = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 2, 2, 2, 2, 2, 2, 0, 1, 2, 3, 3, 3, 3, 3, 0, 1, 2, 3, 4, 4, 4, 4, 0, 1, 2, 3, 4, 5, 5, 5, 0, 1, 2, 3, 4, 5, 6, 6, 0, 1, 2, 3, 4, 5, 6, 7};
        diag1Mapping = new int[]{0, 1, 8, 2, 9, 16, 3, 10, 17, 24, 4, 11, 18, 25, 32, 5, 12, 19, 26, 33, 40, 6, 13, 20, 27, 34, 41, 48, 7, 14, 21, 28, 35, 42, 49, 56, 15, 22, 29, 36, 43, 50, 57, 23, 30, 37, 44, 51, 58, 31, 38, 45, 52, 59, 39, 46, 53, 60, 47, 54, 61, 55, 62, 63};
        diag2Mapping = new int[]{56, 48, 57, 40, 49, 58, 32, 41, 50, 59, 24, 33, 42, 51, 60, 16, 25, 34, 43, 52, 61, 8, 17, 26, 35, 44, 53, 62, 0, 9, 18, 27, 36, 45, 54, 63, 1, 10, 19, 28, 37, 46, 55, 2, 11, 20, 29, 38, 47, 3, 12, 21, 30, 39, 4, 13, 22, 31, 5, 14, 23, 6, 15, 7};
        diag2shift = new int[]{28, 36, 43, 49, 54, 58, 61, 63, 21, 28, 36, 43, 49, 54, 58, 61, 15, 21, 28, 36, 43, 49, 54, 58, 10, 15, 21, 28, 36, 43, 49, 54, 6, 10, 15, 21, 28, 36, 43, 49, 3, 6, 10, 15, 21, 28, 36, 43, 1, 3, 6, 10, 15, 21, 28, 36, 0, 1, 3, 6, 10, 15, 21, 28};
    }

    static class ImpossibleMoveException
    extends Exception {
        public ImpossibleMoveException(String string) {
            super(string);
        }
    }
}

