/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import com.sun.java.util.collections.Iterator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import megamek.client.BoardNewDialog;
import megamek.client.BoardView1;
import megamek.client.ExitsDialog;
import megamek.common.Board;
import megamek.common.BoardEvent;
import megamek.common.BoardListener;
import megamek.common.Coords;
import megamek.common.Hex;
import megamek.common.Terrain;

public class BoardEditor
extends Container
implements BoardListener,
ItemListener,
ActionListener,
TextListener,
KeyListener {
    private Frame frame;
    private Board board;
    private BoardView1 bv;
    private Hex curHex = new Hex();
    private String curpath;
    private String curfile;
    private boolean ctrlheld;
    private boolean altheld;
    private HexCanvas canHex;
    private Label labElev;
    private TextField texElev;
    private Button butElevUp;
    private Button butElevDown;
    private Label labTerrain;
    private List lisTerrain;
    private Button butDelTerrain;
    private Panel panTerrainType;
    private Choice choTerrainType;
    private TextField texTerrainLevel;
    private Panel panTerrExits;
    private Checkbox cheTerrExitSpecified;
    private TextField texTerrExits;
    private Button butTerrExits;
    private Button butAddTerrain;
    private Label blankL;
    private Label labBoard;
    private Panel panButtons;
    private Button butBoardNew;
    private Button butBoardLoad;
    private Button butBoardSave;
    private Button butBoardSaveAs;

    public BoardEditor(Frame frame, Board board, BoardView1 boardView1) {
        this.frame = frame;
        this.board = board;
        this.bv = boardView1;
        board.newData(0, 0, new Hex[0]);
        frame.setTitle("MegaMek Editor : Unnamed");
        this.addKeyListener(this);
        this.canHex = new HexCanvas();
        this.labElev = new Label("Elev:", 2);
        this.texElev = new TextField("0", 1);
        this.texElev.addActionListener(this);
        this.texElev.addTextListener(this);
        this.butElevUp = new Button("U");
        this.butElevUp.addActionListener(this);
        this.butElevDown = new Button("D");
        this.butElevDown.addActionListener(this);
        this.labTerrain = new Label("Terrain:", 0);
        this.lisTerrain = new List(6);
        this.lisTerrain.addItemListener(this);
        this.refreshTerrainList();
        this.butDelTerrain = new Button("Remove Terrain");
        this.butDelTerrain.addActionListener(this);
        this.choTerrainType = new Choice();
        int n = 1;
        while (n < Terrain.SIZE) {
            this.choTerrainType.add(Terrain.getName(n));
            ++n;
        }
        this.texTerrainLevel = new TextField("0", 1);
        this.butAddTerrain = new Button("Add/Set Terrain");
        this.butAddTerrain.addActionListener(this);
        this.panTerrainType = new Panel(new BorderLayout());
        this.panTerrainType.add((Component)this.choTerrainType, "West");
        this.panTerrainType.add((Component)this.texTerrainLevel, "Center");
        this.cheTerrExitSpecified = new Checkbox("Set Exits : ");
        this.butTerrExits = new Button("A");
        this.texTerrExits = new TextField("0", 1);
        this.butTerrExits.addActionListener(this);
        this.panTerrExits = new Panel(new FlowLayout());
        this.panTerrExits.add(this.cheTerrExitSpecified);
        this.panTerrExits.add(this.butTerrExits);
        this.panTerrExits.add(this.texTerrExits);
        this.labBoard = new Label("Board:", 0);
        this.butBoardNew = new Button("New...");
        this.butBoardNew.addActionListener(this);
        this.butBoardLoad = new Button("Load...");
        this.butBoardLoad.addActionListener(this);
        this.butBoardSave = new Button("Save");
        this.butBoardSave.addActionListener(this);
        this.butBoardSaveAs = new Button("Save As...");
        this.butBoardSaveAs.addActionListener(this);
        this.panButtons = new Panel(new GridLayout(2, 2, 2, 2));
        this.panButtons.add(this.butBoardNew);
        this.panButtons.add(this.butBoardLoad);
        this.panButtons.add(this.butBoardSave);
        this.panButtons.add(this.butBoardSaveAs);
        this.blankL = new Label("", 1);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 1, 1);
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.canHex, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.addBag(this.labElev, gridBagLayout, gridBagConstraints);
        this.addBag(this.butElevUp, gridBagLayout, gridBagConstraints);
        this.addBag(this.butElevDown, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.texElev, gridBagLayout, gridBagConstraints);
        this.addBag(this.labTerrain, gridBagLayout, gridBagConstraints);
        this.addBag(this.lisTerrain, gridBagLayout, gridBagConstraints);
        this.addBag(this.butDelTerrain, gridBagLayout, gridBagConstraints);
        this.addBag(this.panTerrainType, gridBagLayout, gridBagConstraints);
        this.addBag(this.panTerrExits, gridBagLayout, gridBagConstraints);
        this.addBag(this.butAddTerrain, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addBag(this.blankL, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.labBoard, gridBagLayout, gridBagConstraints);
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    public void paintHex(Coords coords) {
        this.board.setHex(coords, (Hex)this.curHex.clone());
    }

    public void setCurrentHex(Hex hex) {
        this.curHex = (Hex)hex.clone();
        this.texElev.setText(Integer.toString(this.curHex.getElevation()));
        this.refreshTerrainList();
        if (this.lisTerrain.getItemCount() > 0) {
            this.lisTerrain.select(0);
            this.refreshTerrainFromList();
        }
        this.repaint();
        this.canHex.repaint();
    }

    public void refreshTerrainList() {
        this.lisTerrain.removeAll();
        int n = 0;
        while (n < Terrain.SIZE) {
            Terrain terrain = this.curHex.getTerrain(n);
            if (terrain != null) {
                this.lisTerrain.add(terrain.toString());
            }
            ++n;
        }
    }

    private Terrain enteredTerrain() {
        int n = Terrain.parse(this.choTerrainType.getSelectedItem());
        int n2 = Integer.parseInt(this.texTerrainLevel.getText());
        boolean bl = this.cheTerrExitSpecified.getState();
        int n3 = Integer.parseInt(this.texTerrExits.getText());
        return new Terrain(n, n2, bl, n3);
    }

    private void addSetTerrain() {
        Terrain terrain = this.enteredTerrain();
        this.curHex.addTerrain(terrain);
        this.refreshTerrainList();
        this.canHex.repaint();
    }

    private void refreshTerrainFromList() {
        Terrain terrain = new Terrain(this.lisTerrain.getSelectedItem());
        terrain = this.curHex.getTerrain(terrain.getType());
        this.choTerrainType.select(Terrain.getName(terrain.getType()));
        this.texTerrainLevel.setText(Integer.toString(terrain.getLevel()));
        this.cheTerrExitSpecified.setState(terrain.hasExitsSpecified());
        this.texTerrExits.setText(Integer.toString(terrain.getExits()));
    }

    public void boardNew() {
        BoardNewDialog boardNewDialog = new BoardNewDialog(this.frame, this.lisTerrain.getItems(), this.lisTerrain.getSelectedIndex());
        ((Component)boardNewDialog).setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
        boardNewDialog.show();
        if (boardNewDialog.getX() > 0 || boardNewDialog.getY() > 0) {
            this.board.newData(boardNewDialog.getX(), boardNewDialog.getY());
            int n = 0;
            while (n < this.board.data.length) {
                this.board.data[n] = new Hex();
                ++n;
            }
            this.curpath = null;
            this.curfile = null;
            this.frame.setTitle("MegaMek Editor : Unnamed");
        }
    }

    public void boardLoad() {
        FileDialog fileDialog = new FileDialog(this.frame, "Load Board...", 0);
        fileDialog.setDirectory("data" + File.separator + "boards");
        ((Component)fileDialog).setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        this.curpath = fileDialog.getDirectory();
        this.curfile = fileDialog.getFile();
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(this.curpath, this.curfile));
            this.board.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("error opening file to save!");
            System.err.println(iOException);
        }
        this.frame.setTitle("MegaMek Editor : " + this.curfile);
        this.refreshTerrainList();
    }

    public void boardSave() {
        if (this.curfile == null) {
            this.boardSaveAs();
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(this.curpath, this.curfile));
            this.board.save(fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("error opening file to save!");
            System.err.println(iOException);
        }
    }

    public void boardSaveAs() {
        FileDialog fileDialog = new FileDialog(this.frame, "Save Board As...", 1);
        fileDialog.setDirectory("data" + File.separator + "boards");
        ((Component)fileDialog).setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        this.curpath = fileDialog.getDirectory();
        this.curfile = fileDialog.getFile();
        this.frame.setTitle("MegaMek Editor : " + this.curfile);
        this.boardSave();
    }

    public void boardHexMoused(BoardEvent boardEvent) {
        this.board.cursor(boardEvent.getCoords());
        if (this.altheld) {
            this.setCurrentHex(this.board.getHex(boardEvent.getCoords()));
        }
        if (this.ctrlheld && !this.board.getHex(boardEvent.getCoords()).equals(this.curHex)) {
            this.paintHex(boardEvent.getCoords());
        }
    }

    public void boardHexSelected(BoardEvent boardEvent) {
    }

    public void boardHexCursor(BoardEvent boardEvent) {
    }

    public void boardHexHighlighted(BoardEvent boardEvent) {
    }

    public void boardChangedHex(BoardEvent boardEvent) {
    }

    public void boardChangedEntity(BoardEvent boardEvent) {
    }

    public void boardNewEntities(BoardEvent boardEvent) {
    }

    public void boardNewVis(BoardEvent boardEvent) {
    }

    public void boardNewBoard(BoardEvent boardEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.lisTerrain) {
            this.refreshTerrainFromList();
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.texElev) {
            int n;
            try {
                n = Integer.parseInt(this.texElev.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (n != this.curHex.getElevation()) {
                this.curHex.setElevation(n);
                this.canHex.repaint();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 17: {
                this.paintHex(this.board.lastCursor);
                this.ctrlheld = true;
                break;
            }
            case 18: {
                this.setCurrentHex(this.board.getHex(this.board.lastCursor));
                this.altheld = true;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 17: {
                this.ctrlheld = false;
                break;
            }
            case 18: {
                this.altheld = false;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butBoardNew) {
            this.boardNew();
        } else if (actionEvent.getSource() == this.butBoardLoad) {
            this.boardLoad();
        } else if (actionEvent.getSource() == this.butBoardSave) {
            this.boardSave();
        } else if (actionEvent.getSource() == this.butBoardSaveAs) {
            this.boardSaveAs();
        } else if (actionEvent.getSource() == this.butDelTerrain && this.lisTerrain.getSelectedItem() != null) {
            Terrain terrain = new Terrain(this.lisTerrain.getSelectedItem());
            this.curHex.removeTerrain(terrain.getType());
            this.refreshTerrainList();
            this.canHex.repaint();
        } else if (actionEvent.getSource() == this.butAddTerrain) {
            this.addSetTerrain();
        } else if (actionEvent.getSource() == this.butElevUp && this.curHex.getElevation() < 9) {
            this.curHex.setElevation(this.curHex.getElevation() + 1);
            this.texElev.setText(Integer.toString(this.curHex.getElevation()));
            this.canHex.repaint();
        } else if (actionEvent.getSource() == this.butElevDown && this.curHex.getElevation() > -5) {
            this.curHex.setElevation(this.curHex.getElevation() - 1);
            this.texElev.setText(Integer.toString(this.curHex.getElevation()));
            this.canHex.repaint();
        } else if (actionEvent.getSource() == this.butTerrExits) {
            ExitsDialog exitsDialog = new ExitsDialog(this.frame);
            this.cheTerrExitSpecified.setState(true);
            exitsDialog.setExits(Integer.parseInt(this.texTerrExits.getText()));
            exitsDialog.show();
            this.texTerrExits.setText(Integer.toString(exitsDialog.getExits()));
            this.addSetTerrain();
        }
    }

    private class HexCanvas
    extends Canvas {
        public HexCanvas() {
            this.setSize(72, 72);
        }

        public void paint(Graphics graphics) {
            this.update(graphics);
        }

        public void update(Graphics graphics) {
            if (BoardEditor.this.curHex != null) {
                graphics.drawImage(BoardEditor.this.bv.baseFor(BoardEditor.this.curHex), 0, 0, this);
                if (BoardEditor.this.bv.supersFor(BoardEditor.this.curHex) != null) {
                    Iterator iterator = BoardEditor.this.bv.supersFor(BoardEditor.this.curHex).iterator();
                    while (iterator.hasNext()) {
                        graphics.drawImage((Image)iterator.next(), 0, 0, this);
                        graphics.drawString("SUPER", 0, 10);
                    }
                }
                graphics.setFont(new Font("SansSerif", 0, 9));
                graphics.drawString("LEVEL " + BoardEditor.this.curHex.getElevation(), 24, 70);
            } else {
                graphics.clearRect(0, 0, 72, 72);
            }
        }
    }
}

