/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Hashtable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.TilesetManager;
import megamek.client.util.KeyAlphaFilter;
import megamek.common.BoardEvent;
import megamek.common.BoardListener;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Game;
import megamek.common.Hex;
import megamek.common.MovementData;
import megamek.common.Player;
import megamek.common.Settings;
import megamek.common.WeaponType;
import megamek.common.actions.AttackAction;
import megamek.common.actions.WeaponAttackAction;

public class BoardView1
extends Canvas
implements BoardListener,
MouseListener,
MouseMotionListener,
KeyListener,
Runnable {
    private static final int TIP_DELAY = 1000;
    private static final int TRANSPARENT = -65281;
    private static final Dimension HEX_SIZE = new Dimension(84, 72);
    private static final Font FONT_HEXNUM = new Font("SansSerif", 0, 10);
    private static final Font FONT_ELEV = new Font("SansSerif", 0, 9);
    private Game game;
    private Frame frame;
    private Point mousePos = new Point();
    private Rectangle view = new Rectangle();
    private Point offset = new Point();
    private Dimension boardSize;
    private boolean isScrolling = false;
    private Thread scroller = new Thread(this);
    private Point scroll = new Point();
    private Image backImage;
    private Dimension backSize;
    private Graphics backGraph;
    private Image boardImage;
    private Rectangle boardRect;
    private Graphics boardGraph;
    private com.sun.java.util.collections.Vector entitySprites = new com.sun.java.util.collections.Vector();
    private Hashtable entitySpriteIds = new Hashtable();
    private CursorSprite cursorSprite;
    private CursorSprite highlightSprite;
    private CursorSprite selectedSprite;
    private com.sun.java.util.collections.Vector pathSprites = new com.sun.java.util.collections.Vector();
    private com.sun.java.util.collections.Vector attackSprites = new com.sun.java.util.collections.Vector();
    private com.sun.java.util.collections.Vector C3Sprites = new com.sun.java.util.collections.Vector();
    private Window tipWindow;
    private boolean isTipPossible = false;
    private long lastIdle;
    private TilesetManager tileManager = new TilesetManager(this);
    private Polygon hexPoly;
    private Polygon[] facingPolys;
    private Polygon[] movementPolys;
    private Player m_plDeployer = null;

    public BoardView1(Game game, Frame frame) {
        this.game = game;
        this.frame = frame;
        game.board.addBoardListener(this);
        this.scroller.start();
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.tipWindow = new Window(frame);
        this.initPolys();
        this.cursorSprite = new CursorSprite(Color.cyan);
        this.highlightSprite = new CursorSprite(Color.white);
        this.selectedSprite = new CursorSprite(Color.blue);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.view.setLocation(this.scroll);
        this.view.setSize(this.getOptimalView(dimension));
        this.offset.setLocation(this.getOptimalOffset(dimension));
        if (!this.tileManager.isLoaded()) {
            if (!this.tileManager.isStarted()) {
                graphics.drawString("loading images...", 20, 50);
                System.out.println("boardview1: load all images called");
                this.tileManager.loadAllImages(this.game);
                return;
            }
            return;
        }
        if (this.backGraph == null || !this.view.getSize().equals(this.backSize)) {
            this.backSize = this.view.getSize();
            this.backImage = this.createImage(this.backSize.width, this.backSize.height);
            this.backGraph = this.backImage.getGraphics();
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        }
        if (this.boardImage == null || !this.boardRect.union(this.view).equals(this.boardRect)) {
            this.updateBoardImage();
        }
        this.backGraph.drawImage(this.boardImage, 0, 0, this);
        this.drawSprite(this.highlightSprite);
        this.drawSprites(this.C3Sprites);
        this.drawSprites(this.entitySprites);
        this.drawSprites(this.attackSprites);
        this.drawSprites(this.pathSprites);
        this.drawSprite(this.cursorSprite);
        this.drawSprite(this.selectedSprite);
        if (this.m_plDeployer != null) {
            this.drawDeployment();
        }
        graphics.drawImage(this.backImage, this.offset.x, this.offset.y, this);
    }

    private Dimension getOptimalView(Dimension dimension) {
        return new Dimension(Math.min(dimension.width, this.boardSize.width), Math.min(dimension.height, this.boardSize.height));
    }

    private Point getOptimalOffset(Dimension dimension) {
        int n = 0;
        int n2 = 0;
        if (dimension.width > this.boardSize.width) {
            n = (dimension.width - this.boardSize.width) / 2;
        }
        if (dimension.height > this.boardSize.height) {
            n2 = (dimension.height - this.boardSize.height) / 2;
        }
        return new Point(n, n2);
    }

    private void repaintBounds(Rectangle rectangle) {
        if (this.view != null) {
            this.repaint(rectangle.x - this.view.x + this.offset.x, rectangle.y - this.view.y + this.offset.y, rectangle.width, rectangle.height);
        }
    }

    private synchronized void drawSprites(com.sun.java.util.collections.Vector vector) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Sprite sprite = (Sprite)iterator.next();
            this.drawSprite(sprite);
        }
    }

    private final void drawSprite(Sprite sprite) {
        if (this.view.intersects(sprite.getBounds())) {
            int n = sprite.getBounds().x - this.view.x;
            int n2 = sprite.getBounds().y - this.view.y;
            if (!sprite.isReady()) {
                sprite.prepare();
            }
            sprite.drawOnto(this.backGraph, n, n2, this);
        }
    }

    private void drawDeployment() {
        int n = this.view.x / 63 - 1;
        int n2 = this.view.y / 72 - 1;
        int n3 = this.view.width / 63 + 3;
        int n4 = this.view.height / 72 + 3;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < n3) {
                Coords coords = new Coords(n6 + n, n5 + n2);
                Point point = this.getHexLocation(coords);
                point.translate(-this.view.x, -this.view.y);
                if (this.game.board.isLegalDeployment(coords, this.m_plDeployer)) {
                    this.backGraph.setColor(Color.yellow);
                    int[] nArray = new int[]{point.x + 21, point.x + 62, point.x + 83, point.x + 83, point.x + 62, point.x + 21, point.x, point.x};
                    int[] nArray2 = new int[]{point.y, point.y, point.y + 35, point.y + 36, point.y + 71, point.y + 71, point.y + 36, point.y + 35};
                    this.backGraph.drawPolygon(nArray, nArray2, 8);
                }
                ++n6;
            }
            ++n5;
        }
    }

    private void updateBoardImage() {
        if (this.boardGraph == null || this.view.width > this.boardRect.width || this.view.height > this.boardRect.height) {
            this.boardImage = this.createImage(this.view.width, this.view.height);
            this.boardGraph = this.boardImage.getGraphics();
            System.out.println("boardview1: made a new board buffer " + this.boardRect);
            this.boardRect = new Rectangle(this.view);
            this.drawHexes(this.view);
        }
        if (!this.boardRect.union(this.view).equals(this.boardRect)) {
            this.moveBoardImage();
        }
    }

    private void moveBoardImage() {
        this.boardGraph.setClip(0, 0, this.boardRect.width, this.boardRect.height);
        this.boardGraph.copyArea(0, 0, this.boardRect.width, this.boardRect.height, this.boardRect.x - this.view.x, this.boardRect.y - this.view.y);
        int n = Math.max(this.view.x, this.boardRect.x);
        int n2 = this.view.width - Math.abs(this.view.x - this.boardRect.x);
        Rectangle rectangle = new Rectangle(this.view.x, this.view.y, this.boardRect.x - this.view.x, this.view.height);
        Rectangle rectangle2 = new Rectangle(this.boardRect.x + this.boardRect.width, this.view.y, this.view.x - this.boardRect.x, this.view.height);
        Rectangle rectangle3 = new Rectangle(n, this.view.y, n2, this.boardRect.y - this.view.y);
        Rectangle rectangle4 = new Rectangle(n, this.boardRect.y + this.boardRect.height, n2, this.view.y - this.boardRect.y);
        this.boardRect = new Rectangle(this.view);
        if (rectangle.width > 0) {
            this.drawHexes(rectangle);
        } else if (rectangle2.width > 0) {
            this.drawHexes(rectangle2);
        }
        if (rectangle3.height > 0) {
            this.drawHexes(rectangle3);
        } else if (rectangle4.height > 0) {
            this.drawHexes(rectangle4);
        }
    }

    private void drawHexes(Rectangle rectangle) {
        int n = rectangle.x / 63 - 1;
        int n2 = rectangle.y / 72 - 1;
        int n3 = rectangle.width / 63 + 3;
        int n4 = rectangle.height / 72 + 3;
        this.boardGraph.setClip(rectangle.x - this.boardRect.x, rectangle.y - this.boardRect.y, rectangle.width, rectangle.height);
        if (rectangle.x < 21) {
            this.boardGraph.clearRect(rectangle.x - this.boardRect.x, rectangle.y - this.boardRect.y, 21 - rectangle.x, rectangle.height);
        }
        if (rectangle.y < 36) {
            this.boardGraph.clearRect(rectangle.x - this.boardRect.x, rectangle.y - this.boardRect.y, rectangle.width, 36 - rectangle.y);
        }
        if (rectangle.x > this.boardSize.width - this.view.width - 21) {
            this.boardGraph.clearRect(this.boardRect.width - 21, rectangle.y - this.boardRect.y, 21, rectangle.height);
        }
        if (rectangle.y > this.boardSize.height - this.view.height - 36) {
            this.boardGraph.clearRect(rectangle.x - this.boardRect.x, this.boardRect.height - 36, rectangle.width, 36);
        }
        int n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < n3) {
                this.drawHex(new Coords(n6 + n, n5 + n2));
                ++n6;
            }
            ++n5;
        }
    }

    private void redrawAround(Coords coords) {
        this.boardGraph.setClip(0, 0, this.boardRect.width, this.boardRect.height);
        this.drawHex(coords);
        this.drawHex(coords.translated(0));
        this.drawHex(coords.translated(1));
        this.drawHex(coords.translated(2));
        this.drawHex(coords.translated(3));
        this.drawHex(coords.translated(4));
        this.drawHex(coords.translated(5));
    }

    private void drawHex(Coords coords) {
        if (!this.game.board.contains(coords)) {
            return;
        }
        Hex hex = this.game.board.getHex(coords);
        Point point = this.getHexLocation(coords);
        int n = hex.getElevation();
        int n2 = hex.depth();
        int n3 = point.x - this.boardRect.x;
        int n4 = point.y - this.boardRect.y;
        this.boardGraph.drawImage(this.tileManager.baseFor(hex), n3, n4, this);
        if (this.tileManager.supersFor(hex) != null) {
            Iterator iterator = this.tileManager.supersFor(hex).iterator();
            while (iterator.hasNext()) {
                this.boardGraph.drawImage((Image)iterator.next(), n3, n4, this);
            }
        }
        this.boardGraph.setColor(Settings.mapTextColor);
        this.boardGraph.setFont(FONT_HEXNUM);
        this.boardGraph.drawString(coords.getBoardNum(), n3 + 30, n4 + 12);
        this.boardGraph.setFont(FONT_ELEV);
        if (n != 0 && n2 == 0) {
            this.boardGraph.drawString("LEVEL " + n, n3 + 24, n4 + 70);
        } else if (n2 != 0 && n == 0) {
            this.boardGraph.drawString("DEPTH " + n2, n3 + 24, n4 + 70);
        } else if (n != 0 && n2 != 0) {
            this.boardGraph.drawString("LEVEL " + n, n3 + 24, n4 + 60);
            this.boardGraph.drawString("DEPTH " + n2, n3 + 24, n4 + 70);
        }
        this.boardGraph.setColor(Color.black);
        if (this.drawElevationLine(coords, 0)) {
            this.boardGraph.drawLine(n3 + 21, n4, n3 + 62, n4);
        }
        if (this.drawElevationLine(coords, 1)) {
            this.boardGraph.drawLine(n3 + 62, n4, n3 + 83, n4 + 35);
        }
        if (this.drawElevationLine(coords, 2)) {
            this.boardGraph.drawLine(n3 + 83, n4 + 36, n3 + 62, n4 + 71);
        }
        if (this.drawElevationLine(coords, 3)) {
            this.boardGraph.drawLine(n3 + 62, n4 + 71, n3 + 21, n4 + 71);
        }
        if (this.drawElevationLine(coords, 4)) {
            this.boardGraph.drawLine(n3 + 21, n4 + 71, n3, n4 + 36);
        }
        if (this.drawElevationLine(coords, 5)) {
            this.boardGraph.drawLine(n3, n4 + 35, n3 + 21, n4);
        }
    }

    private final boolean drawElevationLine(Coords coords, int n) {
        Hex hex = this.game.board.getHex(coords);
        Hex hex2 = this.game.board.getHexInDir(coords, n);
        return hex2 != null && hex.floor() != hex2.floor();
    }

    private Point getHexLocation(int n, int n2) {
        return new Point(n * 63, n2 * 72 + ((n & 1) == 1 ? 36 : 0));
    }

    private Point getHexLocation(Coords coords) {
        return this.getHexLocation(coords.x, coords.y);
    }

    Coords getCoordsAt(Point point) {
        int n = (point.x + this.scroll.x - this.offset.x) / 63;
        int n2 = (point.y + this.scroll.y - this.offset.y - ((n & 1) == 1 ? 36 : 0)) / 72;
        return new Coords(n, n2);
    }

    private void showTooltip() {
        try {
            Point point = new Point(this.getLocationOnScreen());
            String[] stringArray = this.getTipText(this.mousePos);
            if (stringArray == null) {
                return;
            }
            this.tipWindow.removeAll();
            this.tipWindow.add(new TooltipCanvas(stringArray));
            this.tipWindow.pack();
            point.translate(this.mousePos.x, this.mousePos.y + 20);
            if (this.frame.getLocation().x + this.frame.getSize().width < point.x + this.tipWindow.getSize().width + 10) {
                point.x = this.frame.getSize().width > this.tipWindow.getSize().width ? (point.x -= point.x + this.tipWindow.getSize().width + 10 - this.frame.getSize().width - this.frame.getLocation().x) : this.getLocationOnScreen().x + 84;
            }
            ((Component)this.tipWindow).setLocation(point);
            this.tipWindow.show();
        }
        catch (Exception exception) {
            this.tipWindow = new Window(this.frame);
        }
    }

    private String[] getTipText(Point point) {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        Object object4;
        int n = 0;
        Coords coords = this.getCoordsAt(point);
        if (this.game.board.contains(coords)) {
            ++n;
        }
        Iterator iterator = this.entitySprites.iterator();
        while (iterator.hasNext()) {
            object4 = (EntitySprite)iterator.next();
            if (!((EntitySprite)object4).isInside(point)) continue;
            n += 3;
        }
        object4 = this.attackSprites.iterator();
        while (object4.hasNext()) {
            stringArray = (String[])object4.next();
            if (!stringArray.isInside(point)) continue;
            n += 1 + ((AttackSprite)stringArray).weaponDescs.size();
        }
        if (n == 0) {
            return null;
        }
        stringArray = new String[n];
        int n2 = 0;
        if (this.game.board.contains(coords)) {
            object3 = this.game.board.getHex(coords);
            stringArray[n2] = "Hex " + coords.getBoardNum() + "; level " + ((Hex)object3).getElevation();
            ++n2;
        }
        object3 = this.entitySprites.iterator();
        while (object3.hasNext()) {
            object2 = (EntitySprite)object3.next();
            if (!((EntitySprite)object2).isInside(point)) continue;
            object = ((EntitySprite)object2).getTooltip();
            System.arraycopy(object, 0, stringArray, n2, ((Object)object).length);
            n2 += ((Object)object).length;
        }
        object2 = this.attackSprites.iterator();
        while (object2.hasNext()) {
            object = (AttackSprite)object2.next();
            if (!((AttackSprite)object).isInside(point)) continue;
            String[] stringArray2 = ((AttackSprite)object).getTooltip();
            System.arraycopy(stringArray2, 0, stringArray, n2, stringArray2.length);
            n2 += 1 + ((AttackSprite)object).weaponDescs.size();
        }
        return stringArray;
    }

    public void hideTooltip() {
        ((Component)this.tipWindow).setVisible(false);
    }

    private boolean isTipShowing() {
        return this.tipWindow.isShowing();
    }

    private void checkTooltip() {
        if (this.isTipShowing()) {
            if (!this.isTipPossible) {
                this.hideTooltip();
            }
        } else if (this.isTipPossible && System.currentTimeMillis() - this.lastIdle > 1000L) {
            this.showTooltip();
        }
    }

    public void redrawEntity(Entity entity) {
        EntitySprite entitySprite = (EntitySprite)this.entitySpriteIds.get((Object)new Integer(entity.getId()));
        com.sun.java.util.collections.Vector vector = new com.sun.java.util.collections.Vector((Collection)this.entitySprites);
        Hashtable hashtable = new Hashtable((Map)this.entitySpriteIds);
        if (entitySprite != null) {
            vector.removeElement((Object)entitySprite);
        }
        if (entity.getPosition() != null) {
            entitySprite = new EntitySprite(entity);
            vector.addElement((Object)entitySprite);
            hashtable.put((Object)new Integer(entity.getId()), (Object)entitySprite);
        }
        this.entitySprites = vector;
        this.entitySpriteIds = hashtable;
        Enumeration enumeration = this.C3Sprites.elements();
        while (enumeration.hasMoreElements()) {
            C3Sprite c3Sprite = (C3Sprite)enumeration.nextElement();
            if (c3Sprite.entityId == entity.getId()) {
                this.C3Sprites.removeElement((Object)c3Sprite);
                continue;
            }
            if (c3Sprite.masterId != entity.getId()) continue;
            if (entity.hasC3()) {
                this.C3Sprites.addElement((Object)new C3Sprite(this.game.getEntity(c3Sprite.entityId), this.game.getEntity(c3Sprite.masterId)));
            }
            this.C3Sprites.removeElement((Object)c3Sprite);
        }
        if (entity.hasC3() || entity.hasC3i()) {
            this.addC3Link(entity);
        }
        this.repaint(100L);
    }

    private void redrawAllEntities() {
        com.sun.java.util.collections.Vector vector = new com.sun.java.util.collections.Vector(this.game.getNoOfEntities());
        Hashtable hashtable = new Hashtable(this.game.getNoOfEntities());
        this.clearC3Networks();
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getPosition() == null) continue;
            EntitySprite entitySprite = new EntitySprite(entity);
            vector.add((Object)entitySprite);
            hashtable.put((Object)new Integer(entity.getId()), (Object)entitySprite);
            if (!entity.hasC3() && !entity.hasC3i()) continue;
            this.addC3Link(entity);
        }
        this.entitySprites = vector;
        this.entitySpriteIds = hashtable;
        this.repaint(100L);
    }

    private void moveCursor(CursorSprite cursorSprite, Coords coords) {
        Rectangle rectangle = new Rectangle(cursorSprite.getBounds());
        if (coords != null) {
            cursorSprite.setLocation(this.getHexLocation(coords));
        } else {
            cursorSprite.setLocation(-100, -100);
        }
        this.repaintBounds(rectangle);
        this.repaintBounds(cursorSprite.getBounds());
    }

    public void centerOnHex(Coords coords) {
        this.scroll.setLocation(this.getHexLocation(coords));
        this.scroll.translate(42 - this.view.width / 2, 36 - this.view.height / 2);
        this.isScrolling = false;
        this.checkScrollBounds();
        this.repaint();
    }

    public void drawMovementData(Entity entity, MovementData movementData) {
        com.sun.java.util.collections.Vector vector = this.pathSprites;
        this.clearMovementData();
        movementData.clearAllFlags();
        Compute.compile(this.game, entity.getId(), movementData);
        Enumeration enumeration = movementData.getSteps();
        while (enumeration.hasMoreElements()) {
            MovementData.Step step = (MovementData.Step)enumeration.nextElement();
            boolean bl = false;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                StepSprite stepSprite = (StepSprite)iterator.next();
                if (!stepSprite.getStep().equals(step)) continue;
                this.pathSprites.addElement((Object)stepSprite);
                bl = true;
            }
            if (bl) continue;
            this.pathSprites.addElement((Object)new StepSprite(step));
        }
    }

    public void clearMovementData() {
        com.sun.java.util.collections.Vector vector = this.pathSprites;
        this.pathSprites = new com.sun.java.util.collections.Vector();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Sprite sprite = (Sprite)iterator.next();
            this.repaintBounds(sprite.getBounds());
        }
    }

    public void markDeploymentHexesFor(Player player) {
        this.m_plDeployer = player;
    }

    public void addC3Link(Entity entity) {
        if (entity.getPosition() == null) {
            return;
        }
        if (entity.hasC3i()) {
            Enumeration enumeration = this.game.getEntities();
            while (enumeration.hasMoreElements()) {
                Entity entity2 = (Entity)enumeration.nextElement();
                if (entity2.getPosition() == null) {
                    return;
                }
                if (!entity.onSameC3NetworkAs(entity2)) continue;
                this.C3Sprites.addElement((Object)new C3Sprite(entity, entity2));
            }
        } else if (entity.getC3Master() != null) {
            Entity entity3 = entity.getC3Master();
            if (entity3.getPosition() == null) {
                return;
            }
            if (!Compute.isAffectedByECM(entity, entity.getPosition(), entity3.getPosition())) {
                this.C3Sprites.addElement((Object)new C3Sprite(entity, entity.getC3Master()));
            }
        }
    }

    public void addAttack(AttackAction attackAction) {
        if (this.game.getEntity(attackAction.getEntityId()) == null || this.game.getEntity(attackAction.getTargetId()) == null) {
            return;
        }
        Iterator iterator = this.attackSprites.iterator();
        while (iterator.hasNext()) {
            AttackSprite attackSprite = (AttackSprite)iterator.next();
            if (attackSprite.getEntityId() != attackAction.getEntityId() || attackSprite.getTargetId() != attackAction.getTargetId()) continue;
            if (attackAction instanceof WeaponAttackAction) {
                attackSprite.addWeapon((WeaponAttackAction)attackAction);
            }
            return;
        }
        this.attackSprites.addElement((Object)new AttackSprite(attackAction));
    }

    public void clearC3Networks() {
        this.C3Sprites.removeAllElements();
    }

    public void clearAllAttacks() {
        this.attackSprites.removeAllElements();
    }

    public Image baseFor(Hex hex) {
        return this.tileManager.baseFor(hex);
    }

    public List supersFor(Hex hex) {
        return this.tileManager.supersFor(hex);
    }

    public void boardHexMoused(BoardEvent boardEvent) {
    }

    public void boardHexCursor(BoardEvent boardEvent) {
        this.moveCursor(this.cursorSprite, boardEvent.getCoords());
    }

    public void boardHexSelected(BoardEvent boardEvent) {
        this.moveCursor(this.selectedSprite, boardEvent.getCoords());
    }

    public void boardHexHighlighted(BoardEvent boardEvent) {
        this.moveCursor(this.highlightSprite, boardEvent.getCoords());
    }

    public void boardChangedHex(BoardEvent boardEvent) {
        this.boardGraph.setClip(0, 0, this.boardRect.width, this.boardRect.height);
        this.redrawAround(boardEvent.getCoords());
    }

    public void boardNewBoard(BoardEvent boardEvent) {
        this.boardSize = new Dimension(this.game.board.width * 63 + 21, this.game.board.height * 72 + 36);
        this.backGraph = null;
        this.backImage = null;
        this.backSize = null;
        this.boardImage = null;
        this.boardGraph = null;
        this.tileManager.reset();
    }

    public void boardNewEntities(BoardEvent boardEvent) {
        this.redrawAllEntities();
    }

    public void boardChangedEntity(BoardEvent boardEvent) {
        this.redrawEntity(boardEvent.getEntity());
    }

    public void doScroll() {
        if (!this.isScrolling) {
            return;
        }
        Point point = new Point(this.scroll);
        if (this.mousePos.x < 100) {
            this.scroll.x -= (100 - this.mousePos.x) / 3;
        } else if (this.mousePos.x > this.backSize.width - 100) {
            this.scroll.x -= (this.backSize.width - 100 - this.mousePos.x) / 3;
        }
        if (this.mousePos.y < 100) {
            this.scroll.y -= (100 - this.mousePos.y) / 3;
        } else if (this.mousePos.y > this.backSize.height - 100) {
            this.scroll.y -= (this.backSize.height - 100 - this.mousePos.y) / 3;
        }
        this.checkScrollBounds();
        if (!point.equals(this.scroll)) {
            this.repaint();
        }
    }

    public void checkScrollBounds() {
        if (this.scroll.x < 0) {
            this.scroll.x = 0;
        } else if (this.scroll.x > this.boardSize.width - this.view.width) {
            this.scroll.x = this.boardSize.width - this.view.width;
        }
        if (this.scroll.y < 0) {
            this.scroll.y = 0;
        } else if (this.scroll.y > this.boardSize.height - this.view.height) {
            this.scroll.y = this.boardSize.height - this.view.height;
        }
    }

    public void initPolys() {
        this.hexPoly = new Polygon();
        this.hexPoly.addPoint(21, 0);
        this.hexPoly.addPoint(62, 0);
        this.hexPoly.addPoint(83, 35);
        this.hexPoly.addPoint(83, 36);
        this.hexPoly.addPoint(62, 71);
        this.hexPoly.addPoint(21, 71);
        this.hexPoly.addPoint(0, 36);
        this.hexPoly.addPoint(0, 35);
        this.facingPolys = new Polygon[6];
        this.facingPolys[0] = new Polygon();
        this.facingPolys[0].addPoint(41, 3);
        this.facingPolys[0].addPoint(38, 6);
        this.facingPolys[0].addPoint(45, 6);
        this.facingPolys[0].addPoint(42, 3);
        this.facingPolys[1] = new Polygon();
        this.facingPolys[1].addPoint(69, 17);
        this.facingPolys[1].addPoint(64, 17);
        this.facingPolys[1].addPoint(68, 23);
        this.facingPolys[1].addPoint(70, 19);
        this.facingPolys[2] = new Polygon();
        this.facingPolys[2].addPoint(69, 53);
        this.facingPolys[2].addPoint(68, 49);
        this.facingPolys[2].addPoint(64, 55);
        this.facingPolys[2].addPoint(68, 54);
        this.facingPolys[3] = new Polygon();
        this.facingPolys[3].addPoint(41, 68);
        this.facingPolys[3].addPoint(38, 65);
        this.facingPolys[3].addPoint(45, 65);
        this.facingPolys[3].addPoint(42, 68);
        this.facingPolys[4] = new Polygon();
        this.facingPolys[4].addPoint(15, 53);
        this.facingPolys[4].addPoint(18, 54);
        this.facingPolys[4].addPoint(15, 48);
        this.facingPolys[4].addPoint(14, 52);
        this.facingPolys[5] = new Polygon();
        this.facingPolys[5].addPoint(13, 19);
        this.facingPolys[5].addPoint(15, 23);
        this.facingPolys[5].addPoint(19, 17);
        this.facingPolys[5].addPoint(17, 17);
        this.movementPolys = new Polygon[6];
        this.movementPolys[0] = new Polygon();
        this.movementPolys[0].addPoint(41, 65);
        this.movementPolys[0].addPoint(38, 68);
        this.movementPolys[0].addPoint(45, 68);
        this.movementPolys[0].addPoint(42, 65);
        this.movementPolys[1] = new Polygon();
        this.movementPolys[1].addPoint(17, 48);
        this.movementPolys[1].addPoint(12, 48);
        this.movementPolys[1].addPoint(16, 54);
        this.movementPolys[1].addPoint(17, 49);
        this.movementPolys[2] = new Polygon();
        this.movementPolys[2].addPoint(18, 19);
        this.movementPolys[2].addPoint(17, 15);
        this.movementPolys[2].addPoint(13, 21);
        this.movementPolys[2].addPoint(17, 20);
        this.movementPolys[3] = new Polygon();
        this.movementPolys[3].addPoint(41, 6);
        this.movementPolys[3].addPoint(38, 3);
        this.movementPolys[3].addPoint(45, 3);
        this.movementPolys[3].addPoint(42, 6);
        this.movementPolys[4] = new Polygon();
        this.movementPolys[4].addPoint(67, 15);
        this.movementPolys[4].addPoint(66, 19);
        this.movementPolys[4].addPoint(67, 20);
        this.movementPolys[4].addPoint(71, 20);
        this.movementPolys[5] = new Polygon();
        this.movementPolys[5].addPoint(69, 55);
        this.movementPolys[5].addPoint(66, 50);
        this.movementPolys[5].addPoint(67, 49);
        this.movementPolys[5].addPoint(72, 48);
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.scroller == thread) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isShowing()) continue;
            if (this.backSize != null) {
                this.doScroll();
                this.checkTooltip();
                continue;
            }
            this.repaint(100L);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.scroll.y -= 36;
                break;
            }
            case 40: {
                this.scroll.y += 36;
                break;
            }
            case 37: {
                this.scroll.x -= 36;
                break;
            }
            case 39: {
                this.scroll.x += 36;
            }
        }
        if (this.isTipShowing()) {
            this.hideTooltip();
        }
        this.lastIdle = System.currentTimeMillis();
        this.checkScrollBounds();
        this.repaint();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.isScrolling = true;
        this.isTipPossible = false;
        if (this.isTipShowing()) {
            this.hideTooltip();
        }
        this.game.board.mouseAction(this.getCoordsAt(mouseEvent.getPoint()), 3, mouseEvent.getModifiers());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.isScrolling = false;
        this.isTipPossible = true;
        if (mouseEvent.getClickCount() == 1) {
            this.game.board.mouseAction(this.getCoordsAt(mouseEvent.getPoint()), 1, mouseEvent.getModifiers());
        } else {
            this.game.board.mouseAction(this.getCoordsAt(mouseEvent.getPoint()), 2, mouseEvent.getModifiers());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.isTipPossible = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mousePos = mouseEvent.getPoint();
        this.isTipPossible = false;
        this.isScrolling = true;
        if (this.backSize != null) {
            this.doScroll();
        }
        this.game.board.mouseAction(this.getCoordsAt(mouseEvent.getPoint()), 3, mouseEvent.getModifiers());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mousePos = mouseEvent.getPoint();
        if (this.isTipShowing()) {
            this.hideTooltip();
        }
        this.lastIdle = System.currentTimeMillis();
        this.isTipPossible = true;
    }

    private class AttackSprite
    extends Sprite {
        private Vector attacks = new Vector();
        private Polygon attackPoly;
        private int entityId;
        private int targetId;
        private String attackerDesc;
        private String targetDesc;
        private com.sun.java.util.collections.Vector weaponDescs = new com.sun.java.util.collections.Vector();

        public AttackSprite(AttackAction attackAction) {
            this.attacks.addElement(attackAction);
            this.entityId = attackAction.getEntityId();
            this.targetId = attackAction.getTargetId();
            Entity entity = BoardView1.this.game.getEntity(attackAction.getEntityId());
            Entity entity2 = BoardView1.this.game.getEntity(attackAction.getTargetId());
            Point point = BoardView1.this.getHexLocation(entity.getPosition());
            Point point2 = BoardView1.this.getHexLocation(entity2.getPosition());
            double d = (entity.getPosition().radian(entity2.getPosition()) + 4.71238898038469) % (Math.PI * 2);
            this.attackPoly = new Polygon();
            this.attackPoly.addPoint(point.x + 42 - (int)Math.round(Math.sin(d) * 3.0), point.y + 36 + (int)Math.round(Math.cos(d) * 3.0));
            this.attackPoly.addPoint(point.x + 42 + (int)Math.round(Math.sin(d) * 3.0), point.y + 36 - (int)Math.round(Math.cos(d) * 3.0));
            this.attackPoly.addPoint(point2.x + 42 + (int)Math.round(Math.sin(d) * 3.0), point2.y + 36 - (int)Math.round(Math.cos(d) * 3.0));
            this.attackPoly.addPoint(point2.x + 42 - (int)Math.round(Math.sin(d) * 3.0), point2.y + 36 + (int)Math.round(Math.cos(d) * 3.0));
            this.bounds = new Rectangle(this.attackPoly.getBounds());
            this.bounds.setSize(this.bounds.getSize().width + 1, this.bounds.getSize().height + 1);
            this.attackPoly.translate(-this.bounds.getLocation().x, -this.bounds.getLocation().y);
            this.attackerDesc = entity.getDisplayName();
            this.targetDesc = entity2.getDisplayName();
            if (attackAction instanceof WeaponAttackAction) {
                this.addWeapon((WeaponAttackAction)attackAction);
            }
            this.image = null;
        }

        public void prepare() {
        }

        public boolean isReady() {
            return true;
        }

        public void drawOnto(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
            Polygon polygon = new Polygon(this.attackPoly.xpoints, this.attackPoly.ypoints, this.attackPoly.npoints);
            polygon.translate(n, n2);
            graphics.setColor(BoardView1.this.game.getEntity(this.entityId).getOwner().getColor());
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.white);
            graphics.drawPolygon(polygon);
        }

        public boolean isInside(Point point) {
            return this.attackPoly.contains(point.x + ((BoardView1)BoardView1.this).view.x - this.bounds.x - ((BoardView1)BoardView1.this).offset.x, point.y + ((BoardView1)BoardView1.this).view.y - this.bounds.y - ((BoardView1)BoardView1.this).offset.y);
        }

        public int getEntityId() {
            return this.entityId;
        }

        public int getTargetId() {
            return this.targetId;
        }

        public void addWeapon(WeaponAttackAction weaponAttackAction) {
            Entity entity = BoardView1.this.game.getEntity(weaponAttackAction.getEntityId());
            WeaponType weaponType = (WeaponType)entity.getEquipment(weaponAttackAction.getWeaponId()).getType();
            int n = Compute.toHitWeapon(BoardView1.this.game, weaponAttackAction, this.attacks).getValue();
            this.weaponDescs.addElement((Object)(weaponType.getName() + "; needs " + n));
        }

        private String[] getTooltip() {
            String[] stringArray = new String[1 + this.weaponDescs.size()];
            int n = 1;
            stringArray[0] = this.attackerDesc + " on " + this.targetDesc;
            Iterator iterator = this.weaponDescs.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = (String)iterator.next();
            }
            return stringArray;
        }
    }

    private class C3Sprite
    extends Sprite {
        private Polygon C3Poly;
        protected int entityId;
        protected int masterId;

        public C3Sprite(Entity entity, Entity entity2) {
            this.entityId = entity.getId();
            this.masterId = entity2.getId();
            Coords coords = entity2.getPosition();
            if (entity.getPosition() == null || entity2.getPosition() == null) {
                this.C3Poly = new Polygon();
                this.C3Poly.addPoint(0, 0);
                this.C3Poly.addPoint(1, 0);
                this.C3Poly.addPoint(0, 1);
                this.bounds = new Rectangle(this.C3Poly.getBounds());
                this.bounds.setSize(this.bounds.getSize().width + 1, this.bounds.getSize().height + 1);
                this.image = null;
                return;
            }
            Point point = BoardView1.this.getHexLocation(entity.getPosition());
            Point point2 = BoardView1.this.getHexLocation(entity2.getPosition());
            double d = (entity.getPosition().radian(entity2.getPosition()) + 4.71238898038469) % (Math.PI * 2);
            this.C3Poly = new Polygon();
            this.C3Poly.addPoint(point.x + 42 - (int)Math.round(Math.sin(d) * 1.0), point.y + 36 + (int)Math.round(Math.cos(d) * 1.0));
            this.C3Poly.addPoint(point.x + 42 + (int)Math.round(Math.sin(d) * 1.0), point.y + 36 - (int)Math.round(Math.cos(d) * 1.0));
            this.C3Poly.addPoint(point2.x + 42 + (int)Math.round(Math.sin(d) * 1.0), point2.y + 36 - (int)Math.round(Math.cos(d) * 1.0));
            this.C3Poly.addPoint(point2.x + 42 - (int)Math.round(Math.sin(d) * 1.0), point2.y + 36 + (int)Math.round(Math.cos(d) * 1.0));
            this.bounds = new Rectangle(this.C3Poly.getBounds());
            this.bounds.setSize(this.bounds.getSize().width + 1, this.bounds.getSize().height + 1);
            this.C3Poly.translate(-this.bounds.getLocation().x, -this.bounds.getLocation().y);
            this.image = null;
        }

        public void prepare() {
        }

        public boolean isReady() {
            return true;
        }

        public void drawOnto(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
            Polygon polygon = new Polygon(this.C3Poly.xpoints, this.C3Poly.ypoints, this.C3Poly.npoints);
            polygon.translate(n, n2);
            graphics.setColor(BoardView1.this.game.getEntity(this.entityId).getOwner().getColor());
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.black);
            graphics.drawPolygon(polygon);
        }

        public boolean isInside(Point point) {
            return this.C3Poly.contains(point.x + ((BoardView1)BoardView1.this).view.x - this.bounds.x - ((BoardView1)BoardView1.this).offset.x, point.y + ((BoardView1)BoardView1.this).view.y - this.bounds.y - ((BoardView1)BoardView1.this).offset.y);
        }
    }

    private class StepSprite
    extends Sprite {
        private MovementData.Step step;

        public StepSprite(MovementData.Step step) {
            this.step = (MovementData.Step)step.clone();
            this.bounds = new Rectangle(BoardView1.this.getHexLocation(step.getPosition()), HEX_SIZE);
            this.image = null;
        }

        public void prepare() {
            Color color;
            Image image = BoardView1.this.createImage(this.bounds.width, this.bounds.height);
            Graphics graphics = image.getGraphics();
            graphics.setColor(new Color(-65281));
            graphics.fillRect(0, 0, this.bounds.width, this.bounds.height);
            Point point = BoardView1.this.getHexLocation(this.step.getPosition());
            point.translate(-this.bounds.x, -this.bounds.y);
            Polygon polygon = BoardView1.this.facingPolys[this.step.getFacing()];
            Polygon polygon2 = BoardView1.this.movementPolys[this.step.getFacing()];
            switch (this.step.getMovementType()) {
                case 2: {
                    color = Settings.moveRunColor;
                    break;
                }
                case 3: {
                    color = Settings.moveJumpColor;
                    break;
                }
                case -1: {
                    color = Settings.moveIllegalColor;
                    break;
                }
                default: {
                    color = Settings.moveDefaultColor;
                }
            }
            switch (this.step.getType()) {
                case 1: 
                case 2: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    Polygon polygon3 = new Polygon(polygon2.xpoints, polygon2.ypoints, polygon2.npoints);
                    graphics.setColor(Color.darkGray);
                    polygon3.translate(point.x + 1, point.y + 1);
                    graphics.drawPolygon(polygon3);
                    graphics.setColor(color);
                    polygon3.translate(-1, -1);
                    graphics.drawPolygon(polygon3);
                    String string = new Integer(this.step.getMpUsed()).toString() + (this.step.isDanger() ? "*" : "");
                    if (this.step.isPastDanger()) {
                        string = "(" + string + ")";
                    }
                    graphics.setFont(new Font("SansSerif", 0, 12));
                    int n = point.x + 42 - graphics.getFontMetrics(graphics.getFont()).stringWidth(string) / 2;
                    graphics.setColor(Color.darkGray);
                    graphics.drawString(string, n, point.y + 39);
                    graphics.setColor(color);
                    graphics.drawString(string, n - 1, point.y + 38);
                    break;
                }
                case 3: 
                case 4: {
                    Polygon polygon4 = new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
                    graphics.setColor(Color.darkGray);
                    polygon4.translate(point.x + 1, point.y + 1);
                    graphics.drawPolygon(polygon4);
                    graphics.setColor(color);
                    polygon4.translate(-1, -1);
                    graphics.drawPolygon(polygon4);
                    break;
                }
            }
            this.image = BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281)));
        }

        public MovementData.Step getStep() {
            return this.step;
        }
    }

    private class EntitySprite
    extends Sprite {
        private Entity entity;
        private Rectangle entityRect;

        public EntitySprite(Entity entity) {
            this.entity = entity;
            String string = entity.getShortName();
            Font font = new Font("SansSerif", 0, 10);
            Rectangle rectangle = new Rectangle(47, 55, BoardView1.this.getFontMetrics(font).stringWidth(string) + 1, BoardView1.this.getFontMetrics(font).getAscent());
            Rectangle rectangle2 = new Rectangle(HEX_SIZE).union(rectangle);
            rectangle2.setLocation(BoardView1.this.getHexLocation(entity.getPosition()));
            this.bounds = rectangle2;
            this.entityRect = new Rectangle(this.bounds.x + 20, this.bounds.y + 14, 44, 44);
            this.image = null;
        }

        public void prepare() {
            int n;
            Color color;
            Color color2;
            Graphics graphics;
            Image image;
            String string = this.entity.getShortName();
            Font font = new Font("SansSerif", 0, 10);
            Rectangle rectangle = new Rectangle(47, 55, BoardView1.this.getFontMetrics(font).stringWidth(string) + 1, BoardView1.this.getFontMetrics(font).getAscent());
            Rectangle rectangle2 = new Rectangle(HEX_SIZE).union(rectangle);
            try {
                image = BoardView1.this.createImage(this.bounds.width, this.bounds.height);
                graphics = image.getGraphics();
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            graphics.setColor(new Color(-65281));
            graphics.fillRect(0, 0, this.bounds.width, this.bounds.height);
            graphics.drawImage(BoardView1.this.tileManager.imageFor(this.entity), 0, 0, this);
            if (this.entity.isImmobile()) {
                color2 = Color.black;
                color = Color.lightGray;
            } else if (!this.entity.ready) {
                color2 = Color.darkGray;
                color = Color.black;
            } else {
                color2 = Color.lightGray;
                color = Color.darkGray;
            }
            graphics.setFont(font);
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            rectangle.translate(-1, -1);
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(this.entity.ready ? Color.black : Color.lightGray);
            graphics.drawString(string, rectangle.x + 1, rectangle.y + rectangle.height - 1);
            graphics.setColor(Color.white);
            if (this.entity.getFacing() != -1) {
                graphics.drawPolygon(BoardView1.this.facingPolys[this.entity.getFacing()]);
            }
            if (this.entity.getFacing() != -1 && this.entity.getArmsFlipped()) {
                graphics.setColor(Color.red);
                n = this.entity.getFacing();
                n = n < 3 ? (n += 3) : (n -= 3);
                graphics.drawPolygon(BoardView1.this.facingPolys[n]);
            }
            if (this.entity.isImmobile() && !this.entity.isProne()) {
                graphics.setColor(Color.darkGray);
                graphics.drawString("IMMOBILE", 18, 39);
                graphics.setColor(Color.red);
                graphics.drawString("IMMOBILE", 17, 38);
            } else if (!this.entity.isImmobile() && this.entity.isProne()) {
                graphics.setColor(Color.darkGray);
                graphics.drawString("PRONE", 26, 39);
                graphics.setColor(Color.yellow);
                graphics.drawString("PRONE", 25, 38);
            } else if (this.entity.isImmobile() && this.entity.isProne()) {
                graphics.setColor(Color.darkGray);
                graphics.drawString("IMMOBILE", 18, 35);
                graphics.drawString("PRONE", 26, 48);
                graphics.setColor(Color.red);
                graphics.drawString("IMMOBILE", 17, 34);
                graphics.setColor(Color.yellow);
                graphics.drawString("PRONE", 25, 47);
            }
            n = 23;
            int n2 = 0;
            double d = 0.0;
            d = this.entity.getArmorRemainingPercent();
            n2 = (int)((double)n * d);
            graphics.setColor(Color.darkGray);
            graphics.fillRect(56, 7, 23, 3);
            graphics.setColor(Color.lightGray);
            graphics.fillRect(55, 6, 23, 3);
            graphics.setColor(this.getStatusBarColor(d));
            graphics.fillRect(55, 6, n2, 3);
            d = this.entity.getInternalRemainingPercent();
            n2 = (int)((double)n * d);
            graphics.setColor(Color.darkGray);
            graphics.fillRect(56, 11, 23, 3);
            graphics.setColor(Color.lightGray);
            graphics.fillRect(55, 10, 23, 3);
            graphics.setColor(this.getStatusBarColor(d));
            graphics.fillRect(55, 10, n2, 3);
            this.image = BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281)));
        }

        private Color getStatusBarColor(double d) {
            if (d <= 0.25) {
                return Color.red;
            }
            if (d <= 0.75) {
                return Color.yellow;
            }
            return new Color(16, 196, 16);
        }

        public boolean isInside(Point point) {
            return this.entityRect.contains(point.x + ((BoardView1)BoardView1.this).view.x - ((BoardView1)BoardView1.this).offset.x, point.y + ((BoardView1)BoardView1.this).view.y - ((BoardView1)BoardView1.this).offset.y);
        }

        private String[] getTooltip() {
            String[] stringArray = new String[]{this.entity.getChassis() + " (" + this.entity.getOwner().getName() + "); " + this.entity.getCrew().getGunnery() + "/" + this.entity.getCrew().getPiloting() + " pilot", "Move " + this.entity.getMovementAbbr(this.entity.moved) + ":" + this.entity.delta_distance + " (+" + Compute.getTargetMovementModifier(BoardView1.this.game, this.entity.getId()).getValue() + ");" + " Heat " + this.entity.heat, "Armor " + this.entity.getTotalArmor() + "; Internal " + this.entity.getTotalInternal()};
            return stringArray;
        }
    }

    private class CursorSprite
    extends Sprite {
        private Color color;

        public CursorSprite(Color color) {
            this.color = color;
            this.bounds = new Rectangle(((BoardView1)BoardView1.this).hexPoly.getBounds().width + 1, ((BoardView1)BoardView1.this).hexPoly.getBounds().height + 1);
            this.image = null;
            this.bounds.setLocation(-100, -100);
        }

        public void prepare() {
            Image image = BoardView1.this.createImage(this.bounds.width, this.bounds.height);
            Graphics graphics = image.getGraphics();
            graphics.setColor(new Color(-65281));
            graphics.fillRect(0, 0, this.bounds.width, this.bounds.height);
            graphics.setColor(this.color);
            graphics.drawPolygon(BoardView1.this.hexPoly);
            this.image = BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281)));
        }

        public void setLocation(int n, int n2) {
            this.bounds.setLocation(n, n2);
        }

        public void setLocation(Point point) {
            this.bounds.setLocation(point);
        }
    }

    private abstract class Sprite
    implements ImageObserver {
        protected Rectangle bounds;
        protected Image image;

        private Sprite() {
        }

        public abstract void prepare();

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (n == 32) {
                this.prepare();
                BoardView1.this.repaint();
                return false;
            }
            return true;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public boolean isReady() {
            return this.image != null;
        }

        public void drawOnto(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
            if (this.isReady()) {
                graphics.drawImage(this.image, n, n2, imageObserver);
            } else {
                this.prepare();
            }
        }

        public boolean isInside(Point point) {
            return this.bounds.contains(point);
        }

        private String[] getTooltip() {
            return null;
        }
    }

    private class TooltipCanvas
    extends Canvas {
        private String[] tipStrings;
        private Dimension size;

        public TooltipCanvas(String[] stringArray) {
            this.tipStrings = stringArray;
            this.setFont(new Font("SansSerif", 0, 12));
            this.setBackground(SystemColor.info);
            this.setForeground(SystemColor.infoText);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (fontMetrics.stringWidth(stringArray[n2]) > n) {
                    n = fontMetrics.stringWidth(stringArray[n2]);
                }
                ++n2;
            }
            this.size = new Dimension(n + 5, fontMetrics.getAscent() * stringArray.length + 4);
            this.setSize(this.size);
        }

        public void paint(Graphics graphics) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.size.width, this.size.height);
            graphics.setColor(this.getForeground());
            graphics.drawRect(0, 0, this.size.width - 1, this.size.height - 1);
            int n = 0;
            while (n < this.tipStrings.length) {
                graphics.drawString(this.tipStrings[n], 2, (n + 1) * fontMetrics.getAscent());
                ++n;
            }
        }
    }
}

