/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import megamek.client.AbstractPhaseDisplay;
import megamek.client.ChatterBox;
import megamek.client.Client;
import megamek.client.CustomMechDialog;
import megamek.client.GameEvent;
import megamek.client.GameListener;
import megamek.common.BoardListener;
import megamek.common.Entity;
import megamek.common.Player;

public class ChatLounge
extends AbstractPhaseDisplay
implements ActionListener,
ItemListener,
BoardListener,
GameListener {
    private static final String[] startNames = new String[]{"Any", "NW", "N", "NE", "E", "SE", "S", "SW", "W"};
    private Client client;
    private Panel panPlayerInfo;
    private Label labPlayerInfo;
    private List lisPlayerInfo;
    private Label labColor;
    private Label labTeam;
    private Choice choColor;
    private Choice choTeam;
    private Button butOptions;
    private Label labBoardSize;
    private Label labMapSize;
    private List lisBoardsSelected;
    private Button butChangeBoard;
    private Panel panBoardSettings;
    private Button butLoad;
    private Button butDelete;
    private Button butCustom;
    private List lisEntities;
    private int[] entityCorrespondance;
    private Panel panEntities;
    private Label labStarts;
    private List lisStarts;
    private Panel panStarts;
    private Button butChangeStart;
    private Label labBVs;
    private List lisBVs;
    private CheckboxGroup bvCbg;
    private Checkbox chkBV;
    private Checkbox chkTons;
    private Panel panBVs;
    private Panel panMain;
    private Panel panUnits;
    private Panel panTop;
    private Label labStatus;
    private Button butReady;

    public ChatLounge(Client client) {
        this.client = client;
        client.addGameListener(this);
        client.game.board.addBoardListener(this);
        ChatterBox chatterBox = client.cb;
        this.butOptions = new Button("Game Options...");
        this.butOptions.addActionListener(this);
        this.setupPlayerInfo();
        this.setupBoardSettings();
        this.refreshGameSettings();
        this.setupEntities();
        this.refreshEntities();
        this.setupBVs();
        this.refreshBVs();
        this.setupStarts();
        this.refreshStarts();
        this.setupMainPanel();
        this.labStatus = new Label("", 1);
        this.butReady = new Button("I'm Ready.");
        this.butReady.setActionCommand("ready");
        this.butReady.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.panMain, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.labStatus, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(client.cb.getComponent(), gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.butReady, gridBagLayout, gridBagConstraints);
        this.validate();
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void setupPlayerInfo() {
        this.panPlayerInfo = new Panel();
        this.labPlayerInfo = new Label("Player Setup");
        this.lisPlayerInfo = new List(5);
        this.labColor = new Label("Color:", 2);
        this.labTeam = new Label("Team:", 2);
        this.choColor = new Choice();
        this.choColor.addItemListener(this);
        this.setupColors();
        this.choTeam = new Choice();
        this.choTeam.addItemListener(this);
        this.setupTeams();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panPlayerInfo.setLayout(gridBagLayout);
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labPlayerInfo, gridBagConstraints);
        this.panPlayerInfo.add(this.labPlayerInfo);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.lisPlayerInfo, gridBagConstraints);
        this.panPlayerInfo.add(this.lisPlayerInfo);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.labColor, gridBagConstraints);
        this.panPlayerInfo.add(this.labColor);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.choColor, gridBagConstraints);
        this.panPlayerInfo.add(this.choColor);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.labTeam, gridBagConstraints);
        this.panPlayerInfo.add(this.labTeam);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.choTeam, gridBagConstraints);
        this.panPlayerInfo.add(this.choTeam);
        this.refreshPlayerInfo();
    }

    private void setupBoardSettings() {
        this.labBoardSize = new Label("Board Size: # x # hexes", 1);
        this.labMapSize = new Label("Map Size: # x # boards", 1);
        this.lisBoardsSelected = new List(5);
        this.lisBoardsSelected.addActionListener(this);
        this.butChangeBoard = new Button("Edit / View Map...");
        this.butChangeBoard.setActionCommand("change_board");
        this.butChangeBoard.addActionListener(this);
        this.panBoardSettings = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panBoardSettings.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labBoardSize, gridBagConstraints);
        this.panBoardSettings.add(this.labBoardSize);
        gridBagLayout.setConstraints(this.labMapSize, gridBagConstraints);
        this.panBoardSettings.add(this.labMapSize);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.lisBoardsSelected, gridBagConstraints);
        this.panBoardSettings.add(this.lisBoardsSelected);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.butChangeBoard, gridBagConstraints);
        this.panBoardSettings.add(this.butChangeBoard);
        this.refreshBoardSettings();
    }

    private void refreshBoardSettings() {
        this.labBoardSize.setText("Board Size: " + this.client.getMapSettings().getBoardWidth() + " x " + this.client.getMapSettings().getBoardHeight() + " hexes");
        this.labMapSize.setText("Map Size: " + this.client.getMapSettings().getMapWidth() + " x " + this.client.getMapSettings().getMapHeight() + " boards");
        this.lisBoardsSelected.removeAll();
        int n = 0;
        Enumeration enumeration = this.client.getMapSettings().getBoardsSelected();
        while (enumeration.hasMoreElements()) {
            this.lisBoardsSelected.add(n++ + ": " + (String)enumeration.nextElement());
        }
    }

    private void setupMainPanel() {
        this.panUnits = new Panel(new BorderLayout());
        this.panUnits.add((Component)this.panEntities, "Center");
        this.panUnits.add((Component)this.panBVs, "East");
        this.setupTop();
        this.panMain = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panMain.setLayout(gridBagLayout);
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butOptions, gridBagConstraints);
        this.panMain.add(this.butOptions);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.panTop, gridBagConstraints);
        this.panMain.add(this.panTop);
        gridBagLayout.setConstraints(this.panUnits, gridBagConstraints);
        this.panMain.add(this.panUnits);
    }

    private void setupTop() {
        this.panTop = new Panel(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panTop.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.panBoardSettings, gridBagConstraints);
        this.panTop.add(this.panBoardSettings);
        gridBagLayout.setConstraints(this.panStarts, gridBagConstraints);
        this.panTop.add(this.panStarts);
        gridBagLayout.setConstraints(this.panPlayerInfo, gridBagConstraints);
        this.panTop.add(this.panPlayerInfo);
    }

    private void setupEntities() {
        this.lisEntities = new List(10);
        this.lisEntities.addActionListener(this);
        this.lisEntities.addItemListener(this);
        this.butLoad = new Button("Add A Mech...");
        this.butLoad.setActionCommand("load_mech");
        this.butLoad.addActionListener(this);
        this.butCustom = new Button("Configure / View Mech Info...");
        this.butCustom.setActionCommand("custom_mech");
        this.butCustom.addActionListener(this);
        this.butCustom.setEnabled(false);
        this.butDelete = new Button("Delete Mech");
        this.butDelete.setActionCommand("delete_mech");
        this.butDelete.addActionListener(this);
        this.butDelete.setEnabled(false);
        this.panEntities = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panEntities.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.lisEntities, gridBagConstraints);
        this.panEntities.add(this.lisEntities);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butLoad, gridBagConstraints);
        this.panEntities.add(this.butLoad);
        gridBagLayout.setConstraints(this.butCustom, gridBagConstraints);
        this.panEntities.add(this.butCustom);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butDelete, gridBagConstraints);
        this.panEntities.add(this.butDelete);
    }

    private void setupBVs() {
        this.labBVs = new Label("Total Battle Values", 1);
        this.lisBVs = new List(5);
        this.panBVs = new Panel();
        this.bvCbg = new CheckboxGroup();
        this.chkBV = new Checkbox("BV", this.bvCbg, true);
        this.chkBV.addItemListener(this);
        this.chkTons = new Checkbox("Tons", this.bvCbg, false);
        this.chkTons.addItemListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panBVs.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labBVs, gridBagConstraints);
        this.panBVs.add(this.labBVs);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.lisBVs, gridBagConstraints);
        this.panBVs.add(this.lisBVs);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.lisBVs, gridBagConstraints);
        this.panBVs.add(this.chkBV);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.lisBVs, gridBagConstraints);
        this.panBVs.add(this.chkTons);
    }

    private void setupStarts() {
        this.labStarts = new Label("Starting Positions", 1);
        this.lisStarts = new List(5);
        this.lisStarts.addActionListener(this);
        this.butChangeStart = new Button("Change Start...");
        this.butChangeStart.addActionListener(this);
        this.panStarts = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panStarts.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labStarts, gridBagConstraints);
        this.panStarts.add(this.labStarts);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.lisStarts, gridBagConstraints);
        this.panStarts.add(this.lisStarts);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.butChangeStart, gridBagConstraints);
        this.panStarts.add(this.butChangeStart);
    }

    private void refreshGameSettings() {
    }

    private void refreshEntities() {
        this.lisEntities.removeAll();
        int n = 0;
        String string = "";
        String string2 = "";
        this.entityCorrespondance = new int[this.client.game.getNoOfEntities()];
        Enumeration enumeration = this.client.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.hasC3i()) {
                string = "";
                if (entity.calculateFreeC3Nodes() == 5) {
                    string = "**";
                }
                string2 = " (" + entity.getC3NetID() + ")";
            } else if (entity.hasC3()) {
                if (entity.getC3Master() == null) {
                    string = entity.hasC3S() ? "***" : "*";
                    string2 = "";
                } else {
                    string = "";
                    if (!entity.C3MasterIs(entity)) {
                        string = ">";
                        if (entity.getC3Master().getC3Master() != null && !entity.getC3Master().C3MasterIs(entity.getC3Master())) {
                            string = ">>";
                        }
                        string2 = " -> " + entity.getC3Master().getDisplayName();
                    }
                }
            } else {
                string = "";
                string2 = "";
            }
            this.lisEntities.add(string + entity.getDisplayName() + " (" + entity.getCrew().getGunnery() + "/" + entity.getCrew().getPiloting() + " pilot)" + " BV=" + entity.calculateBattleValue() + string2);
            this.entityCorrespondance[n++] = entity.getId();
        }
    }

    private void refreshPlayerInfo() {
        this.lisPlayerInfo.removeAll();
        Enumeration enumeration = this.client.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" : ");
            stringBuffer.append(Player.colorNames[player.getColorIndex()]).append(", ");
            stringBuffer.append(Player.teamNames[player.getTeam()]);
            this.lisPlayerInfo.add(stringBuffer.toString());
        }
    }

    private void refreshBVs() {
        boolean bl = this.chkBV.getState();
        this.lisBVs.removeAll();
        Enumeration enumeration = this.client.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player == null) continue;
            float f = 0.0f;
            Enumeration enumeration2 = this.client.getEntities();
            while (enumeration2.hasMoreElements()) {
                Entity entity = (Entity)enumeration2.nextElement();
                if (!entity.getOwner().equals(player)) continue;
                if (bl) {
                    f += (float)entity.calculateBattleValue();
                    continue;
                }
                f += entity.getWeight();
            }
            if (bl) {
                this.lisBVs.add(player.getName() + " BV=" + (int)f);
                continue;
            }
            this.lisBVs.add(player.getName() + " Tons=" + f);
        }
    }

    private void refreshStarts() {
        this.lisStarts.removeAll();
        Enumeration enumeration = this.client.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" : ");
            stringBuffer.append(startNames[player.getStartingPos()]);
            this.lisStarts.add(stringBuffer.toString());
        }
    }

    private void setupColors() {
        this.choColor.removeAll();
        int n = 0;
        while (n < Player.colorNames.length) {
            this.choColor.add(Player.colorNames[n]);
            ++n;
        }
        this.choColor.select(Player.colorNames[this.client.getLocalPlayer().getColorIndex()]);
    }

    private void refreshColors() {
        this.choColor.select(Player.colorNames[this.client.getLocalPlayer().getColorIndex()]);
    }

    private void setupTeams() {
        this.choTeam.removeAll();
        int n = 0;
        while (n < Player.MAX_TEAMS) {
            this.choTeam.add(Player.teamNames[n]);
            ++n;
        }
        this.choTeam.select(this.client.getLocalPlayer().getTeam());
    }

    private void refreshTeams() {
        this.choTeam.select(this.client.getLocalPlayer().getTeam());
    }

    private void refreshReadyButton() {
        this.butReady.setLabel(this.client.getLocalPlayer().isReady() ? "Cancel Ready" : "I'm Ready.");
    }

    public void changeColor(int n) {
        if (this.client.getLocalPlayer().getColorIndex() != n) {
            this.client.getLocalPlayer().setColorIndex(n);
            this.client.sendPlayerInfo();
        }
    }

    public void changeTeam(int n) {
        if (this.client.getLocalPlayer().getTeam() != n) {
            this.client.getLocalPlayer().setTeam(n);
            this.client.sendPlayerInfo();
        }
    }

    public void customizeMech() {
        if (this.lisEntities.getSelectedIndex() == -1) {
            return;
        }
        Entity entity = this.client.game.getEntity(this.entityCorrespondance[this.lisEntities.getSelectedIndex()]);
        boolean bl = entity.getOwnerId() == this.client.getLocalPlayer().getId();
        CustomMechDialog customMechDialog = new CustomMechDialog(this.client, entity, bl);
        customMechDialog.show();
        if (bl && customMechDialog.isOkay()) {
            this.client.sendUpdateEntity(entity);
        }
    }

    public void loadMech() {
        this.client.getMechSelectorDialog().show();
    }

    public void gamePlayerStatusChange(GameEvent gameEvent) {
        this.refreshReadyButton();
        this.refreshBVs();
        this.refreshPlayerInfo();
        this.refreshStarts();
        this.refreshColors();
    }

    public void gamePhaseChange(GameEvent gameEvent) {
        if (this.client.game.phase != 1) {
            this.client.removeGameListener(this);
            this.client.game.board.removeBoardListener(this);
        }
    }

    public void gameNewEntities(GameEvent gameEvent) {
        this.refreshEntities();
        this.refreshBVs();
    }

    public void gameNewSettings(GameEvent gameEvent) {
        this.refreshGameSettings();
        this.refreshBoardSettings();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.choColor) {
            this.changeColor(this.choColor.getSelectedIndex());
        } else if (itemEvent.getSource() == this.choTeam) {
            this.changeTeam(this.choTeam.getSelectedIndex());
        } else if (itemEvent.getSource() == this.chkBV || itemEvent.getSource() == this.chkTons) {
            this.refreshBVs();
        } else if (itemEvent.getSource() == this.lisEntities) {
            boolean bl = this.lisEntities.getSelectedIndex() != -1;
            this.butCustom.setEnabled(bl);
            this.butDelete.setEnabled(bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butReady) {
            this.client.sendReady(!this.client.getLocalPlayer().isReady());
            this.refreshReadyButton();
        } else if (actionEvent.getSource() == this.butLoad) {
            this.loadMech();
        } else if (actionEvent.getSource() == this.butCustom || actionEvent.getSource() == this.lisEntities) {
            this.customizeMech();
        } else if (actionEvent.getSource() == this.butDelete) {
            if (this.lisEntities.getSelectedIndex() != -1) {
                this.client.sendDeleteEntity(this.entityCorrespondance[this.lisEntities.getSelectedIndex()]);
            }
        } else if (actionEvent.getSource() == this.butChangeBoard || actionEvent.getSource() == this.lisBoardsSelected) {
            this.client.getBoardSelectionDialog().update(this.client.getMapSettings(), true);
            this.client.getBoardSelectionDialog().show();
        } else if (actionEvent.getSource() == this.butOptions) {
            this.client.getGameOptionsDialog().update(this.client.game.getOptions());
            this.client.getGameOptionsDialog().show();
        } else if (actionEvent.getSource() == this.butChangeStart || actionEvent.getSource() == this.lisStarts) {
            this.client.getStartingPositionDialog().update();
            this.client.getStartingPositionDialog().show();
        }
    }
}

