/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot.ga;

import java.util.Date;
import megamek.client.bot.ga.Chromosome;

public abstract class GA
implements Runnable {
    double mutationProb;
    int maxGenerations;
    int numPrelimRuns;
    int maxPrelimGenerations;
    int randomSelectionChance;
    double crossoverProb;
    protected int chromosomeDim;
    protected int populationDim;
    public Chromosome[] chromosomes;
    Chromosome[] chromNextGen;
    Chromosome[] prelimChrom;
    public int bestFitnessChromIndex;
    int worstFitnessChromIndex;
    protected int crossoverType;
    double[] genAvgDeviation;
    double[] genAvgFitness;
    boolean computeStatistics;
    boolean verbose;

    protected abstract void initPopulation();

    protected abstract void doRandomMutation(int var1);

    protected abstract void doUniformCrossover(Chromosome var1, Chromosome var2);

    protected abstract double getFitness(int var1);

    protected abstract Chromosome getNewChrom(int var1);

    protected void doHeuristicPass() {
    }

    public void run() {
        this.evolve();
    }

    public GA(int n, int n2, double d, int n3, int n4, int n5, int n6, double d2, int n7, boolean bl, boolean bl2) {
        this.randomSelectionChance = n3;
        this.crossoverType = n7;
        this.chromosomeDim = n;
        this.populationDim = n2;
        this.computeStatistics = bl;
        this.verbose = bl2;
        this.chromosomes = new Chromosome[n2];
        this.chromNextGen = new Chromosome[n2];
        this.prelimChrom = new Chromosome[n2];
        this.genAvgDeviation = new double[n4];
        this.genAvgFitness = new double[n4];
        this.crossoverProb = d;
        this.maxGenerations = n4;
        this.numPrelimRuns = n5;
        this.maxPrelimGenerations = n6;
        this.mutationProb = d2;
        int n8 = 0;
        while (n8 < n2) {
            this.chromosomes[n8] = this.getNewChrom(n);
            this.chromNextGen[n8] = this.getNewChrom(n);
            this.prelimChrom[n8] = this.getNewChrom(n);
            ++n8;
        }
    }

    public double getAvgFitness(int n) {
        return this.genAvgFitness[n];
    }

    public double getMutationProb() {
        return this.mutationProb;
    }

    public int getMaxGenerations() {
        return this.maxGenerations;
    }

    public int getNumPrelimRuns() {
        return this.numPrelimRuns;
    }

    public int getMaxPrelimGenerations() {
        return this.maxPrelimGenerations;
    }

    public int getRandomSelectionChance() {
        return this.randomSelectionChance;
    }

    public double getCrossoverProb() {
        return this.crossoverProb;
    }

    public int getChromosomeDim() {
        return this.chromosomeDim;
    }

    public int getPopulationDim() {
        return this.populationDim;
    }

    public int getCrossoverType() {
        return this.crossoverType;
    }

    public boolean getComputeStatistics() {
        return this.computeStatistics;
    }

    public String getFittestChromosome() {
        return this.chromosomes[this.bestFitnessChromIndex].getGenesAsStr();
    }

    public double getFittestChromosomesFitness() {
        return this.chromosomes[this.bestFitnessChromIndex].fitness;
    }

    int getRandom(int n) {
        int n2 = (int)(Math.random() * (double)n);
        return n2;
    }

    double getRandom(double d) {
        double d2 = Math.random() * d;
        return d2;
    }

    public void log(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    protected boolean shouldDoExhaustive() {
        return false;
    }

    protected void doExhaustiveSearch() {
    }

    public int evolve() {
        if (this.shouldDoExhaustive()) {
            this.doExhaustiveSearch();
            return 0;
        }
        this.log("GA start time: " + new Date().toString());
        int n = 0;
        boolean bl = false;
        while (n < this.maxGenerations && !bl) {
            this.computeFitnessRankings();
            this.doGeneticMating();
            this.copyNextGenToThisGen();
            if (this.computeStatistics) {
                this.genAvgFitness[n] = this.getAvgFitness();
            }
            if (n != 0 && n % 5 == 0) {
                this.doHeuristicPass();
            }
            if (n > 5 && this.getESquared() - this.genAvgFitness[n] * this.genAvgFitness[n] < 0.2 * this.genAvgFitness[n] && this.genAvgFitness[n] - this.genAvgFitness[n - 1] <= 0.0) {
                bl = true;
            }
            ++n;
        }
        this.log("GEN " + (n + 1) + " AVG FITNESS = " + this.getAvgFitness());
        this.addChromosomesToLog(n, 10);
        this.computeFitnessRankings();
        this.log("Best Chromosome Found: ");
        this.log(this.chromosomes[this.bestFitnessChromIndex].getGenesAsStr() + " Fitness= " + this.chromosomes[this.bestFitnessChromIndex].fitness);
        this.log("GA end time: " + new Date().toString());
        return n;
    }

    public double getAvgFitness() {
        double d = 0.0;
        int n = 0;
        while (n < this.populationDim) {
            d += this.chromosomes[n].fitness;
            ++n;
        }
        return d / (double)this.populationDim;
    }

    public double getESquared() {
        double d = 0.0;
        int n = 0;
        while (n < this.populationDim) {
            d += this.chromosomes[n].fitness * this.chromosomes[n].fitness;
            ++n;
        }
        return d / (double)this.populationDim;
    }

    public void selectTwoParents(int[] nArray) {
        int n;
        int n2 = nArray[0];
        int n3 = nArray[1];
        boolean bl = false;
        while (!bl) {
            n = this.getRandom(this.populationDim);
            if (this.randomSelectionChance > this.getRandom(100)) {
                n2 = n;
                bl = true;
                continue;
            }
            if (this.chromosomes[n].fitnessRank + 1 <= this.getRandom(this.populationDim)) continue;
            n2 = n;
            bl = true;
        }
        bl = false;
        while (!bl) {
            n = this.getRandom(this.populationDim);
            if (this.randomSelectionChance > this.getRandom(100)) {
                if (n == n2) continue;
                n3 = n;
                bl = true;
                continue;
            }
            if (n == n2 || this.chromosomes[n].fitnessRank + 1 <= this.getRandom(this.populationDim)) continue;
            n3 = n;
            bl = true;
        }
        nArray[0] = n2;
        nArray[1] = n3;
    }

    int getFitnessRank(double d) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.populationDim) {
            if (d >= this.chromosomes[n2].fitness) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    void computeFitnessRankings() {
        int n = 0;
        while (n < this.populationDim) {
            this.chromosomes[n].fitness = this.getFitness(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.populationDim) {
            this.chromosomes[n2].fitnessRank = this.getFitnessRank(this.chromosomes[n2].fitness);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.populationDim) {
            if (this.chromosomes[n3].fitnessRank == this.populationDim - 1) {
                double d = this.chromosomes[n3].fitness;
                this.bestFitnessChromIndex = n3;
            }
            if (this.chromosomes[n3].fitnessRank == 0) {
                double d = this.chromosomes[n3].fitness;
                this.worstFitnessChromIndex = n3;
            }
            ++n3;
        }
    }

    void doGeneticMating() {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        this.chromNextGen[n3].copyChromGenes(this.chromosomes[this.bestFitnessChromIndex]);
        this.chromNextGen[++n3].copyChromGenes(this.chromosomes[this.bestFitnessChromIndex]);
        ++n3;
        Chromosome chromosome = this.getNewChrom(this.chromosomeDim);
        Chromosome chromosome2 = this.getNewChrom(this.chromosomeDim);
        do {
            int[] nArray = new int[]{n, n2};
            this.selectTwoParents(nArray);
            n = nArray[0];
            n2 = nArray[1];
            chromosome.copyChromGenes(this.chromosomes[n]);
            chromosome2.copyChromGenes(this.chromosomes[n2]);
            if (this.getRandom(1.0) < this.crossoverProb) {
                this.doUniformCrossover(chromosome, chromosome2);
                this.chromNextGen[n3].copyChromGenes(chromosome);
                this.chromNextGen[++n3].copyChromGenes(chromosome2);
                ++n3;
                continue;
            }
            this.chromNextGen[n3].copyChromGenes(chromosome);
            this.chromNextGen[++n3].copyChromGenes(chromosome2);
            ++n3;
        } while (n3 < this.populationDim);
    }

    void copyNextGenToThisGen() {
        int n = 0;
        while (n < this.populationDim) {
            this.chromosomes[n].copyChromGenes(this.chromNextGen[n]);
            if (n != this.bestFitnessChromIndex && (n == this.worstFitnessChromIndex || this.getRandom(1.0) < this.mutationProb)) {
                this.doRandomMutation(n);
            }
            ++n;
        }
    }

    void addChromosomesToLog(int n, int n2) {
        if (!this.verbose) {
            return;
        }
        if (n2 > this.populationDim) {
            n2 = this.chromosomeDim;
        }
        int n3 = 0;
        while (n3 < n2) {
            String string;
            this.chromosomes[n3].fitness = this.getFitness(n3);
            String string2 = "" + n;
            if (string2.length() < 2) {
                string2 = string2 + " ";
            }
            if ((string = "" + n3).length() < 2) {
                string = string + " ";
            }
            System.out.println("Gen " + string2 + ": Chrom" + string + " = " + this.chromosomes[n3].getGenesAsStr() + ", fitness = " + this.chromosomes[n3].fitness);
            ++n3;
        }
    }

    long binaryStrToInt(String string) {
        long l = 0L;
        int n = string.length();
        int n2 = n - 1;
        while (n2 >= 0) {
            long l2 = string.charAt(n2) == '1' ? 1L : 0L;
            l += l2 << n - n2 - 1;
            --n2;
        }
        return l;
    }
}

