/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import com.sun.java.util.collections.Vector;
import java.io.InputStream;
import megamek.common.BipedMech;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EntityLoadingException;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.Mech;
import megamek.common.MechLoader;
import megamek.common.QuadMech;
import megamek.common.util.BuildingBlock;

public class BLKMechFile
implements MechLoader {
    public static final int HD = 0;
    public static final int LA = 1;
    public static final int LF = 2;
    public static final int LB = 3;
    public static final int CF = 4;
    public static final int CB = 5;
    public static final int RF = 6;
    public static final int RB = 7;
    public static final int RA = 8;
    public static final int LL = 9;
    public static final int RL = 10;
    public static final int CT = 4;
    public static final int RT = 6;
    public static final int LT = 2;
    BuildingBlock dataFile;

    public BLKMechFile(InputStream inputStream) {
        this.dataFile = new BuildingBlock(inputStream);
    }

    public BLKMechFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public boolean isMine() {
        return this.dataFile.exists("blockversion");
    }

    public Entity getEntity() throws EntityLoadingException {
        int n = 0;
        n = !this.dataFile.exists("chassis_type") ? 0 : this.dataFile.getDataAsInt("chassis_type")[0];
        Mech mech = null;
        mech = n == 1 ? new QuadMech() : new BipedMech();
        if (!this.dataFile.exists("name")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (!this.dataFile.exists("model")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.setModel(this.dataFile.getDataAsString("Model")[0]);
        if (!this.dataFile.exists("year")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.setYear(this.dataFile.getDataAsInt("year")[0]);
        if (!this.dataFile.exists("type")) {
            throw new EntityLoadingException("Could not find block.");
        }
        if (this.dataFile.getDataAsString("type")[0].equals("IS")) {
            if (mech.getYear() == 3025) {
                mech.setTechLevel(0);
            } else {
                mech.setTechLevel(1);
            }
        } else {
            mech.setTechLevel(2);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.weight = this.dataFile.getDataAsFloat("tonnage")[0];
        if (!this.dataFile.exists("walkingMP")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.setOriginalWalkMP(this.dataFile.getDataAsInt("walkingMP")[0]);
        if (!this.dataFile.exists("jumpingMP")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.setOriginalJumpMP(this.dataFile.getDataAsInt("jumpingMP")[0]);
        if (!this.dataFile.exists("heatsinks")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.addEngineSinks(this.dataFile.getDataAsInt("heatsinks")[0], false);
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find block.");
        }
        int[] nArray = new int[11];
        if (this.dataFile.getDataAsInt("armor").length < 11) {
            System.err.println("BLKMechFile->Read armor array doesn't match my armor array...");
            throw new EntityLoadingException("Could not find block.");
        }
        nArray = this.dataFile.getDataAsInt("Armor");
        mech.initializeArmor(nArray[0], 0);
        mech.initializeArmor(nArray[1], 5);
        mech.initializeArmor(nArray[8], 4);
        mech.initializeArmor(nArray[9], 7);
        mech.initializeArmor(nArray[10], 6);
        mech.initializeArmor(nArray[4], 1);
        mech.initializeArmor(nArray[2], 3);
        mech.initializeArmor(nArray[6], 2);
        mech.initializeRearArmor(nArray[5], 1);
        mech.initializeRearArmor(nArray[3], 3);
        mech.initializeRearArmor(nArray[7], 2);
        if (!this.dataFile.exists("internal armor")) {
            mech.setInternal(3, (nArray[4] + nArray[5]) / 2, (nArray[2] + nArray[3]) / 2, nArray[1] / 2, nArray[9] / 2);
        } else {
            nArray = this.dataFile.getDataAsInt("internal armor");
            mech.setInternal(nArray[0], nArray[4], nArray[2], nArray[1], nArray[9]);
        }
        if (!this.dataFile.getDataAsString("ra criticals")[2].trim().equalsIgnoreCase("Lower Arm Actuator")) {
            mech.removeCriticals(4, new CriticalSlot(0, 9));
        }
        if (!this.dataFile.getDataAsString("ra criticals")[3].trim().equalsIgnoreCase("Hand Actuator")) {
            mech.removeCriticals(4, new CriticalSlot(0, 10));
        }
        if (!this.dataFile.getDataAsString("la criticals")[2].trim().equalsIgnoreCase("Lower Arm Actuator")) {
            mech.removeCriticals(5, new CriticalSlot(0, 9));
        }
        if (!this.dataFile.getDataAsString("la criticals")[3].trim().equalsIgnoreCase("Hand Actuator")) {
            mech.removeCriticals(5, new CriticalSlot(0, 10));
        }
        Vector[] vectorArray = new Vector[8];
        vectorArray[0] = this.dataFile.getDataAsVector("hd criticals");
        vectorArray[5] = this.dataFile.getDataAsVector("la criticals");
        vectorArray[4] = this.dataFile.getDataAsVector("ra criticals");
        vectorArray[7] = this.dataFile.getDataAsVector("ll criticals");
        vectorArray[6] = this.dataFile.getDataAsVector("rl criticals");
        vectorArray[3] = this.dataFile.getDataAsVector("lt criticals");
        vectorArray[2] = this.dataFile.getDataAsVector("rt criticals");
        vectorArray[1] = this.dataFile.getDataAsVector("ct criticals");
        String string = mech.getTechLevel() == 2 ? "Clan " : "IS ";
        int n2 = 0;
        while (n2 < vectorArray.length) {
            int n3 = 0;
            while (n3 < vectorArray[n2].size()) {
                EquipmentType equipmentType;
                String string2 = vectorArray[n2].get(n3).toString().trim();
                boolean bl = false;
                if (string2.startsWith("(R) ")) {
                    bl = true;
                    string2 = string2.substring(4);
                }
                if ((equipmentType = EquipmentType.getByMtfName(string2)) == null) {
                    equipmentType = EquipmentType.getByMepName(string2);
                }
                if (equipmentType == null) {
                    equipmentType = EquipmentType.getByMepName(string + string2);
                }
                if (equipmentType != null) {
                    try {
                        mech.addEquipment(equipmentType, n2, bl);
                    }
                    catch (LocationFullException locationFullException) {
                        throw new EntityLoadingException(locationFullException.getMessage());
                    }
                }
                ++n3;
            }
            ++n2;
        }
        if (mech.isClan()) {
            mech.addClanCase();
        }
        return mech;
    }
}

