/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.InputStream;
import megamek.common.Entity;
import megamek.common.EntityLoadingException;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.MechLoader;
import megamek.common.Tank;
import megamek.common.util.BuildingBlock;

public class BLKTankFile
implements MechLoader {
    BuildingBlock dataFile;
    private static final String[] MOVES = new String[]{"", "", "", "Tracked", "Wheeled", "Hover"};

    public BLKTankFile(InputStream inputStream) {
        this.dataFile = new BuildingBlock(inputStream);
    }

    public BLKTankFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public boolean isMine() {
        return this.dataFile.exists("blockversion");
    }

    public Entity getEntity() throws EntityLoadingException {
        Tank tank = new Tank();
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        tank.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            tank.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            tank.setModel("");
        }
        if (!this.dataFile.exists("year")) {
            throw new EntityLoadingException("Could not find year block.");
        }
        tank.setYear(this.dataFile.getDataAsInt("year")[0]);
        if (!this.dataFile.exists("type")) {
            throw new EntityLoadingException("Could not find type block.");
        }
        if (this.dataFile.getDataAsString("type")[0].equals("IS")) {
            if (tank.getYear() == 3025) {
                tank.setTechLevel(0);
            } else {
                tank.setTechLevel(1);
            }
        } else {
            tank.setTechLevel(2);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        tank.weight = this.dataFile.getDataAsFloat("tonnage")[0];
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n = -1;
        int n2 = 0;
        while (n2 < MOVES.length) {
            if (string.equals(MOVES[n2])) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            throw new EntityLoadingException("Invalid movment type: " + string);
        }
        tank.setMovementType(n);
        if (!this.dataFile.exists("cruiseMP")) {
            throw new EntityLoadingException("Could not find cruiseMP block.");
        }
        tank.setOriginalWalkMP(this.dataFile.getDataAsInt("cruiseMP")[0]);
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length < 4 || nArray.length > 5) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        tank.setHasTurret(nArray.length == 5);
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = 0;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        int n3 = 0;
        while (n3 < nArray2.length) {
            tank.initializeArmor(nArray2[n3], n3);
            ++n3;
        }
        tank.autoSetInternal();
        this.loadEquipment(tank, "Front", 1);
        this.loadEquipment(tank, "Right", 2);
        this.loadEquipment(tank, "Left", 3);
        this.loadEquipment(tank, "Rear", 4);
        if (tank.hasTurret()) {
            this.loadEquipment(tank, "Turret", 5);
        }
        this.loadEquipment(tank, "Body", 0);
        return tank;
    }

    private void loadEquipment(Tank tank, String string, int n) throws EntityLoadingException {
        String[] stringArray = this.dataFile.getDataAsString(string + " Equipment");
        if (stringArray == null) {
            return;
        }
        String string2 = tank.getTechLevel() == 2 ? "Clan " : "IS ";
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2].trim();
            EquipmentType equipmentType = EquipmentType.getByMtfName(string3);
            if (equipmentType == null) {
                equipmentType = EquipmentType.getByMepName(string3);
            }
            if (equipmentType == null) {
                equipmentType = EquipmentType.getByMepName(string2 + string3);
            }
            if (equipmentType != null) {
                try {
                    tank.addEquipment(equipmentType, n);
                }
                catch (LocationFullException locationFullException) {
                    throw new EntityLoadingException(locationFullException.getMessage());
                }
            }
            ++n2;
        }
    }
}

