/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import com.sun.java.util.collections.Random;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.EquipmentType;
import megamek.common.Game;
import megamek.common.Hex;
import megamek.common.HitData;
import megamek.common.LocationFullException;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.WeaponType;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.DisplacementAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.WeaponAttackAction;

public abstract class Entity
implements Serializable {
    public static final Random random = new Random();
    public static final int WEIGHT_LIGHT = 35;
    public static final int WEIGHT_MEDIUM = 55;
    public static final int WEIGHT_HEAVY = 75;
    public static final int WEIGHT_ASSAULT = 100;
    public static final int NONE = -1;
    public static final int MOVE_ILLEGAL = -1;
    public static final int MOVE_NONE = 0;
    public static final int MOVE_WALK = 1;
    public static final int MOVE_RUN = 2;
    public static final int MOVE_JUMP = 3;
    public static final int ARMOR_NA = -1;
    public static final int ARMOR_DOOMED = -2;
    public static final int ARMOR_DESTROYED = -3;
    public static final int LOC_NONE = -1;
    public static final int LOC_DESTROYED = -2;
    protected transient Game game;
    protected int id;
    protected float weight;
    protected boolean omni = false;
    protected String chassis;
    protected String model;
    protected int year;
    protected int techLevel;
    protected String displayName = null;
    protected String shortName = null;
    protected transient Player owner;
    protected int ownerId;
    public Pilot crew = new Pilot();
    protected boolean shutDown = false;
    protected boolean doomed = false;
    protected boolean destroyed = false;
    private Coords position;
    protected int facing = 0;
    protected int sec_facing = 0;
    protected int walkMP = 0;
    protected int jumpMP = 0;
    public boolean ready = false;
    protected boolean prone = false;
    protected boolean findingClub = false;
    protected boolean armsFlipped = false;
    protected boolean unjammingRAC = false;
    protected DisplacementAttackAction displacementAttack = null;
    public int heat = 0;
    public int heatBuildup = 0;
    public int delta_distance = 0;
    public int mpUsed = 0;
    public int moved = 0;
    private int[] armor;
    private int[] internal;
    private int[] orig_armor;
    private int[] orig_internal;
    public int damageThisPhase;
    protected String C3NetIDString = null;
    protected int C3Master = -1;
    protected Vector equipmentList = new Vector();
    protected Vector weaponList = new Vector();
    protected Vector ammoList = new Vector();
    protected Vector miscList = new Vector();
    protected long m_lNarcedBy = 0L;
    protected long m_lPendingNarc = 0L;
    protected CriticalSlot[][] crits;
    protected int movementType = 0;

    public Entity() {
        this.armor = new int[this.locations()];
        this.internal = new int[this.locations()];
        this.orig_armor = new int[this.locations()];
        this.orig_internal = new int[this.locations()];
        this.crits = new CriticalSlot[this.locations()][];
        int n = 0;
        while (n < this.locations()) {
            this.crits[n] = new CriticalSlot[this.getNumberOfCriticals(n)];
            ++n;
        }
        this.setC3NetID(this);
    }

    public void restore() {
        Enumeration enumeration = this.equipmentList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            mounted.restore();
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String string) {
        this.model = string;
    }

    public String getChassis() {
        return this.chassis;
    }

    protected void setChassis(String string) {
        this.chassis = string;
    }

    public int getTechLevel() {
        return this.techLevel;
    }

    protected void setTechLevel(int n) {
        this.techLevel = n;
    }

    public boolean isClan() {
        return this.techLevel == 2;
    }

    public int getYear() {
        return this.year;
    }

    protected void setYear(int n) {
        this.year = n;
    }

    public float getWeight() {
        return this.weight;
    }

    public int getWeightClass() {
        int n = (int)this.getWeight();
        if (n <= 35) {
            return 35;
        }
        if (n <= 55) {
            return 55;
        }
        if (n <= 75) {
            return 75;
        }
        return 100;
    }

    protected void setWeight(float f) {
        this.weight = f;
    }

    public boolean isOmni() {
        return this.omni;
    }

    protected void setOmni(boolean bl) {
        this.omni = bl;
    }

    public abstract int locations();

    public Player getOwner() {
        return this.owner;
    }

    public void setOwner(Player player) {
        this.owner = player;
        this.ownerId = player.getId();
        this.generateDisplayName();
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public boolean isEnemyOf(Entity entity) {
        return this.id != entity.getId() && this.owner.isEnemyOf(entity.getOwner());
    }

    public Pilot getCrew() {
        return this.crew;
    }

    public void setCrew(Pilot pilot) {
        this.crew = pilot;
    }

    public boolean isShutDown() {
        return this.shutDown;
    }

    public void setShutDown(boolean bl) {
        this.shutDown = bl;
    }

    public boolean isDoomed() {
        return this.doomed;
    }

    public void setDoomed(boolean bl) {
        this.doomed = bl;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    public boolean isActive() {
        return !this.shutDown && !this.destroyed && this.getCrew().isActive();
    }

    public boolean isSelectable() {
        return this.ready && this.isActive();
    }

    public boolean isTargetable() {
        return !this.destroyed && !this.doomed && !this.crew.isDead();
    }

    public boolean isProne() {
        return this.prone;
    }

    public void setProne(boolean bl) {
        this.prone = bl;
    }

    public boolean isImmobile() {
        return this.shutDown || this.crew.isUnconcious();
    }

    public boolean isCharging() {
        return this.displacementAttack instanceof ChargeAttackAction;
    }

    public boolean isPushing() {
        return this.displacementAttack instanceof PushAttackAction;
    }

    public boolean isMakingDfa() {
        return this.displacementAttack instanceof DfaAttackAction;
    }

    public boolean hasDisplacementAttack() {
        return this.displacementAttack != null;
    }

    public DisplacementAttackAction getDisplacementAttack() {
        return this.displacementAttack;
    }

    public void setDisplacementAttack(DisplacementAttackAction displacementAttackAction) {
        this.displacementAttack = displacementAttackAction;
    }

    public boolean isTargetOfDisplacementAttack() {
        return this.findTargetedDisplacement() != null;
    }

    public DisplacementAttackAction findTargetedDisplacement() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.hasDisplacementAttack() || entity.getDisplacementAttack().getTargetId() != this.id) continue;
            return entity.getDisplacementAttack();
        }
        return null;
    }

    public boolean isUnjammingRAC() {
        return this.unjammingRAC;
    }

    public void setUnjammingRAC(boolean bl) {
        this.unjammingRAC = bl;
    }

    public boolean isFindingClub() {
        return this.findingClub;
    }

    public void setFindingClub(boolean bl) {
        this.findingClub = bl;
    }

    public void setArmsFlipped(boolean bl) {
        this.armsFlipped = bl;
    }

    public boolean getArmsFlipped() {
        return this.armsFlipped;
    }

    public Coords getPosition() {
        return this.position;
    }

    public void setPosition(Coords coords) {
        this.position = coords;
    }

    public int elevation() {
        Coords coords = this.getPosition();
        if (null == coords) {
            throw new IllegalStateException("Entity #" + this.getId() + "does not know its position.");
        }
        if (!this.game.board.contains(coords)) {
            throw new IllegalStateException("Board does not contain the Coords: " + coords + ".");
        }
        return this.elevationOccupied(this.game.board.getHex(coords));
    }

    public int height() {
        return 0;
    }

    public int absHeight() {
        return this.elevation() + this.height();
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.generateDisplayName();
        }
        return this.displayName;
    }

    private void generateDisplayName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.chassis);
        if (this.model != null && this.model.length() > 0) {
            stringBuffer.append(" ").append(this.model);
        }
        if (this.getOwner() != null) {
            stringBuffer.append(" (").append(this.getOwner().getName()).append(")");
        }
        this.displayName = stringBuffer.toString();
    }

    public String getShortName() {
        if (this.shortName == null) {
            this.generateShortName();
        }
        return this.shortName;
    }

    private void generateShortName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.chassis);
        if (this.model != null && this.model.length() > 0) {
            stringBuffer.append(" ").append(this.model);
        }
        this.shortName = stringBuffer.toString();
    }

    public int getFacing() {
        return this.facing;
    }

    public void setFacing(int n) {
        this.facing = n;
    }

    public int getSecondaryFacing() {
        return this.sec_facing;
    }

    public void setSecondaryFacing(int n) {
        this.sec_facing = n;
    }

    public abstract boolean canChangeSecondaryFacing();

    public abstract boolean isValidSecondaryFacing(int var1);

    public abstract int clipSecondaryFacing(int var1);

    public boolean hasRAC() {
        Enumeration enumeration = this.weaponList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() != 23) continue;
            return true;
        }
        return false;
    }

    public boolean canUnjamRAC() {
        Enumeration enumeration = this.weaponList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() != 23 || !mounted.isJammed()) continue;
            return true;
        }
        return false;
    }

    public boolean canFlipArms() {
        return false;
    }

    public int getOriginalWalkMP() {
        return this.walkMP;
    }

    public void setOriginalWalkMP(int n) {
        this.walkMP = n;
    }

    public int getWalkMP() {
        return Math.max(this.walkMP - this.heat / 5, 0);
    }

    protected int getOriginalRunMP() {
        return (int)Math.ceil((double)this.getOriginalWalkMP() * 1.5);
    }

    public int getRunMP() {
        return (int)Math.ceil((double)this.getWalkMP() * 1.5);
    }

    protected int getOriginalJumpMP() {
        return this.jumpMP;
    }

    public void setOriginalJumpMP(int n) {
        this.jumpMP = n;
    }

    public int getJumpMP() {
        return this.jumpMP;
    }

    public int getJumpMPWithTerrain() {
        return this.jumpMP;
    }

    public int elevationOccupied(Hex hex) {
        return hex.floor();
    }

    public boolean isHexProhibited(Hex hex) {
        return false;
    }

    public abstract String getMovementString(int var1);

    public abstract String getMovementAbbr(int var1);

    public String getLocationName(HitData hitData) {
        return this.getLocationName(hitData.getLocation());
    }

    protected abstract String[] getLocationNames();

    public String getLocationName(int n) {
        String[] stringArray = this.getLocationNames();
        if (null == stringArray || n >= stringArray.length) {
            return "";
        }
        return stringArray[n];
    }

    protected abstract String[] getLocationAbbrs();

    public String getLocationAbbr(HitData hitData) {
        return this.getLocationAbbr(hitData.getLocation()) + (hitData.isRear() && this.hasRearArmor(hitData.getLocation()) ? "R" : "") + (hitData.getEffect() == 1 ? " (critical)" : "");
    }

    public String getLocationAbbr(int n) {
        String[] stringArray = this.getLocationAbbrs();
        if (null == stringArray || n >= stringArray.length) {
            return "";
        }
        return stringArray[n];
    }

    public int getLocationFromAbbr(String string) {
        int n = 0;
        while (n < this.locations()) {
            if (this.getLocationAbbr(n).equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public abstract HitData rollHitLocation(int var1, int var2);

    public abstract HitData getTransferLocation(HitData var1);

    public abstract int getDependentLocation(int var1);

    public abstract boolean hasRearArmor(int var1);

    public int getArmor(int n) {
        return this.getArmor(n, false);
    }

    public int getArmor(HitData hitData) {
        return this.getArmor(hitData.getLocation(), hitData.isRear());
    }

    public int getArmor(int n, boolean bl) {
        return this.armor[n];
    }

    public int getOArmor(int n) {
        return this.getOArmor(n, false);
    }

    public int getOArmor(HitData hitData) {
        return this.getOArmor(hitData.getLocation(), hitData.isRear());
    }

    public int getOArmor(int n, boolean bl) {
        return this.orig_armor[n];
    }

    public void setArmor(int n, HitData hitData) {
        this.setArmor(n, hitData.getLocation(), hitData.isRear());
    }

    public void setArmor(int n, int n2) {
        this.setArmor(n, n2, false);
    }

    public void setArmor(int n, int n2, boolean bl) {
        this.armor[n2] = n;
    }

    public void initializeArmor(int n, int n2) {
        this.orig_armor[n2] = n;
        this.setArmor(n, n2);
    }

    public int getTotalArmor() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.locations()) {
            if (this.getArmor(n2) > 0) {
                n += this.getArmor(n2);
            }
            if (this.hasRearArmor(n2) && this.getArmor(n2, true) > 0) {
                n += this.getArmor(n2, true);
            }
            ++n2;
        }
        return n;
    }

    public int getTotalOArmor() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.locations()) {
            if (this.getOArmor(n2) > 0) {
                n += this.getOArmor(n2);
            }
            if (this.hasRearArmor(n2) && this.getOArmor(n2, true) > 0) {
                n += this.getOArmor(n2, true);
            }
            ++n2;
        }
        return n;
    }

    public double getArmorRemainingPercent() {
        return (double)this.getTotalArmor() / (double)this.getTotalOArmor();
    }

    public int getInternal(HitData hitData) {
        return this.getInternal(hitData.getLocation());
    }

    public int getInternal(int n) {
        return this.internal[n];
    }

    public int getOInternal(HitData hitData) {
        return this.getOInternal(hitData.getLocation());
    }

    public int getOInternal(int n) {
        return this.orig_internal[n];
    }

    public void setInternal(int n, HitData hitData) {
        this.setInternal(n, hitData.getLocation());
    }

    public void setInternal(int n, int n2) {
        this.internal[n2] = n;
    }

    public void initializeInternal(int n, int n2) {
        this.orig_internal[n2] = n;
        this.setInternal(n, n2);
    }

    public abstract void autoSetInternal();

    public int getTotalInternal() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.locations()) {
            if (this.getInternal(n2) > 0) {
                n += this.getInternal(n2);
            }
            ++n2;
        }
        return n;
    }

    public int getTotalOInternal() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.locations()) {
            if (this.getOInternal(n2) > 0) {
                n += this.getOInternal(n2);
            }
            ++n2;
        }
        return n;
    }

    public double getInternalRemainingPercent() {
        return (double)this.getTotalInternal() / (double)this.getTotalOInternal();
    }

    public boolean isLocationDestroyed(int n) {
        return this.getInternal(n) == -3;
    }

    public boolean locationIsLeg(int n) {
        return false;
    }

    public String getArmorString(int n) {
        return this.getArmorString(n, false);
    }

    public String getArmorString(int n, boolean bl) {
        if (this.getArmor(n, bl) == -1) {
            return "N/A";
        }
        if (this.getArmor(n, bl) == -3) {
            return "***";
        }
        return Integer.toString(this.getArmor(n, bl));
    }

    public String getInternalString(int n) {
        if (this.getInternal(n) == -1) {
            return "N/A";
        }
        if (this.getInternal(n) == -3) {
            return "***";
        }
        return Integer.toString(this.getInternal(n));
    }

    public int getHeatFiringModifier() {
        int n = 0;
        if (this.heat >= 8) {
            ++n;
        }
        if (this.heat >= 13) {
            ++n;
        }
        if (this.heat >= 17) {
            ++n;
        }
        if (this.heat >= 24) {
            ++n;
        }
        return n;
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n) throws LocationFullException {
        return this.addEquipment(equipmentType, n, false);
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n, boolean bl) throws LocationFullException {
        Mounted mounted = new Mounted(this, equipmentType);
        this.addEquipment(mounted, n, bl);
        return mounted;
    }

    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        mounted.setLocation(n, bl);
        this.equipmentList.addElement(mounted);
        if (mounted.getType() instanceof WeaponType) {
            this.weaponList.addElement(mounted);
        }
        if (mounted.getType() instanceof AmmoType) {
            this.ammoList.addElement(mounted);
        }
        if (mounted.getType() instanceof MiscType) {
            this.miscList.addElement(mounted);
        }
    }

    public int getEquipmentNum(Mounted mounted) {
        if (mounted != null) {
            return this.equipmentList.indexOf(mounted);
        }
        return -1;
    }

    public Enumeration getEquipment() {
        return this.equipmentList.elements();
    }

    public Mounted getEquipment(int n) {
        try {
            return (Mounted)this.equipmentList.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public int getTotalAmmoOfType(EquipmentType equipmentType) {
        int n = 0;
        Enumeration enumeration = this.getAmmo();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.getType() != equipmentType || mounted.isDumping()) continue;
            n += mounted.getShotsLeft();
        }
        return n;
    }

    public abstract int getWeaponArc(int var1);

    public abstract boolean isSecondaryArcWeapon(int var1);

    public Enumeration getWeapons() {
        return this.weaponList.elements();
    }

    public Vector getWeaponList() {
        return this.weaponList;
    }

    public int getFirstWeapon() {
        Enumeration enumeration = this.weaponList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.isReady()) continue;
            return this.getEquipmentNum(mounted);
        }
        return -1;
    }

    public int getNextWeapon(int n) {
        boolean bl = false;
        Enumeration enumeration = this.weaponList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (bl && mounted.isReady()) {
                return this.getEquipmentNum(mounted);
            }
            if (this.getEquipmentNum(mounted) != n) continue;
            bl = true;
        }
        return this.getFirstWeapon();
    }

    public void loadAllWeapons() {
        Enumeration enumeration = this.weaponList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() == -1) continue;
            this.loadWeapon(mounted);
        }
    }

    public void loadWeapon(Mounted mounted) {
        WeaponType weaponType = (WeaponType)mounted.getType();
        Enumeration enumeration = this.getAmmo();
        while (enumeration.hasMoreElements()) {
            Mounted mounted2 = (Mounted)enumeration.nextElement();
            AmmoType ammoType = (AmmoType)mounted2.getType();
            if (mounted2.isDestroyed() || mounted2.getShotsLeft() <= 0 || mounted2.isDumping() || ammoType.getAmmoType() != weaponType.getAmmoType() || ammoType.getRackSize() != weaponType.getRackSize()) continue;
            mounted.setLinked(mounted2);
            break;
        }
    }

    public void loadWeapon(Mounted mounted, Mounted mounted2) {
        if (mounted2.isDestroyed() || mounted2.getShotsLeft() <= 0 || mounted2.isDumping()) {
            return;
        }
        WeaponType weaponType = (WeaponType)mounted.getType();
        AmmoType ammoType = (AmmoType)mounted2.getType();
        if (ammoType.getAmmoType() == weaponType.getAmmoType() && ammoType.getRackSize() == weaponType.getRackSize()) {
            mounted.setLinked(mounted2);
        }
    }

    public boolean weaponFiredFrom(int n) {
        Enumeration enumeration = this.weaponList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.getLocation() != n || !mounted.isUsedThisRound()) continue;
            return true;
        }
        return false;
    }

    public Enumeration getAmmo() {
        return this.ammoList.elements();
    }

    public Enumeration getMisc() {
        return this.miscList.elements();
    }

    public void removeMisc(String string) {
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.getName().equals(string)) continue;
            this.miscList.removeElement(mounted);
            this.equipmentList.removeElement(mounted);
            break;
        }
    }

    public abstract int getHeatCapacity();

    public abstract int getHeatCapacityWithWater();

    public CriticalSlot getCritical(int n, int n2) {
        return this.crits[n][n2];
    }

    public void setCritical(int n, int n2, CriticalSlot criticalSlot) {
        this.crits[n][n2] = criticalSlot;
    }

    public void removeCriticals(int n, CriticalSlot criticalSlot) {
        int n2 = 0;
        while (n2 < this.getNumberOfCriticals(n)) {
            if (this.getCritical(n, n2) != null && this.getCritical(n, n2).equals(criticalSlot)) {
                this.setCritical(n, n2, null);
            }
            ++n2;
        }
    }

    public int getEmptyCriticals(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.getNumberOfCriticals(n)) {
            if (this.getCritical(n, n3) == null) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public int getHittableCriticals(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.getNumberOfCriticals(n)) {
            if (this.getCritical(n, n3) != null && this.getCritical(n, n3).isHittable()) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public boolean hasHittableCriticals(int n) {
        int n2 = 0;
        while (n2 < this.getNumberOfCriticals(n)) {
            if (this.getCritical(n, n2) != null && !this.getCritical(n, n2).isDestroyed()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getGoodCriticals(CriticalSlot criticalSlot, int n) {
        return this.getGoodCriticals(criticalSlot.getType(), criticalSlot.getIndex(), n);
    }

    public int getGoodCriticals(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.getNumberOfCriticals(n3)) {
            CriticalSlot criticalSlot = this.getCritical(n3, n5);
            if (criticalSlot != null && criticalSlot.getType() == n && criticalSlot.getIndex() == n2 && !criticalSlot.isDestroyed()) {
                ++n4;
            }
            ++n5;
        }
        return n4;
    }

    public int getDestroyedCriticals(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.getNumberOfCriticals(n3)) {
            CriticalSlot criticalSlot = this.getCritical(n3, n5);
            if (criticalSlot != null && criticalSlot.getType() == n && criticalSlot.getIndex() == n2 && criticalSlot.isDestroyed()) {
                ++n4;
            }
            ++n5;
        }
        return n4;
    }

    public int getHitCriticals(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.getNumberOfCriticals(n3)) {
            CriticalSlot criticalSlot = this.getCritical(n3, n5);
            if (criticalSlot != null && criticalSlot.getType() == n && criticalSlot.getIndex() == n2 && criticalSlot.isDamaged()) {
                ++n4;
            }
            ++n5;
        }
        return n4;
    }

    protected abstract int[] getNoOfSlots();

    public int getNumberOfCriticals(int n) {
        int[] nArray = this.getNoOfSlots();
        if (null == nArray || n >= nArray.length || n == -1) {
            return 0;
        }
        return nArray[n];
    }

    public int getNumberOfCriticals(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.getNumberOfCriticals(n3)) {
            CriticalSlot criticalSlot = this.getCritical(n3, n5);
            if (criticalSlot != null && criticalSlot.getType() == n && criticalSlot.getIndex() == n2) {
                ++n4;
            }
            ++n5;
        }
        return n4;
    }

    public boolean hasHipCrit() {
        boolean bl = false;
        int n = 0;
        while (n < this.locations()) {
            if (this.locationIsLeg(n) && this.getDestroyedCriticals(0, 11, n) > 0) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public boolean hasLegActuatorCrit() {
        boolean bl = false;
        int n = 0;
        while (n < this.locations()) {
            if (this.locationIsLeg(n) && (this.getDestroyedCriticals(0, 11, n) > 0 || this.getDestroyedCriticals(0, 12, n) > 0 || this.getDestroyedCriticals(0, 13, n) > 0 || this.getDestroyedCriticals(0, 14, n) > 0)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public boolean hasWorkingSystem(int n, int n2) {
        int n3 = 0;
        while (n3 < this.getNumberOfCriticals(n2)) {
            CriticalSlot criticalSlot = this.getCritical(n2, n3);
            if (criticalSlot != null && criticalSlot.getType() == 0 && criticalSlot.getIndex() == n && !criticalSlot.isDestroyed()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean hasSystem(int n, int n2) {
        int n3 = 0;
        while (n3 < this.getNumberOfCriticals(n2)) {
            CriticalSlot criticalSlot = this.getCritical(n2, n3);
            if (criticalSlot != null && criticalSlot.getType() == 0 && criticalSlot.getIndex() == n) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean hasActiveECM() {
        Enumeration enumeration = this.getMisc();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(8192)) continue;
            return !mounted.isDestroyed() && !mounted.isMissing();
        }
        return false;
    }

    public boolean hasTargComp() {
        Enumeration enumeration = this.getMisc();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(16384)) continue;
            return !mounted.isDestroyed() && !mounted.isMissing();
        }
        return false;
    }

    public boolean hasC3S() {
        if (this.isShutDown()) {
            return false;
        }
        Enumeration enumeration = this.getEquipment();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(1024) || mounted.isDestroyed()) continue;
            return true;
        }
        return false;
    }

    public boolean hasC3M() {
        if (this.isShutDown()) {
            return false;
        }
        Enumeration enumeration = this.getEquipment();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(512) || mounted.isDestroyed()) continue;
            return true;
        }
        return false;
    }

    public boolean hasC3() {
        return this.hasC3S() | this.hasC3M();
    }

    public boolean hasC3i() {
        if (this.isShutDown()) {
            return false;
        }
        Enumeration enumeration = this.getEquipment();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(2048) || mounted.isDestroyed()) continue;
            return true;
        }
        return false;
    }

    public String getC3NetID() {
        if (this.C3NetIDString == null) {
            this.C3NetIDString = "C3." + this.getId() + "." + random.nextInt(1000);
        }
        return this.C3NetIDString;
    }

    public void setC3NetID(Entity entity) {
        if (this.isEnemyOf(entity)) {
            return;
        }
        this.C3NetIDString = entity.C3NetIDString;
    }

    public int calculateFreeC3Nodes() {
        int n = 0;
        if (this.hasC3i()) {
            n = 5;
            if (this.game != null) {
                Enumeration enumeration = this.game.getEntities();
                while (enumeration.hasMoreElements()) {
                    Entity entity = (Entity)enumeration.nextElement();
                    if (this.equals(entity) || !this.onSameC3NetworkAs(entity) || --n > 0) continue;
                    return 0;
                }
            }
            return n;
        }
        if (this.hasC3M()) {
            n = 3;
            if (this.game != null) {
                Enumeration enumeration = this.game.getEntities();
                while (enumeration.hasMoreElements()) {
                    Entity entity = (Entity)enumeration.nextElement();
                    if (!entity.hasC3() || entity == this) continue;
                    Entity entity2 = entity.getC3Master();
                    if (this.equals(entity2)) {
                        --n;
                    }
                    if (n > 0) continue;
                    return 0;
                }
            }
            return n;
        }
        return 0;
    }

    public Entity getC3Top() {
        Entity entity = this;
        while (entity.getC3Master() != null && !entity.getC3Master().equals(entity) && entity.getC3Master().hasC3() && !Compute.isAffectedByECM(entity, entity.getPosition(), entity.getC3Master().getPosition())) {
            entity = entity.getC3Master();
        }
        return entity;
    }

    public Entity getC3Master() {
        Entity entity;
        if (this.C3Master == -1) {
            return null;
        }
        if (this.hasC3S() && this.C3Master > -1) {
            Entity entity2 = this.game.getEntity(this.C3Master);
            if (entity2 == null || entity2.C3MasterIs(entity2)) {
                this.C3Master = -1;
            }
        } else if (this.hasC3M() && this.C3Master > -1 && ((entity = this.game.getEntity(this.C3Master)) == null || !entity.C3MasterIs(entity))) {
            this.C3Master = -1;
        }
        if (this.C3Master == -1) {
            return null;
        }
        return this.game.getEntity(this.C3Master);
    }

    public boolean C3MasterIs(Entity entity) {
        if (entity == null && this.C3Master == -1) {
            return true;
        }
        return entity.id == this.C3Master;
    }

    public void setC3Master(Entity entity) {
        if (entity == null) {
            this.setC3Master(-1);
        } else {
            if (this.isEnemyOf(entity)) {
                return;
            }
            this.setC3Master(entity.id);
        }
    }

    public void setC3Master(int n) {
        Entity entity;
        Enumeration enumeration;
        if (this.id == n != (this.id == this.C3Master)) {
            enumeration = this.game.getEntities();
            while (enumeration.hasMoreElements()) {
                entity = (Entity)enumeration.nextElement();
                if (!entity.C3MasterIs(this) || this.equals(entity)) continue;
                entity.setC3Master(-1);
            }
        }
        if (this.hasC3()) {
            this.C3Master = n;
        }
        if (this.hasC3() && n == -1) {
            this.C3NetIDString = "C3." + this.id + "." + random.nextInt(1000);
        } else if (this.hasC3i() && n == -1) {
            this.C3NetIDString = "C3i." + this.id + "." + random.nextInt(1000);
        } else if (this.hasC3() || this.hasC3i()) {
            this.C3NetIDString = this.game.getEntity(n).getC3NetID();
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            if (!entity.C3MasterIs(this) || this.equals(entity)) continue;
            entity.C3NetIDString = this.C3NetIDString;
        }
    }

    public boolean onSameC3NetworkAs(Entity entity) {
        if (this.isEnemyOf(entity)) {
            return false;
        }
        if (this.isShutDown() || entity.isShutDown()) {
            return false;
        }
        if (this.hasC3i() && entity.hasC3i() && this.getC3NetID().equals(entity.getC3NetID())) {
            return !Compute.isAffectedByECM(entity, entity.getPosition(), this.getPosition());
        }
        if (!this.hasC3() || !entity.hasC3()) {
            return false;
        }
        if (this.getC3Top() == null || entity.getC3Top() == null) {
            return false;
        }
        return this.getC3Top().equals(entity.getC3Top());
    }

    public boolean locationHasCase(int n) {
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.getLocation() != n || !mounted.getType().hasFlag(64) || mounted.isDestroyed()) continue;
            return true;
        }
        return false;
    }

    public void addCritical(int n, CriticalSlot criticalSlot) {
        int n2 = 0;
        while (n2 < this.getNumberOfCriticals(n)) {
            if (this.getCritical(n, n2) == null) {
                this.setCritical(n, n2, criticalSlot);
                return;
            }
            ++n2;
        }
    }

    public void hitAllCriticals(int n, int n2) {
        CriticalSlot criticalSlot = this.getCritical(n, n2);
        int n3 = 0;
        while (n3 < this.getNumberOfCriticals(n)) {
            CriticalSlot criticalSlot2 = this.getCritical(n, n2);
            if (criticalSlot2.getType() == criticalSlot.getType() && criticalSlot2.getIndex() == criticalSlot.getIndex()) {
                criticalSlot2.setHit(true);
            }
            ++n3;
        }
    }

    public void newRound() {
        this.delta_distance = 0;
        this.mpUsed = 0;
        this.moved = 0;
        this.setArmsFlipped(false);
        this.setDisplacementAttack(null);
        this.setFindingClub(false);
        this.setUnjammingRAC(false);
        this.crew.setKoThisRound(false);
        this.m_lNarcedBy |= this.m_lPendingNarc;
        Enumeration enumeration = this.getEquipment();
        while (enumeration.hasMoreElements()) {
            ((Mounted)enumeration.nextElement()).newRound();
        }
    }

    public void applyDamage() {
        int n;
        Enumeration enumeration = this.getEquipment();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.isHit() && !mounted.isMissing()) continue;
            mounted.setShotsLeft(0);
            mounted.setDestroyed(true);
        }
        int n2 = 0;
        while (n2 < this.locations()) {
            n = 0;
            while (n < this.getNumberOfCriticals(n2)) {
                CriticalSlot criticalSlot = this.getCritical(n2, n);
                if (criticalSlot != null) {
                    criticalSlot.setDestroyed(criticalSlot.isDamaged());
                }
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < this.locations()) {
            if (this.getInternal(n) == -2) {
                this.setArmor(-3, n);
                this.setArmor(-3, n, true);
                this.setInternal(-3, n);
            }
            ++n;
        }
    }

    public void reloadEmptyWeapons() {
        Enumeration enumeration = this.getWeapons();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() == -1 || (weaponType.getFlags() & 0xF00) == 3840 || mounted.getLinked() != null && mounted.getLinked().getShotsLeft() > 0) continue;
            this.loadWeapon(mounted);
        }
    }

    public void assignAMS(Vector vector, Vector vector2) {
        Enumeration enumeration = this.getWeapons();
        while (enumeration.hasMoreElements()) {
            WeaponAttackAction weaponAttackAction;
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (((WeaponType)mounted.getType()).getAmmoType() != 14 || !mounted.isReady() || mounted.isMissing() || mounted.curMode().equals("Off")) continue;
            if (mounted.getLinked() == null || mounted.getLinked().getShotsLeft() == 0) {
                this.loadWeapon(mounted);
            }
            if (mounted.getLinked() == null || mounted.getLinked().getShotsLeft() == 0) continue;
            Vector<WeaponAttackAction> vector3 = new Vector<WeaponAttackAction>(vector.size());
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                weaponAttackAction = (WeaponAttackAction)enumeration2.nextElement();
                if (!Compute.isInArc(this.game, this.getId(), this.getEquipmentNum(mounted), weaponAttackAction.getEntityId())) continue;
                vector3.addElement(weaponAttackAction);
            }
            weaponAttackAction = Compute.getHighestExpectedDamage(this.game, vector3, vector2);
            if (weaponAttackAction == null) continue;
            weaponAttackAction.addCounterEquipment(mounted);
        }
    }

    public void setNarcedBy(int n) {
        if (n > 63) {
            System.out.println("Narc system can't handle team IDs this high!");
            return;
        }
        this.m_lPendingNarc |= (long)Math.pow(2.0, n);
    }

    public boolean isNarcedBy(int n) {
        return (this.m_lNarcedBy & (long)Math.pow(2.0, n)) > 0L;
    }

    public abstract int calculateBattleValue();

    public abstract String victoryReport();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Entity entity = (Entity)object;
        return entity.getId() == this.id;
    }

    public int getMovementType() {
        return this.movementType;
    }

    public void setMovementType(int n) {
        this.movementType = n;
    }

    public boolean entityIsBiped() {
        return this.getMovementType() == 1;
    }

    public boolean entityIsQuad() {
        return this.getMovementType() == 2;
    }

    public boolean needsRollToStand() {
        return true;
    }

    public abstract PilotingRollData addEntityBonuses(PilotingRollData var1);

    public abstract int getMaxElevationChange();

    public static interface MovementType {
        public static final int NONE = 0;
        public static final int BIPED = 1;
        public static final int QUAD = 2;
        public static final int TRACKED = 3;
        public static final int WHEELED = 4;
        public static final int HOVER = 5;
    }
}

