/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.Board;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.GameOptions;
import megamek.common.GameTurn;
import megamek.common.HexEntity;
import megamek.common.Infantry;
import megamek.common.Player;

public class Game
implements Serializable {
    public static final int PHASE_UNKNOWN = -1;
    public static final int PHASE_LOUNGE = 1;
    public static final int PHASE_SELECTION = 2;
    public static final int PHASE_EXCHANGE = 3;
    public static final int PHASE_DEPLOYMENT = 12;
    public static final int PHASE_INITIATIVE = 4;
    public static final int PHASE_MOVEMENT = 5;
    public static final int PHASE_MOVEMENT_REPORT = 6;
    public static final int PHASE_FIRING = 7;
    public static final int PHASE_FIRING_REPORT = 8;
    public static final int PHASE_PHYSICAL = 9;
    public static final int PHASE_END = 10;
    public static final int PHASE_VICTORY = 11;
    public static final int INF_MOVE_MULTI = 3;
    public int phase = -1;
    private GameTurn turn;
    private GameOptions options = new GameOptions();
    public Board board = new Board();
    private Vector entities = new Vector();
    private Hashtable entityIds = new Hashtable();
    private Vector graveyard = new Vector();
    private Vector players = new Vector();
    private Hashtable playerIds = new Hashtable();
    private boolean m_bHasDeployed = false;
    private int windDirection;
    private String stringWindDirection;

    public GameOptions getOptions() {
        return this.options;
    }

    public void setOptions(GameOptions gameOptions) {
        this.options = gameOptions;
    }

    public Board getBoard() {
        return this.board;
    }

    public Enumeration getPlayers() {
        return this.players.elements();
    }

    public Vector getPlayersVector() {
        return this.players;
    }

    public int getNoOfPlayers() {
        return this.players.size();
    }

    public Player getPlayer(int n) {
        return (Player)this.playerIds.get(new Integer(n));
    }

    public void addPlayer(int n, Player player) {
        player.setGame(this);
        this.players.addElement(player);
        this.playerIds.put(new Integer(n), player);
    }

    public void setPlayer(int n, Player player) {
        Player player2 = this.getPlayer(n);
        player.setGame(this);
        this.players.setElementAt(player, this.players.indexOf(player2));
        this.playerIds.put(new Integer(n), player);
    }

    public void removePlayer(int n) {
        this.players.removeElement(this.getPlayer(n));
        this.playerIds.remove(new Integer(n));
    }

    public int getEntitiesOwnedBy(Player player) {
        int n = 0;
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.getOwner().equals(player)) continue;
            ++n;
        }
        return n;
    }

    public int getLiveEntitiesOwnedBy(Player player) {
        int n = 0;
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.getOwner().equals(player) || entity.isDestroyed()) continue;
            ++n;
        }
        return n;
    }

    public Vector getValidTargets(Entity entity) {
        Vector<Entity> vector = new Vector<Entity>();
        boolean bl = this.getOptions().booleanOption("friendly_fire");
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity2 = (Entity)enumeration.nextElement();
            if (!entity.isEnemyOf(entity2) && (!bl || entity.getId() == entity2.getId())) continue;
            vector.addElement(entity2);
        }
        return vector;
    }

    public GameTurn getTurn() {
        return this.turn;
    }

    public void setTurn(GameTurn gameTurn) {
        this.turn = gameTurn;
    }

    public boolean hasDeployed() {
        return this.m_bHasDeployed;
    }

    public void setHasDeployed(boolean bl) {
        this.m_bHasDeployed = bl;
    }

    public Enumeration getEntities() {
        return this.entities.elements();
    }

    public Vector getEntitiesVector() {
        return this.entities;
    }

    public void setEntitiesVector(Vector vector) {
        this.entities = vector;
        this.reindexEntities();
    }

    public Enumeration getGraveyardEntities() {
        return this.graveyard.elements();
    }

    public int getNoOfEntities() {
        return this.entities.size();
    }

    public static Coords IdToCoords(int n) {
        if (n > -1000) {
            return null;
        }
        Coords coords = new Coords(-n - 1000 & 0x3FFF, (-n - 1000) / 16384);
        return coords;
    }

    public static int CoordsToId(Coords coords) {
        int n = -1000 - coords.x - coords.y * 16384;
        return n;
    }

    public Entity getEntity(int n) {
        if (n <= -1000) {
            HexEntity hexEntity = new HexEntity(Game.IdToCoords(n));
            hexEntity.setGame(this);
            return hexEntity;
        }
        return (Entity)this.entityIds.get(new Integer(n));
    }

    public void addEntity(int n, Entity entity) {
        entity.setGame(this);
        this.entities.addElement(entity);
        this.entityIds.put(new Integer(n), entity);
    }

    public void setEntity(int n, Entity entity) {
        Entity entity2 = this.getEntity(n);
        entity.setGame(this);
        if (entity2 == null) {
            this.entities.addElement(entity);
        } else {
            this.entities.setElementAt(entity, this.entities.indexOf(entity2));
        }
        this.entityIds.put(new Integer(n), entity);
    }

    public void removeEntity(int n) {
        Entity entity = this.getEntity(n);
        if (entity != null) {
            this.entities.removeElement(entity);
            this.entityIds.remove(new Integer(n));
        }
    }

    public int getEntityID(Entity entity) {
        Enumeration enumeration = this.entityIds.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (this.entityIds.get(n) != entity) continue;
            return n;
        }
        return -1;
    }

    private void reindexEntities() {
        this.entityIds.clear();
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            this.entityIds.put(new Integer(entity.getId()), entity);
            entity.setGame(this);
        }
    }

    public Entity getEntity(Coords coords) {
        return this.getFirstEntity(coords);
    }

    public Entity getFirstEntity(Coords coords) {
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!coords.equals(entity.getPosition()) || !entity.isTargetable()) continue;
            return entity;
        }
        return null;
    }

    public Enumeration getEntities(Coords coords) {
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!coords.equals(entity.getPosition()) || !entity.isTargetable()) continue;
            vector.addElement(entity);
        }
        return vector.elements();
    }

    public void moveToGraveyard(int n) {
        Entity entity = this.getEntity(n);
        if (entity != null) {
            this.removeEntity(n);
            this.graveyard.addElement(entity);
        }
    }

    public boolean isInGraveyard(int n) {
        Entity entity = this.getEntity(n);
        if (entity == null) {
            return false;
        }
        return this.isInGraveyard(entity);
    }

    public boolean isInGraveyard(Entity entity) {
        if (entity == null) {
            return false;
        }
        return this.graveyard.contains(entity);
    }

    public Entity getFirstEntity(Player player) {
        return this.getEntity(this.getFirstEntityNum(player));
    }

    public int getFirstEntityNum(Player player) {
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!player.equals(entity.getOwner()) || !entity.isSelectable()) continue;
            return entity.getId();
        }
        return -1;
    }

    public Entity getNextEntity(Player player, int n) {
        return this.getEntity(this.getNextEntityNum(player, n));
    }

    public void determineWindDirection() {
        this.windDirection = Compute.d6(1) - 1;
        String[] stringArray = new String[]{"North", "Northeast", "Southeast", "South", "Southwest", "Northwest"};
        this.stringWindDirection = stringArray[this.windDirection];
    }

    public int getWindDirection() {
        return this.windDirection;
    }

    public String getStringWindDirection() {
        return this.stringWindDirection;
    }

    public int getNextEntityNum(Player player, int n) {
        boolean bl = false;
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getId() == n) {
                bl = true;
                continue;
            }
            if (!bl || !player.equals(entity.getOwner()) || !entity.isSelectable()) continue;
            return entity.getId();
        }
        return this.getFirstEntityNum(player);
    }

    public boolean hasInfantry(int n) {
        Player player = this.getPlayer(n);
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!player.equals(entity.getOwner()) || !entity.isSelectable() || !(entity instanceof Infantry)) continue;
            return true;
        }
        return false;
    }
}

