/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.WeaponType;

public class Mounted
implements Serializable {
    private boolean usedThisRound = false;
    private boolean destroyed = false;
    private boolean hit = false;
    private boolean missing = false;
    private boolean jammed = false;
    private int mode;
    private int pendingMode = -1;
    private int location;
    private boolean rearMounted;
    private Mounted linked = null;
    private Mounted linkedBy = null;
    private Entity entity;
    private transient EquipmentType type;
    private String typeName;
    private int shotsLeft;
    private boolean m_bPendingDump;
    private boolean m_bDumping;
    private boolean bSplit = false;
    private int nFoundCrits = 0;

    public Mounted(Entity entity, EquipmentType equipmentType) {
        this.entity = entity;
        this.type = equipmentType;
        this.typeName = equipmentType.getInternalName();
        if (equipmentType instanceof AmmoType) {
            this.shotsLeft = ((AmmoType)equipmentType).getShots();
        }
    }

    public void restore() {
        this.type = EquipmentType.getByInternalName(this.typeName);
        if (this.type == null) {
            System.err.println("Mounted.restore: could not restore equipment type \"" + this.typeName + "\"");
        }
    }

    public EquipmentType getType() {
        return this.type;
    }

    public String curMode() {
        return this.type.getModes()[this.mode];
    }

    public String pendingMode() {
        if (this.pendingMode == -1) {
            return "None";
        }
        return this.type.getModes()[this.pendingMode];
    }

    public int switchMode() {
        if (this.type.hasModes()) {
            int n = 0;
            n = this.pendingMode > -1 ? (this.pendingMode + 1) % this.type.getModes().length : (this.mode + 1) % this.type.getModes().length;
            this.setMode(n);
            return n;
        }
        return -1;
    }

    public int setMode(String string) {
        int n = 0;
        while (n < this.type.getModes().length) {
            if (this.type.getModes()[n].equals(string)) {
                this.setMode(n);
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setMode(int n) {
        if (this.type.hasModes()) {
            if (this.type.hasInstantModeSwitch()) {
                this.mode = n;
            } else if (this.pendingMode == -1) {
                this.pendingMode = n;
            }
        }
    }

    public void newRound() {
        this.setUsedThisRound(false);
        if (this.type.hasModes() && this.pendingMode != -1) {
            this.mode = this.pendingMode;
            this.pendingMode = -1;
        }
    }

    public String getName() {
        return this.type.getName();
    }

    public String getDesc() {
        StringBuffer stringBuffer = new StringBuffer(this.type.getDesc());
        if (this.destroyed) {
            stringBuffer.insert(0, "*");
        } else if (this.usedThisRound) {
            stringBuffer.insert(0, "+");
        } else if (this.jammed) {
            stringBuffer.insert(0, "j ");
        }
        if (this.rearMounted) {
            stringBuffer.append(" (R)");
        }
        if (this.type instanceof AmmoType) {
            stringBuffer.append(" (");
            stringBuffer.append(this.shotsLeft);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public boolean isReady() {
        return !this.usedThisRound && !this.destroyed && !this.jammed;
    }

    public boolean isUsedThisRound() {
        return this.usedThisRound;
    }

    public void setUsedThisRound(boolean bl) {
        this.usedThisRound = bl;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    public boolean isHit() {
        return this.hit;
    }

    public void setHit(boolean bl) {
        this.hit = bl;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void setMissing(boolean bl) {
        this.missing = bl;
    }

    public boolean isJammed() {
        return this.jammed;
    }

    public void setJammed(boolean bl) {
        this.jammed = bl;
    }

    public int getShotsLeft() {
        return this.shotsLeft;
    }

    public void setShotsLeft(int n) {
        this.shotsLeft = n;
    }

    public boolean isPendingDump() {
        return this.m_bPendingDump;
    }

    public void setPendingDump(boolean bl) {
        this.m_bPendingDump = bl;
    }

    public boolean isDumping() {
        return this.m_bDumping;
    }

    public void setDumping(boolean bl) {
        this.m_bDumping = bl;
    }

    public int getLocation() {
        return this.location;
    }

    public boolean isRearMounted() {
        return this.rearMounted;
    }

    public void setLocation(int n) {
        this.setLocation(n, false);
    }

    public void setLocation(int n, boolean bl) {
        this.location = n;
        this.rearMounted = bl;
    }

    public Mounted getLinked() {
        return this.linked;
    }

    public Mounted getLinkedBy() {
        return this.linkedBy;
    }

    public void setLinked(Mounted mounted) {
        this.linked = mounted;
        mounted.setLinkedBy(this);
    }

    protected void setLinkedBy(Mounted mounted) {
        if (mounted.getLinked() != this) {
            return;
        }
        this.linkedBy = mounted;
    }

    public int getFoundCrits() {
        return this.nFoundCrits;
    }

    public void setFoundCrits(int n) {
        this.nFoundCrits = n;
    }

    public boolean isSplit() {
        return this.bSplit;
    }

    public void setSplit(boolean bl) {
        this.bSplit = bl;
    }

    public int getExplosionDamage() {
        if (this.type instanceof AmmoType) {
            AmmoType ammoType = (AmmoType)this.type;
            return ammoType.getDamagePerShot() * ammoType.getRackSize() * this.shotsLeft;
        }
        if (this.type instanceof WeaponType) {
            WeaponType weaponType = (WeaponType)this.type;
            if (weaponType.getAmmoType() == 6) {
                return 20;
            }
            if (weaponType.getAmmoType() == 21) {
                return 16;
            }
            if (weaponType.getAmmoType() == 22) {
                return 25;
            }
            if (weaponType.getAmmoType() == 23) {
                return weaponType.getDamage();
            }
        }
        System.err.println("mounted: unable to determine explosion damage for " + this.getName());
        return 0;
    }
}

