/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.awt.Color;
import java.io.Serializable;
import megamek.common.Game;
import megamek.common.InitiativeRoll;

public final class Player
implements Serializable {
    public static final int TEAM_NONE = 0;
    public static final int[] colorRGBs = new int[]{8816319, 15921761, 0xCC6666, 8896390, 0xFFFFFF, 0x8FCCCC, 15900104, 15903329, 0xBEBEBE, 9994603};
    public static final String[] colorNames = new String[]{"Blue", "Yellow", "Red", "Green", "White", "Cyan", "Pink", "Orange", "Gray", "Brown"};
    public static final String[] teamNames = new String[]{"No Team", "Team 1", "Team 2", "Team 3", "Team 4", "Team 5"};
    public static final int MAX_TEAMS = teamNames.length;
    private transient Game game;
    private String name = "unnamed";
    private int id;
    private int team = 0;
    private boolean ready = false;
    private boolean ghost = false;
    private boolean observer = false;
    private int colorIndex = 0;
    private int startingPos = 0;
    private InitiativeRoll initiative = new InitiativeRoll();

    public Player(int n, String string) {
        this.name = string;
        this.id = n;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getId() {
        return this.id;
    }

    public int getTeam() {
        return this.team;
    }

    public void setTeam(int n) {
        this.team = n;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean bl) {
        this.ready = bl;
    }

    public boolean isGhost() {
        return this.ghost;
    }

    public void setGhost(boolean bl) {
        this.ghost = bl;
    }

    public boolean isObserver() {
        return this.observer;
    }

    public void setObserver(boolean bl) {
        this.observer = bl;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(int n) {
        this.colorIndex = n;
    }

    public InitiativeRoll getInitiative() {
        return this.initiative;
    }

    public int getStartingPos() {
        return this.startingPos;
    }

    public void setStartingPos(int n) {
        this.startingPos = n;
    }

    public Color getColor() {
        return new Color(colorRGBs[this.colorIndex]);
    }

    public int getColorRGB() {
        return colorRGBs[this.colorIndex];
    }

    public boolean isEnemyOf(Player player) {
        return this.id != player.getId() && (this.team == 0 || this.team != player.getTeam());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Player player = (Player)object;
        return player.getId() == this.id;
    }

    public int hashCode() {
        return this.getId();
    }
}

