/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.options;

import java.io.Serializable;

public class GameOption
implements Serializable {
    public static final int BOOLEAN = 0;
    public static final int INTEGER = 1;
    public static final int FLOAT = 2;
    private String shortName;
    private String fullName;
    private String desc;
    private int type;
    private Object defaultValue;
    private Object value;

    public GameOption(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, 0, new Boolean(bl));
    }

    public GameOption(String string, String string2, String string3, int n) {
        this(string, string2, string3, 1, new Integer(n));
    }

    public GameOption(String string, String string2, String string3, float f) {
        this(string, string2, string3, 2, new Float(f));
    }

    public GameOption(String string, String string2, String string3, int n, Object object) {
        this.shortName = string;
        this.fullName = string2;
        this.desc = string3;
        this.type = n;
        if (!this.isValidValue(object)) {
            throw new IllegalArgumentException("Tried to give wrong type of value for option type.");
        }
        this.defaultValue = object;
        this.value = object;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getType() {
        return this.type;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean booleanValue() {
        return (Boolean)this.value;
    }

    public int intValue() {
        return (Integer)this.value;
    }

    public float floatValue() {
        return ((Float)this.value).floatValue();
    }

    public String stringValue() {
        return this.value.toString();
    }

    public void setValue(Object object) {
        if (!this.isValidValue(object)) {
            throw new IllegalArgumentException("Tried to give wrong type of value for option type.");
        }
        this.value = object;
    }

    public void setValue(boolean bl) {
        if (this.type != 0) {
            throw new IllegalArgumentException("Tried to give boolean value to non-boolean option.");
        }
        this.value = new Boolean(bl);
    }

    public void setValue(int n) {
        if (this.type != 1) {
            throw new IllegalArgumentException("Tried to give integer value to non-integer option.");
        }
        this.value = new Integer(n);
    }

    public void setValue(float f) {
        if (this.type != 2) {
            throw new IllegalArgumentException("Tried to give float value to non-float option.");
        }
        this.value = new Float(f);
    }

    private boolean isValidValue(Object object) {
        switch (this.type) {
            case 0: {
                return object instanceof Boolean;
            }
            case 1: {
                return object instanceof Integer;
            }
            case 2: {
                return object instanceof Float;
            }
        }
        return false;
    }
}

