/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.util;

import com.sun.java.util.collections.Vector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class BuildingBlock {
    private Vector rawData;
    private static final int version = 1;
    private static final char comment = '#';

    public BuildingBlock() {
        this.rawData = new Vector();
    }

    public BuildingBlock(String[] stringArray) {
        this.rawData = new Vector();
        this.rawData = this.makeVector(stringArray);
    }

    public BuildingBlock(Vector vector) {
        this.rawData = vector;
    }

    public BuildingBlock(InputStream inputStream) {
        this.rawData = new Vector();
        this.readInputStream(inputStream);
    }

    public boolean readInputStream(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.rawData.clear();
        try {
            while (bufferedReader.ready()) {
                String string = bufferedReader.readLine();
                if (string == null || (string = string.trim()).length() <= 0 || string.startsWith("" + '#')) continue;
                this.rawData.add((Object)string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("An IO Exception occured while attempting to read a BuildingBlock stream.");
            return false;
        }
        return true;
    }

    public int findStartIndex(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.rawData.size()) {
            String string2 = this.rawData.get(n2).toString();
            try {
                if (string2.length() >= 3 && string2.substring(1, string2.length() - 1).equalsIgnoreCase(string)) {
                    n = ++n2;
                    break;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                System.err.println("Was looking for <" + string + "> and caught a");
                System.err.println("string index out of bounds exception on line: \"" + string2 + "\"");
                System.err.println("rawData index number: " + n2);
            }
            ++n2;
        }
        return n;
    }

    public int findEndIndex(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.rawData.size()) {
            String string2 = this.rawData.get(n2).toString();
            try {
                if (string2.length() >= 3 && string2.substring(1, string2.length() - 1).equalsIgnoreCase("/" + string)) {
                    n = n2;
                    break;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                System.err.println("Was looking for </" + string + "> and caught a");
                System.err.println("string index out of bounds exception on line: \"" + string2 + "\"");
                System.err.println("rawData index number: " + n2);
            }
            ++n2;
        }
        return n;
    }

    public String[] getDataAsString(String string) {
        int n = 0;
        int n2 = 0;
        n = this.findStartIndex(string);
        n2 = this.findEndIndex(string);
        if (n == -1 || n2 == -1) {
            String[] stringArray = new String[]{"0"};
            return stringArray;
        }
        int n3 = n2 - n;
        String[] stringArray = n3 == 0 ? new String[n3 + 1] : new String[n3];
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            stringArray[n4] = this.rawData.get(n5).toString();
            ++n4;
            ++n5;
        }
        return stringArray;
    }

    public int[] getDataAsInt(String string) {
        int n = this.findStartIndex(string);
        int n2 = this.findEndIndex(string);
        if (n == -1 || n2 == -1) {
            int[] nArray = new int[]{0};
            return nArray;
        }
        int n3 = n2 - n;
        int[] nArray = n3 == 0 ? new int[n3 + 1] : new int[n3];
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            try {
                nArray[n4] = Integer.parseInt(this.rawData.get(n5).toString());
                ++n4;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[0] = 0;
                System.err.println("getDataAsInt(\"" + string + "\") failed.  NumberFormatException was caught.");
            }
            ++n5;
        }
        return nArray;
    }

    public float[] getDataAsFloat(String string) {
        int n = this.findStartIndex(string);
        int n2 = this.findEndIndex(string);
        if (n == -1 || n2 == -1) {
            float[] fArray = new float[]{0.0f};
            return fArray;
        }
        int n3 = n2 - n;
        float[] fArray = n3 == 0 ? new float[n3 + 1] : new float[n3];
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            try {
                fArray[n4] = Float.valueOf(this.rawData.get(n5).toString()).floatValue();
                ++n4;
            }
            catch (NumberFormatException numberFormatException) {
                fArray[0] = 0.0f;
                System.err.println("getDataAsFloat(\"" + string + "\") failed.  NumberFormatException was caught.");
            }
            ++n5;
        }
        return fArray;
    }

    public Vector getDataAsVector(String string) {
        int n = 0;
        int n2 = 0;
        n = this.findStartIndex(string);
        n2 = this.findEndIndex(string);
        if (n == -1 || n2 == -1) {
            Vector vector = new Vector();
            vector.clear();
            return vector;
        }
        int n3 = n2 - n;
        Vector vector = new Vector();
        int n4 = n;
        while (n4 < n2) {
            vector.add(this.rawData.get(n4));
            ++n4;
        }
        return vector;
    }

    public boolean createNewBlock() {
        this.rawData.clear();
        this.writeBlockComment("building block data file");
        this.rawData.add((Object)new String(""));
        this.writeBlockData("BlockVersion", "" + 1);
        return true;
    }

    public boolean writeBlockData(String string, String string2) {
        String[] stringArray = new String[]{string2};
        return this.writeBlockData(string, this.makeVector(stringArray));
    }

    public boolean writeBlockData(String string, int n) {
        String[] stringArray = new String[]{"" + n};
        return this.writeBlockData(string, this.makeVector(stringArray));
    }

    public boolean writeBlockData(String string, int[] nArray) {
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = "" + nArray[n];
            ++n;
        }
        return this.writeBlockData(string, this.makeVector(stringArray));
    }

    public boolean writeBlockData(String string, float f) {
        String[] stringArray = new String[]{"" + f};
        return this.writeBlockData(string, this.makeVector(stringArray));
    }

    public boolean writeBlockData(String string, float[] fArray) {
        String[] stringArray = new String[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            stringArray[n] = "" + fArray[n];
            ++n;
        }
        return this.writeBlockData(string, this.makeVector(stringArray));
    }

    public boolean writeBlockData(String string, String[] stringArray) {
        return this.writeBlockData(string, this.makeVector(stringArray));
    }

    public boolean writeBlockData(String string, Vector vector) {
        this.rawData.add((Object)new String("<" + string + ">"));
        int n = 0;
        while (n < vector.size()) {
            this.rawData.add((Object)new String(vector.get(n).toString().trim()));
            ++n;
        }
        this.rawData.add((Object)new String("</" + string + ">"));
        this.rawData.add((Object)new String(""));
        return true;
    }

    public boolean writeBlockComment(String string) {
        this.rawData.add((Object)('#' + string));
        return true;
    }

    public boolean writeBlockFile(String string) {
        File file = new File(string);
        if (file.exists() && !file.delete()) {
            System.err.println("Unable to delete file...(so I could re-write it)");
            return false;
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            int n = 0;
            while (n < this.rawData.size()) {
                bufferedWriter.write(this.rawData.get(n).toString());
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("Unable to save block file " + string);
            return false;
        }
        return true;
    }

    public void clearData() {
        this.rawData.clear();
    }

    public int dataSize() {
        return this.rawData.size();
    }

    public Vector makeVector(String[] stringArray) {
        Vector vector = new Vector();
        int n = 0;
        try {
            n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringArray[n].trim();
                vector.add((Object)stringArray[n]);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return vector;
        }
        return vector;
    }

    public Vector getVector() {
        return this.rawData;
    }

    public String[] getAllDataAsString() {
        String[] stringArray = new String[this.rawData.size()];
        int n = 0;
        while (n < this.rawData.size()) {
            stringArray[n] = this.rawData.get(n).toString();
            ++n;
        }
        return stringArray;
    }

    public Vector getAllDataAsVector() {
        Vector vector = this.rawData;
        return vector;
    }

    public int getReturnedArraySize(String[] stringArray) {
        try {
            return Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Couldn't find array size at [0]...is this an array I returned...?");
            System.err.println("Trying to find size anyway...");
            return this.countArray(stringArray);
        }
    }

    public int getReturnedArraySize(int[] nArray) {
        return nArray[0];
    }

    public int getReturnedArraySize(Vector vector) {
        return vector.size();
    }

    public int getReturnedArraySize(float[] fArray) {
        try {
            return Integer.parseInt("" + fArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Couldn't find array size at [0]...is this an array I returned...?");
            System.err.println("Trying to find size anyway...");
            return this.countArray(fArray);
        }
    }

    public int countArray(String[] stringArray) {
        return stringArray.length;
    }

    public int countArray(float[] fArray) {
        return fArray.length;
    }

    public int countArray(int[] nArray) {
        return nArray.length;
    }

    public boolean exists(String string) {
        if (this.findStartIndex(string) == -1) {
            return false;
        }
        return this.findEndIndex(string) != -1;
    }
}

