/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Vector;
import megamek.common.Packet;
import megamek.server.Server;

public class Connection {
    private Server server;
    private Socket socket;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private int id;
    private Thread receiver;
    private Thread sender;
    private Vector sendQueue = new Vector();

    public Connection(Server server, Socket socket, int n) {
        this.server = server;
        this.socket = socket;
        this.id = n;
        this.initThreads();
    }

    private void initThreads() {
        Runnable runnable = new Runnable(){

            public void run() {
                while (Connection.this.receiver == Thread.currentThread()) {
                    Connection.this.server.handle(Connection.this.id, Connection.this.readPacket());
                }
            }
        };
        this.receiver = new Thread(runnable);
        this.receiver.start();
        Runnable runnable2 = new Runnable(){

            public void run() {
                while (Connection.this.sender == Thread.currentThread()) {
                    Connection.this.sendFromQueue();
                }
            }
        };
        this.sender = new Thread(runnable2);
        this.sender.start();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public Socket getSocket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() {
        this.receiver = null;
        this.sender = null;
        try {
            Connection connection = this;
            synchronized (connection) {
                this.notifyAll();
            }
            this.socket.close();
            this.in.close();
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void send(Packet packet) {
        this.sendQueue.addElement(packet);
        this.notifyAll();
    }

    private synchronized void sendFromQueue() {
        while (!this.hasPending()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Packet packet = (Packet)this.sendQueue.elementAt(0);
        this.sendQueue.removeElementAt(0);
        this.sendPacket(packet);
    }

    public boolean hasPending() {
        return this.sendQueue.size() > 0;
    }

    private Packet readPacket() {
        try {
            if (this.in == null) {
                this.in = new ObjectInputStream(this.socket.getInputStream());
            }
            Packet packet = (Packet)this.in.readObject();
            return packet;
        }
        catch (IOException iOException) {
            System.err.println("server(" + this.id + "): IO error reading command");
            this.server.disconnected(this.id);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("server(" + this.id + "): class not found error reading command");
            this.server.disconnected(this.id);
            return null;
        }
    }

    private void sendPacket(Packet packet) {
        try {
            if (this.out == null) {
                this.out = new ObjectOutputStream(this.socket.getOutputStream());
                this.out.flush();
            }
            this.out.reset();
            this.out.writeObject(packet);
            this.out.flush();
        }
        catch (IOException iOException) {
            System.err.println("server(" + this.id + "): error sending command.  dropping player");
            System.err.println(iOException);
            System.err.println(iOException.getMessage());
            this.server.disconnected(this.id);
        }
    }
}

