/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.MegaMek;
import megamek.common.AmmoType;
import megamek.common.Board;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Game;
import megamek.common.GameTurn;
import megamek.common.Hex;
import megamek.common.HexEntity;
import megamek.common.HitData;
import megamek.common.Infantry;
import megamek.common.LocationFullException;
import megamek.common.MapSettings;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovementData;
import megamek.common.Packet;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.Tank;
import megamek.common.Terrain;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.DisplacementAttackAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.FindClubAction;
import megamek.common.actions.FlipArmsAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.actions.UnjamAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.options.GameOption;
import megamek.server.Connection;
import megamek.server.ServerLog;
import megamek.server.UnitStatusFormatter;
import megamek.server.commands.HelpCommand;
import megamek.server.commands.KickCommand;
import megamek.server.commands.ResetCommand;
import megamek.server.commands.RollCommand;
import megamek.server.commands.ServerCommand;
import megamek.server.commands.VictoryCommand;
import megamek.server.commands.WhoCommand;

public class Server
implements Runnable {
    public static final String DEFAULT_BOARD = "[SURPRISE]";
    private String password;
    private ServerSocket serverSocket;
    private ServerLog log = new ServerLog();
    private String motd;
    private Vector connections = new Vector(4);
    private Vector connectionsPending = new Vector(4);
    private Hashtable connectionIds = new Hashtable();
    private int connectionCounter = 0;
    private int entityCounter = 0;
    private Game game = new Game();
    private MapSettings mapSettings = new MapSettings();
    private int roundCounter = 0;
    private Vector turns = new Vector();
    private int turnIndex = 0;
    private int turnInfMoved = 0;
    private int turnLastPlayerId = -1;
    private Vector attacks = new Vector();
    private Vector pendingCharges = new Vector();
    private Vector pilotRolls = new Vector();
    private StringBuffer roundReport = new StringBuffer();
    private StringBuffer phaseReport = new StringBuffer();
    private boolean forceVictory = false;
    private Hashtable commandsHash = new Hashtable();
    private Thread connector;

    public Server(String string, int n) {
        this.password = string.length() > 0 ? string : null;
        try {
            this.serverSocket = new ServerSocket(n);
        }
        catch (IOException iOException) {
            System.err.println("could not create server socket on port " + n);
        }
        this.motd = this.createMotd();
        this.game.getOptions().initialize();
        this.changePhase(1);
        System.out.println("s: starting a new server...");
        System.out.println("s: address = " + this.serverSocket.getInetAddress().getHostAddress() + " port = " + this.serverSocket.getLocalPort());
        try {
            System.out.println("s: address = " + InetAddress.getByName("127.0.0.1").getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        System.out.println("s: password = " + this.password);
        this.connector = new Thread(this);
        this.connector.start();
        this.registerCommand(new HelpCommand(this));
        this.registerCommand(new KickCommand(this));
        this.registerCommand(new ResetCommand(this));
        this.registerCommand(new RollCommand(this));
        this.registerCommand(new VictoryCommand(this));
        this.registerCommand(new WhoCommand(this));
    }

    public void setGame(Game game) {
        this.game = game;
    }

    private String createMotd() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Welcome to MegaMek.  Server is running version ");
        stringBuffer.append(MegaMek.VERSION);
        stringBuffer.append(", build date ");
        if (MegaMek.TIMESTAMP > 0L) {
            stringBuffer.append(new Date(MegaMek.TIMESTAMP).toString());
        } else {
            stringBuffer.append("unknown");
        }
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    public boolean isPassworded() {
        return this.password != null;
    }

    public boolean isPassword(Object object) {
        return this.password.equals(object);
    }

    private void registerCommand(ServerCommand serverCommand) {
        this.commandsHash.put(serverCommand.getName(), serverCommand);
    }

    public ServerCommand getCommand(String string) {
        return (ServerCommand)this.commandsHash.get(string);
    }

    public void die() {
        Object object;
        this.connector = null;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Enumeration enumeration = this.connectionsPending.elements();
        while (enumeration.hasMoreElements()) {
            object = (Connection)enumeration.nextElement();
            ((Connection)object).die();
        }
        this.connectionsPending = null;
        object = this.connections.elements();
        while (object.hasMoreElements()) {
            Connection connection = (Connection)object.nextElement();
            connection.die();
        }
        this.connections = null;
        this.connectionIds = null;
    }

    public Enumeration getAllCommandNames() {
        return this.commandsHash.keys();
    }

    private void greeting(int n) {
        this.sendToPending(n, new Packet(1));
    }

    private void receivePlayerInfo(Packet packet, int n) {
        Player player = (Player)packet.getObject(0);
        this.game.getPlayer(n).setColorIndex(player.getColorIndex());
        this.game.getPlayer(n).setStartingPos(player.getStartingPos());
        this.game.getPlayer(n).setTeam(player.getTeam());
    }

    private void receivePlayerName(Packet packet, int n) {
        Connection connection = this.getPendingConnection(n);
        String string = (String)packet.getObject(0);
        boolean bl = false;
        if (connection == null) {
            System.out.println("server: got a client name from a non-pending connection");
            return;
        }
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (!player.isGhost() || !player.getName().equals(string)) continue;
            bl = true;
            player.setGhost(false);
            n = player.getId();
            connection.setId(n);
        }
        this.connectionsPending.removeElement(connection);
        this.connections.addElement(connection);
        this.connectionIds.put(new Integer(connection.getId()), connection);
        if (!bl) {
            this.game.addPlayer(n, new Player(n, string));
            this.validatePlayerInfo(n);
        }
        this.sendServerChat(n, this.motd);
        this.send(this.createPlayerConnectPacket(n));
        this.send(n, new Packet(3, new Integer(n)));
        this.sendCurrentInfo(n);
        System.out.println("s: player " + n + " (" + this.getPlayer(n).getName() + ") connected from " + this.getClient(n).getSocket().getInetAddress());
        this.sendServerChat(this.getPlayer(n).getName() + " connected from " + this.getClient(n).getSocket().getInetAddress());
        if (this.game.getNoOfPlayers() > 1 && this.game.getOptions().booleanOption("friendly_fire")) {
            this.game.getOptions().getOption("friendly_fire").setValue(false);
            this.send(this.createGameSettingsPacket());
        }
    }

    private void sendCurrentInfo(int n) {
        this.transmitAllPlayerConnects(n);
        this.send(this.createGameSettingsPacket());
        if (this.doBlind()) {
            this.send(n, this.createFilteredEntitiesPacket(this.getPlayer(n)));
        } else {
            this.send(n, this.createEntitiesPacket());
        }
        switch (this.game.phase) {
            case 1: {
                this.send(n, this.createMapSettingsPacket());
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                this.send(this.createReportPacket());
            }
            default: {
                this.getPlayer(n).setReady(this.game.getEntitiesOwnedBy(this.getPlayer(n)) <= 0);
                this.send(n, this.createBoardPacket());
            }
        }
        this.send(n, new Packet(15, new Integer(this.game.phase)));
    }

    public void validatePlayerInfo(int n) {
        Player player = this.getPlayer(n);
        boolean[] blArray = new boolean[Player.colorNames.length];
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player2 = (Player)enumeration.nextElement();
            if (player2.getId() == n) continue;
            blArray[player2.getColorIndex()] = true;
        }
        if (blArray[player.getColorIndex()]) {
            int n2 = 0;
            while (n2 < blArray.length) {
                if (!blArray[n2]) {
                    player.setColorIndex(n2);
                    break;
                }
                ++n2;
            }
        }
    }

    public void disconnected(int n) {
        Connection connection = this.getClient(n);
        Player player = this.getPlayer(n);
        if (connection != null) {
            connection.die();
            this.connections.removeElement(connection);
            this.connectionIds.remove(new Integer(n));
        }
        if (this.game.phase == 1) {
            this.removeAllEntitesOwnedBy(player);
            this.entityAllUpdate();
        }
        if (this.game.getEntitiesOwnedBy(player) > 0) {
            player.setGhost(true);
            player.setReady(true);
            this.send(this.createPlayerUpdatePacket(player.getId()));
            this.checkReady();
        } else {
            this.game.removePlayer(player.getId());
            this.send(new Packet(5, new Integer(player.getId())));
        }
        System.out.println("s: player " + n + " disconnected");
        this.sendServerChat(player.getName() + " disconnected.");
    }

    public void resetGame() {
        Vector vector = (Vector)this.game.getEntitiesVector().clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            this.game.removeEntity(entity.getId());
        }
        this.send(this.createEntitiesPacket());
        this.resetPlayerReady();
        this.transmitAllPlayerReadys();
        this.pilotRolls.removeAllElements();
        this.changePhase(1);
    }

    public void autoSave() {
        this.saveGame("autosave");
    }

    public void saveGame(String string) {
        String string2 = string + ".sav";
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string2));
            objectOutputStream.writeObject(this.game);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Unable to save file: " + string2);
            exception.printStackTrace();
        }
        this.sendChat("MegaMek", "Game saved to " + string2);
    }

    public boolean loadGame(File file) {
        Object object;
        Object object2;
        try {
            object2 = new ObjectInputStream(new FileInputStream(file));
            this.game = (Game)((ObjectInputStream)object2).readObject();
            ((ObjectInputStream)object2).close();
        }
        catch (Exception exception) {
            System.err.println("Unable to load file: " + file);
            exception.printStackTrace();
            return false;
        }
        object2 = this.game.getEntities();
        while (object2.hasMoreElements()) {
            object = (Entity)object2.nextElement();
            ((Entity)object).setOwner(this.game.getPlayer(((Entity)object).getOwnerId()));
            ((Entity)object).setGame(this.game);
            ((Entity)object).restore();
        }
        object = this.game.getPlayers();
        while (object.hasMoreElements()) {
            Player player = (Player)object.nextElement();
            player.setGame(this.game);
            player.setGhost(true);
        }
        return true;
    }

    public Player getPlayer(int n) {
        return this.game.getPlayer(n);
    }

    private int countActivePlayers() {
        int n = 0;
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player.isGhost() || player.isObserver()) continue;
            ++n;
        }
        return n;
    }

    private void removeAllEntitesOwnedBy(Player player) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            object = (Entity)enumeration.nextElement();
            if (!((Entity)object).getOwner().equals(player)) continue;
            vector.addElement(object);
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            Entity entity = (Entity)object.nextElement();
            this.game.removeEntity(entity.getId());
        }
    }

    private Connection getClient(int n) {
        return this.getConnection(n);
    }

    public Enumeration getConnections() {
        return this.connections.elements();
    }

    public Connection getConnection(int n) {
        return (Connection)this.connectionIds.get(new Integer(n));
    }

    private Connection getPendingConnection(int n) {
        Enumeration enumeration = this.connectionsPending.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            if (connection.getId() != n) continue;
            return connection;
        }
        return null;
    }

    private boolean areMoreTurns() {
        return this.turnIndex < this.turns.size();
    }

    private GameTurn nextTurn() {
        return (GameTurn)this.turns.elementAt(this.turnIndex++);
    }

    private void resetEntityRound() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            entity.newRound();
        }
    }

    private void resetEntityPhase() {
        Object object;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            object = (Entity)enumeration.nextElement();
            if (((Entity)object).isDoomed()) {
                ((Entity)object).setDestroyed(true);
            }
            if (!((Entity)object).isDestroyed() && !((Entity)object).getCrew().isDead()) continue;
            this.game.moveToGraveyard(((Entity)object).getId());
        }
        object = this.game.getEntities();
        while (object.hasMoreElements()) {
            Entity entity = (Entity)object.nextElement();
            entity.applyDamage();
            entity.reloadEmptyWeapons();
            entity.damageThisPhase = 0;
            entity.ready = entity.isActive();
        }
    }

    private void resetPlayerReady() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            player.setReady(false);
        }
    }

    private void resetActivePlayersReady() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player;
            player.setReady(this.game.getEntitiesOwnedBy(player = (Player)enumeration.nextElement()) <= 0);
        }
        this.transmitAllPlayerReadys();
    }

    private void prepareVictoryReport() {
        Object object;
        this.roundReport = new StringBuffer();
        this.roundReport.append("\nVictory!\n-------------------\n\n");
        this.roundReport.append("Survivors are:\n");
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            object = (Entity)enumeration.nextElement();
            this.roundReport.append(((Entity)object).victoryReport());
            this.roundReport.append('\n');
        }
        this.roundReport.append("\nGraveyard contains:\n");
        object = this.game.getGraveyardEntities();
        while (object.hasMoreElements()) {
            Entity entity = (Entity)object.nextElement();
            this.roundReport.append(entity.victoryReport());
            this.roundReport.append('\n');
        }
        this.roundReport.append("\nDetailed unit status saved to entitystatus.txt\n");
    }

    private String getDetailedVictoryReport() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector();
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Enumeration enumeration2 = this.game.getGraveyardEntities();
        while (enumeration2.hasMoreElements()) {
            vector.addElement(enumeration2.nextElement());
        }
        Enumeration enumeration3 = this.game.getPlayers();
        while (enumeration3.hasMoreElements()) {
            Player player = (Player)enumeration3.nextElement();
            stringBuffer.append("++++++++++ " + player.getName() + " ++++++++++\n");
            int n = 0;
            while (n < vector.size()) {
                Entity entity = (Entity)vector.elementAt(n);
                if (entity.getOwner() == player) {
                    stringBuffer.append(UnitStatusFormatter.format(entity));
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public void forceVictory() {
        this.forceVictory = true;
    }

    private void checkReady() {
        boolean bl = this.countActivePlayers() > 0;
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player.isGhost() || player.isReady()) continue;
            bl = false;
        }
        switch (this.game.phase) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                if (!bl) break;
                this.endCurrentPhase();
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                if (!this.getPlayer(this.game.getTurn().getPlayerNum()).isReady()) break;
                this.changeToNextTurn();
            }
        }
    }

    private void changePhase(int n) {
        this.game.phase = n;
        this.prepareForPhase(n);
        if (this.isPhasePlayable(n)) {
            this.send(new Packet(15, new Integer(n)));
            this.executePhase(n);
        } else {
            this.endCurrentPhase();
        }
    }

    private void prepareForPhase(int n) {
        switch (n) {
            case 1: {
                this.mapSettings.setBoardsAvailableVector(this.scanForBoards(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight()));
                this.mapSettings.setNullBoards(DEFAULT_BOARD);
                break;
            }
            case 3: {
                this.resetPlayerReady();
                this.mapSettings.replaceBoardWithRandom("[RANDOM]");
                this.mapSettings.replaceBoardWithRandom(DEFAULT_BOARD);
                Board[] boardArray = new Board[this.mapSettings.getMapWidth() * this.mapSettings.getMapHeight()];
                int n2 = 0;
                while (n2 < this.mapSettings.getMapWidth() * this.mapSettings.getMapHeight()) {
                    boardArray[n2] = new Board();
                    boardArray[n2].load((String)this.mapSettings.getBoardsSelectedVector().elementAt(n2) + ".board");
                    ++n2;
                }
                this.game.board.combine(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight(), this.mapSettings.getMapWidth(), this.mapSettings.getMapHeight(), boardArray);
                this.game.setHasDeployed(false);
                this.game.determineWindDirection();
                break;
            }
            case 4: {
                this.attacks.removeAllElements();
                this.roundReport = new StringBuffer();
                this.resetEntityPhase();
                this.resetEntityRound();
                this.resetActivePlayersReady();
                this.rollInitiative();
                this.setIneligible(n);
                this.determineTurnOrder();
                this.writeInitiativeReport();
                this.send(this.createReportPacket());
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                this.resetEntityPhase();
                this.setIneligible(n);
                this.determineTurnOrder();
                this.resetActivePlayersReady();
                this.entityAllUpdate();
                this.phaseReport = new StringBuffer();
                break;
            }
            case 10: {
                this.phaseReport = new StringBuffer();
                this.resetEntityPhase();
                this.resolveHeat();
                this.checkForSuffocation();
                this.resolveCrewDamage();
                this.resolveCrewWakeUp();
                this.resolveFire();
                this.autoSave();
                if (this.phaseReport.length() > 0) {
                    this.roundReport.append(this.phaseReport.toString());
                }
                this.log.append("\n" + this.roundReport.toString());
            }
            case 6: 
            case 8: {
                this.resetActivePlayersReady();
                this.send(this.createReportPacket());
                break;
            }
            case 11: {
                this.prepareVictoryReport();
                this.send(this.createReportPacket());
                this.send(this.createEndOfGamePacket());
            }
        }
    }

    private boolean isPhasePlayable(int n) {
        switch (n) {
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                return this.areMoreTurns();
            }
        }
        return true;
    }

    private void executePhase(int n) {
        switch (n) {
            case 3: {
                this.send(this.createBoardPacket());
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                this.turnIndex = 0;
                this.changeToNextTurn();
            }
        }
    }

    private void endCurrentPhase() {
        switch (this.game.phase) {
            case 1: {
                this.changePhase(3);
                break;
            }
            case 3: {
                this.changePhase(4);
                break;
            }
            case 12: {
                this.game.setHasDeployed(true);
                this.changePhase(4);
                break;
            }
            case 4: {
                if (this.game.hasDeployed()) {
                    this.changePhase(5);
                    break;
                }
                this.changePhase(12);
                break;
            }
            case 5: {
                this.roundReport.append("\nMovement Phase\n-------------------\n");
                this.addMovementHeat();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                this.checkForFlamingDeath();
                if (this.phaseReport.length() > 0) {
                    this.roundReport.append(this.phaseReport.toString());
                    this.changePhase(6);
                    break;
                }
                this.roundReport.append("<nothing>\n");
                this.changePhase(7);
                break;
            }
            case 6: {
                this.changePhase(7);
                break;
            }
            case 7: {
                this.assignAMS();
                this.resolveWeaponAttacks();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                if (this.phaseReport.length() > 0) {
                    this.roundReport.append(this.phaseReport.toString());
                    this.changePhase(8);
                    break;
                }
                this.roundReport.append("<nothing>\n");
                this.changePhase(9);
                break;
            }
            case 8: {
                this.changePhase(9);
                break;
            }
            case 9: {
                this.resolvePhysicalAttacks();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                if (this.phaseReport.length() > 0) {
                    this.roundReport.append(this.phaseReport.toString());
                } else {
                    this.roundReport.append("<nothing>\n");
                }
                this.changePhase(10);
                break;
            }
            case 10: {
                if (this.victory()) {
                    this.changePhase(11);
                    break;
                }
                this.changePhase(4);
                break;
            }
            case 11: {
                this.forceVictory = false;
                this.resetGame();
            }
        }
    }

    private void changeToNextTurn() {
        if (!this.areMoreTurns()) {
            this.endCurrentPhase();
            return;
        }
        GameTurn gameTurn = this.nextTurn();
        if (this.getPlayer(gameTurn.getPlayerNum()).isGhost()) {
            this.changeToNextTurn();
            return;
        }
        this.changeTurn(gameTurn);
    }

    private void changeTurn(GameTurn gameTurn) {
        Player player = this.getPlayer(gameTurn.getPlayerNum());
        this.game.setTurn(gameTurn);
        if (player != null) {
            player.setReady(false);
        }
        this.send(new Packet(16, gameTurn));
    }

    public boolean victory() {
        if (this.forceVictory) {
            return true;
        }
        if (!this.game.getOptions().booleanOption("check_victory")) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        boolean[] blArray = new boolean[Player.MAX_TEAMS];
        boolean bl = false;
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            int n3 = player.getTeam();
            if (this.game.getLiveEntitiesOwnedBy(player) <= 0) continue;
            ++n;
            if (n3 == 0) {
                bl = true;
                continue;
            }
            if (blArray[n3]) continue;
            ++n2;
            blArray[n3] = true;
        }
        return n <= 1 || n2 == 1 && !bl;
    }

    private boolean deploy(Entity entity, Coords coords, Coords coords2, int n) {
        if (this.game.board.contains(coords) && this.game.getFirstEntity(coords) == null && !entity.isHexProhibited(this.game.board.getHex(coords))) {
            this.placeEntity(entity, coords, coords.direction(coords2));
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < 6) {
                Coords coords3 = coords.translated(n3);
                if (this.deploy(entity, coords3, coords2, n2)) {
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    private void placeEntity(Entity entity, Coords coords, int n) {
        entity.setPosition(coords);
        entity.setFacing(n);
        entity.setSecondaryFacing(n);
    }

    private Coords getStartingCoords(int n) {
        switch (n) {
            default: {
                return new Coords(1, 1);
            }
            case 1: {
                return new Coords(this.game.board.width / 2, 1);
            }
            case 2: {
                return new Coords(this.game.board.width - 2, 1);
            }
            case 3: {
                return new Coords(this.game.board.width - 2, this.game.board.height / 2);
            }
            case 4: {
                return new Coords(this.game.board.width - 2, this.game.board.height - 2);
            }
            case 5: {
                return new Coords(this.game.board.width / 2, this.game.board.height - 2);
            }
            case 6: {
                return new Coords(1, this.game.board.height - 2);
            }
            case 7: 
        }
        return new Coords(1, this.game.board.height / 2);
    }

    private void rollInitiative() {
        ++this.roundCounter;
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            player.getInitiative().clear();
        }
        this.resolveInitTies(this.game.getPlayersVector());
        this.transmitAllPlayerUpdates();
    }

    private void resolveInitTies(Vector vector) {
        Serializable serializable;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            serializable = (Player)enumeration.nextElement();
            ((Player)serializable).getInitiative().addRoll();
        }
        serializable = new Vector();
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            Player player = (Player)enumeration2.nextElement();
            ((Vector)serializable).removeAllElements();
            ((Vector)serializable).addElement(player);
            Enumeration enumeration3 = this.game.getPlayers();
            while (enumeration3.hasMoreElements()) {
                Player player2 = (Player)enumeration3.nextElement();
                if (player == player2 || !player.getInitiative().equals(player2.getInitiative())) continue;
                ((Vector)serializable).addElement(player2);
            }
            if (((Vector)serializable).size() <= 1) continue;
            this.resolveInitTies((Vector)serializable);
        }
    }

    private void determineTurnOrder() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        ArrayList arrayList = new ArrayList(this.game.getNoOfPlayers());
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            object = (Player)enumeration.nextElement();
            arrayList.add(object);
        }
        Collections.sort((List)arrayList, (Comparator)new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Player)object).getInitiative().compareTo(((Player)object2).getInitiative());
            }
        });
        object = new int[this.game.getNoOfPlayers()];
        int n6 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Player player = (Player)iterator.next();
            object[n6++] = player.getId();
        }
        int n7 = 255;
        int[] nArray = new int[n7];
        int n8 = 0;
        int n9 = 0;
        int[] nArray2 = new int[n7];
        int n10 = 0;
        boolean bl = this.game.getOptions().booleanOption("inf_move_multi");
        boolean bl2 = this.game.getOptions().booleanOption("inf_move_last");
        Enumeration enumeration2 = this.game.getEntities();
        while (enumeration2.hasMoreElements()) {
            Entity entity = (Entity)enumeration2.nextElement();
            if (!entity.isSelectable()) continue;
            n8 = entity.getOwner().getId();
            if (entity instanceof Infantry) {
                int n11 = n8;
                nArray2[n11] = nArray2[n11] + 1;
                if (bl && 1 != nArray2[n8] % 3) continue;
                if (bl2) {
                    ++n10;
                    continue;
                }
            }
            int n12 = n8;
            nArray[n12] = nArray[n12] + 1;
            ++n9;
        }
        this.turns.setSize(n9 + n10);
        this.turnIndex = 0;
        while (this.turnIndex < n9) {
            int n13 = 1;
            n5 = Integer.MAX_VALUE;
            n4 = 0;
            while (n4 < n7) {
                if (nArray[n4] > 0 && nArray[n4] < n5) {
                    n5 = nArray[n4];
                }
                if (nArray[n4] > n13) {
                    n13 = nArray[n4];
                }
                ++n4;
            }
            n3 = 0;
            while (n3 < ((Object)object).length) {
                if (nArray[object[n3]] > 0) {
                    n2 = Math.max(1, (int)Math.floor(nArray[object[n3]] / n5));
                    n = 0;
                    while (n < n2) {
                        this.turns.setElementAt(new GameTurn((int)object[n3]), this.turnIndex);
                        ++this.turnIndex;
                        Object object2 = object[n3];
                        nArray[object2] = nArray[object2] - 1;
                        ++n;
                    }
                }
                ++n3;
            }
        }
        while (this.turnIndex < this.turns.size()) {
            int n14 = 1;
            n5 = Integer.MAX_VALUE;
            n4 = 0;
            while (n4 < n7) {
                if (nArray2[n4] > 0 && nArray2[n4] < n5) {
                    n5 = nArray2[n4];
                }
                if (nArray2[n4] > n14) {
                    n14 = nArray2[n4];
                }
                ++n4;
            }
            n3 = 0;
            while (n3 < ((Object)object).length) {
                if (nArray2[object[n3]] > 0) {
                    n2 = Math.max(1, (int)Math.floor(nArray2[object[n3]] / n5));
                    n = 0;
                    while (n < n2) {
                        this.turns.setElementAt(new GameTurn((int)object[n3]), this.turnIndex);
                        ++this.turnIndex;
                        Object object3 = object[n3];
                        nArray2[object3] = nArray2[object3] - 1;
                        ++n;
                    }
                }
                ++n3;
            }
        }
        this.turnIndex = 0;
        this.turnInfMoved = 0;
        this.turnLastPlayerId = -1;
    }

    private void writeInitiativeReport() {
        if (this.game.hasDeployed()) {
            this.roundReport.append("\nInitiative Phase for Round #").append(this.roundCounter);
        } else {
            this.roundReport.append("\nInitiative Phase for Deployment");
        }
        this.roundReport.append("\n------------------------------\n");
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.roundReport.append(player.getName() + " rolls a ");
            int n = 0;
            while (n < player.getInitiative().size()) {
                if (n != 0) {
                    this.roundReport.append(" / ");
                }
                this.roundReport.append(player.getInitiative().getRoll(n));
                ++n;
            }
            this.roundReport.append(".\n");
        }
        this.roundReport.append("\nThe turn order is:\n  ");
        boolean bl = true;
        Enumeration enumeration2 = this.turns.elements();
        while (enumeration2.hasMoreElements()) {
            GameTurn gameTurn = (GameTurn)enumeration2.nextElement();
            this.roundReport.append((bl ? "" : ", ") + this.getPlayer(gameTurn.getPlayerNum()).getName());
            bl = false;
        }
        this.roundReport.append("\n\n");
        this.roundReport.append("  Wind direction is " + this.game.getStringWindDirection() + "\n");
        this.turnIndex = 0;
    }

    private void setIneligible(int n) {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (this.isEligibleFor(entity, n)) continue;
            entity.ready = false;
        }
    }

    private boolean isEligibleFor(Entity entity, int n) {
        switch (n) {
            case 7: {
                return this.isEligibleForFiring(entity, n);
            }
            case 9: {
                if (entity instanceof Mech) {
                    return this.isEligibleForPhysical(entity, n);
                }
                return false;
            }
        }
        return true;
    }

    private boolean isEligibleForFiring(Entity entity, int n) {
        if (entity.isUnjammingRAC()) {
            return false;
        }
        return !entity.isCharging() && !entity.isMakingDfa();
    }

    private boolean isEligibleForPhysical(Entity entity, int n) {
        boolean bl = false;
        boolean bl2 = this.game.getOptions().booleanOption("friendly_fire");
        if (!entity.isActive()) {
            return false;
        }
        if (entity.isUnjammingRAC()) {
            return false;
        }
        if (entity.isCharging() || entity.isMakingDfa() || entity.isFindingClub()) {
            return false;
        }
        if (!this.game.getOptions().booleanOption("skip_ineligable_physical")) {
            return true;
        }
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity2 = (Entity)enumeration.nextElement();
            if (!entity.isEnemyOf(entity2) && (!bl2 || entity.getId() == entity2.getId())) continue;
            bl |= Compute.toHitPunch(this.game, entity.getId(), entity2.getId(), 1).getValue() != Integer.MAX_VALUE;
            bl |= Compute.toHitPunch(this.game, entity.getId(), entity2.getId(), 2).getValue() != Integer.MAX_VALUE;
            bl |= Compute.toHitKick(this.game, entity.getId(), entity2.getId(), 1).getValue() != Integer.MAX_VALUE;
            bl |= Compute.toHitKick(this.game, entity.getId(), entity2.getId(), 2).getValue() != Integer.MAX_VALUE;
        }
        return bl;
    }

    private void doEntityMovement(Packet packet, int n) {
        Object object;
        MovementData movementData = (MovementData)packet.getObject(1);
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        boolean bl = this.game.getOptions().booleanOption("inf_move_multi");
        boolean bl2 = this.game.getOptions().booleanOption("inf_move_last");
        if (entity == null) {
            return;
        }
        if (!entity.ready) {
            return;
        }
        if (bl && this.turnInfMoved > 0 && (!(entity instanceof Infantry) || entity.getOwnerId() != this.turnLastPlayerId) || !bl2 || this.turnInfMoved <= 0 || !(entity instanceof Infantry)) {
            // empty if block
        }
        if (movementData.contains(10)) {
            this.phaseReport.append("\n" + entity.getDisplayName() + " flees the battlefield.\n");
            this.game.moveToGraveyard(entity.getId());
            this.send(this.createRemoveEntityPacket(entity.getId()));
            return;
        }
        if (entity instanceof Mech && ((Mech)entity).checkForMASCFailure(this.phaseReport)) {
            return;
        }
        Coords coords = entity.getPosition();
        Coords coords2 = entity.getPosition();
        int n2 = entity.getFacing();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        Serializable serializable = null;
        boolean bl3 = entity instanceof Infantry;
        Compute.compile(this.game, entity.getId(), movementData);
        Enumeration enumeration = movementData.getSteps();
        while (enumeration.hasMoreElements()) {
            object = (MovementData.Step)enumeration.nextElement();
            if (((MovementData.Step)object).getMovementType() == -1) break;
            n6 = ((MovementData.Step)object).getMovementType();
        }
        boolean bl4 = true;
        boolean bl5 = false;
        object = movementData.getSteps();
        while (object.hasMoreElements()) {
            Object object2;
            Serializable serializable2;
            MovementData.Step step = (MovementData.Step)object.nextElement();
            boolean bl6 = entity.isProne();
            if (step.getMovementType() == -1) break;
            if (step.getType() == 5) {
                ++entity.heatBuildup;
                entity.setProne(false);
                bl6 = false;
                this.doSkillCheckInPlace(entity, new PilotingRollData(entity.getId(), 0, "getting up"), true);
            } else if (bl4) {
                if (n6 == 2 && !entity.isProne() && (entity.getDestroyedCriticals(0, 4, 1) > 0 || entity.hasHipCrit())) {
                    this.doSkillCheckInPlace(entity, new PilotingRollData(entity.getId(), 0, "running with damaged hip actuator or gyro"), false);
                }
                bl4 = false;
            }
            if (!bl6 && entity.isProne()) {
                n5 = step.getMovementType();
                n2 = entity.getFacing();
                coords2 = entity.getPosition();
                n4 = step.getMpUsed();
                bl5 = true;
                break;
            }
            if (step.getType() == 15) {
                entity.setUnjammingRAC(true);
                this.attacks.addElement(new UnjamAction(entity.getId()));
                break;
            }
            n5 = step.getMovementType();
            n3 = step.getDistance();
            n4 = step.getMpUsed();
            if (step.getType() == 8) {
                serializable2 = this.game.getFirstEntity(step.getPosition());
                object2 = new ChargeAttackAction(entity.getId(), ((Entity)serializable2).getId(), ((Entity)serializable2).getPosition());
                entity.setDisplacementAttack((DisplacementAttackAction)object2);
                this.pendingCharges.addElement(object2);
                break;
            }
            if (step.getType() == 9) {
                serializable2 = this.game.getFirstEntity(step.getPosition());
                object2 = new DfaAttackAction(entity.getId(), ((Entity)serializable2).getId(), ((Entity)serializable2).getPosition());
                entity.setDisplacementAttack((DisplacementAttackAction)object2);
                this.pendingCharges.addElement(object2);
                break;
            }
            coords2 = step.getPosition();
            n2 = step.getFacing();
            serializable2 = this.game.board.getHex(coords2);
            if (n5 != 3 && serializable != null && serializable.contains(5) && n6 == 2 && n7 != n2 && !coords.equals(coords2) && !bl3) {
                object2 = null;
                object2 = entity instanceof Mech ? new PilotingRollData(entity.getId(), this.getMovementPSRModifier(n3), "running & turning on pavement", true) : new PilotingRollData(entity.getId(), this.getMovementPSRModifier(n3), "reckless driving on pavement", true);
                if (!this.doSkillCheckWhileMoving(entity, coords, coords2, (PilotingRollData)object2)) {
                    int n8;
                    Coords coords3 = coords2 = entity.getPosition();
                    Hex hex = null;
                    int n9 = 0;
                    Enumeration enumeration2 = null;
                    Entity entity2 = null;
                    entity.delta_distance = n3;
                    coords3 = coords2.translated(n7);
                    hex = this.game.board.getHex(coords3);
                    n9 = 0;
                    while (n9 < n3) {
                        int n10;
                        if (!this.game.board.contains(coords3)) {
                            if (this.game.getOptions().booleanOption("push_off_board")) {
                                this.game.moveToGraveyard(entity.getId());
                                this.send(this.createRemoveEntityPacket(entity.getId()));
                                this.phaseReport.append("*** " + entity.getDisplayName() + " has skidded off the field. ***\n");
                                break;
                            }
                            this.phaseReport.append("   Can't skid off the field.\n");
                            break;
                        }
                        if (entity.isHexProhibited(hex)) {
                            this.phaseReport.append("   Can't skid into hex " + coords3.getBoardNum() + ".\n");
                            break;
                        }
                        int n11 = this.game.board.getHex(coords2).getElevation();
                        if (n11 < (n10 = hex.getElevation())) {
                            this.phaseReport.append("   Skids into base of hill in hex " + coords3.getBoardNum() + ".\n");
                            break;
                        }
                        if (n11 > n10) {
                            this.phaseReport.append("   Skids off a hillside.\n");
                            this.doEntityFallsInto(entity, coords2, coords3, Compute.getBasePilotingRoll(this.game, entity.getId()));
                            break;
                        }
                        n8 = 0;
                        enumeration2 = this.game.getEntities(coords3);
                        while (enumeration2.hasMoreElements()) {
                            Object object3;
                            entity2 = (Entity)enumeration2.nextElement();
                            if (!(entity2 instanceof Infantry)) {
                                this.phaseReport.append("   Skids into " + entity2.getShortName() + " in hex " + coords3.getBoardNum() + "... ");
                                object3 = new ToHitData();
                                ((ToHitData)object3).setHitTable(entity2.isProne() ? 0 : 2);
                                ((ToHitData)object3).setSideTable(Compute.targetSideTable(entity, entity2));
                                this.resolveChargeDamage(entity, entity2, (ToHitData)object3, n7);
                                n8 = 1;
                            } else {
                                this.phaseReport.append("   Skids through " + entity2.getShortName() + " in hex " + coords3.getBoardNum() + "... ");
                                object3 = entity2.rollHitLocation(0, Compute.targetSideTable(entity, entity2));
                                this.phaseReport.append(this.damageEntity(entity2, (HitData)object3, Math.round(entity.getWeight() / 5.0f)));
                                this.phaseReport.append("\n");
                            }
                            if (entity2.isDoomed()) {
                                if (entity2.ready) {
                                    int n12 = entity2.getOwner().getId();
                                    int n13 = this.turnIndex + 1;
                                    while (n13 < this.turns.size()) {
                                        if (n12 == ((GameTurn)this.turns.elementAt(n13)).getPlayerNum()) {
                                            this.turns.removeElementAt(n13);
                                            break;
                                        }
                                        ++n13;
                                    }
                                }
                                entity2.setDestroyed(true);
                                this.game.moveToGraveyard(entity2.getId());
                                this.send(this.createRemoveEntityPacket(entity2.getId()));
                            }
                            if (this.game.isInGraveyard(entity2)) continue;
                            this.entityUpdate(entity2.getId());
                        }
                        if (n8 != 0) break;
                        if (hex.contains(10)) {
                            this.phaseReport.append("   Skids into building in hex " + coords3.getBoardNum() + ".\n");
                            coords2 = coords3;
                            entity.setPosition(coords2);
                            break;
                        }
                        coords2 = coords3;
                        entity.setPosition(coords2);
                        this.phaseReport.append("   Skids into hex " + coords2.getBoardNum() + ".\n");
                        coords3 = coords3.translated(n7);
                        hex = this.game.board.getHex(coords3);
                        ++n9;
                    }
                    coords2 = entity.getPosition();
                    entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
                    while (entity2 != null) {
                        coords3 = Compute.getValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n7);
                        if (null == coords3) {
                            System.err.println("The skid of " + entity.getShortName() + " should displace " + entity2.getShortName() + " in hex " + coords2.getBoardNum() + " but there is nowhere to go.");
                            break;
                        }
                        this.phaseReport.append("    ");
                        this.doEntityDisplacement(entity2, coords2, coords3, null);
                        entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
                    }
                    if (entity instanceof Mech) {
                        n8 = n9 * (int)Math.ceil((double)Math.round((double)entity.getWeight() / 10.0) / 2.0);
                        this.phaseReport.append("    " + entity.getDisplayName() + " suffers " + n8 + " damage from the skid.");
                        while (n8 > 0) {
                            int n14 = Math.min(5, n8);
                            HitData hitData = entity.rollHitLocation(0, 0);
                            this.phaseReport.append(this.damageEntity(entity, hitData, n14));
                            n8 -= n14;
                        }
                        this.phaseReport.append("\n");
                    }
                    if (entity.isDoomed()) {
                        entity.setDestroyed(true);
                        this.game.moveToGraveyard(entity.getId());
                        this.send(this.createRemoveEntityPacket(entity.getId()));
                    }
                    this.phaseReport.append("      Skid ends.\n");
                    n2 = entity.getFacing();
                    coords2 = entity.getPosition();
                    entity.setSecondaryFacing(n2);
                    n4 = entity.getRunMP();
                    entity.moved = n5;
                    bl5 = true;
                    break;
                }
            }
            if (!coords.equals(coords2) && step.getMovementType() != 3 && ((Hex)serializable2).levelOf(3) > 0) {
                this.doSkillCheckWhileMoving(entity, coords, coords2, new PilotingRollData(entity.getId(), 0, "entering Rubble"));
            }
            if (!coords.equals(coords2) && step.getMovementType() != 3 && this.game.board.getHex(coords).contains(7) && entity instanceof Mech) {
                entity.heatBuildup += 2;
                this.phaseReport.append("\n" + entity.getDisplayName() + " passes through a fire.  It will generate 2 more heat this round.\n");
            }
            if (!coords.equals(coords2) && step.getMovementType() != 3 && this.game.board.getHex(coords2).contains(7) && !(entity instanceof Mech)) {
                this.doFlamingDeath(entity);
            }
            if (!coords.equals(coords2) && step.getMovementType() != 3 && ((Hex)serializable2).levelOf(4) > 0 && entity.getMovementType() != 5) {
                if (((Hex)serializable2).levelOf(4) == 1) {
                    this.doSkillCheckWhileMoving(entity, coords, coords2, new PilotingRollData(entity.getId(), -1, "entering Depth 1 Water"));
                } else if (((Hex)serializable2).levelOf(4) == 2) {
                    this.doSkillCheckWhileMoving(entity, coords, coords2, new PilotingRollData(entity.getId(), 0, "entering Depth 2 Water"));
                } else {
                    this.doSkillCheckWhileMoving(entity, coords, coords2, new PilotingRollData(entity.getId(), 1, "entering Depth 3+ Water"));
                }
            }
            if (!bl6 && entity.isProne()) {
                n2 = entity.getFacing();
                coords2 = entity.getPosition();
                n4 = step.getMpUsed();
                bl5 = true;
                break;
            }
            coords = new Coords(coords2);
            if (!((Hex)serializable2).equals(serializable)) {
                n7 = n2;
            }
            serializable = serializable2;
        }
        entity.setPosition(coords2);
        entity.setFacing(n2);
        entity.setSecondaryFacing(n2);
        entity.delta_distance = n3;
        entity.moved = n5;
        entity.mpUsed = n4;
        if (n6 == 3 && !entity.isMakingDfa()) {
            int n15;
            if (entity.getDestroyedCriticals(0, 4, 1) > 0 || entity.hasLegActuatorCrit()) {
                this.doSkillCheckInPlace(entity, new PilotingRollData(entity.getId(), 0, "landing with damaged leg actuator or gyro"), false);
            }
            if ((n15 = this.game.board.getHex(coords2).levelOf(4)) == 1) {
                this.doSkillCheckInPlace(entity, new PilotingRollData(entity.getId(), -1, "entering Depth 1 Water"), false);
            } else if (n15 == 2) {
                this.doSkillCheckInPlace(entity, new PilotingRollData(entity.getId(), 0, "entering Depth 2 Water"), false);
            } else if (n15 >= 3) {
                this.doSkillCheckInPlace(entity, new PilotingRollData(entity.getId(), 1, "entering Depth 3+ Water"), false);
            }
        }
        if (bl5 && entity.mpUsed < entity.getRunMP() && entity.isSelectable()) {
            entity.applyDamage();
            entity.ready = true;
            this.turns.insertElementAt(new GameTurn(entity.getOwner().getId(), entity.getId()), this.turnIndex);
        } else {
            entity.ready = false;
        }
        if (entity instanceof Infantry) {
            ++this.turnInfMoved;
            this.turnLastPlayerId = entity.getOwnerId();
            if (bl) {
                if (3 == this.turnInfMoved || !this.game.hasInfantry(this.turnLastPlayerId)) {
                    this.turnInfMoved = 0;
                } else {
                    --this.turnIndex;
                }
            }
        }
        if (!this.game.isInGraveyard(entity)) {
            this.entityUpdate(entity.getId());
        }
        if (this.doBlind()) {
            this.send(entity.getOwner().getId(), this.createFilteredEntitiesPacket(entity.getOwner()));
        }
    }

    public void addMovementHeat() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.moved == 1) {
                ++entity.heatBuildup;
                continue;
            }
            if (entity.moved == 2) {
                entity.heatBuildup += 2;
                continue;
            }
            if (entity.moved != 3) continue;
            entity.heatBuildup += Math.max(3, entity.delta_distance);
        }
    }

    private void doSkillCheckInPlace(Entity entity, PilotingRollData pilotingRollData, boolean bl) {
        if (!(entity instanceof Mech) || entity.isProne()) {
            return;
        }
        if (bl && !entity.needsRollToStand() && entity.getDestroyedCriticals(0, 4, 1) < 2) {
            this.phaseReport.append("\n" + entity.getDisplayName() + " does not need to make " + "a piloting skill check to stand up because it has all four of its legs.");
            return;
        }
        PilotingRollData pilotingRollData2 = Compute.getBasePilotingRoll(this.game, entity.getId());
        pilotingRollData2.append(pilotingRollData);
        this.phaseReport.append("\n" + entity.getDisplayName() + " must make a piloting skill check (" + pilotingRollData.getPlainDesc() + ")" + ".\n");
        int n = Compute.d6(2);
        this.phaseReport.append("Needs " + pilotingRollData2.getValueAsString() + " [" + pilotingRollData2.getDesc() + "]" + ", rolls " + n + " : ");
        if (n < pilotingRollData2.getValue()) {
            this.phaseReport.append("falls.\n");
            this.doEntityFall(entity, pilotingRollData2);
        } else {
            this.phaseReport.append("succeeds.\n");
        }
    }

    private boolean doSkillCheckWhileMoving(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData) {
        boolean bl = true;
        if (!(entity instanceof Mech) && !pilotingRollData.isForSkid()) {
            return bl;
        }
        PilotingRollData pilotingRollData2 = Compute.getBasePilotingRoll(this.game, entity.getId());
        Hex hex = this.game.board.getHex(coords);
        Hex hex2 = this.game.board.getHex(coords2);
        pilotingRollData2.append(pilotingRollData);
        boolean bl2 = coords.equals(coords2) || hex.floor() < hex2.floor();
        int n = Math.abs(hex2.floor() - hex.floor());
        this.phaseReport.append("\n" + entity.getDisplayName() + " must make a piloting skill check" + " while moving from hex " + coords.getBoardNum() + " to hex " + coords2.getBoardNum() + " (" + pilotingRollData.getPlainDesc() + ")" + ".\n");
        int n2 = Compute.d6(2);
        this.phaseReport.append("Needs " + pilotingRollData2.getValueAsString() + " [" + pilotingRollData2.getDesc() + "]" + ", rolls " + n2 + " : ");
        if (n2 < pilotingRollData2.getValue()) {
            if (entity instanceof Mech) {
                this.phaseReport.append("falls.\n");
                this.doEntityFallsInto(entity, bl2 ? coords2 : coords, bl2 ? coords : coords2, pilotingRollData2);
            } else {
                this.phaseReport.append("fails.\n");
                entity.setPosition(bl2 ? coords : coords2);
            }
            bl = false;
        } else {
            this.phaseReport.append("succeeds.\n");
        }
        return bl;
    }

    private void doEntityFallsInto(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData) {
        Hex hex = this.game.board.getHex(coords);
        Hex hex2 = this.game.board.getHex(coords2);
        int n = Math.abs(hex2.floor() - hex.floor());
        int n2 = coords.direction(coords2);
        Entity entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
        if (entity2 != null && !Compute.isValidDisplacement(this.game, entity2.getId(), coords, coords2)) {
            Coords coords3 = coords2;
            coords2 = coords;
            coords = coords3;
            entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
        }
        this.phaseReport.append(entity.getDisplayName() + " falls " + n + " level(s) into hex " + coords2.getBoardNum() + ".\n");
        if (entity2 == null) {
            this.doEntityFall(entity, coords2, n, pilotingRollData);
            return;
        }
        if (n < 2) {
            this.doEntityFall(entity, coords2, n, pilotingRollData);
            this.doEntityDisplacement(entity2, coords2, coords2.translated(n2), new PilotingRollData(entity2.getId(), 0, "domino effect"));
            this.entityUpdate(entity2.getId());
        }
    }

    private void doEntityDisplacement(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData) {
        Hex hex = this.game.board.getHex(coords);
        Hex hex2 = this.game.board.getHex(coords2);
        int n = coords.direction(coords2);
        int n2 = entity.elevationOccupied(hex) - entity.elevationOccupied(hex2);
        Entity entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
        if (n2 < 0) {
            n2 = 0;
        }
        if (entity2 == null) {
            if (n2 < 2) {
                this.phaseReport.append(entity.getDisplayName() + " is displaced into hex " + coords2.getBoardNum() + ".\n");
                entity.setPosition(coords2);
                if (pilotingRollData != null) {
                    this.pilotRolls.addElement(pilotingRollData);
                }
                this.entityUpdate(entity.getId());
                return;
            }
            this.phaseReport.append(entity.getDisplayName() + " falls " + n2 + " levels into hex " + coords2.getBoardNum() + ".\n");
            PilotingRollData pilotingRollData2 = Compute.getBasePilotingRoll(this.game, entity.getId());
            if (pilotingRollData != null) {
                pilotingRollData2.append(pilotingRollData);
            }
            this.doEntityFall(entity, coords2, n2, pilotingRollData2);
            return;
        }
        System.err.println("server.doEntityDisplacement: destination occupied");
        if (n2 < 2) {
            this.phaseReport.append(entity.getDisplayName() + " is displaced into hex " + coords2.getBoardNum() + ", violating stacking with " + entity2.getDisplayName() + ".\n");
            entity.setPosition(coords2);
            if (pilotingRollData != null) {
                this.pilotRolls.addElement(pilotingRollData);
            }
            this.doEntityDisplacement(entity2, coords2, coords2.translated(n), new PilotingRollData(entity2.getId(), 0, "domino effect"));
            this.entityUpdate(entity2.getId());
            return;
        }
        this.phaseReport.append(entity.getDisplayName() + " falls " + n2 + " levels into hex " + coords2.getBoardNum() + ", violating stacking with " + entity2.getDisplayName() + ".\n");
        ToHitData toHitData = new ToHitData(7, "base");
        toHitData.append(Compute.getTargetMovementModifier(this.game, entity2.getId()));
        toHitData.append(Compute.getTargetTerrainModifier(this.game, entity2.getId()));
        int n3 = Compute.d6(2);
        this.phaseReport.append("Collision occurs on a " + toHitData.getValue() + " or greater.  Rolls " + n3);
        if (n3 >= toHitData.getValue()) {
            Object object;
            this.phaseReport.append(", hits!\n");
            int n4 = (int)Math.ceil(entity.getWeight() / 10.0f);
            this.phaseReport.append(entity2.getDisplayName() + " takes " + n4 + " from the collision.");
            while (n4 > 0) {
                int n5 = Math.min(5, n4);
                object = entity2.rollHitLocation(1, 0);
                this.phaseReport.append(this.damageEntity(entity2, (HitData)object, n5));
                n4 -= n5;
            }
            this.phaseReport.append("\n");
            PilotingRollData pilotingRollData3 = Compute.getBasePilotingRoll(this.game, entity.getId());
            pilotingRollData3.append(pilotingRollData);
            this.doEntityFall(entity, coords2, n2, 3, pilotingRollData3);
            object = Compute.getValidDisplacement(this.game, entity2.getId(), coords2, n);
            if (object != null) {
                this.doEntityDisplacement(entity2, coords2, (Coords)object, new PilotingRollData(entity2.getId(), 2, "fallen on"));
                this.entityUpdate(entity2.getId());
            } else {
                this.phaseReport.append(this.destroyEntity(entity2, "impossible displacement"));
            }
        } else {
            this.phaseReport.append(", misses.\n");
            Coords coords3 = Compute.getValidDisplacement(this.game, entity.getId(), coords2, n);
            if (coords3 != null) {
                this.doEntityDisplacement(entity, coords, coords3, new PilotingRollData(entity.getId(), Integer.MAX_VALUE, "pushed off a cliff"));
                this.entityUpdate(entity.getId());
            } else {
                this.phaseReport.append(this.destroyEntity(entity, "impossible displacement"));
            }
        }
    }

    private void receiveDeployment(Packet packet) {
        if (this.game.phase != 12) {
            return;
        }
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        Coords coords = (Coords)packet.getObject(1);
        int n = packet.getIntValue(2);
        if (this.game.board.isLegalDeployment(coords, entity.getOwner())) {
            entity.setPosition(coords);
            entity.setFacing(n);
            entity.setSecondaryFacing(n);
            entity.ready = false;
            this.entityUpdate(entity.getId());
        } else {
            System.err.println("Received invalid deployment for " + entity.getShortName());
        }
        boolean bl = this.game.getOptions().booleanOption("inf_move_multi");
        if (entity instanceof Infantry) {
            ++this.turnInfMoved;
            this.turnLastPlayerId = entity.getOwnerId();
            if (bl) {
                if (3 == this.turnInfMoved || !this.game.hasInfantry(this.turnLastPlayerId)) {
                    this.turnInfMoved = 0;
                } else {
                    --this.turnIndex;
                }
            }
        }
    }

    private void receiveAttack(Packet packet) {
        Vector vector = (Vector)packet.getObject(1);
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AbstractEntityAction abstractEntityAction;
            EntityAction entityAction = (EntityAction)enumeration.nextElement();
            if (entityAction instanceof PushAttackAction) {
                abstractEntityAction = (PushAttackAction)entityAction;
                entity.setDisplacementAttack((DisplacementAttackAction)abstractEntityAction);
                this.pendingCharges.addElement(abstractEntityAction);
            } else {
                this.attacks.addElement(entityAction);
            }
            if (entityAction instanceof TorsoTwistAction) {
                abstractEntityAction = (TorsoTwistAction)entityAction;
                this.game.getEntity(abstractEntityAction.getEntityId()).setSecondaryFacing(((TorsoTwistAction)abstractEntityAction).getFacing());
            } else if (entityAction instanceof FlipArmsAction) {
                abstractEntityAction = (FlipArmsAction)entityAction;
                this.game.getEntity(abstractEntityAction.getEntityId()).setArmsFlipped(((FlipArmsAction)abstractEntityAction).getIsFlipped());
            }
            this.send(this.createAttackPacket(entityAction));
        }
        this.entityUpdate(entity.getId());
    }

    private void assignAMS() {
        Serializable serializable;
        Serializable serializable2;
        Enumeration<Object> enumeration;
        Hashtable<Entity, Vector<Serializable>> hashtable = new Hashtable<Entity, Vector<Serializable>>();
        Enumeration enumeration2 = this.attacks.elements();
        while (enumeration2.hasMoreElements()) {
            enumeration = enumeration2.nextElement();
            if (!(enumeration instanceof WeaponAttackAction) || ((WeaponType)((Mounted)(serializable2 = this.game.getEntity(((AbstractEntityAction)(serializable = (WeaponAttackAction)((Object)enumeration))).getEntityId()).getEquipment(((WeaponAttackAction)serializable).getWeaponId()))).getType()).getDamage() != -2) continue;
            Entity entity = this.game.getEntity(((AbstractAttackAction)serializable).getTargetId());
            Vector<Serializable> vector = (Vector<Serializable>)hashtable.get(entity);
            if (vector == null) {
                vector = new Vector<Serializable>();
                hashtable.put(entity, vector);
            }
            vector.addElement(serializable);
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            serializable = (Entity)enumeration.nextElement();
            serializable2 = (Vector)hashtable.get(serializable);
            ((Entity)serializable).assignAMS((Vector)serializable2, this.attacks);
        }
    }

    private void resolveWeaponAttacks() {
        Object object;
        Object object2;
        this.roundReport.append("\nWeapon Attack Phase\n-------------------\n");
        Vector<WeaponResult> vector = new Vector<WeaponResult>(this.attacks.size());
        Enumeration enumeration = this.attacks.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            object2 = this.game.getEntity(((EntityAction)e).getEntityId());
            if (e instanceof WeaponAttackAction) {
                object = (WeaponAttackAction)e;
                vector.addElement(this.preTreatWeaponAttack((WeaponAttackAction)object));
                continue;
            }
            if (e instanceof TorsoTwistAction) {
                object = (TorsoTwistAction)e;
                this.game.getEntity(((AbstractEntityAction)object).getEntityId()).setSecondaryFacing(((TorsoTwistAction)object).getFacing());
                continue;
            }
            if (e instanceof FlipArmsAction) {
                object = (FlipArmsAction)e;
                this.game.getEntity(((AbstractEntityAction)object).getEntityId()).setArmsFlipped(((FlipArmsAction)object).getIsFlipped());
                continue;
            }
            if (e instanceof FindClubAction) {
                object = (FindClubAction)e;
                ((Entity)object2).setFindingClub(true);
                try {
                    ((Entity)object2).addEquipment(EquipmentType.getByInternalName("Tree Club"), -1);
                }
                catch (LocationFullException locationFullException) {
                    // empty catch block
                }
                this.phaseReport.append("\n" + ((Entity)object2).getDisplayName() + " uproots a tree for use as a club.\n");
                continue;
            }
            if (!(e instanceof UnjamAction)) continue;
            this.resolveUnjam(((Entity)object2).getId());
        }
        int n = -1;
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (WeaponResult)object2.nextElement();
            this.resolveWeaponAttack((WeaponResult)object, n);
            n = ((WeaponResult)object).waa.getEntityId();
        }
        this.attacks.removeAllElements();
    }

    private void resolveUnjam(int n) {
        Entity entity = this.game.getEntity(n);
        int n2 = entity.crew.getGunnery() + 3;
        this.phaseReport.append("\nRAC unjam attempts for " + entity.getDisplayName() + "\n");
        Enumeration enumeration = entity.getWeapons();
        while (enumeration.hasMoreElements()) {
            WeaponType weaponType;
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.isJammed() || (weaponType = (WeaponType)mounted.getType()).getAmmoType() != 23) continue;
            this.phaseReport.append("  Unjamming " + weaponType.getName() + "; needs " + n2 + ", ");
            int n3 = Compute.d6(2);
            this.phaseReport.append("rolls " + n3 + " : ");
            if (n3 >= n2) {
                this.phaseReport.append(" Successfully unjammed!\n");
                mounted.setJammed(false);
                continue;
            }
            this.phaseReport.append(" Still jammed!\n");
        }
    }

    private WeaponResult preTreatWeaponAttack(WeaponAttackAction weaponAttackAction) {
        boolean bl;
        Entity entity = this.game.getEntity(weaponAttackAction.getEntityId());
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        WeaponType weaponType = (WeaponType)mounted.getType();
        boolean bl2 = weaponType.getAmmoType() != -1 && !weaponType.hasFlag(3840);
        Mounted mounted2 = null;
        if (bl2) {
            if (weaponAttackAction.getAmmoId() > -1) {
                mounted2 = entity.getEquipment(weaponAttackAction.getAmmoId());
                mounted.setLinked(mounted2);
            } else {
                mounted2 = mounted.getLinked();
            }
        }
        WeaponResult weaponResult = new WeaponResult();
        weaponResult.waa = weaponAttackAction;
        if (mounted.isUsedThisRound()) {
            weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "Weapon has already been used this round");
            return weaponResult;
        }
        if (mounted.isUsedThisRound()) {
            weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "Weapon was destroyed in a previous round");
            return weaponResult;
        }
        if (mounted.isJammed()) {
            weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "Weapon is jammed");
            return weaponResult;
        }
        if (bl2 && (mounted2 == null || mounted2.getShotsLeft() == 0 || mounted2.isDumping())) {
            entity.loadWeapon(mounted);
            mounted2 = mounted.getLinked();
        }
        weaponResult.toHit = Compute.toHitWeapon(this.game, weaponAttackAction, this.attacks);
        weaponResult.roll = Compute.d6(2);
        boolean bl3 = bl = weaponType.getAmmoType() == 11 && weaponResult.roll < weaponResult.toHit.getValue();
        if (weaponResult.toHit.getValue() != Integer.MAX_VALUE && !bl) {
            weaponResult = this.addHeatUseAmmoFor(weaponAttackAction, weaponResult);
        }
        mounted.setUsedThisRound(true);
        if (!bl) {
            weaponResult = this.resolveAmsFor(weaponAttackAction, weaponResult);
        }
        return weaponResult;
    }

    private WeaponResult addHeatUseAmmoFor(WeaponAttackAction weaponAttackAction, WeaponResult weaponResult) {
        int n;
        Entity entity = this.game.getEntity(weaponAttackAction.getEntityId());
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        WeaponType weaponType = (WeaponType)mounted.getType();
        boolean bl = weaponType.getAmmoType() != -1 && !weaponType.hasFlag(3840);
        Mounted mounted2 = mounted.getLinked();
        int n2 = this.howManyShots(mounted, mounted2);
        if (bl && n2 > 1 && (n = entity.getTotalAmmoOfType((AmmoType)mounted2.getType())) < n2) {
            weaponResult.revertsToSingleShot = true;
            n2 = 1;
        }
        if (bl) {
            n = 0;
            while (n < n2) {
                if (mounted2.getShotsLeft() <= 0) {
                    entity.loadWeapon(mounted);
                    mounted2 = mounted.getLinked();
                }
                mounted2.setShotsLeft(mounted2.getShotsLeft() - 1);
                ++n;
            }
        }
        entity.heatBuildup += weaponType.getHeat() * n2;
        return weaponResult;
    }

    private WeaponResult resolveAmsFor(WeaponAttackAction weaponAttackAction, WeaponResult weaponResult) {
        Entity entity = this.game.getEntity(weaponAttackAction.getTargetId());
        Vector vector = weaponAttackAction.getCounterEquipment();
        if (vector == null) {
            return weaponResult;
        }
        int n = 0;
        while (n < vector.size()) {
            Mounted mounted = (Mounted)vector.elementAt(n);
            Mounted mounted2 = mounted.getLinked();
            if (mounted.getType() instanceof WeaponType && ((WeaponType)mounted.getType()).getAmmoType() == 14 && mounted.isReady() && !mounted.isMissing()) {
                int n2 = Compute.d6(((WeaponType)mounted.getType()).getDamage());
                entity.heatBuildup += ((WeaponType)mounted.getType()).getHeat();
                mounted2.setShotsLeft(Math.max(0, mounted2.getShotsLeft() - n2));
                mounted.setUsedThisRound(true);
                weaponResult.amsShotDown += n2;
            }
            ++n;
        }
        return weaponResult;
    }

    private int howManyShots(Mounted mounted, Mounted mounted2) {
        WeaponType weaponType = (WeaponType)mounted.getType();
        int n = 1;
        if (weaponType.getAmmoType() == 20 && mounted.curMode().equals("Ultra")) {
            n = 2;
        } else if (weaponType.getAmmoType() == 23) {
            if (mounted.curMode().equals("2-shot")) {
                n = 2;
            } else if (mounted.curMode().equals("4-shot")) {
                n = 4;
            } else if (mounted.curMode().equals("6-shot")) {
                n = 6;
            }
        }
        return n;
    }

    private void resolveWeaponAttack(WeaponResult weaponResult, int n) {
        int n2;
        int n3;
        Entity entity = this.game.getEntity(weaponResult.waa.getEntityId());
        Entity entity2 = this.game.getEntity(weaponResult.waa.getTargetId());
        Mounted mounted = entity.getEquipment(weaponResult.waa.getWeaponId());
        WeaponType weaponType = (WeaponType)mounted.getType();
        boolean bl = weaponType.hasFlag(3840);
        boolean bl2 = weaponType.getAmmoType() != -1 && !bl;
        Mounted mounted2 = bl2 ? mounted.getLinked() : null;
        AmmoType ammoType = mounted2 == null ? null : (AmmoType)mounted2.getType();
        Infantry infantry = null;
        if (n != entity.getId()) {
            this.phaseReport.append("\nWeapons fire for " + entity.getDisplayName() + "\n");
        }
        this.phaseReport.append("    " + weaponType.getName() + " at " + entity2.getDisplayName());
        ToHitData toHitData = weaponResult.toHit;
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            this.phaseReport.append(", but the shot is impossible (" + toHitData.getDesc() + ")\n");
            return;
        }
        if (toHitData.getValue() == 0x7FFFFFFE) {
            this.phaseReport.append(", the shot is an automatic miss (" + toHitData.getDesc() + "), ");
        } else {
            this.phaseReport.append("; needs " + toHitData.getValue() + ", ");
        }
        if (weaponType.getAmmoType() == 22 && entity.mpUsed > 0) {
            n3 = entity.getWeight() <= 35.0f ? 2 : (entity.getWeight() <= 55.0f ? 1 : (entity.getWeight() <= 75.0f ? 0 : -1));
            this.pilotRolls.addElement(new PilotingRollData(entity.getId(), n3, "fired HeavyGauss unbraced"));
        }
        this.phaseReport.append("rolls " + weaponResult.roll + " : ");
        n3 = this.howManyShots(mounted, mounted2);
        if (n3 > 1) {
            n2 = 0;
            if (weaponType.getAmmoType() == 20 && mounted.curMode().equals("Ultra")) {
                n2 = 2;
            } else if (weaponType.getAmmoType() == 23) {
                if (n3 == 2) {
                    n2 = 2;
                } else if (n3 == 4) {
                    n2 = 3;
                } else if (n3 == 6) {
                    n2 = 4;
                }
            }
            if (n2 > 0 && weaponResult.roll <= n2) {
                this.phaseReport.append("misses AND THE AUTOCANNON JAMS.\n");
                mounted.setJammed(true);
                if (weaponType.getAmmoType() == 20) {
                    mounted.setHit(true);
                }
                return;
            }
        }
        if (weaponResult.roll < toHitData.getValue()) {
            Hex hex;
            this.phaseReport.append("misses.\n");
            if (weaponResult.amsShotDown > 0) {
                this.phaseReport.append("\tAMS activates, firing " + weaponResult.amsShotDown + " shot(s).\n");
            }
            if ((hex = this.game.getBoard().getHex(entity2.getPosition())).contains(1) && !hex.contains(7) && toHitData.getValue() != 0x7FFFFFFE && weaponType.getFireTN() != Integer.MAX_VALUE && this.burn(hex, 11)) {
                this.sendChangedHex(entity2.getPosition());
                this.phaseReport.append("           Missed shot sets the woods on fire! \n");
            }
            return;
        }
        if (weaponType.getAmmoType() == 13) {
            entity2.setNarcedBy(entity.getOwner().getTeam());
            this.phaseReport.append("hits.  Pod attached.\n");
            return;
        }
        n2 = 1;
        int n4 = 1;
        int n5 = 0;
        int n6 = weaponType.getDamage();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = " shot(s) ";
        if (bl) {
            bl3 = true;
            infantry = (Infantry)entity;
            n4 = 5;
            n6 = 1;
            n2 = infantry.getDamage(infantry.getShootingStrength());
        } else if (weaponType.getDamage() == -2) {
            string = " missile(s) ";
            bl3 = true;
            n6 = ammoType.getDamagePerShot();
            if (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 12) {
                n4 = 5;
            }
            if (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 9) {
                Mounted mounted3 = mounted.getLinkedBy();
                if (mounted3 != null && mounted3.getType() instanceof MiscType && !mounted3.isDestroyed() && !mounted3.isMissing() && mounted3.getType().hasFlag(4096)) {
                    if (!bl4) {
                        bl5 = Compute.isAffectedByECM(entity, entity.getPosition(), entity2.getPosition());
                        bl4 = true;
                    }
                    if (!bl5) {
                        n5 += 2;
                    }
                } else if (entity2.isNarcedBy(entity.getOwner().getTeam())) {
                    if (!bl4) {
                        bl5 = Compute.isAffectedByECM(entity, entity.getPosition(), entity2.getPosition());
                        bl4 = true;
                    }
                    if (!bl5) {
                        n5 += 2;
                    }
                }
            }
            n2 = weaponType.getAmmoType() == 11 ? weaponType.getRackSize() : (weaponType.getRackSize() == 30 || weaponType.getRackSize() == 40 ? Compute.missilesHit(weaponType.getRackSize() / 2) + Compute.missilesHit(weaponType.getRackSize() / 2) : Compute.missilesHit(weaponType.getRackSize(), n5));
        } else if (ammoType != null && ammoType.hasFlag(1)) {
            bl3 = true;
            n2 = Compute.missilesHit(weaponType.getRackSize());
            n6 = 1;
        } else if (n3 > 1) {
            bl3 = true;
            n2 = Compute.missilesHit(n3);
        } else if (ammoType != null && ammoType.hasFlag(1024) && !bl && entity2 instanceof Infantry) {
            n6 = Compute.d6(weaponType.getDamage());
            this.phaseReport.append("riddles the target with " + n6 + string + "and ");
        } else if (weaponType.getAmmoType() == 22) {
            int n7 = entity.getPosition().distance(entity2.getPosition());
            n6 = n7 <= weaponType.getShortRange() ? 25 : (n7 <= weaponType.getMediumRange() ? 20 : 10);
        }
        if (bl3) {
            this.phaseReport.append(n2 + string + "hit" + toHitData.getTableDesc());
            if (bl5) {
                this.phaseReport.append(" (ECM prevents bonus)");
            }
            if (n5 > 0) {
                this.phaseReport.append(" (w/ +").append(n5).append(" bonus)");
            }
            this.phaseReport.append(".");
            if (weaponResult.amsShotDown > 0) {
                this.phaseReport.append("\n\tAMS shoots down " + weaponResult.amsShotDown + " missile(s).");
                n2 -= weaponResult.amsShotDown;
            }
        }
        while (n2 > 0) {
            Object object;
            if (entity2 instanceof HexEntity) {
                int n8;
                int n9 = n6 * n2;
                this.phaseReport.append("hits!\n");
                this.phaseReport.append("    Terrain takes " + n9 + " damage.\n");
                object = entity2.getPosition();
                Hex hex = this.game.getBoard().getHex((Coords)object);
                if (!hex.contains(1)) {
                    return;
                }
                int n10 = 14 - n9;
                if (!weaponType.hasFlag(2)) {
                    n8 = hex.levelOf(1);
                    if (n8 < 1) {
                        return;
                    }
                    int n11 = Compute.d6(2);
                    this.phaseReport.append("    Checking to clear woods; needs " + n10 + ", rolls " + n11 + ": ");
                    if (n11 >= n10) {
                        if (n8 > 1) {
                            hex.removeTerrain(1);
                            hex.addTerrain(new Terrain(1, n8 - 1));
                            this.phaseReport.append(" Heavy Woods converted to Light Woods!\n");
                        } else if (n8 == 1) {
                            hex.removeTerrain(1);
                            hex.addTerrain(new Terrain(2, 1));
                            this.phaseReport.append(" Light Woods converted to Rough!\n");
                        }
                        this.sendChangedHex((Coords)object);
                    } else {
                        this.phaseReport.append(" fails!\n");
                    }
                }
                n10 = weaponType.getFireTN();
                this.phaseReport.append("    Checking to start fire in hex; needs " + n10 + ", ");
                n8 = Compute.d6(2);
                this.phaseReport.append("rolls " + n8 + " : ");
                if (n8 >= n10) {
                    this.phaseReport.append(" Fire started!\n");
                    hex.addTerrain(new Terrain(7, 1));
                    this.sendChangedHex((Coords)object);
                } else {
                    this.phaseReport.append(" No fire.\n");
                }
                return;
            }
            if (weaponType.hasFlag(2) && this.game.getOptions().booleanOption("flamer_heat")) {
                int n12 = n6 * n2;
                this.phaseReport.append("\n        Target gains ").append(n12).append(" more heat during heat phase.");
                entity2.heatBuildup += n12;
                n2 = 0;
                continue;
            }
            object = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            int n13 = n6 * Math.min(n4, n2);
            if (!bl3) {
                this.phaseReport.append("hits" + toHitData.getTableDesc() + " " + entity2.getLocationAbbr((HitData)object));
            }
            this.phaseReport.append(this.damageEntity(entity2, (HitData)object, n13));
            n2 -= n4;
        }
        this.phaseReport.append("\n");
    }

    private void resolvePhysicalAttacks() {
        this.roundReport.append("\nPhysical Attack Phase\n-------------------\n");
        int n = -1;
        Enumeration enumeration = this.pendingCharges.elements();
        while (enumeration.hasMoreElements()) {
            this.attacks.addElement(enumeration.nextElement());
        }
        this.pendingCharges.removeAllElements();
        this.cleanupPhysicalAttacks();
        Enumeration enumeration2 = this.attacks.elements();
        while (enumeration2.hasMoreElements()) {
            AbstractAttackAction abstractAttackAction;
            Object e = enumeration2.nextElement();
            AttackAction attackAction = (AttackAction)e;
            if (!this.game.getEntity(attackAction.getEntityId()).isActive() && !(e instanceof DfaAttackAction)) continue;
            if (e instanceof PunchAttackAction) {
                abstractAttackAction = (PunchAttackAction)e;
                if (((PunchAttackAction)abstractAttackAction).getArm() == 0) {
                    ((PunchAttackAction)abstractAttackAction).setArm(1);
                    this.resolvePunchAttack((PunchAttackAction)abstractAttackAction, n);
                    n = abstractAttackAction.getEntityId();
                    ((PunchAttackAction)abstractAttackAction).setArm(2);
                    this.resolvePunchAttack((PunchAttackAction)abstractAttackAction, n);
                    continue;
                }
                this.resolvePunchAttack((PunchAttackAction)abstractAttackAction, n);
                n = abstractAttackAction.getEntityId();
                continue;
            }
            if (e instanceof KickAttackAction) {
                abstractAttackAction = (KickAttackAction)e;
                this.resolveKickAttack((KickAttackAction)abstractAttackAction, n);
                n = abstractAttackAction.getEntityId();
                continue;
            }
            if (e instanceof ClubAttackAction) {
                abstractAttackAction = (ClubAttackAction)e;
                this.resolveClubAttack((ClubAttackAction)abstractAttackAction, n);
                n = abstractAttackAction.getEntityId();
                continue;
            }
            if (e instanceof PushAttackAction) {
                abstractAttackAction = (PushAttackAction)e;
                this.resolvePushAttack((PushAttackAction)abstractAttackAction, n);
                n = abstractAttackAction.getEntityId();
                continue;
            }
            if (e instanceof ChargeAttackAction) {
                abstractAttackAction = (ChargeAttackAction)e;
                this.resolveChargeAttack((ChargeAttackAction)abstractAttackAction, n);
                n = abstractAttackAction.getEntityId();
                continue;
            }
            if (!(e instanceof DfaAttackAction)) continue;
            abstractAttackAction = (DfaAttackAction)e;
            this.resolveDfaAttack((DfaAttackAction)abstractAttackAction, n);
            n = abstractAttackAction.getEntityId();
        }
    }

    private void cleanupPhysicalAttacks() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            this.removeDuplicateAttacks(entity.getId());
        }
        this.removeDeadAttacks();
    }

    private void removeDuplicateAttacks(int n) {
        boolean bl = false;
        Vector<EntityAction> vector = new Vector<EntityAction>(this.attacks.size());
        Enumeration enumeration = this.attacks.elements();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = (EntityAction)enumeration.nextElement();
            if (entityAction.getEntityId() != n) {
                vector.addElement(entityAction);
                continue;
            }
            if (!bl) {
                vector.addElement(entityAction);
                bl = true;
                continue;
            }
            System.err.println("server: removing duplicate phys attack for id#" + n);
        }
        this.attacks = vector;
    }

    private void removeDeadAttacks() {
        Vector<EntityAction> vector = new Vector<EntityAction>(this.attacks.size());
        Enumeration enumeration = this.attacks.elements();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = (EntityAction)enumeration.nextElement();
            Entity entity = this.game.getEntity(entityAction.getEntityId());
            if (entity == null || entity.isDestroyed() || !entity.isActive() && !(entityAction instanceof DfaAttackAction)) continue;
            vector.addElement(entityAction);
        }
        this.attacks = vector;
    }

    private void resolvePunchAttack(PunchAttackAction punchAttackAction, int n) {
        String string;
        Entity entity = this.game.getEntity(punchAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(punchAttackAction.getTargetId());
        String string2 = string = punchAttackAction.getArm() == 1 ? "Left Arm" : "Right Arm";
        if (n != punchAttackAction.getEntityId()) {
            this.phaseReport.append("\nPhysical attacks for " + entity.getDisplayName() + "\n");
        }
        this.phaseReport.append("    Punch (" + string + ") at " + entity2.getDisplayName());
        ToHitData toHitData = Compute.toHitPunch(this.game, punchAttackAction);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            this.phaseReport.append(", but the punch is impossible (" + toHitData.getDesc() + ")\n");
            return;
        }
        this.phaseReport.append("; needs " + toHitData.getValue() + ", ");
        int n2 = Compute.d6(2);
        this.phaseReport.append("rolls " + n2 + " : ");
        if (n2 < toHitData.getValue()) {
            this.phaseReport.append("misses.\n");
            return;
        }
        int n3 = Compute.getPunchDamageFor(entity, punchAttackAction.getArm());
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        this.phaseReport.append("hits" + toHitData.getTableDesc() + " " + entity2.getLocationAbbr(hitData));
        this.phaseReport.append(this.damageEntity(entity2, hitData, n3));
        this.phaseReport.append("\n");
    }

    private void resolveKickAttack(KickAttackAction kickAttackAction, int n) {
        String string;
        Entity entity = this.game.getEntity(kickAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(kickAttackAction.getTargetId());
        String string2 = string = kickAttackAction.getLeg() == 1 ? "Left Leg" : "Right Leg";
        if (n != entity.getId()) {
            this.phaseReport.append("\nPhysical attacks for " + entity.getDisplayName() + "\n");
        }
        this.phaseReport.append("    Kick (" + string + ") at " + entity2.getDisplayName());
        ToHitData toHitData = Compute.toHitKick(this.game, kickAttackAction);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            this.phaseReport.append(", but the kick is impossible (" + toHitData.getDesc() + ")\n");
            this.pilotRolls.addElement(new PilotingRollData(entity.getId(), 0, "missed a kick"));
            return;
        }
        this.phaseReport.append("; needs " + toHitData.getValue() + ", ");
        int n2 = Compute.d6(2);
        this.phaseReport.append("rolls " + n2 + " : ");
        if (n2 < toHitData.getValue()) {
            this.phaseReport.append("misses.\n");
            this.pilotRolls.addElement(new PilotingRollData(entity.getId(), 0, "missed a kick"));
            return;
        }
        int n3 = Compute.getKickDamageFor(entity, kickAttackAction.getLeg());
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        this.phaseReport.append("hits" + toHitData.getTableDesc() + " " + entity2.getLocationAbbr(hitData));
        this.phaseReport.append(this.damageEntity(entity2, hitData, n3));
        if (entity2.getMovementType() == 1 || entity2.getMovementType() == 2) {
            this.pilotRolls.addElement(new PilotingRollData(entity2.getId(), 0, "was kicked"));
        }
        this.phaseReport.append("\n");
    }

    private void resolveClubAttack(ClubAttackAction clubAttackAction, int n) {
        Entity entity = this.game.getEntity(clubAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(clubAttackAction.getTargetId());
        clubAttackAction.getClub().restore();
        if (n != clubAttackAction.getEntityId()) {
            this.phaseReport.append("\nPhysical attacks for " + entity.getDisplayName() + "\n");
        }
        this.phaseReport.append("    " + clubAttackAction.getClub().getName() + " attack on " + entity2.getDisplayName());
        ToHitData toHitData = Compute.toHitClub(this.game, clubAttackAction);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            this.phaseReport.append(", but the attack is impossible (" + toHitData.getDesc() + ")\n");
            return;
        }
        this.phaseReport.append("; needs " + toHitData.getValue() + ", ");
        int n2 = Compute.d6(2);
        this.phaseReport.append("rolls " + n2 + " : ");
        if (n2 < toHitData.getValue()) {
            this.phaseReport.append("misses.\n");
            return;
        }
        int n3 = Compute.getClubDamageFor(entity, clubAttackAction.getClub());
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        this.phaseReport.append("hits" + toHitData.getTableDesc() + " " + entity2.getLocationAbbr(hitData));
        this.phaseReport.append(this.damageEntity(entity2, hitData, n3));
        this.phaseReport.append("\n");
        if (clubAttackAction.getClub().getType().hasFlag(32)) {
            this.phaseReport.append("The " + clubAttackAction.getClub().getName() + " breaks.\n");
            entity.removeMisc(clubAttackAction.getClub().getName());
        }
    }

    private void resolvePushAttack(PushAttackAction pushAttackAction, int n) {
        Entity entity = this.game.getEntity(pushAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(pushAttackAction.getTargetId());
        if (n != pushAttackAction.getEntityId()) {
            this.phaseReport.append("\nPhysical attacks for " + entity.getDisplayName() + "\n");
        }
        this.phaseReport.append("    Pushing " + entity2.getDisplayName());
        ToHitData toHitData = Compute.toHitPush(this.game, pushAttackAction);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            this.phaseReport.append(", but the push is impossible (" + toHitData.getDesc() + ")\n");
            return;
        }
        this.phaseReport.append("; needs " + toHitData.getValue() + ", ");
        int n2 = Compute.d6(2);
        this.phaseReport.append("rolls " + n2 + " : ");
        if (n2 < toHitData.getValue()) {
            this.phaseReport.append("misses.\n");
            return;
        }
        int n3 = entity.getFacing();
        Coords coords = entity2.getPosition();
        Coords coords2 = coords.translated(n3);
        if (Compute.isValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n3)) {
            this.phaseReport.append("succeeds: target is pushed into hex " + coords2.getBoardNum() + "\n");
            this.doEntityDisplacement(entity2, coords, coords2, new PilotingRollData(entity2.getId(), 0, "was pushed"));
            if (!entity2.getPosition().equals(coords)) {
                entity.setPosition(coords);
            }
        } else if (this.game.getOptions().booleanOption("push_off_board") && !this.game.board.contains(coords2)) {
            this.game.moveToGraveyard(entity2.getId());
            this.send(this.createRemoveEntityPacket(entity2.getId()));
            this.phaseReport.append("\n*** " + entity2.getDisplayName() + " has been forced from the field. ***\n");
            entity.setPosition(coords);
        } else {
            this.phaseReport.append("succeeds, but target can't be moved.\n");
            this.pilotRolls.addElement(new PilotingRollData(entity2.getId(), 0, "was pushed"));
        }
        this.phaseReport.append("\n");
    }

    private void resolveChargeAttack(ChargeAttackAction chargeAttackAction, int n) {
        int n2;
        Entity entity = this.game.getEntity(chargeAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(chargeAttackAction.getTargetId());
        if (entity == null) {
            return;
        }
        int n3 = entity.getFacing();
        entity.setDisplacementAttack(null);
        if (n != chargeAttackAction.getEntityId()) {
            this.phaseReport.append("\nPhysical attacks for " + entity.getDisplayName() + "\n");
        }
        if (entity2 == null || entity2.isDestroyed() || entity2.isDoomed() || entity2.crew.isDead()) {
            this.phaseReport.append("    Charge cancelled as the target has been destroyed.\n");
            return;
        }
        if (entity.isProne()) {
            this.phaseReport.append("    Charge cancelled as the attacker has fallen.\n");
            return;
        }
        if (entity.isImmobile()) {
            this.phaseReport.append("    Charge cancelled as the attacker has been immobilized.\n");
            return;
        }
        this.phaseReport.append("    Charging " + entity2.getDisplayName());
        if (!entity2.getPosition().equals(chargeAttackAction.getTargetPos())) {
            this.phaseReport.append(" but the target has moved.\n");
            return;
        }
        ToHitData toHitData = Compute.toHitCharge(this.game, chargeAttackAction);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            n2 = -12;
            this.phaseReport.append(", but the charge is impossible (" + toHitData.getDesc() + ") : ");
        } else {
            n2 = Compute.d6(2);
            this.phaseReport.append("; needs " + toHitData.getValue() + ", ");
            this.phaseReport.append("rolls " + n2 + " : ");
        }
        if (n2 < toHitData.getValue()) {
            Coords coords = entity.getPosition();
            Coords coords2 = Compute.getMissedChargeDisplacement(this.game, entity.getId(), coords, n3);
            this.phaseReport.append("misses.\n");
            this.doEntityDisplacement(entity, coords, coords2, null);
        } else {
            this.resolveChargeDamage(entity, entity2, toHitData, n3);
        }
    }

    private void resolveChargeDamage(Entity entity, Entity entity2, ToHitData toHitData, int n) {
        Object object;
        int n2;
        int n3 = Compute.getChargeDamageFor(entity);
        int n4 = Compute.getChargeDamageTakenBy(entity, entity2);
        PilotingRollData pilotingRollData = null;
        if (!entity.isProne()) {
            pilotingRollData = new PilotingRollData(entity.getId(), 2, "charging");
        }
        this.phaseReport.append("hits.");
        this.phaseReport.append("\n  Defender takes " + n3 + " damage" + toHitData.getTableDesc() + ".");
        while (n3 > 0) {
            n2 = Math.min(5, n3);
            object = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            this.phaseReport.append(this.damageEntity(entity2, (HitData)object, n2));
            n3 -= n2;
        }
        this.phaseReport.append("\n  Attacker takes " + n4 + " damage.");
        while (n4 > 0) {
            n2 = Math.min(5, n4);
            object = entity.rollHitLocation(0, 0);
            this.phaseReport.append(this.damageEntity(entity, (HitData)object, n2));
            n4 -= n2;
        }
        Coords coords = entity2.getPosition();
        object = coords.translated(n);
        if (Compute.isValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n)) {
            this.phaseReport.append("\n");
            this.doEntityDisplacement(entity2, coords, (Coords)object, new PilotingRollData(entity2.getId(), 2, "was charged"));
            this.doEntityDisplacement(entity, entity.getPosition(), coords, pilotingRollData);
        } else if (this.game.getOptions().booleanOption("push_off_board") && !this.game.board.contains((Coords)object)) {
            this.game.moveToGraveyard(entity2.getId());
            this.send(this.createRemoveEntityPacket(entity2.getId()));
            this.phaseReport.append("\n*** " + entity2.getDisplayName() + " target has been forced from the field. ***\n");
            this.doEntityDisplacement(entity, entity.getPosition(), coords, pilotingRollData);
        } else {
            this.pilotRolls.addElement(new PilotingRollData(entity2.getId(), 2, "was charged"));
            this.pilotRolls.addElement(pilotingRollData);
        }
        this.phaseReport.append("\n");
    }

    private void resolveDfaAttack(DfaAttackAction dfaAttackAction, int n) {
        Object object;
        int n2;
        int n3;
        Entity entity = this.game.getEntity(dfaAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(dfaAttackAction.getTargetId());
        if (entity == null) {
            return;
        }
        int n4 = entity.getFacing();
        if (n != dfaAttackAction.getEntityId()) {
            this.phaseReport.append("\nPhysical attacks for " + entity.getDisplayName() + "\n");
        }
        entity.setDisplacementAttack(null);
        if (entity2 == null || entity2.isDestroyed() || entity2.isDoomed() || entity2.crew.isDead()) {
            this.phaseReport.append("    Death from above deals no damage as the target has been destroyed.\n");
            if (entity.isProne()) {
                this.doEntityFall(entity, dfaAttackAction.getTargetPos(), 2, 3, Compute.getBasePilotingRoll(this.game, entity.getId()));
            } else {
                this.doEntityDisplacement(entity, entity.getPosition(), dfaAttackAction.getTargetPos(), new PilotingRollData(entity.getId(), 4, "executed death from above"));
            }
            return;
        }
        this.phaseReport.append("    Attempting death from above on " + entity2.getDisplayName());
        if (!entity2.getPosition().equals(dfaAttackAction.getTargetPos())) {
            this.phaseReport.append(" but the target has moved.\n");
            return;
        }
        ToHitData toHitData = Compute.toHitDfa(this.game, dfaAttackAction);
        if (entity.isProne() || !entity.isActive()) {
            n3 = -12;
            this.phaseReport.append(" but the attacker is prone or incapacitated : ");
        } else if (toHitData.getValue() == Integer.MAX_VALUE) {
            n3 = -12;
            this.phaseReport.append(" but the attack is impossible (" + toHitData.getDesc() + ") : ");
        } else {
            n3 = Compute.d6(2);
            this.phaseReport.append("; needs " + toHitData.getValue() + ", ");
            this.phaseReport.append("rolls " + n3 + " : ");
        }
        if (n3 < toHitData.getValue()) {
            Coords coords = entity.getPosition();
            Coords coords2 = entity2.getPosition();
            Coords coords3 = Compute.getPreferredDisplacement(this.game, entity2.getId(), coords2, n4);
            this.phaseReport.append("misses.\n");
            if (coords3 != null) {
                this.doEntityDisplacement(entity2, coords2, coords3, null);
                this.phaseReport.append(entity.getDisplayName() + " falls into hex " + coords2.getBoardNum() + ".\n");
                this.doEntityFall(entity, coords2, 2, 3, Compute.getBasePilotingRoll(this.game, entity.getId()));
            } else {
                this.phaseReport.append(this.destroyEntity(entity, "impossible displacement"));
            }
            return;
        }
        int n5 = Compute.getDfaDamageFor(entity);
        int n6 = Compute.getDfaDamageTakenBy(entity);
        this.phaseReport.append("hits.");
        this.phaseReport.append("\n  Defender takes " + n5 + " damage" + toHitData.getTableDesc() + ".");
        while (n5 > 0) {
            n2 = Math.min(5, n5);
            object = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            this.phaseReport.append(this.damageEntity(entity2, (HitData)object, n2));
            n5 -= n2;
        }
        this.phaseReport.append("\n  Attacker takes " + n6 + " damage.");
        while (n6 > 0) {
            n2 = Math.min(5, n6);
            object = entity.rollHitLocation(2, 0);
            this.phaseReport.append(this.damageEntity(entity, (HitData)object, n2));
            n6 -= n2;
        }
        this.phaseReport.append("\n");
        Coords coords = entity.getPosition();
        object = entity2.getPosition();
        Coords coords4 = Compute.getValidDisplacement(this.game, entity2.getId(), (Coords)object, n4);
        if (this.game.getOptions().booleanOption("push_off_board") && !this.game.board.contains(((Coords)object).translated(n4))) {
            this.game.moveToGraveyard(entity2.getId());
            this.send(this.createRemoveEntityPacket(entity2.getId()));
            this.phaseReport.append("\n*** " + entity2.getDisplayName() + " target has been forced from the field. ***\n");
        } else if (coords4 != null) {
            this.doEntityDisplacement(entity2, (Coords)object, coords4, new PilotingRollData(entity2.getId(), 2, "hit by death from above"));
        } else {
            this.phaseReport.append(this.destroyEntity(entity2, "impossible displacement"));
        }
        this.doEntityDisplacement(entity, (Coords)object, (Coords)object, new PilotingRollData(entity.getId(), 4, "executed death from above"));
    }

    private void resolveHeat() {
        this.roundReport.append("\nHeat Phase\n----------\n");
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            int n;
            int n2;
            Entity entity = (Entity)enumeration.nextElement();
            Hex hex = this.game.getBoard().getHex(entity.getPosition());
            if (!(entity instanceof Mech)) {
                entity.heatBuildup = 0;
                continue;
            }
            if (entity.isDestroyed() || entity.isDoomed() || entity.crew.isDead()) continue;
            if (!entity.isShutDown()) {
                entity.heatBuildup += 5 * entity.getHitCriticals(0, 3, 1);
                entity.heatBuildup += 5 * entity.getHitCriticals(0, 3, 3);
                entity.heatBuildup += 5 * entity.getHitCriticals(0, 3, 2);
            }
            if (hex.levelOf(7) == 2) {
                entity.heatBuildup += 5;
                this.roundReport.append("\nAdded heat from a fire....\n");
            }
            this.roundReport.append(entity.getDisplayName() + " gains " + entity.heatBuildup + " heat,");
            entity.heat += entity.heatBuildup;
            entity.heatBuildup = 0;
            int n3 = Math.min(entity.getHeatCapacityWithWater(), entity.heat);
            entity.heat -= n3;
            this.roundReport.append(" sinks " + n3 + " heat and is now at " + entity.heat + " heat.\n");
            if (entity.heat < 30 && entity.isShutDown()) {
                if (entity.heat < 14) {
                    entity.setShutDown(false);
                    this.roundReport.append(entity.getDisplayName() + " automatically starts up.\n");
                } else {
                    n2 = 4 + (entity.heat - 14) / 4 * 2;
                    n = Compute.d6(2);
                    this.roundReport.append(entity.getDisplayName() + " needs a " + n2 + "+ to start up, rolls " + n + " : ");
                    if (n >= n2) {
                        entity.setShutDown(false);
                        this.roundReport.append("successful!\n");
                    } else {
                        this.roundReport.append("fails.\n");
                    }
                }
            }
            if (entity.heat >= 14 && !entity.isShutDown()) {
                if (entity.heat >= 30) {
                    this.roundReport.append(entity.getDisplayName() + " automatically shuts down.\n");
                    this.pilotRolls.addElement(new PilotingRollData(entity.getId(), 3, "reactor shutdown"));
                    this.resolvePilotingRolls();
                    entity.setShutDown(true);
                } else if (entity.heat >= 14) {
                    n2 = 4 + (entity.heat - 14) / 4 * 2;
                    n = Compute.d6(2);
                    this.roundReport.append(entity.getDisplayName() + " needs a " + n2 + "+ to avoid shutdown, rolls " + n + " : ");
                    if (n >= n2) {
                        this.roundReport.append("avoids successfully!\n");
                    } else {
                        this.roundReport.append("shuts down.\n");
                        this.pilotRolls.addElement(new PilotingRollData(entity.getId(), 3, "reactor shutdown"));
                        this.resolvePilotingRolls();
                        entity.setShutDown(true);
                    }
                }
            }
            if (entity.heat >= 19) {
                n2 = 4 + (entity.heat >= 23 ? 2 : 0) + (entity.heat >= 28 ? 2 : 0);
                n = Compute.d6(2);
                this.roundReport.append(entity.getDisplayName() + " needs a " + n2 + "+ to avoid ammo explosion, rolls " + n + " : ");
                if (n >= n2) {
                    this.roundReport.append("avoids successfully!\n");
                } else {
                    this.roundReport.append("fails to avoid explosion.\n");
                    this.roundReport.append(this.explodeAmmoFromHeat(entity));
                }
            }
            if (entity.getHitCriticals(0, 0, 0) <= 0 || entity.heat < 15) continue;
            if (entity.heat >= 25) {
                this.roundReport.append(entity.getDisplayName() + " has 25 or higher heat and damaged life support.  Mechwarrior takes 2 damage.\n");
                this.damageCrew(entity, 2);
            } else {
                this.roundReport.append(entity.getDisplayName() + " has 15 or higher heat and damaged life support.  Mechwarrior takes 1 damage.\n");
                this.damageCrew(entity, 1);
            }
            if (!entity.crew.isDead()) continue;
            this.roundReport.append("*** " + entity.getDisplayName() + " PILOT BAKES TO DEATH! ***");
        }
    }

    private void doFlamingDeath(Entity entity) {
        int n = Compute.d6(2);
        this.phaseReport.append(entity.getDisplayName() + " is on fire.  Needs an 8+ to avoid destruction, rolls " + n + " : ");
        if (n >= 8) {
            this.phaseReport.append("avoids successfully!\n");
        } else {
            this.phaseReport.append("fails to avoid horrible instant flaming death.\n");
            this.phaseReport.append(this.destroyEntity(entity, "fire"));
        }
    }

    private void checkFor20Damage() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getMovementType() != 1 && entity.getMovementType() != 2 || entity.damageThisPhase < 20) continue;
            this.pilotRolls.addElement(new PilotingRollData(entity.getId(), 1, "20+ damage"));
        }
    }

    public void checkForFlamingDeath() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Hex hex;
            Entity entity = (Entity)enumeration.nextElement();
            if (entity instanceof Mech || entity.isDoomed() || entity.isDestroyed() || !(hex = this.game.board.getHex(entity.getPosition())).contains(7)) continue;
            this.doFlamingDeath(entity);
        }
    }

    private void checkForSuffocation() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            Hex hex = this.game.board.getHex(entity.getPosition());
            if (hex.levelOf(4) <= 1 && (hex.levelOf(4) != 1 || !entity.isProne()) || entity.getHitCriticals(0, 0, 0) <= 0) continue;
            this.roundReport.append("\n" + entity.getDisplayName() + " is underwater with damaged life support.  Mechwarrior takes 1 damage.\n");
            this.damageCrew(entity, 1);
        }
    }

    private void resolvePilotingRolls() {
        Enumeration enumeration = this.game.getEntities();
        block0: while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!(entity instanceof Mech) || entity.isProne() || entity.isDoomed() || entity.isDestroyed()) continue;
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            PilotingRollData pilotingRollData = Compute.getBasePilotingRoll(this.game, entity.getId());
            Enumeration enumeration2 = this.pilotRolls.elements();
            while (enumeration2.hasMoreElements()) {
                PilotingRollData pilotingRollData2 = (PilotingRollData)enumeration2.nextElement();
                if (pilotingRollData2.getEntityId() != entity.getId()) continue;
                ++n;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(pilotingRollData2.getPlainDesc());
                pilotingRollData.append(pilotingRollData2);
            }
            if (n == 0) continue;
            if (pilotingRollData.getValue() == 0x7FFFFFFE || pilotingRollData.getValue() == Integer.MAX_VALUE) {
                this.phaseReport.append("\n" + entity.getDisplayName() + " must make " + n + " piloting skill roll(s) and automatically fails (" + pilotingRollData.getDesc() + ").\n");
                this.doEntityFall(entity, pilotingRollData);
                continue;
            }
            this.phaseReport.append("\n" + entity.getDisplayName() + " must make " + n + " piloting skill roll(s) (" + stringBuffer + ").\n");
            this.phaseReport.append("The target is " + pilotingRollData.getValueAsString() + " [" + pilotingRollData.getDesc() + "].\n");
            int n2 = 0;
            while (n2 < n) {
                int n3 = Compute.d6(2);
                this.phaseReport.append("    " + entity.getDisplayName() + " needs " + pilotingRollData.getValueAsString() + ", rolls " + n3 + " : ");
                this.phaseReport.append((n3 >= pilotingRollData.getValue() ? "remains standing" : "falls") + ".\n");
                if (n3 < pilotingRollData.getValue()) {
                    this.doEntityFall(entity, pilotingRollData);
                    continue block0;
                }
                ++n2;
            }
        }
        this.pilotRolls.removeAllElements();
    }

    private String damageCrew(Entity entity, int n) {
        String string = new String();
        if (!entity.crew.isDead()) {
            entity.crew.setHits(entity.crew.getHits() + n);
            string = string + "        Pilot of " + entity.getDisplayName() + " \"" + entity.crew.getName() + "\" takes " + n + " damage.";
            if (entity.crew.getHits() < 6) {
                entity.crew.setRollsNeeded(entity.crew.getRollsNeeded() + n);
            } else {
                entity.crew.setDead(true);
                entity.crew.setRollsNeeded(0);
                string = string + "\n*** " + entity.getDisplayName() + " PILOT KILLED! ***";
            }
        }
        return string;
    }

    private void resolveCrewDamage() {
        boolean bl = false;
        Enumeration enumeration = this.game.getEntities();
        block0: while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            int n = entity.getCrew().getHits();
            int n2 = entity.getCrew().getRollsNeeded();
            entity.crew.setRollsNeeded(0);
            if (!entity.isTargetable() || !entity.getCrew().isActive() || n2 == 0) continue;
            bl = true;
            int n3 = n - n2 + 1;
            while (n3 <= n) {
                int n4 = Compute.d6(2);
                int n5 = Compute.getConciousnessNumber(n3);
                this.phaseReport.append("\nPilot of " + entity.getDisplayName() + " \"" + entity.getCrew().getName() + "\" needs a " + n5 + " to stay concious.  Rolls " + n4 + " : ");
                if (n4 < n5) {
                    entity.crew.setUnconcious(true);
                    entity.crew.setKoThisRound(true);
                    this.phaseReport.append("blacks out.");
                    continue block0;
                }
                this.phaseReport.append("successful!");
                ++n3;
            }
        }
        if (bl) {
            this.phaseReport.append("\n");
        }
    }

    private void resolveCrewWakeUp() {
        boolean bl = false;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.isTargetable() || !entity.crew.isUnconcious() || entity.crew.isKoThisRound() || !(entity instanceof Mech)) continue;
            bl = true;
            int n = Compute.d6(2);
            int n2 = Compute.getConciousnessNumber(entity.crew.getHits());
            this.roundReport.append("\nPilot of " + entity.getDisplayName() + " \"" + entity.crew.getName() + "\" needs a " + n2 + " to regain conciousness.  Rolls " + n + " : ");
            if (n >= n2) {
                this.roundReport.append("successful!");
                entity.crew.setUnconcious(false);
                continue;
            }
            this.roundReport.append("fails.");
        }
        if (bl) {
            this.roundReport.append("\n");
        }
    }

    public String damageEntity(Entity entity, HitData hitData, int n) {
        return this.damageEntity(entity, hitData, n, false);
    }

    private String damageEntity(Entity entity, HitData hitData, int n, boolean bl) {
        String string = new String();
        boolean bl2 = entity instanceof Infantry;
        Hex hex = null;
        int n2 = hitData.getEffect() == 1 ? 1 : 0;
        HitData hitData2 = null;
        if (!(!bl2 || entity.isDestroyed() || entity.isDoomed() || (hex = this.game.board.getHex(entity.getPosition())).contains(1) || hex.contains(2) || hex.contains(3) || hex.contains(10))) {
            n *= 2;
            string = string + "\n        Infantry caught in the open!!!  Damage doubled.";
        }
        while (n > 0) {
            int n3;
            boolean bl3;
            string = string + "\n        " + entity.getDisplayName() + " takes " + n + " damage to " + entity.getLocationAbbr(hitData) + ".";
            if (entity.getInternal(hitData) == -2) {
                n2 = 0;
            }
            boolean bl4 = bl3 = (n3 = hitData.getLocation()) == 1 || n3 == 2 || n3 == 3;
            if (entity instanceof Mech && hitData.isRear() && bl3) {
                Enumeration enumeration = entity.getAmmo();
                while (enumeration.hasMoreElements()) {
                    Mounted mounted = (Mounted)enumeration.nextElement();
                    if (!mounted.isDumping() || mounted.isDestroyed() || mounted.isHit()) continue;
                    string = string + this.explodeEquipment(entity, mounted.getLocation(), mounted);
                    mounted.setHit(true);
                }
            }
            if (!bl && entity.getArmor(hitData) > 0) {
                if (entity.getArmor(hitData) > n) {
                    entity.setArmor(entity.getArmor(hitData) - n, hitData);
                    entity.damageThisPhase += n;
                    n = 0;
                    string = string + " " + entity.getArmor(hitData) + " Armor remaining";
                } else {
                    int n4 = Math.max(entity.getArmor(hitData), 0);
                    entity.setArmor(-3, hitData);
                    entity.damageThisPhase += n4;
                    n -= n4;
                    string = string + " Armor destroyed,";
                }
            }
            if (n > 0) {
                if (entity.getInternal(hitData) > 0) {
                    if (!bl2) {
                        ++n2;
                    }
                    if (entity.getInternal(hitData) > n) {
                        entity.setInternal(entity.getInternal(hitData) - n, hitData);
                        entity.damageThisPhase += n;
                        n = 0;
                        string = bl2 ? string + " " + entity.getInternal(hitData) + " men alive." : string + " " + entity.getInternal(hitData) + " Internal Structure remaining";
                    } else {
                        int n5 = Math.max(entity.getInternal(hitData), 0);
                        this.destroyLocation(entity, hitData.getLocation());
                        entity.damageThisPhase += n5;
                        n -= n5;
                        string = bl2 ? string + " <<<PLATOON KILLED>>>," : string + " <<<SECTION DESTROYED>>>,";
                        if (hitData.getLocation() == 2 || hitData.getLocation() == 3) {
                            int n6 = 0;
                            n6 += entity.getHitCriticals(0, 3, 1);
                            n6 += entity.getHitCriticals(0, 3, 2);
                            if ((n6 += entity.getHitCriticals(0, 3, 3)) > 2) {
                                this.phaseReport.append(this.destroyEntity(entity, "engine destruction"));
                            }
                        }
                    }
                }
                if (entity.getInternal(hitData) <= 0) {
                    hitData2 = entity.getTransferLocation(hitData);
                    if (hitData2.getLocation() == -2) {
                        string = string + this.destroyEntity(entity, "damage");
                        n = 0;
                    } else if (bl && entity.locationHasCase(hitData.getLocation())) {
                        string = string + " remaining " + n + " damage prevented by CASE.";
                        n = 0;
                    } else if (n > 0) {
                        string = string + " " + n + " damage transfers to " + entity.getLocationAbbr(hitData2) + ".";
                    }
                }
            }
            if (hitData.getEffect() == 3) {
                string = string + "\n            Movement system damaged!";
                int n7 = entity.getOriginalWalkMP();
                if (n7 <= 1) {
                    ((Tank)entity).immobilize();
                    hex = this.game.board.getHex(entity.getPosition());
                    if (entity.getMovementType() == 5 && hex.levelOf(4) > 0) {
                        string = string + this.destroyEntity(entity, "a watery grave");
                    }
                } else {
                    entity.setOriginalWalkMP(n7 - 1);
                }
            } else if (hitData.getEffect() == 2) {
                string = string + "\n            Movement system destroyed!";
                ((Tank)entity).immobilize();
                hex = this.game.board.getHex(entity.getPosition());
                if (entity.getMovementType() == 5 && hex.levelOf(4) > 0) {
                    string = string + this.destroyEntity(entity, "a watery grave");
                }
            } else if (hitData.getEffect() == 4) {
                string = string + "\n            Turret locked!";
                ((Tank)entity).lockTurret();
            }
            int n8 = 0;
            while (n8 < n2) {
                string = string + "\n" + this.criticalEntity(entity, hitData.getLocation());
                ++n8;
            }
            n2 = 0;
            if (entity instanceof Mech && hitData.getLocation() == 0) {
                string = string + "\n" + this.damageCrew(entity, 1);
            }
            hitData = hitData2;
        }
        return string;
    }

    private String criticalEntity(Entity entity, int n) {
        String string = "        Critical hit on " + entity.getLocationAbbr(n) + ". ";
        int n2 = 0;
        int n3 = Compute.d6(2);
        string = string + "Roll = " + n3 + ";";
        if (n3 <= 7) {
            string = string + " no effect.";
            return string;
        }
        if (n3 >= 8 && n3 <= 9) {
            n2 = 1;
            string = string + " 1 location.";
        } else if (n3 >= 10 && n3 <= 11) {
            n2 = 2;
            string = string + " 2 locations.";
        } else if (n3 == 12) {
            if (entity instanceof Tank) {
                n2 = 3;
                string = string + " 3 locations.";
            } else {
                if (entity.locationIsLeg(n)) {
                    string = string + "<<<LIMB BLOWN OFF>>> " + entity.getLocationName(n) + " blown off.";
                    if (entity.getInternal(n) > 0) {
                        this.destroyLocation(entity, n);
                    }
                    return string;
                }
                if (n == 4 || n == 5) {
                    string = string + "<<<LIMB BLOWN OFF>>> " + entity.getLocationName(n) + " blown off.";
                    this.destroyLocation(entity, n);
                    return string;
                }
                if (n == 0) {
                    string = string + "<<<HEAD BLOWN OFF>>> " + entity.getLocationName(n) + " blown off.";
                    this.destroyLocation(entity, n);
                    entity.crew.setDead(true);
                    string = string + "\n*** " + entity.getDisplayName() + " PILOT KILLED! ***";
                    return string;
                }
                n2 = 3;
                string = string + " 3 locations.";
            }
        }
        if (entity instanceof Tank) {
            Tank tank = (Tank)entity;
            int n4 = 0;
            while (n4 < n2 && !tank.isDoomed()) {
                switch (Compute.d6(1)) {
                    case 1: {
                        string = string + "\n            <<<CRITICAL HIT>>> Crew stunned for 3 turns";
                        tank.stunCrew();
                        break;
                    }
                    case 2: {
                        Mounted mounted = tank.getMainWeapon();
                        if (mounted == null) {
                            string = string + "\n            No main weapon crit, because no main weapon!";
                            break;
                        }
                        string = string + "\n            <<<CRITICAL HIT>>> " + mounted.getName() + " jams.";
                        tank.setJammedWeapon(mounted);
                        break;
                    }
                    case 3: {
                        string = string + "\n            <<<CRITICAL HIT>>> Engine destroyed.  Immobile.";
                        tank.immobilize();
                        Hex hex = this.game.board.getHex(entity.getPosition());
                        if (entity.getMovementType() != 5 || hex.levelOf(4) <= 0) break;
                        string = string + this.destroyEntity(entity, "a watery grave");
                        break;
                    }
                    case 4: {
                        string = string + "\n            <<<CRITICAL HIT>>> Crew killed";
                        string = string + this.destroyEntity(entity, "crew death");
                        break;
                    }
                    case 5: {
                        string = string + "\n            <<<CRITICAL HIT>>> Fuel tank hit.  BOOM!";
                        string = string + this.destroyEntity(entity, "fuel tank explosion");
                        break;
                    }
                    case 6: {
                        string = string + "\n            <<<CRITICAL HIT>>> Power plant hit.  BOOM!";
                        string = string + this.destroyEntity(entity, "power plant destruction");
                    }
                }
                ++n4;
            }
        } else {
            if (n2 > 0 && !entity.hasHittableCriticals(n) && entity.getTransferLocation(new HitData(n)).getLocation() != -2) {
                n = entity.getTransferLocation(new HitData(n)).getLocation();
                string = string + "\n            Location is empty, so criticals transfer to " + entity.getLocationAbbr(n) + ".";
                if (n2 > 0 && !entity.hasHittableCriticals(n) && entity.getTransferLocation(new HitData(n)).getLocation() != -2) {
                    n = entity.getTransferLocation(new HitData(n)).getLocation();
                    string = string + "\n            Location is empty, so criticals transfer to " + entity.getLocationAbbr(n) + ".";
                }
            }
            while (n2 > 0) {
                if (entity.getHittableCriticals(n) <= 0) {
                    string = string + "\n            Location has no more hittable critical slots.";
                    break;
                }
                int n5 = Compute.random.nextInt(entity.getNumberOfCriticals(n));
                CriticalSlot criticalSlot = entity.getCritical(n, n5);
                if (criticalSlot == null || !criticalSlot.isHittable()) continue;
                criticalSlot.setHit(true);
                switch (criticalSlot.getType()) {
                    case 0: {
                        string = string + "\n            <<<CRITICAL HIT>>> on " + Mech.systemNames[criticalSlot.getIndex()] + ".";
                        switch (criticalSlot.getIndex()) {
                            case 2: {
                                entity.crew.setDead(true);
                                string = string + "\n*** " + entity.getDisplayName() + " PILOT KILLED! ***";
                                break;
                            }
                            case 3: {
                                int n6 = 0;
                                n6 += entity.getHitCriticals(0, 3, 1);
                                n6 += entity.getHitCriticals(0, 3, 2);
                                if ((n6 += entity.getHitCriticals(0, 3, 3)) <= 2) break;
                                string = string + this.destroyEntity(entity, "engine destruction");
                                break;
                            }
                            case 4: {
                                if (entity.getHitCriticals(0, 4, n) > 1) {
                                    this.pilotRolls.addElement(new PilotingRollData(entity.getId(), 0x7FFFFFFE, 3, "gyro destroyed"));
                                    break;
                                }
                                this.pilotRolls.addElement(new PilotingRollData(entity.getId(), 3, "gyro hit"));
                                break;
                            }
                            case 12: 
                            case 13: 
                            case 14: {
                                this.pilotRolls.addElement(new PilotingRollData(entity.getId(), 1, "leg/foot actuator hit"));
                                break;
                            }
                            case 11: {
                                this.pilotRolls.addElement(new PilotingRollData(entity.getId(), 2, "hip actuator hit"));
                            }
                        }
                        break;
                    }
                    case 1: {
                        Mounted mounted = entity.getEquipment(criticalSlot.getIndex());
                        EquipmentType equipmentType = mounted.getType();
                        boolean bl = mounted.isHit();
                        string = string + "\n            <<<CRITICAL HIT>>> on " + mounted.getDesc() + ".";
                        mounted.setHit(true);
                        if (!equipmentType.isExplosive() || bl) break;
                        string = string + this.explodeEquipment(entity, n, n5);
                    }
                }
                --n2;
            }
        }
        return string;
    }

    private void destroyLocation(Entity entity, int n) {
        if (entity.getInternal(n) < 0) {
            return;
        }
        entity.setArmor(-2, n, false);
        entity.setInternal(-2, n);
        if (entity.hasRearArmor(n)) {
            entity.setArmor(-2, n, true);
        }
        Enumeration enumeration = entity.getEquipment();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.getLocation() != n) continue;
            mounted.setMissing(true);
        }
        int n2 = 0;
        while (n2 < entity.getNumberOfCriticals(n)) {
            CriticalSlot criticalSlot = entity.getCritical(n, n2);
            if (criticalSlot != null) {
                criticalSlot.setMissing(true);
            }
            ++n2;
        }
        if (n == 6 || n == 7) {
            this.pilotRolls.addElement(new PilotingRollData(entity.getId(), 0x7FFFFFFE, 5, "leg destroyed"));
        }
        if (entity.getDependentLocation(n) != -1) {
            this.destroyLocation(entity, entity.getDependentLocation(n));
        }
    }

    private String destroyEntity(Entity entity, String string) {
        if (!entity.isDoomed() && !entity.isDestroyed()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n*** ");
            stringBuffer.append(entity.getDisplayName());
            stringBuffer.append(" DESTROYED by ");
            stringBuffer.append(string);
            stringBuffer.append("! ***\n");
            entity.setDoomed(true);
            return stringBuffer.toString();
        }
        return "";
    }

    private String explodeEquipment(Entity entity, int n, int n2) {
        return this.explodeEquipment(entity, n, entity.getEquipment(entity.getCritical(n, n2).getIndex()));
    }

    private String explodeEquipment(Entity entity, int n, Mounted mounted) {
        StringBuffer stringBuffer = new StringBuffer();
        if (mounted.isDestroyed()) {
            System.err.println("server: explodeEquipment called on destroyed equipment (" + mounted.getName() + ")");
            return "";
        }
        if (mounted.getType() instanceof WeaponType && ((WeaponType)mounted.getType()).getAmmoType() == 23 && !mounted.isJammed()) {
            return "";
        }
        int n2 = mounted.getExplosionDamage();
        if (n2 <= 0) {
            return "";
        }
        stringBuffer.append("\n*** ");
        stringBuffer.append(mounted.getName());
        stringBuffer.append(" EXPLODES!  ");
        stringBuffer.append(n2);
        stringBuffer.append(" DAMAGE! ***");
        stringBuffer.append(this.damageEntity(entity, new HitData(n), n2, true));
        stringBuffer.append("\n");
        if (!entity.isDoomed() && !entity.isDestroyed()) {
            stringBuffer.append(this.damageCrew(entity, 2));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String explodeAmmoFromHeat(Entity entity) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < entity.locations()) {
            int n6 = 0;
            while (n6 < entity.getNumberOfCriticals(n5)) {
                AmmoType ammoType;
                Mounted mounted;
                CriticalSlot criticalSlot = entity.getCritical(n5, n6);
                if (!(criticalSlot == null || criticalSlot.isDestroyed() || criticalSlot.isHit() || criticalSlot.getType() != 1 || !((mounted = entity.getEquipment(entity.getCritical(n5, n6).getIndex())).getType() instanceof AmmoType) || !(ammoType = (AmmoType)mounted.getType()).isExplosive() || mounted.isHit() || n2 >= ammoType.getDamagePerShot() * ammoType.getRackSize() && n >= mounted.getExplosionDamage())) {
                    n2 = ammoType.getDamagePerShot() * ammoType.getRackSize();
                    n = mounted.getExplosionDamage();
                    n3 = n5;
                    n4 = n6;
                }
                ++n6;
            }
            ++n5;
        }
        if (n3 != -1 && n4 != -1) {
            CriticalSlot criticalSlot = entity.getCritical(n3, n4);
            criticalSlot.setHit(true);
            entity.getEquipment(criticalSlot.getIndex()).setHit(true);
            return this.explodeEquipment(entity, n3, n4);
        }
        return "  Luckily, there is no ammo to explode.\n";
    }

    private void doEntityFall(Entity entity, Coords coords, int n, int n2, PilotingRollData pilotingRollData) {
        int n3;
        int n4;
        String string;
        if (entity.isMakingDfa()) {
            this.phaseReport.append("But, since the 'mech is making a death from above attack, damage will be dealt during the physical phase.\n");
            entity.setProne(true);
            return;
        }
        switch (n2) {
            case 1: 
            case 2: {
                string = "right side";
                n4 = 3;
                break;
            }
            case 3: {
                string = "rear";
                n4 = 1;
                break;
            }
            case 4: 
            case 5: {
                string = "left side";
                n4 = 2;
                break;
            }
            default: {
                string = "front";
                n4 = 0;
            }
        }
        int n5 = Math.round(entity.getWeight() / 10.0f) * (n + 1);
        if (this.game.board.getHex(coords).levelOf(4) > 0) {
            n5 = (int)Math.ceil((double)n5 / 2.0);
        }
        this.phaseReport.append("    " + entity.getDisplayName() + " falls on its " + string + ", suffering " + n5 + " damage.");
        while (n5 > 0) {
            n3 = Math.min(5, n5);
            HitData hitData = entity.rollHitLocation(0, n4);
            this.phaseReport.append(this.damageEntity(entity, hitData, n3));
            n5 -= n3;
        }
        pilotingRollData.removeAutos();
        if (n > 0) {
            pilotingRollData.addModifier(n, "height of fall");
        }
        if (pilotingRollData.getValue() == Integer.MAX_VALUE) {
            this.phaseReport.append("\nPilot of " + entity.getDisplayName() + " \"" + entity.crew.getName() + "\" cannot avoid damage.\n");
            this.phaseReport.append(this.damageCrew(entity, 1) + "\n");
        } else {
            n3 = Compute.d6(2);
            this.phaseReport.append("\nPilot of " + entity.getDisplayName() + " \"" + entity.crew.getName() + "\" must roll " + pilotingRollData.getValueAsString() + " to avoid damage; rolls " + n3 + " : ");
            if (n3 >= pilotingRollData.getValue()) {
                this.phaseReport.append("succeeds.\n");
            } else {
                this.phaseReport.append("fails.\n");
                this.phaseReport.append(this.damageCrew(entity, 1) + "\n");
            }
        }
        if (entity instanceof Mech) {
            entity.setProne(true);
        }
        entity.setPosition(coords);
        entity.setFacing((entity.getFacing() + (n2 - 1)) % 6);
        entity.setSecondaryFacing(entity.getFacing());
    }

    private void doEntityFall(Entity entity, Coords coords, int n, PilotingRollData pilotingRollData) {
        this.doEntityFall(entity, coords, n, Compute.d6(1), pilotingRollData);
    }

    private void doEntityFall(Entity entity, PilotingRollData pilotingRollData) {
        this.doEntityFall(entity, entity.getPosition(), 0, pilotingRollData);
    }

    private void resolveFire() {
        Serializable serializable;
        int n;
        Board board = this.game.getBoard();
        int n2 = board.width;
        int n3 = board.height;
        int n4 = this.game.getWindDirection();
        this.phaseReport.append("\n\nResolving fire movement \n ------------------------\n");
        int n5 = 0;
        while (n5 < n2) {
            n = 0;
            while (n < n3) {
                Coords coords = new Coords(n5, n);
                serializable = board.getHex(n5, n);
                if (((Hex)serializable).contains(7) && !((Hex)serializable).contains(1)) {
                    this.removeFire(n5, n, (Hex)serializable);
                }
                if (((Hex)serializable).levelOf(7) == 2) {
                    this.phaseReport.append("Fire at " + coords.getBoardNum() + " is burning brightly.\n");
                    this.spreadFire(n5, n, n4);
                }
                ++n;
            }
            ++n5;
        }
        n = 0;
        while (n < n2) {
            int n6 = 0;
            while (n6 < n3) {
                serializable = new Coords(n, n6);
                Hex hex = board.getHex(n, n6);
                if (hex.levelOf(7) == 1) {
                    hex.removeTerrain(7);
                    hex.addTerrain(new Terrain(7, 2));
                    this.sendChangedHex((Coords)serializable);
                    this.phaseReport.append("Fire at " + ((Coords)serializable).getBoardNum() + " was started this round.\n");
                }
                if (hex.contains(7)) {
                    this.addSmoke(n, n6, n4);
                    this.addSmoke(n, n6, (n4 + 1) % 6);
                    this.addSmoke(n, n6, (n4 + 5) % 6);
                    board.initializeAround(n, n6);
                }
                ++n6;
            }
            ++n;
        }
    }

    public void spreadFire(int n, int n2, int n3) {
        Coords coords = new Coords(n, n2);
        Coords coords2 = coords.translated(n3);
        this.spreadFire(coords2, 9);
        Hex hex = this.game.getBoard().getHex(coords2);
        if (hex != null && !hex.contains(7)) {
            this.spreadFire(coords2.translated(n3), 12);
        }
        this.spreadFire(coords.translated((n3 + 1) % 6), 11);
        this.spreadFire(coords.translated((n3 + 5) % 6), 11);
    }

    public void spreadFire(Coords coords, int n) {
        Hex hex = this.game.getBoard().getHex(coords);
        if (this.burn(hex, n)) {
            this.sendChangedHex(coords);
            this.phaseReport.append("Fire spreads to " + coords.getBoardNum() + "!\n");
        }
    }

    public boolean burn(Hex hex, int n) {
        if (!this.game.getOptions().booleanOption("fire") || null == hex || hex.contains(7) || !hex.contains(1)) {
            return false;
        }
        int n2 = Compute.d6(2);
        if (n2 >= n) {
            hex.addTerrain(new Terrain(7, 1));
            return true;
        }
        return false;
    }

    public void removeFire(int n, int n2, Hex hex) {
        Coords coords = new Coords(n, n2);
        int n3 = this.game.getWindDirection();
        hex.removeTerrain(7);
        this.sendChangedHex(coords);
        this.removeSmoke(n, n2, n3);
        this.removeSmoke(n, n2, (n3 + 1) % 6);
        this.removeSmoke(n, n2, (n3 + 5) % 6);
        this.phaseReport.append("Fire at " + coords.getBoardNum() + " goes out due to lack of fuel!\n");
    }

    public void addSmoke(int n, int n2, int n3) {
        Coords coords = new Coords(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
        Hex hex = this.game.getBoard().getHex(coords);
        if (hex != null && !hex.contains(8)) {
            hex.addTerrain(new Terrain(8, 1));
            this.sendChangedHex(coords);
            this.phaseReport.append("Smoke fills " + coords.getBoardNum() + "!\n");
        }
    }

    public void removeSmoke(int n, int n2, int n3) {
        Coords coords = new Coords(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
        Hex hex = this.game.getBoard().getHex(coords);
        if (hex != null && hex.contains(8)) {
            hex.removeTerrain(8);
            this.sendChangedHex(coords);
            this.phaseReport.append("Smoke clears from " + coords.getBoardNum() + "!\n");
        }
    }

    private Vector scanForBoards(int n, int n2) {
        Vector<String> vector = new Vector<String>();
        File file = new File("data/boards");
        if (!file.isDirectory()) {
            return vector;
        }
        String[] stringArray = file.list();
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].indexOf(".board") != -1 && Board.boardIsSize(stringArray[n3], n, n2)) {
                vector.addElement(stringArray[n3].substring(0, stringArray[n3].lastIndexOf(".board")));
            }
            ++n3;
        }
        if (vector.size() > 0) {
            vector.insertElementAt("[RANDOM]", 0);
            vector.insertElementAt(DEFAULT_BOARD, 1);
        }
        return vector;
    }

    private boolean doBlind() {
        return this.game.getOptions().booleanOption("double_blind") && this.game.phase >= 4;
    }

    private void entityUpdate(int n) {
        if (this.doBlind()) {
            Serializable serializable;
            Entity entity = this.game.getEntity(n);
            Vector vector = this.game.getPlayersVector();
            Vector<Player> vector2 = new Vector<Player>();
            vector2.addElement(entity.getOwner());
            Vector vector3 = this.game.getEntitiesVector();
            int n2 = 0;
            while (n2 < vector3.size()) {
                serializable = (Entity)vector3.elementAt(n2);
                if (!vector2.contains(((Entity)serializable).getOwner()) && ((Entity)serializable).isActive() && Compute.canSee(this.game, (Entity)serializable, entity)) {
                    vector2.addElement(((Entity)serializable).getOwner());
                }
                ++n2;
            }
            serializable = this.createEntityPacket(n);
            int n3 = 0;
            while (n3 < vector2.size()) {
                Player player = (Player)vector2.elementAt(n3);
                this.send(player.getId(), (Packet)serializable);
                ++n3;
            }
            serializable = this.createRemoveEntityPacket(n);
            int n4 = 0;
            while (n4 < vector.size()) {
                if (!vector2.contains(vector.elementAt(n4))) {
                    Player player = (Player)vector.elementAt(n4);
                    this.send(player.getId(), (Packet)serializable);
                }
                ++n4;
            }
        } else {
            this.send(this.createEntityPacket(n));
        }
    }

    private void entityAllUpdate() {
        if (this.doBlind()) {
            Vector vector = this.game.getPlayersVector();
            int n = 0;
            while (n < vector.size()) {
                Player player = (Player)vector.elementAt(n);
                this.send(player.getId(), this.createFilteredEntitiesPacket(player));
                ++n;
            }
        } else {
            this.send(this.createEntitiesPacket());
        }
    }

    private Vector filterEntities(Player player, Vector vector) {
        Vector<Entity> vector2 = new Vector<Entity>();
        Vector vector3 = this.game.getEntitiesVector();
        Vector<Entity> vector4 = new Vector<Entity>();
        int n = 0;
        while (n < vector3.size()) {
            Entity entity = (Entity)vector3.elementAt(n);
            if (entity.getOwner() == player) {
                vector4.addElement(entity);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n2);
            if (vector4.contains(entity)) {
                vector2.addElement(entity);
            } else {
                int n3 = 0;
                while (n3 < vector4.size()) {
                    Entity entity2 = (Entity)vector4.elementAt(n3);
                    if (Compute.canSee(this.game, entity2, entity)) {
                        vector2.addElement(entity);
                        break;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return vector2;
    }

    private void receiveEntityReady(Packet packet, int n) {
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        boolean bl = this.game.getOptions().booleanOption("inf_move_multi");
        boolean bl2 = this.game.getOptions().booleanOption("inf_move_last");
        if (entity != null && entity.getOwner() == this.getPlayer(n) && this.game.getTurn().getPlayerNum() == n) {
            if (!bl || this.turnInfMoved <= 0 || !(entity instanceof Infantry) || entity.getOwnerId() != this.turnLastPlayerId) {
                // empty if block
            }
            entity.ready = false;
            if (entity instanceof Infantry) {
                ++this.turnInfMoved;
                this.turnLastPlayerId = entity.getOwnerId();
                if (bl) {
                    if (3 == this.turnInfMoved || !this.game.hasInfantry(this.turnLastPlayerId)) {
                        this.turnInfMoved = 0;
                    } else {
                        --this.turnIndex;
                    }
                }
            }
        } else {
            System.out.println("server.receiveEntityReady: got an invalid ready message");
        }
    }

    private void receiveEntityAdd(Packet packet, int n) {
        Entity entity = (Entity)packet.getObject(0);
        entity.restore();
        entity.setOwner(this.getPlayer(n));
        entity.setId(this.entityCounter++);
        this.game.addEntity(entity.getId(), entity);
        this.send(this.createAddEntityPacket(entity.getId()));
    }

    private void receiveEntityUpdate(Packet packet, int n) {
        Entity entity = (Entity)packet.getObject(0);
        Entity entity2 = this.game.getEntity(entity.getId());
        if (entity2 != null && entity2.getOwner() == this.getPlayer(n)) {
            entity.restore();
            entity.setOwner(this.getPlayer(n));
            this.game.setEntity(entity.getId(), entity);
            this.send(this.createEntitiesPacket());
        }
    }

    private void receiveEntityModeChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (entity.getOwner() != this.getPlayer(n)) {
            return;
        }
        Mounted mounted = entity.getEquipment(n3);
        if (mounted.getType() instanceof AmmoType) {
            mounted.setPendingDump(n4 == 1);
        } else {
            mounted.setMode(n4);
        }
    }

    private void receiveEntityDelete(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        Entity entity = this.game.getEntity(n2);
        if (entity != null && entity.getOwner() == this.getPlayer(n)) {
            this.game.removeEntity(n2);
            this.send(this.createRemoveEntityPacket(n2));
        }
    }

    private void receivePlayerReady(Packet packet, int n) {
        boolean bl = packet.getBooleanValue(0);
        if (bl && this.game.phase == 1 && this.game.getEntitiesOwnedBy(this.getPlayer(n)) < 1) {
            bl = false;
        }
        this.getPlayer(n).setReady(bl);
    }

    private boolean receiveGameOptions(Packet packet, int n) {
        if (this.password != null && this.password.length() > 0 && !this.password.equals(packet.getObject(0))) {
            this.sendServerChat(n, "The password you specified to change game options is incorrect.");
            return false;
        }
        int n2 = 0;
        boolean bl = this.game.getOptions().getOption("inf_move_last").booleanValue();
        boolean bl2 = this.game.getOptions().getOption("inf_move_multi").booleanValue();
        Enumeration enumeration = ((Vector)packet.getObject(1)).elements();
        while (enumeration.hasMoreElements()) {
            GameOption gameOption = (GameOption)enumeration.nextElement();
            GameOption gameOption2 = this.game.getOptions().getOption(gameOption.getShortName());
            if (gameOption2 == null) continue;
            this.sendServerChat("Player " + this.getPlayer(n).getName() + " changed option \"" + gameOption2.getFullName() + "\" to " + gameOption.stringValue() + ".");
            if (gameOption.getShortName().equals("inf_move_last")) {
                bl = gameOption.booleanValue();
            } else if (gameOption.getShortName().equals("inf_move_multi")) {
                bl2 = gameOption.booleanValue();
            }
            gameOption2.setValue(gameOption.getValue());
            ++n2;
        }
        if (bl && bl == bl2) {
            this.sendServerChat("Player " + this.getPlayer(n).getName() + " tried to set BOTH \"" + this.game.getOptions().getOption("inf_move_last").getFullName() + "\" and \"" + this.game.getOptions().getOption("inf_move_multi").getFullName() + "\" to true.");
            this.sendServerChat("Clearing *BOTH* options.");
            this.game.getOptions().getOption("inf_move_last").setValue(false);
            this.game.getOptions().getOption("inf_move_multi").setValue(false);
            n2 += 2;
        }
        return n2 > 0;
    }

    private void transmitAllPlayerConnects(int n) {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.send(n, this.createPlayerConnectPacket(player.getId()));
        }
    }

    private Packet createPlayerConnectPacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), this.getPlayer(n)};
        return new Packet(4, objectArray);
    }

    private Packet createPlayerUpdatePacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), this.getPlayer(n)};
        return new Packet(6, objectArray);
    }

    private void transmitAllPlayerUpdates() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.send(this.createPlayerUpdatePacket(player.getId()));
        }
    }

    private void transmitAllPlayerReadys() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.send(this.createPlayerReadyPacket(player.getId()));
        }
    }

    private Packet createPlayerReadyPacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), new Boolean(this.getPlayer(n).isReady())};
        return new Packet(7, objectArray);
    }

    private Packet createMapSettingsPacket() {
        return new Packet(22, this.mapSettings);
    }

    private Packet createMapQueryPacket(MapSettings mapSettings) {
        return new Packet(23, mapSettings);
    }

    private Packet createGameSettingsPacket() {
        return new Packet(21, this.game.getOptions());
    }

    private Packet createBoardPacket() {
        return new Packet(17, this.game.board);
    }

    private Packet createEntityPacket(int n) {
        Entity entity = this.game.getEntity(n);
        Object[] objectArray = new Object[]{new Integer(n), entity};
        return new Packet(14, objectArray);
    }

    private Packet createReportPacket() {
        return new Packet(20, this.roundReport.toString());
    }

    private Packet createEntitiesPacket() {
        return new Packet(18, this.game.getEntitiesVector());
    }

    private Packet createFilteredEntitiesPacket(Player player) {
        return new Packet(18, this.filterEntities(player, this.game.getEntitiesVector()));
    }

    private Packet createAddEntityPacket(int n) {
        Entity entity = this.game.getEntity(n);
        Object[] objectArray = new Object[]{new Integer(n), entity};
        return new Packet(9, objectArray);
    }

    private Packet createRemoveEntityPacket(int n) {
        return new Packet(10, new Integer(n));
    }

    private Packet createEndOfGamePacket() {
        return new Packet(24, this.getDetailedVictoryReport());
    }

    private void sendChat(int n, String string, String string2) {
        this.send(n, new Packet(8, string + ": " + string2));
    }

    private void sendChat(String string, String string2) {
        String string3 = string + ": " + string2;
        this.send(new Packet(8, string3));
        this.log.append(string3);
    }

    public void sendServerChat(int n, String string) {
        this.sendChat(n, "***Server", string);
    }

    public void sendServerChat(String string) {
        this.sendChat("***Server", string);
    }

    private Packet createHexChangePacket(Coords coords, Hex hex) {
        Object[] objectArray = new Object[]{coords, hex};
        return new Packet(25, objectArray);
    }

    public void sendChangedHex(Coords coords) {
        this.send(this.createHexChangePacket(coords, this.game.board.getHex(coords)));
    }

    private Packet createAttackPacket(EntityAction entityAction) {
        return new Packet(12, entityAction);
    }

    private void send(Packet packet) {
        if (this.connections == null) {
            return;
        }
        packet.zipData();
        Enumeration enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            connection.send(packet);
        }
    }

    private void send(int n, Packet packet) {
        packet.zipData();
        this.getClient(n).send(packet);
    }

    private void sendToPending(int n, Packet packet) {
        this.getPendingConnection(n).send(packet);
    }

    private void processCommand(int n, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        String string2 = stringArray[0].substring(1);
        ServerCommand serverCommand = this.getCommand(string2);
        if (serverCommand != null) {
            serverCommand.run(n, stringArray);
        } else {
            this.sendServerChat(n, "Command not recognized.  Type /help for a list of commands.");
        }
    }

    private int getMovementPSRModifier(int n) {
        if (n > 10) {
            return 4;
        }
        if (n > 7) {
            return 2;
        }
        if (n > 4) {
            return 1;
        }
        if (n > 2) {
            return 0;
        }
        return -1;
    }

    synchronized void handle(int n, Packet packet) {
        if (packet == null) {
            System.out.println("server.connection.handle: got null packet");
            return;
        }
        switch (packet.getCommand()) {
            case 2: {
                this.receivePlayerName(packet, n);
                break;
            }
            case 6: {
                this.receivePlayerInfo(packet, n);
                this.validatePlayerInfo(n);
                this.send(this.createPlayerUpdatePacket(n));
                break;
            }
            case 13: {
                this.receiveEntityReady(packet, n);
                this.entityUpdate(packet.getIntValue(0));
                break;
            }
            case 7: {
                this.receivePlayerReady(packet, n);
                this.send(this.createPlayerReadyPacket(n));
                this.checkReady();
                break;
            }
            case 8: {
                String string = (String)packet.getObject(0);
                if (string.startsWith("/")) {
                    this.processCommand(n, string);
                    break;
                }
                this.sendChat(this.getPlayer(n).getName(), string);
                break;
            }
            case 11: {
                this.doEntityMovement(packet, n);
                break;
            }
            case 27: {
                this.receiveDeployment(packet);
                break;
            }
            case 12: {
                this.receiveAttack(packet);
                break;
            }
            case 9: {
                this.receiveEntityAdd(packet, n);
                this.resetPlayerReady();
                this.transmitAllPlayerReadys();
                break;
            }
            case 14: {
                this.receiveEntityUpdate(packet, n);
                this.resetPlayerReady();
                this.transmitAllPlayerReadys();
                break;
            }
            case 26: {
                this.receiveEntityModeChange(packet, n);
                break;
            }
            case 10: {
                this.receiveEntityDelete(packet, n);
                this.resetPlayerReady();
                this.transmitAllPlayerReadys();
                break;
            }
            case 21: {
                if (!this.receiveGameOptions(packet, n)) break;
                this.resetPlayerReady();
                this.transmitAllPlayerReadys();
                this.send(this.createGameSettingsPacket());
                break;
            }
            case 22: {
                this.mapSettings = (MapSettings)packet.getObject(0);
                this.mapSettings.replaceBoardWithRandom("[RANDOM]");
                this.resetPlayerReady();
                this.transmitAllPlayerReadys();
                this.send(this.createMapSettingsPacket());
                break;
            }
            case 23: {
                MapSettings mapSettings = (MapSettings)packet.getObject(0);
                mapSettings.setBoardsAvailableVector(this.scanForBoards(mapSettings.getBoardWidth(), mapSettings.getBoardHeight()));
                mapSettings.removeUnavailable();
                mapSettings.setNullBoards(DEFAULT_BOARD);
                mapSettings.replaceBoardWithRandom("[RANDOM]");
                mapSettings.removeUnavailable();
                this.send(n, this.createMapQueryPacket(mapSettings));
            }
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        System.out.println("s: listening for clients...");
        while (this.connector == thread) {
            try {
                int n;
                Socket socket = this.serverSocket.accept();
                ++this.connectionCounter;
                System.out.println("s: accepting player connection #" + n + " ...");
                this.connectionsPending.addElement(new Connection(this, socket, n));
                this.greeting(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class WeaponResult {
        public WeaponAttackAction waa = null;
        public ToHitData toHit = null;
        public int roll = -1;
        public boolean revertsToSingleShot = false;
        public int amsShotDown = 0;

        private WeaponResult() {
        }
    }
}

