/*
 * Decompiled with CFR 0.152.
 */
package game;

import i18n.I18n;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class MapLabel
extends JLabel
implements ActionListener {
    private static final long serialVersionUID = 2747458994628364853L;
    private static final int NO_OF_DETECTIVES = 5;
    private BufferedImage[] flagImage;
    private Point[] playerPositions = null;
    private int currentPlayer = -1;
    boolean blinkOn = false;
    boolean mrXVisible = false;
    Timer blinkTimer = new Timer(1000, this);

    public MapLabel(ImageIcon imageIcon, int numDetectives) {
        super(imageIcon);
        this.playerPositions = new Point[numDetectives + 1];
        this.flagImage = new BufferedImage[6];
        int i = 0;
        while (i <= 5) {
            String fileName = "./flag" + Integer.toString(i) + ".gif";
            try {
                this.flagImage[i] = ImageIO.read(new File(fileName));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, I18n.tr("ErrorFileNotFound", fileName), I18n.tr("ErrorTitle"), 0);
                System.exit(1);
            }
            ++i;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.playerPositions != null) {
            Graphics2D g2 = (Graphics2D)g;
            int i = 0;
            while (i < this.playerPositions.length) {
                if (!(this.playerPositions[i] == null || this.blinkOn && i == this.currentPlayer || i == 0 && !this.mrXVisible)) {
                    Point playerPos = this.getPlayerPos(i);
                    g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
                    g2.drawImage((Image)this.flagImage[i], playerPos.x, playerPos.y - this.flagImage[i].getHeight(), null);
                }
                ++i;
            }
        }
    }

    public void setPlayerPos(int player, int x, int y) {
        this.playerPositions[player] = new Point(x, y);
        this.repaintPlayerPos(player);
    }

    public void setPlayerPos(int player, Point pos) {
        this.setPlayerPos(player, pos.x, pos.y);
    }

    public Point getPlayerPos(int player) {
        if (player < 0 || player >= this.playerPositions.length) {
            return null;
        }
        int xOffset = this.getWidth() - this.getIcon().getIconWidth() < 0 ? 0 : (this.getWidth() - this.getIcon().getIconWidth()) / 2;
        int yOffset = this.getHeight() - this.getIcon().getIconHeight() < 0 ? 0 : (this.getHeight() - this.getIcon().getIconHeight()) / 2;
        return new Point(xOffset + this.playerPositions[player].x, yOffset + this.playerPositions[player].y);
    }

    public void setCurrentPlayer(int player) {
        if (player != this.currentPlayer) {
            if (this.blinkTimer.isRunning()) {
                this.blinkTimer.stop();
            }
            this.blinkOn = false;
            if (this.currentPlayer != -1) {
                this.repaintPlayerPos(this.currentPlayer);
            }
            this.currentPlayer = player;
            this.blinkTimer.start();
            this.repaintPlayerPos(this.currentPlayer);
        }
    }

    public void repaintPlayerPos(int player) {
        Point playerPos = this.getPlayerPos(player);
        if (player != -1 && playerPos != null) {
            int width = this.flagImage[player].getWidth();
            int height = this.flagImage[player].getHeight();
            this.repaint(playerPos.x, playerPos.y - height, width, height);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.blinkTimer) {
            boolean bl = this.blinkOn = !this.blinkOn;
            if (this.playerPositions != null) {
                this.repaintPlayerPos(this.currentPlayer);
            }
        }
    }
}

