/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Transport;
import i18n.I18n;
import java.util.Comparator;
import java.util.StringTokenizer;

public class Move
implements Comparator<Object>,
Transport,
Comparable<Object> {
    int nodeIndex;
    int ticketType;

    public Move(int n, int t) {
        this.nodeIndex = n;
        this.ticketType = t;
    }

    public Move(String str) {
        StringTokenizer getFields = new StringTokenizer(str, " (");
        this.nodeIndex = Integer.parseInt(getFields.nextToken());
        String type = getFields.nextToken();
        type = type.substring(0, type.length() - 1);
        if (type.equals("None")) {
            this.ticketType = 0;
        }
        if (type.equals(I18n.tr("TaxiTicket"))) {
            this.ticketType = 1;
        }
        if (type.equals(I18n.tr("BusTicket"))) {
            this.ticketType = 2;
        } else if (type.equals(I18n.tr("UndergroundTicket"))) {
            this.ticketType = 3;
        } else if (type.equals("FERRY") || type.equals("BLACK")) {
            this.ticketType = 60;
        }
    }

    public int getScore() {
        return 10 * this.nodeIndex + this.ticketType;
    }

    public int getNode() {
        return this.nodeIndex;
    }

    public int getType() {
        return this.ticketType;
    }

    public String toString() {
        return this.nodeIndex + " (" + this.toStringTicket() + ")";
    }

    public String toDisplayString() {
        return I18n.tr("Move", this.nodeIndex, this.toStringTicket());
    }

    public String toStringTicket() {
        String type = "None";
        if (this.ticketType == 1) {
            type = I18n.tr("TaxiTicket");
        }
        if (this.ticketType == 2) {
            type = I18n.tr("BusTicket");
        } else if (this.ticketType == 3) {
            type = I18n.tr("UndergroundTicket");
        } else if (this.ticketType == 60 || this.ticketType == 50) {
            type = "Black";
        }
        return type;
    }

    @Override
    public int compare(Object o1, Object o2) {
        Move m1 = (Move)o1;
        Move m2 = (Move)o2;
        if (m1.getScore() < m2.getScore()) {
            return -1;
        }
        if (m1.getScore() == m2.getScore()) {
            return 0;
        }
        return 1;
    }

    public boolean equal(Move m1, Move m2) {
        return m1.getScore() == m2.getScore();
    }

    @Override
    public int compareTo(Object o) {
        Move m = (Move)o;
        return this.getScore() - m.getScore();
    }
}

