/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ResourceNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;

public class ResourceManager {
    private String locale = "";
    protected final String resourceBasePath = "/res/";
    private AutomatedInstallData installData;
    private static ResourceManager instance = null;

    protected ResourceManager(AutomatedInstallData data) {
        this.installData = data;
        this.locale = data.localeISO3 != null ? data.localeISO3 : this.installData.xmlData.getAttribute("langpack", "eng");
    }

    public static ResourceManager create(AutomatedInstallData data) {
        if (instance == null) {
            instance = new ResourceManager(data);
        }
        return instance;
    }

    public static ResourceManager getInstance() {
        return instance;
    }

    private String getLanguageResourceString(String resource) throws ResourceNotFoundException {
        String resourcePath = this.resourceBasePath + resource + "_" + this.locale;
        InputStream in = ResourceManager.class.getResourceAsStream(resourcePath);
        if (in != null) {
            return resourcePath;
        }
        resourcePath = this.resourceBasePath + resource;
        in = ResourceManager.class.getResourceAsStream(resourcePath);
        if (in != null) {
            return resourcePath;
        }
        throw new ResourceNotFoundException("Can not find Resource " + resource + " for language " + this.locale);
    }

    public InputStream getInputStream(String resource) throws ResourceNotFoundException {
        String resourcepath = this.getLanguageResourceString(resource);
        return ResourceManager.class.getResourceAsStream(resourcepath);
    }

    public URL getURL(String resource) throws ResourceNotFoundException {
        try {
            return this.getClass().getResource(this.getLanguageResourceString(resource + "_" + this.installData.localeISO3));
        }
        catch (Exception ex) {
            return this.getClass().getResource(this.getLanguageResourceString(resource));
        }
    }

    public String getTextResource(String resource, String encoding) throws ResourceNotFoundException, IOException {
        int bytesInBuffer;
        InputStream in = null;
        try {
            in = this.getInputStream(resource + "_" + this.installData.localeISO3);
        }
        catch (Exception ex) {
            in = this.getInputStream(resource);
        }
        ByteArrayOutputStream infoData = new ByteArrayOutputStream();
        byte[] buffer = new byte[5120];
        while ((bytesInBuffer = in.read(buffer)) != -1) {
            infoData.write(buffer, 0, bytesInBuffer);
        }
        if (encoding != null) {
            return infoData.toString(encoding);
        }
        return infoData.toString();
    }

    public String getTextResource(String resource) throws ResourceNotFoundException, IOException {
        return this.getTextResource(resource, null);
    }

    public ImageIcon getImageIconResource(String resource) throws ResourceNotFoundException, IOException {
        return new ImageIcon(this.getURL(resource));
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }
}

