/*
 * Decompiled with CFR 0.152.
 */
import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.SingleInstanceJFrame;
import edu.xtec.jclic.project.ProjectInstallerDlg;
import edu.xtec.util.BasicResourceBridge;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import java.awt.Component;

public abstract class JClicInstaller {
    public static void main(String[] args) {
        boolean exit = true;
        try {
            Options options = new Options((Component)null);
            Messages messages = PersistentSettings.getMessages(options, "messages.JClicMessages");
            messages.addBundle("commonSettings");
            messages.addBundle("messages.PlayerMessages");
            String installer = SingleInstanceJFrame.loadArgs(args, options);
            if (installer == null) {
                System.err.println("Error: no installer file specified!");
            } else if (!installer.endsWith(".jclic.inst")) {
                System.err.println("Error: " + installer + " isn't a JClic package install script.\nJClic package install scripts end always with .jclic.inst");
            } else {
                BasicResourceBridge rb = new BasicResourceBridge(options);
                PlayerSettings settings = PlayerSettings.loadPlayerSettings(rb);
                if (settings.promptPassword(null, null)) {
                    settings.checkLibrary();
                    ProjectInstallerDlg pi = ProjectInstallerDlg.getProjectInstallerDlg(null, settings.libraryManager, installer);
                    if (pi != null) {
                        pi.setVisible(true);
                        if (!pi.cancel && pi.launchNow && pi.pathToMainProject != null) {
                            JClicPlayer.main(new String[]{pi.pathToMainProject});
                            exit = false;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Error installing:\n" + ex);
        }
        if (exit) {
            System.exit(0);
        }
    }
}

